/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.platform;

import com.fr.base.FRContext;
import com.fr.fs.web.platform.SimpleControl;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.privilege.AuthorityBridge;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PermissionAndAuthorityControl
extends SimpleControl {
    private List authorityNameList = new ArrayList();

    public int getAuthoryryNameCount() {
        return this.authorityNameList.size();
    }

    public JSONArray getAuthorityNameArray() {
        return new JSONArray((Collection)this.authorityNameList);
    }

    public void setAuthorityName(JSONArray jSONArray) {
        this.authorityNameList.clear();
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                this.authorityNameList.add(jSONArray.get(i));
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    public void addAuthorityName(String string) {
        this.authorityNameList.add(string);
    }

    public String getAuthorityName(int n) {
        if (n < 0 || n > this.authorityNameList.size() - 1) {
            return null;
        }
        return (String)this.authorityNameList.get(n);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.authorityNameList.clear();
        }
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("NameAttr")) {
            String string2 = xMLableReader.getAttrAsString("names", "");
            for (String string3 : new FArray((Object[])string2.split(","))) {
                if (!StringUtils.isNotBlank((String)string3)) continue;
                this.authorityNameList.add(string3);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("XMLable");
        if (this.authorityNameList.size() > 0) {
            xMLPrintWriter.startTAG("NameAttr").attr("names", StableUtils.join((Collection)this.authorityNameList, (String)",")).end();
        }
        xMLPrintWriter.end();
    }

    public PrivilegeVote access(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return PrivilegeVoteImpls.MP_AUTH_ERROR;
        }
        AuthorityBridge[] authorityBridgeArray = authentication.getAuthorities();
        if (authorityBridgeArray == null || authorityBridgeArray.length == 0) {
            return PrivilegeVoteImpls.MP_ROLE_ERROR;
        }
        if (authentication.isRoot()) {
            return PrivilegeVoteImpls.SUCCESS;
        }
        int n = authorityBridgeArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.authorityNameList.contains(authorityBridgeArray[i].getName())) continue;
            authentication.setAuthorities((AuthorityBridge[])new Authority[]{new Authority(authorityBridgeArray[i].getName())});
            return PrivilegeVoteImpls.SUCCESS;
        }
        return PrivilegeVoteImpls.MP_ROLE_ERROR;
    }

    public int getID() {
        return 1;
    }
}

