/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.data.load.LazyExecutionException;
import com.fr.data.load.LazyExecutionJob;
import com.fr.data.load.LazyExecutionManager;
import com.fr.fs.FSConfig;
import com.fr.fs.FSConfigProvider;
import com.fr.fs.cache.CompanyRoleCacheImpl;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.cache.DepartmentCacheImpl;
import com.fr.fs.cache.EntryCacheImpl;
import com.fr.fs.cache.HomePageCacheImpl;
import com.fr.fs.cache.LoginUserCacheImpl;
import com.fr.fs.cache.ModuleCacheImpl;
import com.fr.fs.cache.PostCacheImpl;
import com.fr.fs.event.PlateListener;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.file.XMLFileManagerProvider;
import java.util.ArrayList;
import java.util.List;

public class FSContext {
    private static List<PlateListener> listenerList;
    private static boolean DATA_ON;

    public static boolean isUseFS() {
        return FSConfig.getProviderInstance().isUseFS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsingFS() {
        if (!FSContext.isUseFS()) {
            FSConfigProvider fSConfigProvider;
            FSConfigProvider fSConfigProvider2 = fSConfigProvider = FSConfig.getProviderInstance();
            synchronized (fSConfigProvider2) {
                if (!fSConfigProvider.isUseFS()) {
                    fSConfigProvider.setUseFS(true);
                    try {
                        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)fSConfigProvider);
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
    }

    public static boolean isDataOn() {
        return DATA_ON;
    }

    public static void resetDataOn() {
        DATA_ON = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initData() {
        if (DATA_ON) {
            return;
        }
        Class<FSContext> clazz = FSContext.class;
        synchronized (FSContext.class) {
            if (!DATA_ON) {
                LazyExecutionManager.addJob((LazyExecutionJob)new LazyExecutionJob(){

                    public void waitForRun() throws LazyExecutionException {
                        FSContext.initCache();
                        FSConfig.getProviderInstance().initLoginUserListByType(1);
                        FSConfig.getProviderInstance().initLoginUserListByType(2);
                        DATA_ON = true;
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initCache() {
        try {
            EntryCacheImpl.getInstance().initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Entry Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            CustomRoleCacheImpl.getInstance().initCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Simple Role Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            CompanyRoleCacheImpl.getInstance().initCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Job Role Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            DepartmentCacheImpl.getInstance().initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Department Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            PostCacheImpl.getInstance().initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Post Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            ModuleCacheImpl.getInstance().initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Module Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            HomePageCacheImpl.getInstance().initHomePageCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Homepage Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            LoginUserCacheImpl.getInstance().initLoginUserCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("LoginUser Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
    }

    public static void addPlateListener(PlateListener plateListener) {
        if (listenerList == null) {
            listenerList = new ArrayList<PlateListener>();
        }
        listenerList.add(plateListener);
    }

    public static void fireAllPlateStartFinish() {
        if (listenerList != null) {
            for (PlateListener plateListener : listenerList) {
                plateListener.onAfterStart();
            }
        }
    }

    static {
        DATA_ON = false;
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                DATA_ON = false;
                listenerList = null;
            }
        });
    }
}

