/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.cfg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.openwebflow.cfg.StartEngineEventListener;
import org.openwebflow.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDefinedProcessModels
implements StartEngineEventListener {
    File _modelDir;

    @Override
    public void afterStartEngine(ProcessEngineConfigurationImpl conf, ProcessEngine processEngine) throws Exception {
        this.checkAndImportNewModels(processEngine.getRepositoryService());
    }

    @Override
    public void beforeStartEngine(ProcessEngineConfigurationImpl conf) {
    }

    public void checkAndImportNewModels(RepositoryService repositoryService) throws IOException, XMLStreamException {
        List<File> newModelFiles = this.checkNewModelNames(repositoryService);
        for (File modelFile : newModelFiles) {
            ModelUtils.importModel(repositoryService, modelFile);
        }
    }

    private List<File> checkNewModelNames(RepositoryService repositoryService) throws FileNotFoundException {
        if (!this._modelDir.exists()) {
            throw new FileNotFoundException(this._modelDir.getPath());
        }
        File[] files = this._modelDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".bpmn");
            }
        });
        ArrayList<File> newModelFiles = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (this.exists(repositoryService, file.getName())) continue;
                newModelFiles.add(file);
            }
        }
        return newModelFiles;
    }

    public boolean exists(RepositoryService repositoryService, String name) {
        return repositoryService.createModelQuery().modelKey(name).count() != 0L;
    }

    public File getModelDir() {
        return this._modelDir;
    }

    public void setModelDir(File modelDir) {
        this._modelDir = modelDir;
    }
}

