/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.assign.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.openwebflow.assign.TaskAssignmentHandler;
import org.openwebflow.assign.TaskAssignmentHandlerChain;
import org.openwebflow.assign.permission.ActivityPermissionEntity;
import org.openwebflow.assign.permission.ActivityPermissionManager;
import org.openwebflow.util.OwfException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityPermissionAssignmentHandler
implements TaskAssignmentHandler {
    ActivityPermissionManager _activityPermissionManager;

    private Collection<String> asList(String[] ids) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, ids);
        return list;
    }

    public ActivityPermissionManager getActivityPermissionManager() {
        return this._activityPermissionManager;
    }

    @Override
    public void handleAssignment(TaskAssignmentHandlerChain chain, TaskEntity task, ActivityExecution execution) {
        ActivityPermissionEntity entity;
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        try {
            entity = this._activityPermissionManager.load(processDefinitionId, taskDefinitionKey, true);
        }
        catch (Exception e) {
            throw new OwfException(e);
        }
        if (entity == null) {
            chain.resume(task, execution);
            return;
        }
        task.setAssignee(entity.getAssignee());
        task.addCandidateGroups(this.asList(entity.getGrantedGroupIds()));
        task.addCandidateUsers(this.asList(entity.getGrantedUserIds()));
    }

    public void setActivityPermissionManager(ActivityPermissionManager activityPermissionManager) {
        this._activityPermissionManager = activityPermissionManager;
    }
}

