/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.GraphHelper;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.VanChartDataSheetPlotGlyphInterface;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class VanChartDataSheetGlyph
extends DataSheetGlyph {
    private static final long serialVersionUID = -7424733367816035489L;
    private static final double MAX_WIDTH = 4.0;
    boolean hasAxisReversed = false;
    private FRFont legendFont;
    private TextAttr cateLabelTextAttr;
    private VanChartDataSheetPlotGlyphInterface plotGlyph;
    private LegendItem[] legendItems;
    private double seriesWidth;
    private double cateWidth;
    private double cateHeight;
    private double seriesHeight;

    public VanChartDataSheetGlyph(FRFont fRFont, Format format, GeneralInfo generalInfo) {
        this.setFont(fRFont);
        this.setFormat(format);
        this.setGeneralInfo(generalInfo);
    }

    public void initDataSheet(LegendGlyph legendGlyph, VanChartDataSheetPlotGlyphInterface vanChartDataSheetPlotGlyphInterface) {
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph = vanChartDataSheetPlotGlyphInterface.getDefaultXAxisGlyph();
        this.hasAxisReversed = vanChartBaseAxisGlyph.hasAxisReversed();
        this.cateLabelTextAttr = vanChartBaseAxisGlyph.getTextAttr();
        this.cateLabelTextAttr.setRotation(0);
        if (legendGlyph != null && legendGlyph.isVisible()) {
            this.legendFont = legendGlyph.getFont();
            this.legendItems = vanChartDataSheetPlotGlyphInterface.createLegendItems();
        } else {
            this.legendFont = this.getFont();
        }
        this.plotGlyph = vanChartDataSheetPlotGlyphInterface;
    }

    public void calculateSeriesWidth(Rectangle2D rectangle2D, int n) {
        this.seriesHeight = Double.MIN_VALUE;
        this.seriesWidth = Double.MIN_VALUE;
        double d = rectangle2D.getWidth() / 4.0;
        boolean bl = this.hasLegend();
        int n2 = this.plotGlyph.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            Dimension2D dimension2D = bl ? this.legendItems[i].prefferedSize(this.legendFont, n) : GlyphUtils.calculateTextDimensionWithNoRotation((String)this.plotGlyph.getSeries(i).getSeriesName(), (TextAttr)new TextAttr(this.legendFont), (int)n);
            this.seriesWidth = Math.max(this.seriesWidth, dimension2D.getWidth());
            this.seriesWidth = Math.min(this.seriesWidth, d);
            this.seriesHeight = Math.max(this.seriesHeight, Math.ceil(dimension2D.getWidth() / this.seriesWidth) * dimension2D.getHeight());
        }
        this.seriesWidth += 8.0;
    }

    public void calculateOtherWidthAndHeight(int n) {
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.plotGlyph.getDefaultXAxisGlyph();
        this.cateWidth = vanChartBaseAxisGlyph.getAxisLength() / (double)this.getCategoryCount();
        this.calculateCateHeight(n);
        this.calculateSeriesHeight(n);
    }

    private void calculateCateHeight(int n) {
        DataSeries dataSeries = this.plotGlyph.getSeries(0);
        if (dataSeries != null) {
            int n2 = dataSeries.getDataPointCount();
            for (int i = 0; i < n2; ++i) {
                String string = dataSeries.getDataPoint(i).getCategoryName();
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)this.cateLabelTextAttr, (int)n);
                this.cateHeight = Math.max(this.cateHeight, Math.ceil(dimension2D.getWidth() / this.cateWidth) * dimension2D.getHeight());
            }
        }
        this.cateHeight += 4.0;
    }

    private void calculateSeriesHeight(int n) {
        int n2 = this.plotGlyph.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.plotGlyph.getSeries(i);
            int n3 = dataSeries.getDataPointCount();
            for (int j = 0; j < n3; ++j) {
                double d = dataSeries.getDataPoint(j).getValue();
                String string = VanChartAttrHelper.getValueStringWithFormat(d, this.format);
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)new TextAttr(this.getFont()), (int)n);
                this.seriesHeight = Math.max(this.seriesHeight, Math.ceil(dimension2D.getWidth() / this.cateWidth) * dimension2D.getHeight());
            }
        }
        this.seriesHeight += 8.0;
    }

    public double getLeftWidth() {
        return this.seriesWidth;
    }

    public double getBottomHeight() {
        return this.cateHeight + this.seriesHeight * (double)this.plotGlyph.getSeriesSize();
    }

    public double getWholeWidth() {
        if (this.plotGlyph.getSeriesSize() < 1) {
            return 0.0;
        }
        DataSeries dataSeries = this.plotGlyph.getSeries(0);
        return this.seriesWidth + this.cateWidth * (double)dataSeries.getDataPointCount();
    }

    public void draw(Graphics graphics, int n) {
        if (this.plotGlyph.getSeriesSize() < 1) {
            return;
        }
        this.drawLine(graphics);
        this.drawCateLabel(graphics, n);
        this.drawDataPointValue(graphics, n);
        this.drawSeriesLabel(graphics, n);
    }

    private void drawLine(Graphics graphics) {
        double d;
        int n = this.getBorderStyle();
        if (n == 0) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.getBorderColor());
        Rectangle2D rectangle2D = this.getBounds();
        for (d = rectangle2D.getX() + this.seriesWidth; d <= rectangle2D.getMaxX() + 1.0; d += this.cateWidth) {
            this.newLine(graphics, d, rectangle2D.getY(), d, rectangle2D.getMaxY(), n);
        }
        for (d = rectangle2D.getY() + this.cateHeight; d <= rectangle2D.getMaxY() + 1.0; d += this.seriesHeight) {
            this.newLine(graphics, rectangle2D.getX(), d, rectangle2D.getMaxX(), d, n);
        }
        this.newLine(graphics, rectangle2D.getX() + this.seriesWidth, rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getY(), n);
        this.newLine(graphics, rectangle2D.getX(), rectangle2D.getY() + this.cateHeight, rectangle2D.getX(), rectangle2D.getMaxY(), n);
        graphics.setColor(color);
    }

    private void newLine(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        Line2D.Double double_ = new Line2D.Double(d, d2, d3, d4);
        GraphHelper.draw((Graphics)graphics, (Shape)double_, (int)n);
    }

    public int getSeriesSize() {
        return this.plotGlyph.getSeriesSize();
    }

    protected DataSeries getSeries(int n) {
        return this.plotGlyph.getSeries(n);
    }

    public int getCategoryCount() {
        return this.getSeries(0) == null ? 0 : this.getSeries(0).getDataPointCount();
    }

    private double getXWithCateIndex(int n, int n2) {
        return this.getBounds().getX() + this.seriesWidth + this.cateWidth * (double)(this.hasAxisReversed ? n2 - 1 - n : n);
    }

    private Rectangle2D adjustStringBounds(double d, double d2, double d3, double d4, String string, TextAttr textAttr, int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)textAttr, (int)n);
        if (dimension2D.getWidth() < d3) {
            d += (d3 - dimension2D.getWidth()) / 2.0;
            d3 = dimension2D.getWidth();
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private void drawCateLabel(Graphics graphics, int n) {
        DataSeries dataSeries = this.getSeries(0);
        double d = this.getBounds().getY();
        int n2 = this.getCategoryCount();
        for (int i = 0; i < n2; ++i) {
            String string = dataSeries.getDataPoint(i).getCategoryName();
            double d2 = this.getXWithCateIndex(i, n2);
            Rectangle2D rectangle2D = this.adjustStringBounds(d2, d, this.cateWidth, this.cateHeight, string, this.cateLabelTextAttr, n);
            GlyphUtils.drawStrings((Graphics)graphics, (String)string, (TextAttr)this.cateLabelTextAttr, (Rectangle2D)rectangle2D, (int)n);
        }
    }

    private void drawDataPointValue(Graphics graphics, int n) {
        TextAttr textAttr = new TextAttr(this.getFont());
        double d = this.getBounds().getY() + this.cateHeight;
        int n2 = this.plotGlyph.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.plotGlyph.getSeries(i);
            int n3 = dataSeries.getDataPointCount();
            for (int j = 0; j < n3; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                double d2 = dataPoint.getValue();
                String string = VanChartAttrHelper.getValueStringWithFormat(d2, this.format);
                if (dataPoint.isValueIsNull()) {
                    string = "-";
                }
                double d3 = this.getXWithCateIndex(j, n3);
                Rectangle2D rectangle2D = this.adjustStringBounds(d3, d, this.cateWidth, this.seriesHeight, string, textAttr, n);
                GlyphUtils.drawStrings((Graphics)graphics, (String)string, (TextAttr)textAttr, (Rectangle2D)rectangle2D, (int)n);
            }
            d += this.seriesHeight;
        }
    }

    private boolean hasLegend() {
        return this.legendItems != null && this.legendItems.length == this.getSeriesSize();
    }

    private void drawSeriesLabel(Graphics graphics, int n) {
        Rectangle2D rectangle2D = this.getBounds();
        TextAttr textAttr = new TextAttr(this.legendFont);
        int n2 = this.getSeriesSize();
        double d = this.getBounds().getY() + this.cateHeight;
        boolean bl = this.hasLegend();
        for (int i = 0; i < n2; ++i) {
            String string = this.getSeries(i).getSeriesName();
            if (bl) {
                int n3;
                double d2 = GaugeGlyphHelper.calculateOneLineHeight(this.legendFont);
                int n4 = this.legendFont.getShowSize(n);
                String string2 = LegendItem.getTextWhenNotEnoughWidth((String)string, (Font)this.legendFont.applyResolutionNP(n), (double)this.seriesWidth);
                int n5 = string2.lastIndexOf("...");
                if (n5 == (n3 = string2.length()) - 3) {
                    if (ComparatorUtils.equals((Object)(string2 = string2.substring(0, n3 - 3)), (Object)string)) {
                        this.drawOneLineLegend(i, graphics, d, d2, n);
                        d += this.seriesHeight;
                        continue;
                    }
                    this.legendItems[i].setLabel("");
                    this.legendItems[i].setBounds((Rectangle2D)new Rectangle2D.Double(rectangle2D.getX() + 4.0, d, this.seriesWidth, d2));
                    this.legendItems[i].draw(graphics, this.legendFont, n);
                    this.legendItems[i].setLabel(string);
                    Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + 4.0 + (double)n4, d, this.seriesWidth - (double)n4, d2);
                    GlyphUtils.drawStrings((Graphics)graphics, (String)string2, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
                    String string3 = string.replace(string2, "");
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX() + 4.0, d + d2, this.seriesWidth, this.seriesHeight - d2);
                    GlyphUtils.drawStrings((Graphics)graphics, (String)string3, (TextAttr)textAttr, (Rectangle2D)double_2, (int)n);
                } else {
                    this.drawOneLineLegend(i, graphics, d, d2, n);
                }
            } else {
                Rectangle2D rectangle2D2 = this.adjustStringBounds(rectangle2D.getX(), d, this.seriesWidth, this.seriesHeight, string, textAttr, n);
                GlyphUtils.drawStrings((Graphics)graphics, (String)string, (TextAttr)textAttr, (Rectangle2D)rectangle2D2, (int)n);
            }
            d += this.seriesHeight;
        }
    }

    private void drawOneLineLegend(int n, Graphics graphics, double d, double d2, int n2) {
        this.legendItems[n].setBounds((Rectangle2D)new Rectangle2D.Double(this.bounds.getX() + 4.0, d + (this.seriesHeight - d2) / 2.0, this.seriesWidth, d2 + 4.0));
        boolean bl = this.legendItems[n].isDrawInCut();
        this.legendItems[n].setDrawInCut(true);
        this.legendItems[n].draw(graphics, this.legendFont, n2);
        this.legendItems[n].setDrawInCut(bl);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", true);
        if (this.getBorderColor() != null) {
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.getBorderColor()));
        } else {
            jSONObject.put("borderColor", (Object)"rgba(255,255,255,0)");
        }
        jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(this.getBorderStyle()));
        jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getFont()));
        jSONObject.put("formatter", (Object)VanChartAttrHelper.getFormatFunction(this.getFormat()));
        return jSONObject;
    }
}

