/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge;

import com.fr.chart.base.AreaColor;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.gauge.GaugeStyle;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

public class GaugeDetailStyle
implements XMLable {
    private static final long serialVersionUID = -1375490941381976058L;
    public static final String XML_TAG = "GaugeDetailStyle";
    private static final Color HINGE = new Color(101, 107, 109);
    private static final Color HINGE_BACKGROUND = new Color(220, 242, 249);
    private static final Color NEEDLE = new Color(229, 113, 90);
    private static final Color PANE_BACKGROUND = new Color(252, 252, 252);
    private static final Color RING_PANE_BACKGROUND_COLOR = new Color(238, 238, 238);
    private static final Color RING_INNER_PANE_BACKGROUND = new Color(244, 244, 244);
    private static final Color SLOT_NEEDLE_COLOR = Color.WHITE;
    private static final Color SLOT_BACKGROUND = new Color(238, 238, 238);
    private static final Color THERMOMETER_NEEDLE_COLOR = Color.WHITE;
    private static final Color THERMOMETER_SLOT_BACKGROUND_COLOR = new Color(229, 229, 229);
    private boolean horizontalLayout = true;
    private Color hingeColor;
    private Color hingeBackgroundColor;
    private Color needleColor;
    private Color paneBackgroundColor;
    private Color slotBackgroundColor;
    private boolean antiClockWise = true;
    private Color innerPaneBackgroundColor;
    private MapHotAreaColor hotAreaColor = new MapHotAreaColor();

    public void setAntiClockWise(boolean bl) {
        this.antiClockWise = bl;
    }

    public boolean isAntiClockWise() {
        return this.antiClockWise;
    }

    public void setHingeBackgroundColor(Color color) {
        this.hingeBackgroundColor = color;
    }

    public Color getHingeBackgroundColor() {
        return this.hingeBackgroundColor;
    }

    public void setHingeColor(Color color) {
        this.hingeColor = color;
    }

    public Color getHingeColor() {
        return this.hingeColor;
    }

    public void setHorizontalLayout(boolean bl) {
        this.horizontalLayout = bl;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public void setHotAreaColor(MapHotAreaColor mapHotAreaColor) {
        this.hotAreaColor = mapHotAreaColor;
    }

    public MapHotAreaColor getHotAreaColor() {
        return this.hotAreaColor;
    }

    public void setInnerPaneBackgroundColor(Color color) {
        this.innerPaneBackgroundColor = color;
    }

    public Color getInnerPaneBackgroundColor() {
        return this.innerPaneBackgroundColor;
    }

    public void setNeedleColor(Color color) {
        this.needleColor = color;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public void setPaneBackgroundColor(Color color) {
        this.paneBackgroundColor = color;
    }

    public Color getPaneBackgroundColor() {
        return this.paneBackgroundColor;
    }

    public void setSlotBackgroundColor(Color color) {
        this.slotBackgroundColor = color;
    }

    public Color getSlotBackgroundColor() {
        return this.slotBackgroundColor;
    }

    public GaugeDetailStyle(GaugeStyle gaugeStyle) {
        switch (gaugeStyle) {
            case THERMOMETER: {
                this.needleColor = THERMOMETER_NEEDLE_COLOR;
                this.slotBackgroundColor = THERMOMETER_SLOT_BACKGROUND_COLOR;
                break;
            }
            case SLOT: {
                this.needleColor = SLOT_NEEDLE_COLOR;
                this.slotBackgroundColor = SLOT_BACKGROUND;
                break;
            }
            case RING: {
                this.paneBackgroundColor = RING_PANE_BACKGROUND_COLOR;
                this.innerPaneBackgroundColor = RING_INNER_PANE_BACKGROUND;
                break;
            }
            default: {
                this.hingeColor = HINGE;
                this.hingeBackgroundColor = HINGE_BACKGROUND;
                this.needleColor = NEEDLE;
                this.paneBackgroundColor = PANE_BACKGROUND;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("GaugeDetailStyleAttr").attr("horizontalLayout", this.horizontalLayout);
        if (this.hingeColor != null) {
            xMLPrintWriter.attr("hingeColor", this.hingeColor.getRGB());
        }
        if (this.hingeBackgroundColor != null) {
            xMLPrintWriter.attr("hingeBackgroundColor", this.hingeBackgroundColor.getRGB());
        }
        if (this.needleColor != null) {
            xMLPrintWriter.attr("needleColor", this.needleColor.getRGB());
        }
        if (this.paneBackgroundColor != null) {
            xMLPrintWriter.attr("paneBackgroundColor", this.paneBackgroundColor.getRGB());
        }
        if (this.slotBackgroundColor != null) {
            xMLPrintWriter.attr("slotBackgroundColor", this.slotBackgroundColor.getRGB());
        }
        if (this.innerPaneBackgroundColor != null) {
            xMLPrintWriter.attr("innerPaneBackgroundColor", this.innerPaneBackgroundColor.getRGB());
        }
        xMLPrintWriter.attr("antiClockWise", this.antiClockWise);
        xMLPrintWriter.end();
        if (this.hotAreaColor != null) {
            this.hotAreaColor.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("GaugeDetailStyleAttr".equals(string)) {
                this.horizontalLayout = xMLableReader.getAttrAsBoolean("horizontalLayout", true);
                this.hingeColor = xMLableReader.getAttrAsColor("hingeColor", null);
                this.hingeBackgroundColor = xMLableReader.getAttrAsColor("hingeBackgroundColor", null);
                this.needleColor = xMLableReader.getAttrAsColor("needleColor", null);
                this.paneBackgroundColor = xMLableReader.getAttrAsColor("paneBackgroundColor", null);
                this.slotBackgroundColor = xMLableReader.getAttrAsColor("slotBackgroundColor", null);
                this.antiClockWise = xMLableReader.getAttrAsBoolean("antiClockWise", true);
                this.innerPaneBackgroundColor = xMLableReader.getAttrAsColor("innerPaneBackgroundColor", null);
            } else if (ComparatorUtils.equals((Object)string, (Object)"MapHotAreaColor")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        GaugeDetailStyle.this.hotAreaColor = (MapHotAreaColor)xMLableReader.readXMLObject((XMLReadable)new MapHotAreaColor());
                    }
                });
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GaugeDetailStyle gaugeDetailStyle = (GaugeDetailStyle)super.clone();
        gaugeDetailStyle.setAntiClockWise(this.isAntiClockWise());
        gaugeDetailStyle.setHingeBackgroundColor(this.getHingeBackgroundColor());
        gaugeDetailStyle.setHingeColor(this.getHingeColor());
        gaugeDetailStyle.setHorizontalLayout(this.isHorizontalLayout());
        gaugeDetailStyle.setHotAreaColor((MapHotAreaColor)this.getHotAreaColor().clone());
        gaugeDetailStyle.setInnerPaneBackgroundColor(this.getInnerPaneBackgroundColor());
        gaugeDetailStyle.setNeedleColor(this.getNeedleColor());
        gaugeDetailStyle.setSlotBackgroundColor(this.getSlotBackgroundColor());
        gaugeDetailStyle.setPaneBackgroundColor(this.getPaneBackgroundColor());
        return gaugeDetailStyle;
    }

    public boolean equals(Object object) {
        return object instanceof GaugeDetailStyle && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).isAntiClockWise(), (Object)this.isAntiClockWise()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getHingeBackgroundColor(), (Object)this.getHingeBackgroundColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getHingeColor(), (Object)this.getHingeColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).isHorizontalLayout(), (Object)this.isHorizontalLayout()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getHotAreaColor(), (Object)this.getHotAreaColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getInnerPaneBackgroundColor(), (Object)this.getInnerPaneBackgroundColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getNeedleColor(), (Object)this.getNeedleColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getSlotBackgroundColor(), (Object)this.getSlotBackgroundColor()) && ComparatorUtils.equals((Object)((GaugeDetailStyle)object).getPaneBackgroundColor(), (Object)this.getPaneBackgroundColor());
    }

    public void dealFormula(Calculator calculator) {
        this.hotAreaColor.dealFormula(calculator);
    }

    public JSONArray getBandsArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        List list = this.hotAreaColor.getAreaColorList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AreaColor areaColor = (AreaColor)list.get(i);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("from", areaColor.getMinNum());
            jSONObject.put("to", areaColor.getMaxNum());
            jSONObject.put("color", (Object)StableUtils.javaColor2JSColorWithAlpha((Color)areaColor.getAreaColor()));
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public void addDetailStyleJSON(JSONObject jSONObject, GaugeStyle gaugeStyle) throws JSONException {
        switch (gaugeStyle) {
            case RING: {
                this.addClockWiseJSON(jSONObject);
                this.addPaneBackgroundColorJSON(jSONObject);
                this.addInnerPaneBackgroundColorJSON(jSONObject);
                break;
            }
            case SLOT: {
                this.addNeedleColorJSON(jSONObject);
                this.addSlotBackgroundColorJSON(jSONObject);
                break;
            }
            case THERMOMETER: {
                this.addNeedleColorJSON(jSONObject);
                this.addSlotBackgroundColorJSON(jSONObject);
                jSONObject.put("thermometerLayout", (Object)(this.isHorizontalLayout() ? "vertical" : "horizontal"));
                break;
            }
            default: {
                this.addHingeColorJSON(jSONObject);
                this.addHingeBackgroundColorJSON(jSONObject);
                this.addNeedleColorJSON(jSONObject);
                this.addPaneBackgroundColorJSON(jSONObject);
            }
        }
    }

    private void addClockWiseJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("clockwise", !this.antiClockWise);
    }

    private void addPaneBackgroundColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("paneBackgroundColor", (Object)VanChartAttrHelper.getStringColor(this.paneBackgroundColor));
    }

    private void addInnerPaneBackgroundColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("innerPaneBackgroundColor", (Object)VanChartAttrHelper.getStringColor(this.innerPaneBackgroundColor));
    }

    private void addNeedleColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("needle", (Object)VanChartAttrHelper.getStringColor(this.needleColor));
    }

    private void addSlotBackgroundColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("slotBackgroundColor", (Object)VanChartAttrHelper.getStringColor(this.slotBackgroundColor));
    }

    private void addHingeColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("hinge", (Object)VanChartAttrHelper.getStringColor(this.hingeColor));
    }

    private void addHingeBackgroundColorJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("hingeBackgroundColor", (Object)VanChartAttrHelper.getStringColor(this.hingeBackgroundColor));
    }
}

