/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component.format;

import com.fr.base.Style;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.gui.frpane.UIBubbleFloatPane;
import com.fr.design.gui.ibutton.UIButton;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.style.FormatPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Format;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class VanChartFormatPaneWithCheckBox
extends JPanel {
    private static final long serialVersionUID = -6563172546340480058L;
    private UICheckBox isSelectedBox;
    private UIButton formatButton;
    private FormatPane formatPane;
    private Format format;
    private VanChartStylePane parent;
    private JPanel showOnPane;
    private boolean isDirty;

    public VanChartFormatPaneWithCheckBox(VanChartStylePane vanChartStylePane, JPanel jPanel) {
        this.parent = vanChartStylePane;
        this.showOnPane = jPanel;
        this.isDirty = true;
        this.setLayout(new BorderLayout());
        this.isSelectedBox = new UICheckBox(this.getCheckBoxText());
        this.formatButton = new UIButton(Inter.getLocText((String)"Chart-Use_Format"));
        this.add((Component)this.isSelectedBox, "Center");
        this.add((Component)this.formatButton, "East");
        this.initFormatListener();
        this.isSelectedBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                VanChartFormatPaneWithCheckBox.this.isDirty = true;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    protected abstract String getCheckBoxText();

    protected boolean isPercent() {
        return false;
    }

    private void initFormatListener() {
        if (this.formatButton != null) {
            this.formatButton.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (!VanChartFormatPaneWithCheckBox.this.formatButton.isEnabled()) {
                        return;
                    }
                    if (VanChartFormatPaneWithCheckBox.this.formatPane == null) {
                        VanChartFormatPaneWithCheckBox.this.formatPane = new FormatPane();
                    }
                    Point point = VanChartFormatPaneWithCheckBox.this.formatButton.getLocationOnScreen();
                    Point point2 = new Point(point.x + VanChartFormatPaneWithCheckBox.this.formatButton.getWidth(), point.y + VanChartFormatPaneWithCheckBox.this.formatButton.getHeight());
                    UIBubbleFloatPane uIBubbleFloatPane = new UIBubbleFloatPane(2, point2, (BasicBeanPane)VanChartFormatPaneWithCheckBox.this.formatPane, 258, 209){

                        public void updateContentPane() {
                            VanChartFormatPaneWithCheckBox.this.format = VanChartFormatPaneWithCheckBox.this.formatPane.update();
                            if (VanChartFormatPaneWithCheckBox.this.parent != null) {
                                VanChartFormatPaneWithCheckBox.this.parent.attributeChanged();
                            }
                        }
                    };
                    uIBubbleFloatPane.show((JComponent)VanChartFormatPaneWithCheckBox.this.showOnPane, (Object)Style.getInstance((Format)VanChartFormatPaneWithCheckBox.this.format));
                    super.mouseReleased(mouseEvent);
                    if (VanChartFormatPaneWithCheckBox.this.isPercent()) {
                        VanChartFormatPaneWithCheckBox.this.formatPane.justUsePercentFormat();
                    }
                }
            });
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean isSelected() {
        return this.isSelectedBox.isSelected();
    }

    public void setSelected(boolean bl) {
        this.isSelectedBox.setSelected(bl);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }
}

