/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component;

import com.fr.design.beans.BasicBeanPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.general.Inter;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartHtmlLabelPane;
import com.fr.plugin.chart.designer.component.VanChartHtmlLabelPaneWithOutWidthAndHeight;
import com.fr.plugin.chart.designer.component.format.CategoryNameFormatPaneWithCheckBox;
import com.fr.plugin.chart.designer.component.format.PercentFormatPaneWithCheckBox;
import com.fr.plugin.chart.designer.component.format.SeriesNameFormatPaneWithCheckBox;
import com.fr.plugin.chart.designer.component.format.ValueFormatPaneWithCheckBox;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class VanChartTooltipContentPane
extends BasicBeanPane<AttrTooltipContent> {
    private static final long serialVersionUID = 8825929000117843641L;
    protected UIButtonGroup<Integer> content;
    protected ValueFormatPaneWithCheckBox valueFormatPane;
    protected PercentFormatPaneWithCheckBox percentFormatPane;
    protected CategoryNameFormatPaneWithCheckBox categoryNameFormatPane;
    protected SeriesNameFormatPaneWithCheckBox seriesNameFormatPane;
    private JPanel centerPane;
    protected VanChartHtmlLabelPane htmlLabelPane;
    private VanChartStylePane parent;
    private JPanel showOnPane;

    public VanChartHtmlLabelPane getHtmlLabelPane() {
        return this.htmlLabelPane;
    }

    public VanChartTooltipContentPane(VanChartStylePane vanChartStylePane, JPanel jPanel) {
        this.parent = vanChartStylePane;
        this.showOnPane = jPanel;
        this.setLayout(new BorderLayout());
        this.add(this.createLabelContentPane(), "Center");
    }

    protected JPanel createLabelContentPane() {
        this.content = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Common"), Inter.getLocText((String)"Plugin-ChartF_Custom")});
        this.initFormatPane(this.parent, this.showOnPane);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2, d};
        double[] dArray2 = this.getRowSize(d);
        final JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])this.getPaneComponents(), (double[])dArray2, (double[])dArray);
        this.htmlLabelPane = this.createHtmlLabelPane();
        this.centerPane = new JPanel(new CardLayout()){

            @Override
            public Dimension getPreferredSize() {
                if (VanChartTooltipContentPane.this.content.getSelectedIndex() == 0) {
                    return jPanel.getPreferredSize();
                }
                return VanChartTooltipContentPane.this.htmlLabelPane.getPreferredSize();
            }
        };
        this.centerPane.add((Component)this.htmlLabelPane, Inter.getLocText((String)"Plugin-ChartF_Custom"));
        this.centerPane.add((Component)jPanel, Inter.getLocText((String)"Plugin-ChartF_Common"));
        this.initContentListener();
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 4));
        jPanel2.add((Component)this.content, "North");
        jPanel2.add((Component)this.centerPane, "Center");
        return this.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Content"), jPanel2);
    }

    protected VanChartHtmlLabelPane createHtmlLabelPane() {
        return new VanChartHtmlLabelPaneWithOutWidthAndHeight();
    }

    protected void initFormatPane(VanChartStylePane vanChartStylePane, JPanel jPanel) {
        this.categoryNameFormatPane = new CategoryNameFormatPaneWithCheckBox(vanChartStylePane, jPanel);
        this.seriesNameFormatPane = new SeriesNameFormatPaneWithCheckBox(vanChartStylePane, jPanel);
        this.valueFormatPane = new ValueFormatPaneWithCheckBox(vanChartStylePane, jPanel);
        this.percentFormatPane = new PercentFormatPaneWithCheckBox(vanChartStylePane, jPanel);
    }

    protected JPanel createTableLayoutPaneWithTitle(String string, Component component) {
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(string, component);
    }

    protected double[] getRowSize(double d) {
        return new double[]{d, d, d, d};
    }

    protected Component[][] getPaneComponents() {
        return new Component[][]{{this.categoryNameFormatPane, null}, {this.seriesNameFormatPane, null}, {this.valueFormatPane, null}, {this.percentFormatPane, null}};
    }

    private void initContentListener() {
        this.content.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartTooltipContentPane.this.checkCardPane();
            }
        });
    }

    private void checkCardPane() {
        CardLayout cardLayout = (CardLayout)this.centerPane.getLayout();
        if (this.content.getSelectedIndex() == 1) {
            cardLayout.show(this.centerPane, Inter.getLocText((String)"Plugin-ChartF_Custom"));
            if (this.isDirty()) {
                this.setCustomFormatterText();
                this.setDirty(false);
            }
        } else {
            cardLayout.show(this.centerPane, Inter.getLocText((String)"Plugin-ChartF_Common"));
        }
    }

    protected void setCustomFormatterText() {
        this.htmlLabelPane.setCustomFormatterText(this.updateBean().getFormatterTextFromCommon());
    }

    public boolean isDirty() {
        return this.categoryNameFormatPane.isDirty() || this.seriesNameFormatPane.isDirty() || this.valueFormatPane.isDirty() || this.percentFormatPane.isDirty();
    }

    public void setDirty(boolean bl) {
        this.categoryNameFormatPane.setDirty(bl);
        this.seriesNameFormatPane.setDirty(bl);
        this.valueFormatPane.setDirty(bl);
        this.percentFormatPane.setDirty(bl);
    }

    protected String title4PopupWindow() {
        return "";
    }

    public void populateBean(AttrTooltipContent attrTooltipContent) {
        if (attrTooltipContent == null) {
            return;
        }
        this.content.setSelectedIndex(attrTooltipContent.isCommon() ? 0 : 1);
        this.setFormatPaneIsSelected(attrTooltipContent);
        this.setFormatPaneFormat(attrTooltipContent);
        this.htmlLabelPane.populate(attrTooltipContent.getHtmlLabel());
        if (!attrTooltipContent.isCommon()) {
            this.setDirty(false);
        }
        this.checkCardPane();
    }

    public void setFormatPaneIsSelected(AttrTooltipContent attrTooltipContent) {
        this.categoryNameFormatPane.setSelected(attrTooltipContent.getCategoryFormat().isEnable());
        this.seriesNameFormatPane.setSelected(attrTooltipContent.getSeriesFormat().isEnable());
        this.valueFormatPane.setSelected(attrTooltipContent.getValueFormat().isEnable());
        this.percentFormatPane.setSelected(attrTooltipContent.getPercentFormat().isEnable());
    }

    public void setFormatPaneFormat(AttrTooltipContent attrTooltipContent) {
        this.categoryNameFormatPane.setFormat(attrTooltipContent.getCategoryFormat().getFormat());
        this.seriesNameFormatPane.setFormat(attrTooltipContent.getSeriesFormat().getFormat());
        this.valueFormatPane.setFormat(attrTooltipContent.getValueFormat().getFormat());
        this.percentFormatPane.setFormat(attrTooltipContent.getPercentFormat().getFormat());
    }

    public AttrTooltipContent updateBean() {
        AttrTooltipContent attrTooltipContent = new AttrTooltipContent();
        attrTooltipContent.setCommon(this.content.getSelectedIndex() == 0);
        this.updateFormatPaneIsSelected(attrTooltipContent);
        this.updateFormatPaneFormat(attrTooltipContent);
        this.htmlLabelPane.update(attrTooltipContent.getHtmlLabel());
        return attrTooltipContent;
    }

    public void updateFormatPaneIsSelected(AttrTooltipContent attrTooltipContent) {
        attrTooltipContent.getCategoryFormat().setEnable(this.categoryNameFormatPane.isSelected());
        attrTooltipContent.getSeriesFormat().setEnable(this.seriesNameFormatPane.isSelected());
        attrTooltipContent.getValueFormat().setEnable(this.valueFormatPane.isSelected());
        attrTooltipContent.getPercentFormat().setEnable(this.percentFormatPane.isSelected());
    }

    public void updateFormatPaneFormat(AttrTooltipContent attrTooltipContent) {
        attrTooltipContent.getCategoryFormat().setFormat(this.categoryNameFormatPane.getFormat());
        attrTooltipContent.getSeriesFormat().setFormat(this.seriesNameFormatPane.getFormat());
        attrTooltipContent.getValueFormat().setFormat(this.valueFormatPane.getFormat());
        attrTooltipContent.getPercentFormat().setFormat(this.percentFormatPane.getFormat());
    }
}

