/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr.plot;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartValueAxis;
import com.fr.plugin.chart.attr.plot.VanChartAxisPlot;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartRectanglePlotGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public abstract class VanChartRectanglePlot
extends VanChartPlot
implements VanChartAxisPlot {
    private static final long serialVersionUID = -464988260022618096L;
    protected List<VanChartAxis> xAxisList;
    protected List<VanChartAxis> yAxisList;
    protected VanChartPlotType vanChartPlotType = VanChartPlotType.NORMAL;
    private boolean isDefaultIntervalBackground = true;
    private ConditionCollection stackAndAxisCondition = new ConditionCollection();

    @Override
    public List<VanChartAxis> getYAxisList() {
        return this.yAxisList;
    }

    @Override
    public List<VanChartAxis> getXAxisList() {
        return this.xAxisList;
    }

    public void setXAxisList(List<VanChartAxis> list) {
        this.xAxisList = list;
    }

    public void setYAxisList(List<VanChartAxis> list) {
        this.yAxisList = list;
    }

    public void setVanChartPlotType(VanChartPlotType vanChartPlotType) {
        this.vanChartPlotType = vanChartPlotType;
    }

    public VanChartPlotType getVanChartPlotType() {
        return this.vanChartPlotType;
    }

    public void setIsDefaultIntervalBackground(boolean bl) {
        this.isDefaultIntervalBackground = bl;
    }

    public boolean isDefaultIntervalBackground() {
        return this.isDefaultIntervalBackground;
    }

    public void setStackAndAxisCondition(ConditionCollection conditionCollection) {
        this.stackAndAxisCondition = conditionCollection;
    }

    @Override
    public ConditionCollection getStackAndAxisCondition() {
        return this.stackAndAxisCondition;
    }

    public VanChartRectanglePlot() {
        this(VanChartPlotType.NORMAL);
    }

    public VanChartRectanglePlot(VanChartPlotType vanChartPlotType) {
        this.vanChartPlotType = vanChartPlotType;
        this.initXYAxisList();
        this.setDataSheetDefaultFormat();
    }

    protected void initXYAxisList() {
        this.xAxisList = VanChartAttrHelper.createDefaultXAxisList();
        this.yAxisList = VanChartAttrHelper.createDefaultYAxisList();
    }

    protected void setDataSheetDefaultFormat() {
        if (this.getDataSheet() != null) {
            this.getDataSheet().setFormat((Format)VanChartAttrHelper.VALUE_FORMAT);
        }
    }

    @Override
    public VanChartAxis createXAxis(String string, int n) {
        return new VanChartAxis(string, n);
    }

    @Override
    public VanChartAxis createYAxis(String string, int n) {
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(string, n);
        vanChartValueAxis.setAxisStyle(0);
        vanChartValueAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        return vanChartValueAxis;
    }

    public boolean isNormalChart() {
        return ComparatorUtils.equals((Object)((Object)this.vanChartPlotType), (Object)((Object)VanChartPlotType.NORMAL));
    }

    @Override
    public boolean isCustomChart() {
        return ComparatorUtils.equals((Object)((Object)this.vanChartPlotType), (Object)((Object)VanChartPlotType.CUSTOM));
    }

    public boolean isStackChart() {
        return ComparatorUtils.equals((Object)((Object)this.vanChartPlotType), (Object)((Object)VanChartPlotType.STACK));
    }

    public boolean isPercentStackChart() {
        return ComparatorUtils.equals((Object)((Object)this.vanChartPlotType), (Object)((Object)VanChartPlotType.STACK_BY_PERCENT));
    }

    public VanChartAxis getDefaultXAxis() {
        return this.xAxisList.get(0);
    }

    public VanChartAxis getDefaultYAxis() {
        return this.yAxisList.get(0);
    }

    public void installAxisGlyph(VanChartRectanglePlotGlyph vanChartRectanglePlotGlyph, ChartData chartData) {
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph;
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            vanChartBaseAxisGlyph = vanChartAxis.createAxisGlyph(chartData);
            vanChartRectanglePlotGlyph.addXAxisGlyph(vanChartBaseAxisGlyph);
        }
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            vanChartBaseAxisGlyph = vanChartAxis.createAxisGlyph(chartData);
            vanChartRectanglePlotGlyph.addYAxisGlyph(vanChartBaseAxisGlyph);
        }
    }

    public DataSheetGlyph createDataSheetGlyph(PlotGlyph plotGlyph) {
        boolean bl;
        boolean bl2 = bl = this.getDefaultXAxis().getPosition() == 3 && ComparatorUtils.equals((Object)((Object)this.getDefaultXAxis().getAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY));
        if (this.getDataSheet() != null && this.getDataSheet().isVisible() && bl) {
            return plotGlyph.createDataSheetGlyph(this.getDataSheet(), null);
        }
        if (this.getDataSheet() != null) {
            this.getDataSheet().setVisible(false);
        }
        return null;
    }

    @Override
    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, ChartData chartData) {
        if (this.getStackAndAxisCondition().getConditionAttrSize() > 0) {
            this.clearAllAxisPercent();
        }
        super.addSeriesByIndex(n, n2, plotGlyph, chartData);
    }

    @Override
    protected void dealDataSeriesOtherAttr(VanChartDataSeries vanChartDataSeries, boolean bl, ConditionCollection conditionCollection) {
        if (bl) {
            this.dealDataSeriesCustomCondition(vanChartDataSeries, conditionCollection);
        }
        this.dealDataSeriesStackAndAxisCondition(vanChartDataSeries, this.stackAndAxisCondition);
    }

    private void clearAllAxisPercent() {
        if (this.isPercentStackChart()) {
            return;
        }
        for (VanChartAxis vanChartAxis : this.getValueAxisList()) {
            vanChartAxis.setPercentage(false);
        }
    }

    protected List<VanChartAxis> getValueAxisList() {
        return this.yAxisList;
    }

    protected void dealDataSeriesStackAndAxisCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        if (this.isCustomChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = (AttrSeriesStackAndAxis)conditionCollection.getCustomDataSeriesCondition(AttrSeriesStackAndAxis.class, (Result)vanChartDataSeries);
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
            if (attrSeriesStackAndAxis != null && attrSeriesStackAndAxis.isPercentStacked()) {
                VanChartAxis vanChartAxis = this.getDefaultValueAxis(attrSeriesStackAndAxis);
                vanChartAxis.setPercentage(true);
            }
        } else if (this.isStackChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
        } else if (this.isPercentStackChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
            attrSeriesStackAndAxis.setPercentStacked(true);
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
            VanChartAxis vanChartAxis = this.getDefaultValueAxis();
            vanChartAxis.setPercentage(true);
        }
    }

    protected VanChartAxis getDefaultValueAxis() {
        return this.getDefaultYAxis();
    }

    protected VanChartAxis getDefaultValueAxis(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return this.getYAxisList().get(attrSeriesStackAndAxis.getYAxisIndex());
    }

    public boolean equals(Object object) {
        return object instanceof VanChartRectanglePlot && super.equals(object) && ComparatorUtils.equals((Object)((Object)((VanChartRectanglePlot)object).getVanChartPlotType()), (Object)((Object)this.getVanChartPlotType())) && ComparatorUtils.equals((Object)((VanChartRectanglePlot)object).isDefaultIntervalBackground(), (Object)this.isDefaultIntervalBackground()) && ComparatorUtils.equals(((VanChartRectanglePlot)object).getYAxisList(), this.getYAxisList()) && ComparatorUtils.equals(((VanChartRectanglePlot)object).getXAxisList(), this.getXAxisList()) && ComparatorUtils.equals((Object)((VanChartRectanglePlot)object).getStackAndAxisCondition(), (Object)this.getStackAndAxisCondition());
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartRectanglePlot vanChartRectanglePlot = (VanChartRectanglePlot)super.clone();
        vanChartRectanglePlot.setVanChartPlotType(this.getVanChartPlotType());
        vanChartRectanglePlot.setIsDefaultIntervalBackground(this.isDefaultIntervalBackground());
        vanChartRectanglePlot.xAxisList = new ArrayList<VanChartAxis>();
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            vanChartRectanglePlot.xAxisList.add((VanChartAxis)((Object)vanChartAxis.clone()));
        }
        vanChartRectanglePlot.yAxisList = new ArrayList<VanChartAxis>();
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            vanChartRectanglePlot.yAxisList.add((VanChartAxis)((Object)vanChartAxis.clone()));
        }
        if (this.getStackAndAxisCondition() != null) {
            vanChartRectanglePlot.setStackAndAxisCondition((ConditionCollection)this.getStackAndAxisCondition().clone());
        }
        return vanChartRectanglePlot;
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("VanChartRectanglePlotAttr")) {
                this.vanChartPlotType = VanChartPlotType.parse(xMLableReader.getAttrAsString("vanChartPlotType", VanChartPlotType.NORMAL.getType()));
                this.isDefaultIntervalBackground = xMLableReader.getAttrAsBoolean("isDefaultIntervalBackground", true);
            } else if (string.equals("XAxisList")) {
                this.xAxisList.clear();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("VanChartAxis")) {
                            VanChartRectanglePlot.this.xAxisList.add((VanChartAxis)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if (string.equals("YAxisList")) {
                this.yAxisList.clear();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("VanChartAxis")) {
                            VanChartRectanglePlot.this.yAxisList.add((VanChartAxis)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if (string.equals("stackAndAxisCondition")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ConditionCollection")) {
                            VanChartRectanglePlot.this.setStackAndAxisCondition((ConditionCollection)xMLableReader.readXMLObject((XMLReadable)new ConditionCollection()));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartRectanglePlotAttr").attr("vanChartPlotType", this.vanChartPlotType.getType()).attr("isDefaultIntervalBackground", this.isDefaultIntervalBackground).end();
        xMLPrintWriter.startTAG("XAxisList");
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)vanChartAxis, (String)"VanChartAxis");
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("YAxisList");
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)vanChartAxis, (String)"VanChartAxis");
        }
        xMLPrintWriter.end();
        if (this.stackAndAxisCondition != null) {
            xMLPrintWriter.startTAG("stackAndAxisCondition");
            this.stackAndAxisCondition.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            vanChartAxis.dealFormula(calculator);
        }
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            vanChartAxis.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            vanChartAxis.buidExecuteSequenceList(list, calculator);
        }
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            vanChartAxis.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        for (VanChartAxis vanChartAxis : this.xAxisList) {
            vanChartAxis.modFormulaString(mOD_COLUMN_ROW);
        }
        for (VanChartAxis vanChartAxis : this.yAxisList) {
            vanChartAxis.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public boolean isSupportIntervalBackground() {
        return true;
    }

    public boolean isSupportBorder() {
        return true;
    }

    public boolean isSupportTrendLine() {
        return true;
    }

    public boolean isSupportTooltipSeriesType() {
        return true;
    }

    public boolean isSupportDataSheet() {
        return true;
    }

    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    public boolean isSupportZoomDirection() {
        return true;
    }
}

