/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr.plot;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.js.NameJavaScriptGroup;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.base.AttrAreaSeriesFillColorBackground;
import com.fr.plugin.chart.base.AttrFloatColor;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.base.VanChartAttrTrendLine;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartLegendGlyph;
import com.fr.plugin.chart.glyph.VanChartPlotGlyph;
import com.fr.plugin.chart.line.VanChartLineDataPoint;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public abstract class VanChartPlot
extends Plot {
    private static final long serialVersionUID = 734260049200573474L;
    private boolean useDefaultNullData = false;

    public VanChartPlot() {
        this.setLegend(this.initLegend());
    }

    protected VanChartLegend initLegend() {
        return new VanChartLegend();
    }

    public ChartData createNullChartData() {
        this.useDefaultNullData = true;
        return super.createNullChartData();
    }

    public void install4PlotGlyph(VanChartPlotGlyph vanChartPlotGlyph, ChartData chartData) {
        vanChartPlotGlyph.setGeneralInfo((GeneralInfo)this);
        vanChartPlotGlyph.setConditionCollection(this.getConditionCollection());
        vanChartPlotGlyph.setHotHyperLink(this.getHotHyperLink());
        vanChartPlotGlyph.setAutoRefreshPerSecond(this.getAutoRefreshPerSecond());
        vanChartPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        vanChartPlotGlyph.setPlotStyle(this.getPlotStyle());
        vanChartPlotGlyph.setUseDefaultNullData(this.useDefaultNullData);
        this.addSeries2PlotGlyph(vanChartPlotGlyph, chartData);
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        if (chartData instanceof NormalChartData) {
            super.addSeries2PlotGlyph(plotGlyph, chartData);
        }
    }

    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, ChartData chartData) {
        super.addSeriesByIndex(n, n2, plotGlyph, chartData);
        this.dealDataSeriesAndPointOtherAttr(plotGlyph);
    }

    protected void dealDataSeriesAndPointOtherAttr(PlotGlyph plotGlyph) {
        ConditionCollection conditionCollection = this.getConditionCollection();
        boolean bl = conditionCollection.getConditionAttrSize() > 0;
        int n = plotGlyph.getSeriesSize();
        Color[] colorArray = ChartBaseUtils.createFillColorArray((AttrFillStyle)this.getPlotFillStyle(), (int)n);
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)plotGlyph.getSeries(i);
            this.dealDataSeriesOtherAttr(vanChartDataSeries, bl, conditionCollection);
            int n2 = plotGlyph.getCategoryCount();
            for (int j = 0; j < n2; ++j) {
                VanChartDataPoint vanChartDataPoint = (VanChartDataPoint)vanChartDataSeries.getDataPoint(j);
                this.dealDataPointOtherAttr(vanChartDataPoint, bl, conditionCollection, colorArray[i], vanChartDataSeries);
            }
        }
    }

    protected void dealDataSeriesOtherAttr(VanChartDataSeries vanChartDataSeries, boolean bl, ConditionCollection conditionCollection) {
        if (bl) {
            this.dealDataSeriesCustomCondition(vanChartDataSeries, conditionCollection);
        }
    }

    protected void dealDataPointOtherAttr(VanChartDataPoint vanChartDataPoint, boolean bl, ConditionCollection conditionCollection, Color color, VanChartDataSeries vanChartDataSeries) {
        if (bl) {
            this.dealDataPointCustomCondition(vanChartDataPoint, conditionCollection);
            vanChartDataPoint.setDefaultColor(color);
        }
    }

    protected abstract void dealDataSeriesCustomCondition(VanChartDataSeries var1, ConditionCollection var2);

    protected void dealDataSeriesAttrTrendLineCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        VanChartAttrTrendLine vanChartAttrTrendLine = (VanChartAttrTrendLine)conditionCollection.getCustomDataSeriesCondition(VanChartAttrTrendLine.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setAttrTrendLine(vanChartAttrTrendLine);
    }

    protected void dealDataSeriesAttrBackgroundCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        AttrBackground attrBackground = (AttrBackground)conditionCollection.getCustomDataSeriesCondition(AttrBackground.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setColor(attrBackground);
    }

    protected void dealDataSeriesAttrAlphaCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        AttrAlpha attrAlpha = (AttrAlpha)conditionCollection.getCustomDataSeriesCondition(AttrAlpha.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setAlpha(attrAlpha);
    }

    protected void dealDataSeriesAttrLineCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        VanChartAttrLine vanChartAttrLine = (VanChartAttrLine)conditionCollection.getCustomDataSeriesCondition(VanChartAttrLine.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setAttrLine(vanChartAttrLine);
    }

    protected void dealDataSeriesAttrMarkerCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        VanChartAttrMarker vanChartAttrMarker = (VanChartAttrMarker)conditionCollection.getCustomDataSeriesCondition(VanChartAttrMarker.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setMarker(vanChartAttrMarker);
    }

    protected void dealDataSeriesAttrFillColorBackgroundCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = (AttrAreaSeriesFillColorBackground)conditionCollection.getCustomDataSeriesCondition(AttrAreaSeriesFillColorBackground.class, (Result)vanChartDataSeries);
        vanChartDataSeries.setFillColorBackground(attrAreaSeriesFillColorBackground);
    }

    protected abstract void dealDataPointCustomCondition(VanChartDataPoint var1, ConditionCollection var2);

    protected void dealDataPointAttrLabelCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrLabel attrLabel = (AttrLabel)conditionCollection.getCustomDataSeriesCondition(AttrLabel.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setLabel(attrLabel);
    }

    protected void dealDataPointAttrTooltipCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrTooltip attrTooltip = (AttrTooltip)conditionCollection.getCustomDataSeriesCondition(AttrTooltip.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setTooltip(attrTooltip);
    }

    protected void dealDataPointAttrAlphaCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrAlpha attrAlpha = (AttrAlpha)conditionCollection.getCustomDataSeriesCondition(AttrAlpha.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setAlpha(attrAlpha);
    }

    protected void dealDataPointAttrBorderCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrBorder attrBorder = (AttrBorder)conditionCollection.getCustomDataSeriesCondition(AttrBorder.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setBorder(attrBorder);
    }

    protected void dealDataPointAttrBackgroundCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrBackground attrBackground = (AttrBackground)conditionCollection.getCustomDataSeriesCondition(AttrBackground.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setColor(attrBackground);
    }

    protected void dealDataPointAttrFloatColorCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        AttrFloatColor attrFloatColor = (AttrFloatColor)conditionCollection.getCustomDataSeriesCondition(AttrFloatColor.class, (Result)vanChartDataPoint);
        vanChartDataPoint.setFloatColor(attrFloatColor);
    }

    protected void dealDataPointAttrMarkerCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        VanChartAttrMarker vanChartAttrMarker = (VanChartAttrMarker)conditionCollection.getCustomDataSeriesCondition(VanChartAttrMarker.class, (Result)vanChartDataPoint);
        ((VanChartLineDataPoint)vanChartDataPoint).setAttrMarker(vanChartAttrMarker);
    }

    public VanChartLegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (this.getLegend() == null) {
            return null;
        }
        return ((VanChartLegend)this.getLegend()).createLegendGlyph(plotGlyph);
    }

    protected DataPoint createDataPoint() {
        return new VanChartDataPoint();
    }

    protected DataSeries createDataSeries(int n) {
        return new VanChartDataSeries(n);
    }

    protected void createDataPointLabel(PlotGlyph plotGlyph) {
    }

    public AttrTooltip getDefaultAttrTooltip() {
        AttrTooltip attrTooltip = new AttrTooltip();
        attrTooltip.getContent().getCategoryFormat().setEnable(true);
        attrTooltip.getContent().getSeriesFormat().setEnable(true);
        return attrTooltip;
    }

    public AttrLabel getDefaultAttrLabel() {
        return new AttrLabel();
    }

    protected void readPlotXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("ConditionCollection".equals(string)) {
                this.setConditionCollection((ConditionCollection)xMLableReader.readXMLObject((XMLReadable)new ConditionCollection()));
            } else if ("Legend4VanChart".equals(string)) {
                this.setLegend((Legend)xMLableReader.readXMLObject((XMLReadable)this.initLegend()));
            } else if ("DataSheet".equals(string)) {
                this.setDataSheet((DataSheet)xMLableReader.readXMLObject((XMLReadable)new DataSheet()));
            } else if (string.equals("newHotTooltipStyle")) {
                xMLableReader.readXMLObject((XMLReadable)new AttrContents());
            } else if ("NameJavaScriptGroup".equals(string)) {
                this.setHotHyperLink((NameJavaScriptGroup)xMLableReader.readXMLObject((XMLReadable)new NameJavaScriptGroup()));
            } else if (string.equals("Attr")) {
                this.readerAttr(xMLableReader);
            } else if (string.equals("newPlotFillStyle")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            VanChartPlot.this.setPlotFillStyle((AttrFillStyle)xMLableReader.readXMLObject((XMLReadable)new AttrFillStyle()));
                        }
                    }
                });
            }
        }
    }

    protected void readerAttr(XMLableReader xMLableReader) {
        this.setAutoRefreshPerSecond(xMLableReader.getAttrAsInt("autoRefreshPerSecond", 0));
        this.setPlotStyle(xMLableReader.getAttrAsInt("plotStyle", 0));
    }

    public DataSeriesCondition getAttrLabelFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = conditionAttr.getExisted(AttrLabel.class);
        return dataSeriesCondition;
    }

    public DataSeriesCondition getAttrTooltipFromConditionCollection() {
        ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = conditionAttr.getExisted(AttrTooltip.class);
        return dataSeriesCondition;
    }
}

