/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString = "  ";

    public IndentPrintWriter(Writer writer, int n2) {
        super(writer);
        this.setIndent(n2);
    }

    public IndentPrintWriter(Writer writer) {
        this(writer, 0);
    }

    public void print(boolean bl) {
        this.doIndent();
        super.print(bl);
    }

    public void print(char c2) {
        this.doIndent();
        super.print(c2);
    }

    public void print(char[] cArray) {
        this.doIndent();
        super.print(cArray);
    }

    public void print(double d2) {
        this.doIndent();
        super.print(d2);
    }

    public void print(float f2) {
        this.doIndent();
        super.print(f2);
    }

    public void print(int n2) {
        this.doIndent();
        super.print(n2);
    }

    public void print(long l2) {
        this.doIndent();
        super.print(l2);
    }

    public void print(Object object) {
        this.doIndent();
        super.print(object);
    }

    public void print(String string) {
        this.doIndent();
        super.print(string);
    }

    public void println() {
        this.indented = false;
        super.println();
    }

    private void doIndent() {
        if (this.indented) {
            return;
        }
        this.indented = true;
        for (int i2 = 0; i2 < this.indent; ++i2) {
            super.print(this.indentString);
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n2) {
        this.indent = n2;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }
}

