/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.gif.GIFEncoder;
import org.freehep.graphicsio.gif.GIFImageWriteParam;
import org.freehep.graphicsio.gif.GIFImageWriterSpi;

public class GIFImageWriter
extends ImageWriter {
    public GIFImageWriter(GIFImageWriterSpi gIFImageWriterSpi) {
        super(gIFImageWriterSpi);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object object = this.getOutput();
        if (object == null) {
            throw new IllegalStateException("output was not set");
        }
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        ImageOutputStream imageOutputStream = (ImageOutputStream)object;
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        if (!(renderedImage instanceof BufferedImage)) {
            throw new IOException("Image not of type BufferedImage");
        }
        BufferedImage bufferedImage = (BufferedImage)renderedImage;
        boolean bl = imageWriteParam.getProgressiveMode() != 0;
        GIFEncoder gIFEncoder = new GIFEncoder((Image)bufferedImage, (DataOutput)imageOutputStream, bl);
        gIFEncoder.encode();
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }
}

