/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.BMPEncodeParam;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoderImpl;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SeekableOutputStream;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.output = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.version = bMPEncodeParam.getVersion();
        this.isCompressed = bMPEncodeParam.isCompressed();
        if (this.isCompressed && !(outputStream instanceof SeekableOutputStream)) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder6"));
        }
        this.isTopDown = bMPEncodeParam.isTopDown();
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = renderedImage.getMinX();
        int n6 = renderedImage.getMinY();
        this.w = renderedImage.getWidth();
        this.h = renderedImage.getHeight();
        int n7 = 24;
        boolean bl = false;
        int n8 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n9 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n9 != 1 && n9 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        for (n4 = 1; n4 < nArray.length; ++n4) {
            if (nArray[n4] == nArray[0]) continue;
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
        }
        n4 = sampleModel.getTransferType();
        if (n4 == 1 || n4 == 2 || n4 == 3 || n4 == 4 || n4 == 5) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int n10 = this.w * n9;
        int n11 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n8 = indexColorModel.getMapSize();
            if (n8 <= 2) {
                n7 = 1;
                n10 = (int)Math.ceil((double)this.w / 8.0);
            } else if (n8 <= 16) {
                n7 = 4;
                n10 = (int)Math.ceil((double)this.w / 2.0);
            } else if (n8 <= 256) {
                n7 = 8;
            } else {
                n7 = 24;
                bl = false;
                n8 = 0;
                n10 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n8];
                byArray2 = new byte[n8];
                byArray3 = new byte[n8];
                byArray4 = new byte[n8];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n9 == 1) {
            bl = true;
            n8 = 256;
            n7 = nArray[0];
            n10 = (int)Math.ceil((double)(this.w * n7) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            for (n3 = 0; n3 < 256; ++n3) {
                byArray[n3] = (byte)n3;
                byArray2[n3] = (byte)n3;
                byArray3[n3] = (byte)n3;
                byArray4[n3] = (byte)n3;
            }
        }
        n3 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = n8;
        int n19 = 0;
        int n20 = n10 % 4;
        if (n20 != 0) {
            n19 = 4 - n20;
        }
        switch (this.version) {
            case 0: {
                n12 = 26 + n8 * 3;
                n13 = 12;
                n14 = (n10 + n19) * this.h;
                n3 = n14 + n12;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                if (this.isCompressed && n7 == 8) {
                    n11 = 1;
                } else if (this.isCompressed && n7 == 4) {
                    n11 = 2;
                }
                n12 = 54 + n8 * 4;
                n14 = (n10 + n19) * this.h;
                n3 = n14 + n12;
                n13 = 40;
                break;
            }
            case 2: {
                n13 = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        this.writeFileHeader(n3, n12);
        this.writeInfoHeader(n13, n7);
        this.writeDWord(n11);
        this.writeDWord(n14);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        this.writeDWord(n18);
        if (bl) {
            switch (this.version) {
                case 0: {
                    for (n2 = 0; n2 < n8; ++n2) {
                        this.output.write(byArray3[n2]);
                        this.output.write(byArray2[n2]);
                        this.output.write(byArray[n2]);
                    }
                    break;
                }
                default: {
                    for (n2 = 0; n2 < n8; ++n2) {
                        this.output.write(byArray3[n2]);
                        this.output.write(byArray2[n2]);
                        this.output.write(byArray[n2]);
                        this.output.write(byArray4[n2]);
                    }
                }
            }
        }
        n2 = this.w * n9;
        int[] nArray2 = new int[8 * n2];
        byte[] byArray5 = new byte[n10];
        if (!this.isTopDown) {
            int n21 = n6 + this.h;
            for (int i2 = n21 - 1; i2 >= n6; i2 -= 8) {
                int n22 = Math.min(8, i2 - n6 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n5, i2 - n22 + 1, this.w, n22));
                raster.getPixels(n5, i2 - n22 + 1, this.w, n22, nArray2);
                int n23 = 0;
                int n24 = n2 * n22 - 1;
                for (int i3 = 0; i3 < n22; ++i3) {
                    n23 = n24 - (i3 + 1) * n2 + 1;
                    this.writePixels(n23, n2, n7, nArray2, byArray5, n19, n9, indexColorModel);
                }
            }
        } else {
            int n25 = n6 + this.h;
            for (int i4 = n6; i4 < n25; i4 += 8) {
                int n26 = Math.min(8, n25 - i4);
                Raster raster = renderedImage.getData(new Rectangle(n5, i4, this.w, n26));
                raster.getPixels(n5, i4, this.w, n26, nArray2);
                int n27 = 0;
                for (int i5 = 0; i5 < n26; ++i5) {
                    this.writePixels(n27, n2, n7, nArray2, byArray5, n19, n9, indexColorModel);
                }
            }
        }
        if (this.isCompressed && (n7 == 4 || n7 == 8)) {
            this.output.write(0);
            this.output.write(1);
            this.incCompImageSize(2);
            n14 = this.compImageSize;
            n3 = this.compImageSize + n12;
            this.writeSize(n3, 2);
            this.writeSize(n14, 34);
        }
    }

    private void writePixels(int n2, int n3, int n4, int[] nArray, byte[] byArray, int n5, int n6, IndexColorModel indexColorModel) throws IOException {
        int n7 = 0;
        int n8 = 0;
        switch (n4) {
            case 1: {
                int n9;
                for (n9 = 0; n9 < n3 / 8; ++n9) {
                    byArray[n8++] = (byte)(nArray[n2++] << 7 | nArray[n2++] << 6 | nArray[n2++] << 5 | nArray[n2++] << 4 | nArray[n2++] << 3 | nArray[n2++] << 2 | nArray[n2++] << 1 | nArray[n2++]);
                }
                if (n3 % 8 > 0) {
                    n7 = 0;
                    for (n9 = 0; n9 < n3 % 8; ++n9) {
                        n7 |= nArray[n2++] << 7 - n9;
                    }
                    byArray[n8++] = (byte)n7;
                }
                this.output.write(byArray, 0, (n3 + 7) / 8);
                break;
            }
            case 4: {
                if (this.isCompressed) {
                    byte[] byArray2 = new byte[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        byArray2[i2] = (byte)nArray[n2++];
                    }
                    this.encodeRLE4(byArray2, n3);
                    break;
                }
                for (int i3 = 0; i3 < n3 / 2; ++i3) {
                    n7 = nArray[n2++] << 4 | nArray[n2++];
                    byArray[n8++] = (byte)n7;
                }
                if (n3 % 2 == 1) {
                    n7 = nArray[n2] << 4;
                    byArray[n8++] = (byte)n7;
                }
                this.output.write(byArray, 0, (n3 + 1) / 2);
                break;
            }
            case 8: {
                if (this.isCompressed) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        byArray[i4] = (byte)nArray[n2++];
                    }
                    this.encodeRLE8(byArray, n3);
                    break;
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    byArray[i5] = (byte)nArray[n2++];
                }
                this.output.write(byArray, 0, n3);
                break;
            }
            case 24: {
                if (n6 == 3) {
                    for (int i6 = 0; i6 < n3; i6 += 3) {
                        byArray[n8++] = (byte)nArray[n2 + 2];
                        byArray[n8++] = (byte)nArray[n2 + 1];
                        byArray[n8++] = (byte)nArray[n2];
                        n2 += 3;
                    }
                    this.output.write(byArray, 0, n3);
                    break;
                }
                int n10 = indexColorModel.getMapSize();
                byte[] byArray3 = new byte[n10];
                byte[] byArray4 = new byte[n10];
                byte[] byArray5 = new byte[n10];
                indexColorModel.getReds(byArray3);
                indexColorModel.getGreens(byArray4);
                indexColorModel.getBlues(byArray5);
                for (int i7 = 0; i7 < n3; ++i7) {
                    int n11 = nArray[n2];
                    byArray[n8++] = byArray5[n11];
                    byArray[n8++] = byArray4[n11];
                    byArray[n8++] = byArray5[n11];
                    ++n2;
                }
                this.output.write(byArray, 0, n3 * 3);
            }
        }
        if (!this.isCompressed || n4 != 8 && n4 != 4) {
            for (n8 = 0; n8 < n5; ++n8) {
                this.output.write(0);
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n2) throws IOException {
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n5];
        byte[] byArray2 = new byte[256];
        while (n5 < n2 - 1) {
            int n6;
            if ((by2 = byArray[++n5]) == by) {
                if (n4 >= 3) {
                    this.output.write(0);
                    this.output.write(n4);
                    this.incCompImageSize(2);
                    for (n6 = 0; n6 < n4; ++n6) {
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4)) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        this.output.write(1);
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(2);
                    }
                }
                n4 = -1;
                if (++n3 == 256) {
                    this.output.write(n3 - 1);
                    this.output.write(by);
                    this.incCompImageSize(2);
                    n3 = 1;
                }
            } else {
                if (n3 > 1) {
                    this.output.write(n3);
                    this.output.write(by);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                } else if (n4 < 254) {
                    byArray2[++n4] = by2;
                } else {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    for (n6 = 0; n6 <= n4; ++n6) {
                        this.output.write(byArray2[n6]);
                        this.incCompImageSize(1);
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by2;
                n3 = 1;
            }
            if (n5 != n2 - 1) continue;
            if (n4 == -1) {
                this.output.write(n3);
                this.output.write(by);
                this.incCompImageSize(2);
                n3 = 1;
            } else if (n4 >= 2) {
                this.output.write(0);
                this.output.write(n4 + 1);
                this.incCompImageSize(2);
                for (n6 = 0; n6 <= n4; ++n6) {
                    this.output.write(byArray2[n6]);
                    this.incCompImageSize(1);
                }
                if (!this.isEven(n4 + 1)) {
                    this.output.write(0);
                    this.incCompImageSize(1);
                }
            } else if (n4 > -1) {
                for (n6 = 0; n6 <= n4; ++n6) {
                    this.output.write(1);
                    this.output.write(byArray2[n6]);
                    this.incCompImageSize(2);
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n2) throws IOException {
        int n3 = 2;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n5];
        by2 = byArray[++n5];
        while (n5 < n2 - 2) {
            int n8;
            by3 = byArray[++n5];
            by4 = byArray[++n5];
            if (by3 == by) {
                if (n4 >= 4) {
                    this.output.write(0);
                    this.output.write(n4 - 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4 - 2; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4 - 1)) {
                        n7 = byArray2[n4 - 2] << 4 | 0;
                        this.output.write(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 - 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    this.output.write(2);
                    n6 = byArray2[0] << 4 | byArray2[1];
                    this.output.write(n6);
                    this.incCompImageSize(2);
                }
                n4 = -1;
                if (by4 == by2) {
                    if ((n3 += 2) == 256) {
                        this.output.write(n3 - 1);
                        n6 = by << 4 | by2;
                        this.output.write(n6);
                        this.incCompImageSize(2);
                        n3 = 2;
                        if (n5 < n2 - 1) {
                            by = by2;
                            by2 = byArray[++n5];
                        } else {
                            this.output.write(1);
                            n8 = by2 << 4 | 0;
                            this.output.write(n8);
                            this.incCompImageSize(2);
                            n3 = -1;
                        }
                    }
                } else {
                    n6 = by << 4 | by2;
                    this.output.write(++n3);
                    this.output.write(n6);
                    this.incCompImageSize(2);
                    n3 = 2;
                    by = by4;
                    if (n5 < n2 - 1) {
                        by2 = byArray[++n5];
                    } else {
                        this.output.write(1);
                        n8 = by4 << 4 | 0;
                        this.output.write(n8);
                        this.incCompImageSize(2);
                        n3 = -1;
                    }
                }
            } else {
                if (n3 > 2) {
                    n6 = by << 4 | by2;
                    this.output.write(n3);
                    this.output.write(n6);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else if (n4 < 253) {
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by3;
                by2 = by4;
                n3 = 2;
            }
            if (n5 < n2 - 2) continue;
            if (n4 == -1 && n3 >= 2) {
                if (n5 == n2 - 2) {
                    if (byArray[++n5] == by) {
                        n6 = by << 4 | by2;
                        this.output.write(++n3);
                        this.output.write(n6);
                        this.incCompImageSize(2);
                    } else {
                        n6 = by << 4 | by2;
                        this.output.write(n3);
                        this.output.write(n6);
                        this.output.write(1);
                        n6 = byArray[n5] << 4 | 0;
                        this.output.write(n6);
                        n8 = byArray[n5] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.output.write(n3);
                    n6 = by << 4 | by2;
                    this.output.write(n6);
                    this.incCompImageSize(2);
                }
            } else if (n4 > -1) {
                if (n5 == n2 - 2) {
                    byArray2[++n4] = byArray[++n5];
                }
                if (n4 >= 2) {
                    this.output.write(0);
                    this.output.write(n4 + 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.output.write((byte)n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4 + 1)) {
                        n7 = byArray2[n4] << 4 | 0;
                        this.output.write(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 + 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n4) {
                        case 0: {
                            this.output.write(1);
                            n8 = byArray2[0] << 4 | 0;
                            this.output.write(n8);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.output.write(2);
                            n6 = byArray2[0] << 4 | byArray2[1];
                            this.output.write(n6);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n2) {
        this.compImageSize += n2;
    }

    private boolean isEven(int n2) {
        return n2 % 2 == 0;
    }

    private void writeFileHeader(int n2, int n3) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(n2);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(n3);
    }

    private void writeInfoHeader(int n2, int n3) throws IOException {
        this.writeDWord(n2);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(n3);
    }

    public void writeWord(int n2) throws IOException {
        this.output.write(n2 & 0xFF);
        this.output.write((n2 & 0xFF00) >> 8);
    }

    public void writeDWord(int n2) throws IOException {
        this.output.write(n2 & 0xFF);
        this.output.write((n2 & 0xFF00) >> 8);
        this.output.write((n2 & 0xFF0000) >> 16);
        this.output.write((n2 & 0xFF000000) >> 24);
    }

    private void writeSize(int n2, int n3) throws IOException {
        ((SeekableOutputStream)this.output).seek(n3);
        this.writeDWord(n2);
    }
}

