/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.elementcase;

import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.present.DictPresent;
import com.fr.base.present.FormulaPresent;
import com.fr.base.present.Present;
import com.fr.data.Dictionary;
import com.fr.data.impl.FormulaDictionary;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.form.event.Listener;
import com.fr.form.ui.DictionaryContainer;
import com.fr.form.ui.IframeEditor;
import com.fr.form.ui.TreeEditor;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.page.ReportPageAttrProvider;
import com.fr.privilege.finegrain.ColumnRowPrivilegeControl;
import com.fr.report.cell.Cell;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.ExpandAttrElem;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellInsertPolicyAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.cellattr.highlight.DefaultHighlight;
import com.fr.report.cell.cellattr.highlight.Highlight;
import com.fr.report.cell.cellattr.highlight.HighlightAction;
import com.fr.report.cell.cellattr.highlight.HighlightGroup;
import com.fr.report.cell.cellattr.highlight.PresentHighlightAction;
import com.fr.report.cell.cellattr.highlight.ValueHighlightAction;
import com.fr.report.cellcase.CellCase;
import com.fr.report.cellcase.DefaultCellCase;
import com.fr.report.core.PaintUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.elementcase.mod.InsertColumnMOD;
import com.fr.report.elementcase.mod.InsertDeleteRowOrColumnAction;
import com.fr.report.elementcase.mod.InsertRowMOD;
import com.fr.report.elementcase.mod.RemoveColumnMOD;
import com.fr.report.elementcase.mod.RemoveRowMOD;
import com.fr.report.web.button.write.AppendRowButton;
import com.fr.report.web.button.write.DeleteRowButton;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementCase
implements ElementCase,
XMLable {
    public static final String XML_TAG = "AbsEC";
    private static final int INIT_ROW_NUMBER = 50;
    public static final int INIT_COLUMN_NUMBER = 20;
    private static final int MIN_WIDTH = 190500;
    private static final int FACTOR_FOR_COMPATIBLE = 10;
    protected CellCase cellcase;
    protected List<FloatElement> floatElementList;
    protected ReportPageAttrProvider reportPageAttr = null;
    private DynamicUnitList rowHeightList_DEC;
    private DynamicUnitList columnWidthList_DEC;
    private HashMap<Integer, ColumnRowPrivilegeControl> columnPrivilegeControl;
    private HashMap<Integer, ColumnRowPrivilegeControl> rowPrivilegeControl;
    private Set<String> cellTableDataSet = new HashSet<String>();

    protected AbstractElementCase() {
        this.cellcase = new DefaultCellCase();
        this.reportPageAttr = (ReportPageAttrProvider)((Object)StableFactory.createXmlObject("ReportPageAttr"));
        this.floatElementList = new ArrayList<FloatElement>();
        this.rowHeightList_DEC = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, 50);
        this.columnWidthList_DEC = new DynamicUnitList(UNITConstants.DEFAULT_COL_WIDTH, 20);
        this.columnPrivilegeControl = new HashMap();
        this.rowPrivilegeControl = new HashMap();
    }

    @Override
    public ReportPageAttrProvider getReportPageAttr() {
        return this.reportPageAttr;
    }

    @Override
    public void setReportPageAttr(ReportPageAttrProvider reportPageAttrProvider) {
        this.reportPageAttr = reportPageAttrProvider;
    }

    @Override
    public void addColumnPrivilegeControl(int n2, String string) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.columnPrivilegeControl.get(n2);
        if (columnRowPrivilegeControl == null) {
            columnRowPrivilegeControl = new ColumnRowPrivilegeControl(n2);
            this.columnPrivilegeControl.put(n2, columnRowPrivilegeControl);
        }
        columnRowPrivilegeControl.addInvisibleRole(string);
    }

    @Override
    public void removeColumnPrivilegeControl(int n2, String string) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.columnPrivilegeControl.get(n2);
        if (columnRowPrivilegeControl != null) {
            columnRowPrivilegeControl.removeInvisibleRole(string);
        }
    }

    @Override
    public void removeRowPrivilegeControl(int n2, String string) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.rowPrivilegeControl.get(n2);
        if (columnRowPrivilegeControl != null) {
            columnRowPrivilegeControl.removeInvisibleRole(string);
        }
    }

    @Override
    public ColumnRowPrivilegeControl getRowPrivilegeControl(int n2) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.rowPrivilegeControl.get(n2);
        return columnRowPrivilegeControl == null ? new ColumnRowPrivilegeControl() : columnRowPrivilegeControl;
    }

    @Override
    public ColumnRowPrivilegeControl getColumnPrivilegeControl(int n2) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.columnPrivilegeControl.get(n2);
        return columnRowPrivilegeControl == null ? new ColumnRowPrivilegeControl() : columnRowPrivilegeControl;
    }

    @Override
    public void addRowPrivilegeControl(int n2, String string) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl = this.rowPrivilegeControl.get(n2);
        if (columnRowPrivilegeControl == null) {
            columnRowPrivilegeControl = new ColumnRowPrivilegeControl(n2);
            this.rowPrivilegeControl.put(n2, columnRowPrivilegeControl);
        }
        columnRowPrivilegeControl.addInvisibleRole(string);
    }

    public void addCellElement(CellElement cellElement, boolean bl) {
        this.cellcase.add(cellElement, bl);
    }

    @Override
    public Object getCellValue(int n2, int n3) {
        CellElement cellElement = (CellElement)this.cellcase.get(n2, n3);
        return cellElement != null ? cellElement.getValue() : null;
    }

    @Override
    public void setCellValue(int n2, int n3, Object object) {
        CellElement cellElement = (CellElement)this.cellcase.get(n2, n3);
        if (cellElement != null) {
            cellElement.setValue(object);
            return;
        }
        CellElement cellElement2 = this.createDefaultCellElementCase();
        cellElement2.setColumn(n2);
        cellElement2.setRow(n3);
        cellElement2.setValue(object);
        this.cellcase.add(cellElement2, true);
    }

    @Override
    public CellElement getCellElement(int n2, int n3) {
        return (CellElement)this.cellcase.get(n2, n3);
    }

    public boolean removeCellElement(CellElement cellElement) {
        if (cellElement == null) {
            return true;
        }
        if (this.cellcase.get(cellElement.getColumn(), cellElement.getRow()) == cellElement) {
            this.cellcase.removeCell(cellElement.getColumn(), cellElement.getRow());
            return true;
        }
        return false;
    }

    @Override
    public CellElement removeCellElement(int n2, int n3) {
        return (CellElement)this.cellcase.removeCell(n2, n3);
    }

    @Override
    public void removeAllCellElements() {
        this.cellcase.clear();
    }

    @Override
    public void removeRow(int n2) {
        this.cellcase.removeRow(n2);
        this.__mod_column_row(new RemoveRowMOD(n2, this.getRowHeightList_DEC()));
    }

    @Override
    public void removeColumn(int n2) {
        this.cellcase.removeColumn(n2);
        this.__mod_column_row(new RemoveColumnMOD(n2, this.getColumnWidthList_DEC()));
    }

    @Override
    public void insertRow(int n2) {
        this.cellcase.insertRow(n2);
        this.__mod_column_row(new InsertRowMOD(n2, this.getRowHeightList_DEC()));
    }

    @Override
    public void insertColumn(int n2) {
        this.cellcase.insertColumn(n2);
        this.__mod_column_row(new InsertColumnMOD(n2, this.getColumnWidthList_DEC()));
    }

    @Override
    public int getColumnCount() {
        return this.cellcase.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.cellcase.getRowCount();
    }

    @Override
    public Iterator cellIterator() {
        return this.cellcase.cellIterator();
    }

    @Override
    public Iterator intersect(int n2, int n3, int n4, int n5) {
        return this.cellcase.intersect(n2, n3, n4, n5);
    }

    @Override
    public Iterator getColumn(int n2) {
        return this.cellcase.getColumn(n2);
    }

    @Override
    public Iterator getRow(int n2) {
        return this.cellcase.getRow(n2);
    }

    @Override
    public void merge(int n2, int n3, int n4, int n5) {
        Cell cell = null;
        for (int i2 = n2; i2 <= n3; ++i2) {
            for (int i3 = n4; i3 <= n5; ++i3) {
                CellElement cellElement = (CellElement)this.cellcase.get(i3, i2);
                if (cellElement == null) continue;
                if (cell == null) {
                    cell = cellElement;
                }
                this.cellcase.removeCell(cellElement.getColumn(), cellElement.getRow());
            }
        }
        if (cell != null) {
            cell.setColumn(n4);
            cell.setRow(n2);
            cell.setColumnSpan(n5 - n4 + 1);
            cell.setRowSpan(n3 - n2 + 1);
        } else {
            CellElement cellElement = this.createDefaultCellElementCase();
            cellElement.setColumn(n4);
            cellElement.setRow(n2);
            cellElement.setColumnSpan(n5 - n4 + 1);
            cellElement.setRowSpan(n3 - n2 + 1);
            cellElement.setValue(null);
            cell = cellElement;
        }
        this.cellcase.add(cell, true);
    }

    public void recalculateCellCase() {
        if (this.cellcase != null) {
            this.cellcase.recalculate();
        }
    }

    public void setCellCase(CellCase cellCase) {
        this.cellcase = cellCase;
    }

    public CellCase getCellCase() {
        return this.cellcase;
    }

    public void cacheCellElement(int n2, int n3, boolean bl) {
        this.cellcase.toCache(n2, n3, bl);
    }

    public void releaseCellElementCache() {
        this.cellcase.releaseCache();
    }

    public void addCellElement(CellElement cellElement) {
        this.addCellElement(cellElement, true);
    }

    public Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        Object object;
        if (mOD_COLUMN_ROW == null || mOD_COLUMN_ROW.intercept()) {
            return null;
        }
        mOD_COLUMN_ROW.mod_cwidth_rheight();
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            object = (CellElement)iterator.next();
            this.insertChangeCellElement((CellElement)object, mOD_COLUMN_ROW);
        }
        object = this.floatIterator();
        while (object.hasNext()) {
            FloatElement floatElement = (FloatElement)object.next();
            Object object2 = floatElement.getValue();
            if (object2 instanceof BaseChartCollection) {
                BaseChartCollection baseChartCollection = (BaseChartCollection)object2;
                baseChartCollection.modFormulaString(mOD_COLUMN_ROW);
            } else if (object2 instanceof Formula) {
                ((Formula)object2).modColumnRow(mOD_COLUMN_ROW);
            }
            this.dealWithHyperLink(floatElement.getNameHyperlinkGroup(), mOD_COLUMN_ROW);
        }
        if (mOD_COLUMN_ROW instanceof InsertDeleteRowOrColumnAction) {
            ((InsertDeleteRowOrColumnAction)((Object)mOD_COLUMN_ROW)).mod_pageAttr(this.reportPageAttr);
        }
        return mOD_COLUMN_ROW;
    }

    private void insertChangeCellElement(CellElement cellElement, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        XMLReadable xMLReadable;
        XMLable xMLable;
        Object object = cellElement.getValue();
        if (object instanceof Formula) {
            ((Formula)object).modColumnRow(mOD_COLUMN_ROW);
        }
        if (cellElement instanceof ExpandAttrElem && (xMLable = ((ExpandAttrElem)((Object)cellElement)).getCellExpandAttr()) != null) {
            ((CellExpandAttr)xMLable).modColumnRow(mOD_COLUMN_ROW);
        }
        if ((xMLable = cellElement.getCellGUIAttr()) != null) {
            ((CellGUIAttr)xMLable).modColumnRow(mOD_COLUMN_ROW);
        }
        if (object instanceof DSColumn) {
            xMLReadable = ((DSColumn)object).getCondition();
            mOD_COLUMN_ROW.mod_object(xMLReadable);
        }
        if (object instanceof BaseChartCollection) {
            ((BaseChartCollection)object).modFormulaString(mOD_COLUMN_ROW);
        }
        if (cellElement instanceof TemplateCellElement) {
            xMLReadable = (TemplateCellElement)cellElement;
            this.dealWithWidget(xMLReadable.getWidget(), mOD_COLUMN_ROW);
            this.dealWithHighlightGroup(xMLReadable.getHighlightGroup(), mOD_COLUMN_ROW);
            this.dealWithPresent(xMLReadable.getPresent(), mOD_COLUMN_ROW);
            CellInsertPolicyAttr cellInsertPolicyAttr = xMLReadable.getCellInsertPolicyAttr();
            if (cellInsertPolicyAttr != null) {
                cellInsertPolicyAttr.modColumnRow(mOD_COLUMN_ROW);
            }
        }
        this.dealWithHyperLink(cellElement.getNameHyperlinkGroup(), mOD_COLUMN_ROW);
    }

    private void dealWithHyperLink(NameJavaScriptGroup nameJavaScriptGroup, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (nameJavaScriptGroup == null) {
            return;
        }
        nameJavaScriptGroup.modFormulaString(mOD_COLUMN_ROW);
    }

    private void dealWithPresent(Present present, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (present instanceof FormulaPresent) {
            if (((FormulaPresent)present).getFormulaContent().indexOf("'") != -1) {
                return;
            }
            ((FormulaPresent)present).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(((FormulaPresent)present).getFormulaContent()));
        } else if (present instanceof DictPresent) {
            this.dealWithDictionary(((DictPresent)present).getDictionary(), mOD_COLUMN_ROW);
        }
    }

    private void dealWithDictionary(Dictionary dictionary, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (dictionary == null) {
            return;
        }
        if (dictionary instanceof FormulaDisplayDictionary) {
            FormulaProvider formulaProvider = ((FormulaDisplayDictionary)dictionary).getFormula();
            if (formulaProvider != null) {
                formulaProvider.modColumnRow(mOD_COLUMN_ROW);
            }
        } else if (dictionary instanceof FormulaDictionary) {
            String string;
            FormulaDictionary formulaDictionary = (FormulaDictionary)dictionary;
            String string2 = formulaDictionary.getProduceFormula();
            if (StringUtils.isNotEmpty(string2)) {
                formulaDictionary.setProduceFormula(mOD_COLUMN_ROW.mod_fm_statement(string2));
            }
            if (StringUtils.isNotEmpty(string = formulaDictionary.getExcuteFormula())) {
                formulaDictionary.setExcuteFormula(mOD_COLUMN_ROW.mod_fm_statement(string));
            }
        }
    }

    private void dealWithWidget(Widget widget, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        XMLReadable xMLReadable;
        int n2;
        if (widget == null) {
            return;
        }
        if (widget instanceof DeleteRowButton) {
            ((DeleteRowButton)widget).setFixCell(mOD_COLUMN_ROW.mod_columnrow(((DeleteRowButton)widget).getFixCell()));
        } else if (widget instanceof AppendRowButton) {
            ((AppendRowButton)widget).setFixCell(mOD_COLUMN_ROW.mod_columnrow(((AppendRowButton)widget).getFixCell()));
        } else if (widget instanceof TreeEditor) {
            this.dealWithDictionary(((TreeEditor)widget).getDictionary(), mOD_COLUMN_ROW);
        } else if (widget instanceof IframeEditor) {
            ParameterProvider[] parameterProviderArray = ((IframeEditor)widget).getParameters();
            for (n2 = 0; n2 < parameterProviderArray.length; ++n2) {
                xMLReadable = parameterProviderArray[n2];
                if (xMLReadable == null) continue;
                xMLReadable.setValue(mOD_COLUMN_ROW.mod_object(xMLReadable.getValue()));
            }
        }
        if (widget instanceof DictionaryContainer) {
            this.dealWithDictionary(((DictionaryContainer)((Object)widget)).getDictionary(), mOD_COLUMN_ROW);
        }
        n2 = widget.getListenerSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLReadable = widget.getListener(i2);
            JavaScript javaScript = ((Listener)xMLReadable).getAction();
            ParameterProvider[] parameterProviderArray = javaScript.getParameters();
            boolean bl = false;
            while (parameterProviderArray != null && i2 < parameterProviderArray.length) {
                ParameterProvider parameterProvider = parameterProviderArray[i2];
                if (parameterProvider != null) {
                    parameterProvider.setValue(mOD_COLUMN_ROW.mod_object(parameterProvider.getValue()));
                }
                ++i2;
            }
        }
    }

    private void dealWithHighlightGroup(HighlightGroup highlightGroup, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (highlightGroup == null) {
            return;
        }
        for (int i2 = 0; i2 < highlightGroup.size(); ++i2) {
            Highlight highlight = highlightGroup.getHighlight(i2);
            if (!(highlight instanceof DefaultHighlight)) continue;
            Condition condition = ((DefaultHighlight)highlight).getCondition();
            mOD_COLUMN_ROW.mod_object(condition);
            for (int i3 = 0; i3 < ((DefaultHighlight)highlight).actionCount(); ++i3) {
                Object object;
                HighlightAction highlightAction = ((DefaultHighlight)highlight).getHighlightAction(i3);
                if (highlightAction instanceof ValueHighlightAction && (object = ((ValueHighlightAction)highlightAction).getValue()) instanceof Formula) {
                    ((Formula)object).modColumnRow(mOD_COLUMN_ROW);
                }
                if (!(highlightAction instanceof PresentHighlightAction)) continue;
                object = ((PresentHighlightAction)highlightAction).getPresent();
                this.dealWithPresent((Present)object, mOD_COLUMN_ROW);
            }
        }
    }

    @Override
    public FU getRowHeight(int n2) {
        return this.getRowHeightList_DEC().get(n2);
    }

    @Override
    public void setRowHeight(int n2, UNIT uNIT) {
        if (uNIT == null || uNIT.less_than_zero()) {
            uNIT = UNIT.ZERO;
        }
        this.getRowHeightList_DEC().set(n2, uNIT);
    }

    @Override
    public FU getColumnWidth(int n2) {
        return this.getColumnWidthList_DEC().get(n2);
    }

    @Override
    public void setColumnWidth(int n2, UNIT uNIT) {
        if (uNIT == null || uNIT.less_than_zero()) {
            uNIT = UNIT.ZERO;
        }
        this.getColumnWidthList_DEC().set(n2, uNIT);
    }

    @Override
    public void addFloatElement(FloatElement floatElement) {
        if (this.floatElementList == null) {
            this.floatElementList = new ArrayList<FloatElement>();
        }
        this.floatElementList.add(floatElement);
    }

    @Override
    public FloatElement getFloatElement(String string) {
        int n2 = this.floatElementList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FloatElement floatElement = this.floatElementList.get(i2);
            if (!ComparatorUtils.equals(floatElement.getName(), string)) continue;
            return floatElement;
        }
        return null;
    }

    @Override
    public Iterator<FloatElement> floatIterator() {
        return this.floatElementList.iterator();
    }

    @Override
    public FloatElement removeFloatElement(String string) {
        for (int i2 = this.floatElementList.size() - 1; i2 >= 0; --i2) {
            FloatElement floatElement = this.floatElementList.get(i2);
            if (!ComparatorUtils.equals(floatElement.getName(), string)) continue;
            this.floatElementList.remove(i2);
            return floatElement;
        }
        return null;
    }

    @Override
    public boolean removeFloatElement(FloatElement floatElement) {
        int n2 = this.floatElementList.indexOf(floatElement);
        boolean bl = false;
        if (n2 >= 0) {
            bl = this.floatElementList.remove(floatElement);
        }
        return bl;
    }

    @Override
    public void removeAllFloatElements() {
        this.floatElementList.clear();
    }

    @Override
    public void bringFloatElementToFront(FloatElement floatElement) {
        int n2 = this.floatElementList.indexOf(floatElement);
        if (n2 == -1 || n2 == this.floatElementList.size() - 1) {
            return;
        }
        this.floatElementList.remove(n2);
        this.floatElementList.add(floatElement);
    }

    @Override
    public void sendFloatElementToBack(FloatElement floatElement) {
        int n2 = this.floatElementList.indexOf(floatElement);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.floatElementList.remove(n2);
        this.floatElementList.add(0, floatElement);
    }

    @Override
    public void bringFloatElementForward(FloatElement floatElement) {
        int n2 = this.floatElementList.indexOf(floatElement);
        if (n2 == -1 || n2 == this.floatElementList.size() - 1) {
            return;
        }
        Utils.swapElementsInList(this.floatElementList, n2, n2 + 1);
    }

    @Override
    public void sendFloatElementBackward(FloatElement floatElement) {
        int n2 = this.floatElementList.indexOf(floatElement);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        Utils.swapElementsInList(this.floatElementList, n2, n2 - 1);
    }

    @Override
    public void shrinkTOFitRowHeightForCellElement(CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        int n2 = cellElement.getRow();
        int n3 = cellElement.getRowSpan();
        long l2 = this.getRowHeightList_DEC().getRangeValue(n2, n2 + n3).toFU();
        if (l2 == 0L) {
            return;
        }
        long l3 = this.getColumnWidthList_DEC().getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan()).toFU();
        if (this.isLessFive(l3)) {
            return;
        }
        long l4 = PaintUtils.analyzeCellElementPreferredHeight(cellElement, FU.getInstance(l3)).toFU();
        if (n3 == 1) {
            if (this.getRowHeightList_DEC().get(n2).more_than_zero()) {
                this.getRowHeightList_DEC().setToFU(n2, Math.max(l4, this.getRowHeightList_DEC().get(n2).toFU()));
            }
        } else {
            this.shrinkMultiRow(cellElement, n2, n3, l2, l4);
        }
    }

    private boolean isLessFive(long l2) {
        return l2 < 190500L;
    }

    private void shrinkMultiRow(CellElement cellElement, int n2, int n3, long l2, long l3) {
        long l4 = l3 - l2;
        int n4 = n2 + n3 - 1;
        int n5 = n3;
        if (l4 > 0L) {
            int n6;
            for (n6 = n2; n6 <= n4; ++n6) {
                if (!this.getRowHeightList_DEC().get(n6).equal_zero()) continue;
                --n5;
            }
            for (n6 = n2; n6 <= n4; ++n6) {
                if (!this.getRowHeightList_DEC().get(n6).more_than_zero()) continue;
                this.getRowHeightList_DEC().setToFU(n6, this.getRowHeightList_DEC().get(n6).toFU() + l4 / (long)n5);
            }
            n6 = 0;
            for (int i2 = n2; i2 <= n4 && (long)n6 < l4 % (long)n5; ++i2) {
                if (!this.getRowHeightList_DEC().get(i2).more_than_zero()) continue;
                this.getRowHeightList_DEC().setToFU(i2, this.getRowHeightList_DEC().get(i2).toFU() + 1L);
                ++n6;
            }
            this.specialShrinkTOFitRowHeight(cellElement, n5, n2, n4);
        }
    }

    private long getSingleLineHeight(CellElement cellElement) {
        Style style = cellElement.getStyle();
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        Font font = style.getFRFont().applyResolutionNP(96);
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        FU fU = FU.valueOfPix(fontMetrics.getHeight(), 96);
        return new PT((float)style.getLineSpacing()).add(fU).toFU();
    }

    private void specialShrinkTOFitRowHeight(CellElement cellElement, int n2, int n3, int n4) {
        boolean bl;
        CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
        Style style = cellElement.getStyle();
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        boolean bl2 = bl = cellPageAttr != null && !cellPageAttr.isRepeat();
        if (bl && style.getRotation() == 0 && style.getVerticalText() == 0 && style.getTextStyle() == 0 && n2 != 1) {
            long l2 = this.getSingleLineHeight(cellElement);
            long l3 = new PT((float)style.getSpacingBefore()).toFU();
            long l4 = 0L;
            int n5 = 1;
            for (int i2 = n3; i2 <= n4; ++i2) {
                if (!this.getRowHeightList_DEC().get(i2).more_than_zero()) continue;
                l4 = l3;
                l3 = this.mod(this.getRowHeightList_DEC().get(i2).toFU() - l4, l2);
                if (l3 != 0L) {
                    l3 = l2 - l3;
                }
                long l5 = this.getRowHeightList_DEC().get(i2).toFU() + l3 - (n5 == 1 ? 0L : l4);
                this.getRowHeightList_DEC().setToFU(i2, l5);
                ++n5;
            }
        }
    }

    private long mod(long l2, long l3) {
        if (l2 >= 0L) {
            return l2 % l3;
        }
        return (long)((double)l2 - (double)l3 * Math.floor((double)l2 * 1.0 / (double)l3));
    }

    @Override
    public void shrinkTOFitColumnWidthForCellElement(CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        int n2 = cellElement.getRow();
        int n3 = cellElement.getRowSpan();
        long l2 = this.getRowHeightList_DEC().getRangeValue(n2, n2 + n3).toFU();
        long l3 = this.getColumnWidthList_DEC().getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan()).toFU();
        if (l3 == 0L) {
            return;
        }
        long l4 = PaintUtils.getPreferredWidth(cellElement, PT.valueOfFU(l2)).toFU();
        if (cellElement.getColumnSpan() == 1) {
            this.getColumnWidthList_DEC().setToFU(cellElement.getColumn(), Math.max(l4, this.getColumnWidthList_DEC().get(cellElement.getColumn()).toFU()));
        } else {
            int n4;
            int n5 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
            long l5 = l4 - this.getColumnWidthList_DEC().getRangeValue(cellElement.getColumn(), n5 + 1).toFU();
            int n6 = cellElement.getColumnSpan();
            for (n4 = cellElement.getColumn(); n4 <= n5; ++n4) {
                if (!this.getColumnWidthList_DEC().get(n4).equal_zero()) continue;
                --n6;
            }
            if (l5 > 0L) {
                for (n4 = cellElement.getColumn(); n4 <= n5; ++n4) {
                    if (!this.getColumnWidthList_DEC().get(n4).more_than_zero()) continue;
                    this.getColumnWidthList_DEC().setToFU(n4, this.getColumnWidthList_DEC().get(n4).toFU() + l5 / (long)n6);
                }
            }
            n4 = 0;
            for (int i2 = cellElement.getColumn(); i2 <= n5 && (long)n4 < l5 % (long)n6; ++i2) {
                if (!this.getColumnWidthList_DEC().get(i2).more_than_zero()) continue;
                this.getColumnWidthList_DEC().setToFU(i2, this.getColumnWidthList_DEC().get(i2).toFU() + 1L);
                ++n4;
            }
        }
    }

    protected abstract CellElement createDefaultCellElementCase();

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            boolean bl;
            String string = xMLableReader.getTagName();
            boolean bl2 = bl = !xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION();
            if (ComparatorUtils.equals(string, "RowHeight")) {
                this.setRowHeightList_DEC(AbstractElementCase.readDynamicValueList(xMLableReader, bl));
            } else if (ComparatorUtils.equals(string, "ColumnWidth")) {
                this.setColumnWidthList_DEC(AbstractElementCase.readDynamicValueList(xMLableReader, bl));
            } else if (ComparatorUtils.equals(string, "ReportPageAttr")) {
                ReportPageAttrProvider reportPageAttrProvider = (ReportPageAttrProvider)((Object)StableFactory.createXmlObject("ReportPageAttr"));
                xMLableReader.readXMLObject((XMLReadable)((Object)reportPageAttrProvider));
                this.setReportPageAttr(reportPageAttrProvider);
            } else if (ComparatorUtils.equals(string, "CellElementList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            CellElement cellElement = AbstractElementCase.this.createDefaultCellElementCase();
                            xMLableReader.readXMLObject(cellElement);
                            AbstractElementCase.this.addCellElement(cellElement, false);
                            Object object = cellElement.getValue();
                            if (object instanceof DSColumn && ((DSColumn)object).getParameters().length == 0) {
                                AbstractElementCase.this.cellTableDataSet.add(((DSColumn)object).getDSName());
                            }
                        }
                    }

                    private boolean isArrayString(Object object) {
                        return object != null && object.toString().endsWith("]") && object.toString().startsWith("[");
                    }
                });
            } else if (ComparatorUtils.equals(string, "FloatElementList")) {
                this.floatElementList = new ArrayList<FloatElement>();
                ReportXMLUtils.readFloatElementList(xMLableReader, this.floatElementList, this);
            } else if (ComparatorUtils.equals(string, "ColumnPrivilegeControl")) {
                this.columnPrivilegeControl = this.readPrivilegeControl(xMLableReader);
            } else if (ComparatorUtils.equals(string, "RowPrivilegeControl")) {
                this.rowPrivilegeControl = this.readPrivilegeControl(xMLableReader);
            }
        }
    }

    private HashMap<Integer, ColumnRowPrivilegeControl> readPrivilegeControl(XMLableReader xMLableReader) {
        final HashMap<Integer, ColumnRowPrivilegeControl> hashMap = new HashMap<Integer, ColumnRowPrivilegeControl>();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if ("PrivilegeControl".equals(xMLableReader.getTagName())) {
                    ColumnRowPrivilegeControl columnRowPrivilegeControl = new ColumnRowPrivilegeControl();
                    xMLableReader.readXMLObject(columnRowPrivilegeControl);
                    int n2 = columnRowPrivilegeControl.getIndex();
                    if (n2 != -1) {
                        hashMap.put(n2, columnRowPrivilegeControl);
                    }
                }
            }
        });
        return hashMap;
    }

    private static DynamicUnitList readDynamicValueList(XMLableReader xMLableReader, boolean bl) {
        String string;
        long l2;
        DynamicUnitList dynamicUnitList = null;
        if (bl) {
            l2 = xMLableReader.getAttrAsInt("defaultValue", 10);
            l2 *= 38100L;
        } else {
            l2 = xMLableReader.getAttrAsInt("defaultValue", 381000);
        }
        dynamicUnitList = new DynamicUnitList(FU.getInstance(l2));
        if (dynamicUnitList != null && (string = xMLableReader.getElementValue()) != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || stringArray[i2].length() <= 0) continue;
                long l3 = (long)Double.parseDouble(stringArray[i2]);
                if (bl) {
                    l3 *= 38100L;
                }
                dynamicUnitList.setToFU(i2, l3);
            }
        }
        return dynamicUnitList;
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, OCellWriter.SC);
    }

    public void writeCommonXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, CommonCellWriter.SC);
    }

    protected void writeReportPageAttrXML(XMLPrintWriter xMLPrintWriter) {
        this.reportPageAttr.writeXML(xMLPrintWriter);
    }

    private void writeXML(XMLPrintWriter xMLPrintWriter, CellWriter cellWriter) {
        XMLReadable xMLReadable;
        if (this.reportPageAttr != null) {
            xMLPrintWriter.startTAG("ReportPageAttr");
            this.writeReportPageAttrXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("ColumnPrivilegeControl");
        this.writePrivilegeControl(xMLPrintWriter, this.columnPrivilegeControl);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("RowPrivilegeControl");
        this.writePrivilegeControl(xMLPrintWriter, this.rowPrivilegeControl);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("RowHeight");
        this.writeDynamicUnitList(xMLPrintWriter, this.getRowHeightList_DEC());
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("ColumnWidth");
        this.writeDynamicUnitList(xMLPrintWriter, this.getColumnWidthList_DEC());
        xMLPrintWriter.end();
        int n2 = this.floatElementList.size();
        if (n2 > 0) {
            xMLPrintWriter.startTAG("FloatElementList");
            for (int i2 = 0; i2 < n2; ++i2) {
                xMLReadable = this.floatElementList.get(i2);
                ReportXMLUtils.writeFloatElement(xMLPrintWriter, xMLReadable);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("CellElementList");
        Iterator iterator = this.cellcase.cellIterator();
        while (iterator.hasNext()) {
            xMLReadable = (CellElement)iterator.next();
            cellWriter.writeCell(xMLPrintWriter, (CellElement)xMLReadable);
        }
        xMLPrintWriter.end();
    }

    private void writePrivilegeControl(XMLPrintWriter xMLPrintWriter, HashMap<Integer, ColumnRowPrivilegeControl> hashMap) {
        for (Map.Entry<Integer, ColumnRowPrivilegeControl> entry : hashMap.entrySet()) {
            ColumnRowPrivilegeControl columnRowPrivilegeControl = entry.getValue();
            columnRowPrivilegeControl.writeXML(xMLPrintWriter);
        }
    }

    private void writeDynamicUnitList(XMLPrintWriter xMLPrintWriter, DynamicUnitList dynamicUnitList) {
        xMLPrintWriter.attr("defaultValue", dynamicUnitList.getDefaultUnit().toFU());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = dynamicUnitList.size();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(dynamicUnitList.get(i2).toFU());
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractElementCase abstractElementCase = (AbstractElementCase)super.clone();
        if (this.cellcase != null) {
            abstractElementCase.cellcase = (CellCase)this.cellcase.clone();
        }
        this.cloneWithoutCellCase(abstractElementCase);
        return abstractElementCase;
    }

    public Object cloneWithoutCellCase() throws CloneNotSupportedException {
        AbstractElementCase abstractElementCase = (AbstractElementCase)super.clone();
        this.cloneWithoutCellCase(abstractElementCase);
        return abstractElementCase;
    }

    public void cloneWithoutCellCase(AbstractElementCase abstractElementCase) throws CloneNotSupportedException {
        if (abstractElementCase == null || this.reportPageAttr == null) {
            return;
        }
        abstractElementCase.reportPageAttr = (ReportPageAttrProvider)this.reportPageAttr.clone();
        abstractElementCase.setRowHeightList_DEC((DynamicUnitList)this.getRowHeightList_DEC().clone());
        abstractElementCase.setColumnWidthList_DEC((DynamicUnitList)this.getColumnWidthList_DEC().clone());
        this.cloneFloatElement(abstractElementCase);
    }

    private void cloneFloatElement(AbstractElementCase abstractElementCase) throws CloneNotSupportedException {
        if (abstractElementCase == null) {
            return;
        }
        List list = null;
        try {
            list = (List)GeneralUtils.classForName(this.floatElementList.getClass().getName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRContext.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            FRContext.getLogger().error(instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRContext.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
        }
        if (list != null) {
            int n2 = this.floatElementList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                list.add(this.floatElementList.get(i2).clone());
            }
            abstractElementCase.floatElementList = list;
        }
    }

    @Override
    public DynamicUnitList getRowHeightList_DEC() {
        return this.rowHeightList_DEC;
    }

    public void setRowHeightList_DEC(DynamicUnitList dynamicUnitList) {
        this.rowHeightList_DEC = dynamicUnitList;
    }

    @Override
    public void shrinkToFitPaper(Calculator calculator) {
    }

    @Override
    public DynamicUnitList getColumnWidthList_DEC() {
        return this.columnWidthList_DEC;
    }

    public void setColumnWidthList_DEC(DynamicUnitList dynamicUnitList) {
        this.columnWidthList_DEC = dynamicUnitList;
    }

    public Set<String> getCellTableDataSet() {
        return this.cellTableDataSet;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractElementCase && ComparatorUtils.equals(this.cellcase, ((AbstractElementCase)object).cellcase) && ComparatorUtils.equals(this.floatElementList, ((AbstractElementCase)object).floatElementList) && ComparatorUtils.equals(this.reportPageAttr, ((AbstractElementCase)object).reportPageAttr) && ComparatorUtils.equals(this.rowHeightList_DEC, ((AbstractElementCase)object).rowHeightList_DEC) && ComparatorUtils.equals(this.columnWidthList_DEC, ((AbstractElementCase)object).columnWidthList_DEC);
    }

    private static class CommonCellWriter
    implements CellWriter {
        private static CommonCellWriter SC = new CommonCellWriter();

        private CommonCellWriter() {
        }

        public void writeCell(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
            ReportXMLUtils.writeCellElementWithCommonResultAttr(xMLPrintWriter, cellElement);
        }
    }

    private static class OCellWriter
    implements CellWriter {
        private static OCellWriter SC = new OCellWriter();

        private OCellWriter() {
        }

        public void writeCell(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
            ReportXMLUtils.writeCellElement(xMLPrintWriter, cellElement);
        }
    }

    private static interface CellWriter {
        public void writeCell(XMLPrintWriter var1, CellElement var2);
    }
}

