/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.data.DataUtils;
import com.fr.data.PresentationType;
import com.fr.data.condition.ListCondition;
import com.fr.form.ui.Widget;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.BarcodeAttr;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.cellattr.core.ResultSubReport;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.core.BarCodeUtils;
import com.fr.report.core.Html2ImageUtils;
import com.fr.report.core.ReportUtils;
import com.fr.stable.CoreConstants;
import com.fr.stable.fun.FontProcessor;
import com.fr.stable.html.Tag;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class PaintUtils {
    public static final int CELL_MARK_SIZE = 6;
    public static final Color CELL_HIGHT_LIGHT_MARK_COLOR = new Color(255, 0, 55);
    public static final Color CELL_PRESENT_MARK_COLOR = new Color(0, 255, 200);
    public static final Color CELL_PAGINATION_MARK_COLOR = new Color(55, 255, 0);
    public static final Color CELL_RESULT_MARK_COLOR = new Color(200, 0, 255);
    public static final Color CELL_CONDITION_FILTER_MARK_COLOR = new Color(255, 200, 0);
    public static final Color CELL_PARAMETER_FILTER_MARK_CONLR = new Color(0, 55, 255);
    public static final Color CELL_DIRECTION_MARK_COLOR = Color.gray;
    private static final int UNIT_SIZE = 4;
    private static Hashtable fontAttributeMapCache = new Hashtable();

    private PaintUtils() {
    }

    public static void paintGridCellContent(Graphics2D graphics2D, TemplateCellElement templateCellElement, int n2, int n3, int n4) {
        int n5 = 6;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (PaintUtils.paintHighlightGroupMarkWhenExsit(graphics2D, templateCellElement, n6)) {
            ++n6;
        }
        if (PaintUtils.paintPresentMarkWhenExsit(graphics2D, templateCellElement, n6)) {
            ++n6;
        }
        if (PaintUtils.paintPaginationMarkWhenExsit(graphics2D, templateCellElement, n2, n7)) {
            ++n7;
        }
        PaintUtils.paintWidgetMarkWhenExsit(graphics2D, templateCellElement, n2, n3);
        PaintUtils.paintExpandMarkWhenExsit(graphics2D, templateCellElement);
        Object object = templateCellElement.getValue();
        if (object == null) {
            return;
        }
        if (PaintUtils.paintResultMarkWhenExsit(graphics2D, object, n2, n7)) {
            ++n7;
        }
        if (PaintUtils.paintDSColumnParametermarkWhenExsit(graphics2D, object, n3, n8)) {
            ++n8;
        }
        if (PaintUtils.paintDSColumnConditionmarkWhenExsit(graphics2D, object, n3, n8)) {
            ++n8;
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getContent();
        }
        if (object instanceof ResultSubReport) {
            object = BaseUtils.readImage("/com/fr/base/images/report/painter/subReport.png");
            GraphHelper.paintImage(graphics2D, n2, n3, (Image)object, 1, BaseUtils.getAlignment4Horizontal(templateCellElement.getStyle(), object), templateCellElement.getStyle().getVerticalAlignment(), n2 > 16 ? 16 : n2, n3 > 16 ? 16 : n3);
        } else {
            Style.paintContent(graphics2D, object, templateCellElement.getStyle(), n2, n3, n4);
        }
    }

    private static boolean paintHighlightGroupMarkWhenExsit(Graphics2D graphics2D, TemplateCellElement templateCellElement, int n2) {
        if (templateCellElement.getHighlightGroup() != null && templateCellElement.getHighlightGroup().size() > 0) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_HIGHT_LIGHT_MARK_COLOR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.0f, 6.0f);
            generalPath.lineTo(6.0f, 0.0f);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    private static boolean paintPresentMarkWhenExsit(Graphics2D graphics2D, TemplateCellElement templateCellElement, int n2) {
        if (templateCellElement.getPresent() != null) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_PRESENT_MARK_COLOR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(0 + n2 * 6, 0.0f);
            generalPath.lineTo(0 + n2 * 6, 6.0f);
            generalPath.lineTo(6 + n2 * 6, 0.0f);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    private static boolean paintPaginationMarkWhenExsit(Graphics2D graphics2D, TemplateCellElement templateCellElement, int n2, int n3) {
        if (PaintUtils.isRightTopMarker(templateCellElement)) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_PAGINATION_MARK_COLOR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(n2 - 1 - n3 * 6, 0.0f);
            generalPath.lineTo(n2 - 1 - n3 * 6, 6.0f);
            generalPath.lineTo(n2 - 1 - (n3 + 1) * 6, 0.0f);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    private static boolean isRightTopMarker(TemplateCellElement templateCellElement) {
        return templateCellElement.getCellPageAttr() != null && (templateCellElement.getCellPageAttr().isPageAfterColumn() || templateCellElement.getCellPageAttr().isPageBeforeColumn() || templateCellElement.getCellPageAttr().isPageAfterRow() || templateCellElement.getCellPageAttr().isPageBeforeRow());
    }

    private static boolean paintResultMarkWhenExsit(Graphics2D graphics2D, Object object, int n2, int n3) {
        if (object instanceof DSColumn && ((DSColumn)object).getResult() != null && !ComparatorUtils.equals(((DSColumn)object).getResult(), "$$$")) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_RESULT_MARK_COLOR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(n2 - n3 * 6 - 1, 0.0f);
            generalPath.lineTo(n2 - n3 * 6 - 1, 6.0f);
            generalPath.lineTo(n2 - (n3 + 1) * 6 - 1, 0.0f);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    private static void paintWidgetMarkWhenExsit(Graphics2D graphics2D, TemplateCellElement templateCellElement, int n2, int n3) {
        if (templateCellElement.getWidget() != null) {
            Widget widget = templateCellElement.getWidget();
            Image image = ((ImageIcon)ReportUtils.createWidgetIcon(widget.getClass())).getImage();
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.67f));
            graphics2D.drawImage(image, n2 - 15, n3 - 15, 15, 15, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3));
        }
    }

    private static void paintExpandMarkWhenExsit(Graphics2D graphics2D, TemplateCellElement templateCellElement) {
        CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
        if (cellExpandAttr != null) {
            if (cellExpandAttr.getDirection() == 0) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(CELL_DIRECTION_MARK_COLOR);
                GraphHelper.drawLine(graphics2D, 2.0, 0.0, 2.0, 5.0);
                GraphHelper.drawLine(graphics2D, 2.0, 5.0, 0.0, 2.0);
                GraphHelper.drawLine(graphics2D, 2.0, 5.0, 4.0, 2.0);
                graphics2D.setPaint(paint);
            } else if (cellExpandAttr.getDirection() == 1) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(CELL_DIRECTION_MARK_COLOR);
                GraphHelper.drawLine(graphics2D, 0.0, 2.0, 5.0, 2.0);
                GraphHelper.drawLine(graphics2D, 5.0, 2.0, 2.0, 0.0);
                GraphHelper.drawLine(graphics2D, 5.0, 2.0, 2.0, 4.0);
                graphics2D.setPaint(paint);
            }
        }
    }

    private static boolean paintDSColumnConditionmarkWhenExsit(Graphics2D graphics2D, Object object, int n2, int n3) {
        if (object instanceof DSColumn && ((DSColumn)object).getCondition() != null && (!(((DSColumn)object).getCondition() instanceof ListCondition) || ((ListCondition)((DSColumn)object).getCondition()).getJoinConditionCount() != 0)) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_CONDITION_FILTER_MARK_COLOR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(0 + n3 * 6, n2 - 1);
            generalPath.lineTo((n3 + 1) * 6 + 1, n2 - 1);
            generalPath.lineTo(0 + n3 * 6, n2 - 2 - 6);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    private static boolean paintDSColumnParametermarkWhenExsit(Graphics2D graphics2D, Object object, int n2, int n3) {
        if (object instanceof DSColumn && ((DSColumn)object).getParameters() != null && ((DSColumn)object).getParameters().length > 0) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(CELL_PARAMETER_FILTER_MARK_CONLR);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(0 + n3 * 6, n2 - 1);
            generalPath.lineTo((n3 + 1) * 6 + 1, n2 - 1);
            generalPath.lineTo(0 + n3 * 6, n2 - 2 - 6);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    public static void paintFloatElement(Graphics2D graphics2D, FloatElement floatElement, int n2, int n3, int n4) {
        Style.paintBackground(graphics2D, floatElement.getStyle(), n2, n3);
        Object object = floatElement.getValue();
        if (object instanceof Formula) {
            object = ((Formula)object).getContent();
        }
        if (object instanceof Image) {
            object = CellUtils.value2ImageWithBackground(object, n4, floatElement.getStyle(), n2, n3);
        }
        Style.paintContent(graphics2D, object, floatElement.getStyle(), n2, n3, n4);
        Style.paintBorder(graphics2D, floatElement.getStyle(), n2, n3);
    }

    public static void paintFloatElement(Graphics2D graphics2D, FloatElement floatElement, Rectangle rectangle, Rectangle rectangle2, int n2) {
        Style.paintBackground(graphics2D, floatElement.getStyle(), rectangle, rectangle2);
        Style.paintContent(graphics2D, floatElement.getValue(), n2, floatElement.getStyle(), rectangle, rectangle2);
        Style.paintBorder(graphics2D, floatElement.getStyle(), rectangle, rectangle2);
    }

    public static void paintHTMLContent(Graphics2D graphics2D, String string, int n2, Style style, Rectangle rectangle, Rectangle rectangle2) {
        Style.paintContent(graphics2D, (Object)PaintUtils.createHTMLContentBufferedImage(string, rectangle, 0, 0, style), n2, style, rectangle, rectangle2);
    }

    public static void paintTag(Painter painter, Repository repository, int n2, int n3, Style style, Tag tag) {
        painter.paintTag(repository, n2, n3, style, tag);
    }

    public static BufferedImage createHTMLContentBufferedImage(String string, Rectangle rectangle, int n2, int n3, Style style) {
        return Html2ImageUtils.createHTMLContentBufferedImage(string, rectangle, n2, n3, style);
    }

    public static int getLineTextCount(String string, Style style, FontMetrics fontMetrics, double d2, boolean bl) {
        if (style.getRotation() != 0) {
            return 1;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        if (style.getTextStyle() != 0) {
            return PaintUtils.dealNotWrapTextCount(cArray, n2);
        }
        return PaintUtils.dealWrapTextCount(cArray, n2, style, fontMetrics, d2);
    }

    private static int dealNotWrapTextCount(char[] cArray, int n2) {
        boolean bl = false;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '\\') {
                if (i2 + 1 < cArray.length && cArray[i2 + 1] == 'n') {
                    ++i2;
                    ++n2;
                    if (!bl) continue;
                    bl = false;
                    continue;
                }
                if (bl) continue;
                bl = true;
                continue;
            }
            if (cArray[i2] == '\n' || cArray[i2] == '\r' && i2 + 1 < cArray.length - 1 && cArray[i2 + 1] != '\n') {
                ++n2;
                if (!bl) continue;
                bl = false;
                continue;
            }
            if (bl) continue;
            bl = true;
        }
        if (bl) {
            ++n2;
        }
        return n2;
    }

    private static int dealWrapTextCount(char[] cArray, int n2, Style style, FontMetrics fontMetrics, double d2) {
        double d3 = d2 - (double)style.getPaddingLeft() - (double)(style.getPaddingRight() == 2 ? 0 : style.getPaddingRight()) - (double)style.getBorderLeftWidth();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = cArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (i2 != 0 && BaseUtils.isNumOrLetter(cArray[i2]) && BaseUtils.isNumOrLetter(cArray[i2 - 1])) {
                if ((double)(n4 + fontMetrics.charWidth(cArray[i2])) > d3) {
                    if (n3 > 0) {
                        ++n2;
                        bl = false;
                        n3 = 0;
                    }
                    ++n2;
                    n4 = 0;
                }
                n4 += fontMetrics.charWidth(cArray[i2]);
                continue;
            }
            if (PaintUtils.isSwitchLine(cArray, i2) || PaintUtils.isLN(cArray, i2)) {
                if (PaintUtils.isLN(cArray, i2)) {
                    ++i2;
                }
                n2 = (double)(n3 + n4) > d3 && bl ? (n2 += 2) : ++n2;
                bl = false;
                n3 = 0;
                n4 = 0;
                continue;
            }
            if (cArray[i2] == '\\' && i2 + 1 < cArray.length && cArray[i2 + 1] == '\\') {
                ++i2;
            }
            if ((double)(n3 + n4) > d3 && bl) {
                ++n2;
                n3 = PaintUtils.isPunctuationAtLineHead(i2, cArray) ? PaintUtils.dealLineWidthWithPunctuation(i2, cArray, fontMetrics) : 0;
            }
            bl = true;
            n3 += n4;
            n4 = fontMetrics.charWidth(cArray[i2]);
        }
        n2 = (double)(n3 + n4) > d3 && bl ? (n2 += 2) : ++n2;
        return n2;
    }

    private static boolean isPunctuationAtLineHead(int n2, char[] cArray) {
        return n2 > 1 && BaseUtils.isPunctuation(cArray[n2 - 1]);
    }

    private static int dealLineWidthWithPunctuation(int n2, char[] cArray, FontMetrics fontMetrics) {
        if (n2 < 2) {
            return 0;
        }
        int n3 = 0;
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            n3 += fontMetrics.charWidth(cArray[i2]);
            if (!BaseUtils.isPunctuation(cArray[i2])) break;
        }
        return n3;
    }

    private static boolean isSwitchLine(char[] cArray, int n2) {
        return cArray[n2] == '\n' || cArray[n2] == '\r' && n2 + 1 < cArray.length - 1 && cArray[n2 + 1] != '\n';
    }

    private static boolean isLN(char[] cArray, int n2) {
        return cArray[n2] == '\\' && n2 + 1 < cArray.length && cArray[n2 + 1] == 'n';
    }

    public static UNIT getPreferredWidth(CellElement cellElement, UNIT uNIT) {
        Style style;
        if (cellElement == null) {
            return UNIT.ZERO;
        }
        Object object = cellElement.getShowValue();
        if (object instanceof Formula) {
            object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : "";
        }
        if ((style = cellElement.getStyle()) == null) {
            style = Style.DEFAULT_STYLE;
        }
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr() == null ? new CellGUIAttr() : cellElement.getCellGUIAttr();
        object = Utils.resolveOtherValue(object, cellGUIAttr.isShowAsImage(), PresentationType.EXPORT);
        String string = Style.valueToText(object, style.getFormat());
        FontMetrics fontMetrics = PaintUtils.getFontMetrics(style);
        PT pT = new PT((float)(style.getPaddingLeft() + style.getPaddingRight()));
        if (cellGUIAttr.isShowAsHTML()) {
            return Html2ImageUtils.getHtmlWidth(string, uNIT, style);
        }
        return FU.valueOfPix(fontMetrics.stringWidth(string) + 4, 96).add(pT);
    }

    private static FontMetrics getFontMetrics(Style style) {
        Font font = style.getFRFont().applyResolutionNP(96);
        FontProcessor fontProcessor = (FontProcessor)ExtraClassManager.getInstance().getSingle("FontProcessor");
        if (fontProcessor != null) {
            font = fontProcessor.readExtraFont(font);
        }
        return GraphHelper.getFontMetrics(font);
    }

    public static UNIT analyzeCellElementPreferredHeight(CellElement cellElement, UNIT uNIT) {
        CellGUIAttr cellGUIAttr;
        Object object = cellElement.getShowValue();
        Style style = cellElement.getStyle();
        if (object instanceof Formula) {
            object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : "";
        }
        CellGUIAttr cellGUIAttr2 = cellGUIAttr = cellElement.getCellGUIAttr() == null ? new CellGUIAttr() : cellElement.getCellGUIAttr();
        if (!(object instanceof String) && !(object instanceof Integer)) {
            object = DataUtils.resolveOtherValue(object, cellGUIAttr.isShowAsImage(), cellGUIAttr.isShowAsDownload(), null, true);
        }
        String string = Style.valueToText(object, style.getFormat());
        if (cellGUIAttr.isShowAsHTML()) {
            return Html2ImageUtils.getHtmlHeight(string, uNIT, style);
        }
        return PaintUtils.analyzeCellElementPreferredHeight(string, style, uNIT, cellGUIAttr.isShowAsHTML());
    }

    private static UNIT analyzeCellElementPreferredHeight(String string, Style style, UNIT uNIT, boolean bl) {
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if (string == null || string.length() <= 0) {
            return PT.valueOf(0.0f);
        }
        if (style.getRotation() != 0) {
            return PT.valueOf((float)GraphHelper.stringDimensionWithRotation(string, style.getFRFont(), -style.getRotation(), CoreConstants.DEFAULT_FRC).getHeight());
        }
        FontMetrics fontMetrics = PaintUtils.getFontMetrics(style);
        int n2 = PaintUtils.getLineTextCount(string, style, fontMetrics, uNIT.toPixD(96), bl);
        PT pT = PT.valueOf(style.getSpacingAfter() + style.getSpacingBefore() + style.getLineSpacing() * n2);
        int n3 = fontMetrics.getHeight();
        FU fU = FU.valueOfPix(n3 * n2, 96);
        return pT.add(fU);
    }

    public static String clipBlockValue(Object object, Style style, Rectangle rectangle, Rectangle rectangle2, int n2) {
        int n3;
        if (object == null) {
            return null;
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        ArrayList arrayList = new ArrayList();
        if (rectangle2.y >= rectangle.height || rectangle2.y + rectangle2.height <= 0) {
            return null;
        }
        int n4 = rectangle2.y > 0 ? rectangle2.y : 0;
        int n5 = n3 = rectangle2.y + rectangle2.height < rectangle.height ? rectangle2.y + rectangle2.height : rectangle.height;
        if (rectangle2.x >= rectangle.width || rectangle2.x + rectangle2.width <= 0) {
            return null;
        }
        List list = BaseUtils.getLineTextList((String)object, style, style.getFRFont().applyResolutionNP(n2), rectangle.width);
        if (list.isEmpty()) {
            return null;
        }
        double d2 = PT.pt2pix(style.getSpacingBefore(), n2);
        double d3 = PT.pt2pix(style.getSpacingAfter(), n2);
        double d4 = PT.pt2pix(style.getLineSpacing(), n2);
        double d5 = d4 + (double)GraphHelper.getFontMetrics(style.getFRFont().applyResolutionNP(n2)).getHeight();
        int n6 = (int)(d5 * (double)list.size() + d2 + d3);
        int n7 = (int)d2;
        if (style.getVerticalAlignment() == 3) {
            n7 += rectangle.height - n6;
        }
        if (n3 <= n7 || (double)n4 >= (double)n7 + d5 * (double)list.size()) {
            return null;
        }
        int n8 = PaintUtils.getLineEnd(list, d5, n3, n7);
        String string = "";
        for (int i2 = PaintUtils.getLineStart(list, d5, n7, n4); i2 <= n8; ++i2) {
            string = string + list.get(i2);
        }
        return string;
    }

    private static int getLineStart(List list, double d2, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!((double)n2 + d2 * (double)i2 <= (double)n3) || !((double)n2 + d2 * (double)(i2 + 1) > (double)n3)) continue;
            n4 = (double)(n3 - n2) - d2 * (double)i2 > d2 / 2.0 ? i2 + 1 : i2;
        }
        return n4;
    }

    private static int getLineEnd(List list, double d2, int n2, int n3) {
        int n4 = list.size() - 1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!((double)n3 + d2 * (double)i2 < (double)n2) || !((double)n3 + d2 * (double)(i2 + 1) >= (double)n2)) continue;
            n4 = (double)(n2 - n3) - d2 * (double)i2 >= d2 / 2.0 ? i2 : i2 - 1;
        }
        return n4;
    }

    public static void paintBarcode(Graphics2D graphics2D, int n2, int n3, String string, Style style, BarcodeAttr barcodeAttr) {
        Background background;
        BarcodeImpl barcodeImpl;
        try {
            barcodeImpl = BarCodeUtils.getBarcodeImpl(barcodeAttr, string);
        }
        catch (BarcodeException barcodeException) {
            try {
                barcodeImpl = BarCodeUtils.getBarcodeImpl(new BarcodeAttr(), null);
            }
            catch (BarcodeException barcodeException2) {
                FRContext.getLogger().error(barcodeException2.getMessage(), barcodeException2);
                return;
            }
        }
        if (style.getFRFont() != null) {
            barcodeImpl.setFont(style.getFRFont());
            barcodeImpl.setForeground(style.getFRFont().getForeground());
        }
        if ((background = style.getBackground()) != null && background instanceof ColorBackground) {
            barcodeImpl.setBackground(((ColorBackground)background).getColor());
        }
        int n4 = (n2 - barcodeImpl.getWidth()) / 2;
        int n5 = (n3 - barcodeImpl.getHeight()) / 2;
        barcodeImpl.draw(graphics2D, n4, n5);
    }

    public static Map createFontAttributeMap(Font font) {
        FRFont fRFont;
        Map<TextAttribute, ?> map = (Map<TextAttribute, ?>)fontAttributeMapCache.get(font);
        if (map == null) {
            map = font.getAttributes();
            fontAttributeMapCache.put(font, map);
        }
        if (font instanceof FRFont && (fRFont = (FRFont)font).isStrikethrough()) {
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return map;
    }
}

