/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.line.ean13;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.layout.LabelLayoutFactory;
import com.fr.report.cell.painter.barcode.line.ean13.EAN13ModuleFactory;
import com.fr.report.cell.painter.barcode.line.ean13.UPCABarcode;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import com.fr.report.cell.painter.barcode.output.SizingOutput;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class EAN13Barcode
extends UPCABarcode {
    public static final String[] TYPES = new String[]{"EAN-13", "EAN13"};
    public static final int LEFT_ODD = 0;
    public static final int LEFT_EVEN = 1;
    public static final int RIGHT = 2;
    public static final int PARITY_EVEN = 0;
    public static final int PARITY_ODD = 1;
    public static final int BARCODE_LENGTH = 12;
    public static final String ISBN_NUMBER_SYSTEM = "978";
    public static final int ISBN_SIZE = 10;

    public EAN13Barcode(String string) throws BarcodeException {
        super(string);
    }

    protected int getBarcodeLength() {
        return 12;
    }

    protected int getGuardCharSize() {
        return 0;
    }

    protected int getLeftWidth() {
        return 7;
    }

    protected Module getRightMargin() {
        return EAN13ModuleFactory.RIGHT_MARGIN;
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        this.x = n2;
        this.y = n3;
        GraphicsOutput graphicsOutput = new GraphicsOutput(graphics2D, this.font, this.barWidth, this.barHeight, true, this.getForeground(), this.getBackground());
        this.size = this.draw(graphicsOutput, n2, n3, this.barWidth, this.barHeight);
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        int n4;
        int n5 = n2;
        abstractOutput.beginDraw(d2, d3);
        double d4 = 0.0;
        double d5 = d3 * 2.0;
        double d6 = 10.0 * d2;
        if (this.drawingText) {
            d5 = (d3 - 11.0 * d2) * 2.0;
            d4 = d5 + 6.0 * d2;
        } else {
            d5 = d3 - 6.0 * d2;
            d4 = d3;
        }
        String string = this.getLabel();
        double d7 = this.barHeight + (double)n3;
        Module[] moduleArray = this.encodeData();
        String string2 = String.valueOf(string.charAt(0));
        String string3 = string.substring(1, this.getLeftWidth());
        String string4 = string.substring(this.getLeftWidth());
        if (this.requiresChecksum) {
            string4 = string4 + this.calculateChecksum().getSymbol();
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n2;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        Module module = this.getPreAmble();
        Module module2 = this.getPostAmble();
        n9 = 0;
        if (this.drawingQuietSection) {
            n5 = (int)((double)n5 + this.drawModule(this.getLeftMargin(), abstractOutput, n5, n3, d2, d5 + d6));
        }
        n6 = n2;
        n9 = n5 - n6;
        n12 = n5;
        int n13 = this.getGuardCharSize();
        int n14 = this.getLeftWidth() - 1;
        if (module != null) {
            n5 = (int)((double)n5 + this.drawModule(module, abstractOutput, n5, n3, d2, d4));
        }
        for (n4 = 0; n4 < n13; ++n4) {
            n5 = (int)((double)n5 + this.drawModule(moduleArray[0], abstractOutput, n5, n3, d2, d4));
        }
        n7 = n5;
        n12 = n5 - n12;
        for (n4 = n13; n4 < n14; ++n4) {
            n5 = (int)((double)n5 + this.drawModule(moduleArray[n4], abstractOutput, n5, n3, d2, d5));
        }
        n10 = n5 - n7;
        n12 = n5;
        n8 = n5 = (int)((double)n5 + this.drawModule(this.getCentreGuard(), abstractOutput, n5, n3, d2, d4));
        n12 = n5 - n12;
        for (n4 = n14; n4 < moduleArray.length; ++n4) {
            n5 = (int)((double)n5 + this.drawModule(moduleArray[n4], abstractOutput, n5, n3, d2, d5));
        }
        n11 = n5 - n8;
        n12 = n5;
        if (module2 != null) {
            n5 = (int)((double)n5 + this.drawModule(module2, abstractOutput, n5, n3, d2, d4));
        }
        n12 = n5 - n12;
        n5 = (int)((double)n5 + this.drawModule(this.getRightMargin(), abstractOutput, n5, n3, d2, d5 + d6));
        if (this.drawingText) {
            abstractOutput.drawText(string2, LabelLayoutFactory.createMarginLayout(n6, (int)(d7 - d6), n9, (int)d6));
            abstractOutput.drawText(string3, LabelLayoutFactory.createMarginLayout(n7, (int)(d7 - d6), n10, (int)d6));
            abstractOutput.drawText(string4, LabelLayoutFactory.createMarginLayout(n8, (int)(d7 - d6), n11, (int)d6));
        }
        Dimension dimension = new Dimension(n5 - n2, (int)d7 - n3);
        abstractOutput.endDraw();
        return dimension;
    }

    protected Dimension calculateSize() {
        Dimension dimension = new Dimension();
        try {
            FontMetrics fontMetrics = null;
            if (this.font != null) {
                fontMetrics = this.getFontMetrics(this.font);
            }
            dimension = this.draw(new SizingOutput(this.font, this.barWidth, this.barHeight, fontMetrics, this.getForeground(), this.getBackground()), 0, 0, this.barWidth, this.barHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimension;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        Module module = null;
        int n2 = this.data.length();
        String string = this.data.substring(0, 1);
        for (int i2 = 1; i2 < n2; ++i2) {
            char c2 = this.data.charAt(i2);
            module = EAN13ModuleFactory.getModule(string, String.valueOf(c2), i2);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        if (this.requiresChecksum) {
            module = EAN13ModuleFactory.getModule(string, this.calculateChecksum().getSymbol(), arrayList.size() - 1);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            return EAN13ModuleFactory.getModuleForIndex(this.data.substring(0, 1), EAN13Barcode.getMod10CheckDigit(this.data));
        }
        return null;
    }

    public static int getMod10CheckDigit(String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                int n4 = Integer.parseInt(String.valueOf(string.charAt(i2)));
                n2 += EAN13Barcode.calculateChecksum(n4, i2 % 2 == 0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 10 - n2 % 10;
    }
}

