/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core;

import com.fr.base.Style;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.report.cell.cellattr.core.RichChar;
import com.fr.report.cell.cellattr.core.RichText;
import com.fr.report.core.Html2ImageUtils;
import com.fr.stable.StringUtils;
import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.FontFactory;
import com.fr.third.com.lowagie.text.ListItem;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.html.simpleparser.HTMLWorker;
import com.fr.third.com.lowagie.text.html.simpleparser.StyleSheet;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextConverter {
    private static boolean FONT_INIT_STATE = false;
    private static String DEF_FONTNAME = "unknown";
    private static int DEF_FONTSIZE = 12;
    private static Chunk SWITCH_LINE = new Chunk("\n");
    private static final String KAITI = "KaiTi";
    private static final String ST_XINGKAI = "STXingkai";
    private static final String ST_KAITI = "STKaiti";
    private static final String FANGSONG = "FangSong";
    private static final String FONT_ENCODE = "gb18030";
    private static final int DEFAULT_CHARSET = 134;

    public static RichText converHtmlToRichText(boolean bl, String string, Style style) {
        if (!bl) {
            RichChar richChar = new RichChar(string, style);
            return new RichText(richChar);
        }
        return RichTextConverter.html2RichText(string, style);
    }

    public static RichText html2RichText(String string) {
        return RichTextConverter.html2RichText(string, Style.DEFAULT_STYLE);
    }

    public static RichText html2RichText(String string, Style style) {
        RichText richText = new RichText();
        for (Chunk chunk : RichTextConverter.html2ChunkArray(string, style)) {
            Style style2 = RichTextConverter.convertHtmlStyle(chunk, style);
            richText.addContent(new RichChar(chunk.getContent(), style2));
        }
        return richText;
    }

    private static String splitAndFilterString(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        String string2 = string.replaceAll("<[a-zA-Z]+[1-9]?[^><]*>", "").replaceAll("</[a-zA-Z]+[1-9]?>", "");
        string2 = string2.replaceAll("[(/>)<]", "").replaceAll("&nbsp;", " ");
        return string2;
    }

    private static Style convertHtmlStyle(Chunk chunk, Style style) {
        Style style2 = Style.DEFAULT_STYLE;
        Font font = chunk.getFont();
        String string = font.getFamilyname();
        float f2 = font.getSize();
        int n2 = font.getStyle();
        Color color = RichTextConverter.converItextColorToJava(font.getColor());
        int n3 = font.isUnderlined() ? 1 : 0;
        HashMap hashMap = chunk.getAttributes();
        boolean bl = false;
        boolean bl2 = false;
        if (hashMap != null && hashMap.containsKey("SUBSUPSCRIPT")) {
            float f3 = ((Number)hashMap.get("SUBSUPSCRIPT")).floatValue();
            bl2 = f3 > 0.0f;
            bl = !bl2;
        }
        FRFont fRFont = FRFont.getInstance(string, n2, f2, color, n3, false, false, bl2, bl);
        fRFont = fRFont.applyName(fRFont.getFontName());
        return style2.deriveFRFont(fRFont);
    }

    private static Color converItextColorToJava(Color color) {
        if (color == null) {
            return Color.BLACK;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static void initFontFactory() {
        if (!FONT_INIT_STATE) {
            FontFactory.registerDirectories();
            FONT_INIT_STATE = true;
        }
    }

    private static Font validChunkFont(Font font, Style style) {
        String string = font.getFamilyname();
        float f2 = font.getSize();
        if (!ComparatorUtils.equals(DEF_FONTNAME, string)) {
            return RichTextConverter.getLocaleRFTFont(string, font);
        }
        string = style.getFRFont().getFontName();
        font.setFamily(string);
        if (f2 == (float)DEF_FONTSIZE) {
            f2 = style.getFRFont().getSize();
            font.setSize(f2);
        }
        return RichTextConverter.getLocaleRFTFont(string, font);
    }

    private static RtfFont getLocaleRFTFont(String string, Font font) {
        if (ComparatorUtils.equals(KAITI, string)) {
            string = Inter.getLocText("FR-Engine_KaiTi");
        } else if (ComparatorUtils.equals(ST_KAITI, string)) {
            string = Inter.getLocText("FR-Engine_STKaiTi");
        } else if (ComparatorUtils.equals(ST_XINGKAI, string)) {
            string = Inter.getLocText("FR-Engine_STXingKai");
        } else if (ComparatorUtils.equals(FANGSONG, string)) {
            string = Inter.getLocText("FR-Engine_FangSong");
        }
        try {
            string = new String(string.getBytes(FONT_ENCODE), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new RtfFont(string, font.getSize(), font.getStyle(), font.getColor(), 134);
    }

    public static Chunk[] html2ChunkArray(String string) {
        return RichTextConverter.html2ChunkArray(string, Style.DEFAULT_STYLE);
    }

    public static Chunk[] html2ChunkArray(String string, Style style) {
        ArrayList arrayList;
        string = Html2ImageUtils.convertPx2Pt(string);
        try {
            RichTextConverter.initFontFactory();
            arrayList = HTMLWorker.parseToList((Reader)new StringReader(string), (StyleSheet)new StyleSheet());
        }
        catch (Exception exception) {
            String string2 = RichTextConverter.splitAndFilterString(string);
            Chunk chunk = new Chunk(string2);
            return new Chunk[]{chunk};
        }
        ArrayList<Chunk> arrayList2 = new ArrayList<Chunk>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Element element = (Element)arrayList.get(i2);
            int n2 = element.type();
            RichTextConverter.dispatchDifferentElems(n2, i2, element, arrayList2);
        }
        return RichTextConverter.validChunksFont(arrayList2, style);
    }

    private static Chunk[] validChunksFont(List<Chunk> list, Style style) {
        int n2 = list.size();
        Chunk[] chunkArray = new Chunk[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Chunk chunk = list.get(i2);
            if (RichTextConverter.validChar(chunk)) {
                chunk.setFont(RichTextConverter.validChunkFont(chunk.getFont(), style));
            }
            chunkArray[i2] = chunk;
        }
        return chunkArray;
    }

    private static boolean validChar(Chunk chunk) {
        return !ComparatorUtils.equals(chunk.getContent(), "\n");
    }

    private static void appendSwitchLine(int n2, List<Chunk> list) {
        if (n2 != 0) {
            list.add(SWITCH_LINE);
        }
    }

    private static void dispatchDifferentElems(int n2, int n3, Element element, List<Chunk> list) {
        switch (n2) {
            case 12: {
                RichTextConverter.appendSwitchLine(n3, list);
                Paragraph paragraph = (Paragraph)element;
                list.addAll(paragraph.getChunks());
                break;
            }
            case 10: {
                RichTextConverter.appendSwitchLine(n3, list);
                Chunk chunk = (Chunk)element;
                list.add(chunk);
                break;
            }
            case 14: {
                com.fr.third.com.lowagie.text.List list2 = (com.fr.third.com.lowagie.text.List)element;
                list.addAll(list2.getChunks());
                break;
            }
            case 15: {
                ListItem listItem = (ListItem)element;
                list.addAll(listItem.getChunks());
                break;
            }
            case 23: {
                throw new UnsupportedOperationException("Unsupport tag : <table>");
            }
            default: {
                return;
            }
        }
    }

    private static String wrapperSpan(String string, Style style) {
        FRFont fRFont = style.getFRFont();
        String string2 = fRFont.getFontName();
        int n2 = fRFont.getSize();
        return "<span style='font-size:" + n2 + "pt;font-family:" + string2 + ";'>" + string + "</span>";
    }

    public static String asFormula(String string) {
        return "$" + "{" + string + "}";
    }
}

