/*
 * Decompiled with CFR 0.152.
 */
package com.fr.main.parameter;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Parameter;
import com.fr.base.background.ColorBackground;
import com.fr.base.parameter.ParameterUI;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TemplateParameterAttr
implements XMLable {
    public static final int POPUP = 0;
    public static final int EMBED = 1;
    protected boolean delayPlaying = true;
    protected boolean showWindow = true;
    protected int windowPosition = 1;
    public static final int LEFTPOSITION = 0;
    public static final int CENTERPOSITION = 1;
    public static final int RIGHTPOSITION = 2;
    protected int align = 0;
    protected Background background = ColorBackground.getInstance(new Color(238, 238, 238));
    protected ParameterUI parameterUI = null;
    protected List parameters = new ArrayList();
    protected String parameterWindowTitle = Inter.getLocText("Parameter");

    public String getParameterWindowTitle() {
        return this.parameterWindowTitle;
    }

    public void setParameterWindowTitle(String string) {
        this.parameterWindowTitle = string;
    }

    public boolean isShowWindow() {
        return this.showWindow;
    }

    public void setShowWindow(boolean bl) {
        this.showWindow = bl;
    }

    public boolean isDelayPlaying() {
        return this.delayPlaying;
    }

    public void setDelayPlaying(boolean bl) {
        this.delayPlaying = bl;
    }

    public int getWindowPosition() {
        return this.windowPosition;
    }

    public void setWindowPosition(int n2) {
        this.windowPosition = n2;
    }

    public void setAlign(int n2) {
        this.align = n2;
    }

    public int getAlign() {
        return this.align;
    }

    public ParameterUI getParameterUI() {
        return this.parameterUI;
    }

    public void setParameterUI(ParameterUI parameterUI) {
        this.parameterUI = parameterUI;
    }

    public void addParameter(Parameter parameter) {
        if (this.hasParameter(parameter)) {
            return;
        }
        this.parameters.add(parameter);
    }

    private boolean hasParameter(Parameter parameter) {
        Parameter[] parameterArray = this.getParameters();
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            if (!ComparatorUtils.equals(parameter.getName(), parameterArray[i2].getName())) continue;
            return true;
        }
        return false;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void clearParameter(Parameter parameter) {
        this.parameters.remove(parameter);
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void readXML(XMLableReader xMLableReader) {
        Object var2_2 = null;
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.setShowWindow(xMLableReader.getAttrAsBoolean("showWindow", false));
                this.setDelayPlaying(xMLableReader.getAttrAsBoolean("delayPlaying", true));
                this.setWindowPosition(xMLableReader.getAttrAsInt("windowPosition", 1));
                this.setAlign(xMLableReader.getAttrAsInt("align", 1));
            } else if ("ParameterUI".equals(string)) {
                this.setParameterUI(ReportXMLUtils.readParameterUI(xMLableReader));
            } else if ("PWTitle".equals(string)) {
                this.setParameterWindowTitle(xMLableReader.getElementValue());
            } else if ("Parameter".equals(string)) {
                this.parameters.add(BaseXMLUtils.readParameter(xMLableReader));
            } else if ("Parameters".equals(string)) {
                this.parameters.addAll(Arrays.asList(BaseXMLUtils.readParameters(xMLableReader)));
            } else if ("Background".equals(string)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("showWindow", this.showWindow).attr("delayPlaying", this.delayPlaying).attr("windowPosition", this.windowPosition).attr("align", this.align).end();
        xMLPrintWriter.startTAG("PWTitle").textNode(this.getParameterWindowTitle()).end();
        ReportXMLUtils.writeParameterUI(xMLPrintWriter, this.parameterUI);
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StableXMLUtils.writeParameter(xMLPrintWriter, (Parameter)this.parameters.get(i2));
        }
        if (!ColorBackground.getInstance(new Color(238, 238, 238)).equals(this.background)) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TemplateParameterAttr templateParameterAttr = (TemplateParameterAttr)super.clone();
        if (this.parameterUI != null) {
            templateParameterAttr.parameterUI = (ParameterUI)this.parameterUI.clone();
        }
        templateParameterAttr.parameters = new ArrayList();
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            templateParameterAttr.parameters.add(((Parameter)this.parameters.get(i2)).clone());
        }
        return templateParameterAttr;
    }

    public boolean equals(Object object) {
        return object instanceof TemplateParameterAttr && this.delayPlaying == ((TemplateParameterAttr)object).delayPlaying && this.showWindow == ((TemplateParameterAttr)object).showWindow && this.align == ((TemplateParameterAttr)object).align && this.windowPosition == ((TemplateParameterAttr)object).windowPosition && ComparatorUtils.equals(this.background, ((TemplateParameterAttr)object).background) && ComparatorUtils.equals((Object)this.parameters, (Object)((TemplateParameterAttr)object).parameters) && ComparatorUtils.equals(this.parameterWindowTitle, ((TemplateParameterAttr)object).parameterWindowTitle) && ComparatorUtils.equals(this.parameterUI, ((TemplateParameterAttr)object).parameterUI);
    }
}

