/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter.excel.stream;

import com.fr.base.CustomConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Margin;
import com.fr.base.Painter;
import com.fr.base.PaperSize;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.types.StringNumberType;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.io.attr.ExcelExportAttr;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.excel.stream.CellHelper;
import com.fr.io.exporter.excel.stream.CellPosition;
import com.fr.io.exporter.excel.stream.MergeCellDynamicIterator;
import com.fr.io.exporter.excel.stream.MergeCellHelper;
import com.fr.io.exporter.excel.stream.StreamExcel2007Exporter;
import com.fr.io.exporter.excel.stream.StreamExcelHiddenCellsTool;
import com.fr.io.exporter.poi.wrapper.POIClientAnchorAction;
import com.fr.io.exporter.poi.wrapper.POIHeaderFooterAction;
import com.fr.io.exporter.poi.wrapper.POIPatriarchAction;
import com.fr.io.exporter.poi.wrapper.POIPrintSetupAction;
import com.fr.io.exporter.poi.wrapper.POISheetAction;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.io.exporter.poi.wrapper.PaperSettingWrapper;
import com.fr.io.exporter.poi.wrapper.XssfCellWrapper;
import com.fr.io.exporter.poi.wrapper.XssfClientAnchorWrapper;
import com.fr.io.exporter.poi.wrapper.XssfFooterWrapper;
import com.fr.io.exporter.poi.wrapper.XssfHeaderWrapper;
import com.fr.io.exporter.poi.wrapper.XssfPatriarchWrapper;
import com.fr.io.exporter.poi.wrapper.XssfPrintSetupWrapper1;
import com.fr.io.exporter.poi.wrapper.XssfSheetWrapper;
import com.fr.io.exporter.poi.wrapper.XssfWorkbookWrapper;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.fun.CommentExcelProcessor;
import com.fr.report.report.Report;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.script.ExTool;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellStyle;
import com.fr.third.v2.org.apache.poi.ss.usermodel.ClientAnchor;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Comment;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Drawing;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Font;
import com.fr.third.v2.org.apache.poi.ss.usermodel.RichTextString;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Sheet;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Workbook;
import com.fr.third.v2.org.apache.poi.ss.util.CellRangeAddress;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFColor;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFFont;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFPicture;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFTextBox;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import com.fr.web.core.utils.ExportUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamExcelReportExporter {
    private static final int MAX_COLUMN_WIDTH = 65280;
    private static final int MILLISECOND_PER_SEC = 1000;
    private ElementCase report;
    private List paperSettingList;
    private DynamicUnitList rowHeightList;
    private DynamicUnitList columnWidthList;
    private ExcelExportAttr eea;
    private int reportIndex;
    private List xssfCellList;
    private List xssfCellFormulaList;
    private String sheetName;
    private SXSSFWorkbook wb;
    private Sheet xssfSheet;
    private XSSFDrawing patriarch;
    private Drawing patr;
    protected Map[] columnRowPostileMaps;
    private Set<Integer> hiddenRowList = new HashSet<Integer>();
    private Set<Integer> hiddenColList = new HashSet<Integer>();
    private Calculator cal = Calculator.createCalculator();
    private StreamExcelHiddenCellsTool ex_tool = new StreamExcelHiddenCellsTool();
    private StreamExcel2007Exporter exporter;

    protected StreamExcelReportExporter(ElementCase elementCase, String string, SXSSFWorkbook sXSSFWorkbook, List list, List list2, ExcelExportAttr excelExportAttr, int n2, List list3, Map[] mapArray, StreamExcel2007Exporter streamExcel2007Exporter) {
        this.report = elementCase;
        this.sheetName = string;
        this.wb = sXSSFWorkbook;
        this.paperSettingList = list3;
        this.eea = excelExportAttr;
        this.reportIndex = n2;
        this.xssfCellList = list;
        this.xssfCellFormulaList = list2;
        this.xssfSheet = sXSSFWorkbook.createSheet();
        this.columnRowPostileMaps = mapArray;
        if (StringUtils.isNotEmpty(excelExportAttr.getProtectedWord())) {
            this.xssfSheet.protectSheet(excelExportAttr.getProtectedWord());
        }
        this.patriarch = (XSSFDrawing)this.xssfSheet.createDrawingPatriarch();
        if (this.columnRowPostileMaps != null && this.columnRowPostileMaps[n2] != null) {
            this.patr = this.xssfSheet.createDrawingPatriarch();
        }
        this.exporter = streamExcel2007Exporter;
    }

    public void export() {
        this.setSheetName();
        this.initPageSetting();
        Iterator iterator = this.report.cellIterator();
        this.rowHeightList = ReportHelper.getRowHeightList(this.report);
        this.columnWidthList = ReportHelper.getColumnWidthList(this.report);
        this.initHiddenSet();
        this.setFreeze();
        this.setAttr4ECReportSIL();
        this.exportCells(iterator);
        this.exportFloatElement();
        this.setColumnWidth();
        CommentExcelProcessor commentExcelProcessor = (CommentExcelProcessor)ExtraReportClassManager.getInstance().getSingle("CommentExcelProcessor");
        if (commentExcelProcessor != null) {
            if (this.patr == null) {
                this.patr = this.xssfSheet.createDrawingPatriarch();
            }
            commentExcelProcessor.addCellComment(this.xssfSheet, this.report, this.patr);
        }
    }

    private void setSheetName() {
        ExportUtils.setSheetName((POIWorkbookAction)new XssfWorkbookWrapper((Workbook)this.wb), (String)this.sheetName);
    }

    private void initPageSetting() {
        this.initECReportAndBlockPageSetting();
        this.xssfSheet.setDefaultColumnWidth(9);
    }

    private void initECReportAndBlockPageSetting() {
        ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings((Report)((Object)this.report));
        PaperSettingWrapper paperSettingWrapper = new PaperSettingWrapper(this.paperSettingList, this.reportIndex, reportSettingsProvider);
        ExportUtils.dealWithAlignAndMargin((POISheetAction)new XssfSheetWrapper(this.xssfSheet), (ReportSettingsProvider)reportSettingsProvider, (Margin)paperSettingWrapper.getMargin());
        ExportUtils.dealWithPrintSetUp((POIPrintSetupAction)new XssfPrintSetupWrapper1(this.xssfSheet.getPrintSetup()), (PaperSize)paperSettingWrapper.getPaperSize(), (int)paperSettingWrapper.getOrientation(), (ReportSettingsProvider)reportSettingsProvider);
        if (reportSettingsProvider.getHeaderHeight().more_than_zero()) {
            ExportUtils.applyReportHFHeader((ReportHFProvider)((Report)((Object)this.report)).getHeader(0), (POIHeaderFooterAction)new XssfHeaderWrapper(this.xssfSheet.getHeader()));
        }
        if (reportSettingsProvider.getFooterHeight().more_than_zero()) {
            ExportUtils.applyReportHFFooter((ReportHFProvider)((Report)((Object)this.report)).getFooter(0), (POIHeaderFooterAction)new XssfFooterWrapper(this.xssfSheet.getFooter()));
        }
    }

    private CellPosition getCellPosition(CellElement cellElement) {
        int n2 = cellElement.getColumn();
        int n3 = cellElement.getRow();
        int n4 = cellElement.getColumnSpan();
        int n5 = cellElement.getRowSpan();
        int[] nArray = this.dealWithHiddenCR(n3, n5, this.hiddenRowList);
        n3 = nArray[0];
        n5 = nArray[1];
        nArray = this.dealWithHiddenCR(n2, n4, this.hiddenColList);
        n2 = nArray[0];
        n4 = nArray[1];
        return new CellPosition(n2, n4, n3, n5);
    }

    private void exportCells(Iterator<CellElement> iterator) {
        MergeCellDynamicIterator mergeCellDynamicIterator = new MergeCellDynamicIterator();
        int n2 = 0;
        CellHelper cellHelper = null;
        int n3 = n2;
        block0: while (iterator.hasNext() || mergeCellDynamicIterator.hasNext()) {
            Object object;
            Object object2;
            Row row;
            while (this.hasMergeCellCondition(iterator, mergeCellDynamicIterator, n2)) {
                n3 = mergeCellDynamicIterator.getCurrentRow();
                row = this.createRow(n3);
                object2 = mergeCellDynamicIterator.next();
                object = object2.iterator();
                while (object.hasNext()) {
                    MergeCellHelper mergeCellHelper = (MergeCellHelper)object.next();
                    this.dealWithMergeCell(mergeCellHelper, row);
                }
            }
            for (int i2 = n3; i2 < n2; ++i2) {
                this.createRow(i2);
            }
            row = this.createRow(n2);
            n3 = n2;
            while (iterator.hasNext()) {
                if (cellHelper != null) {
                    this.dealWithCell(cellHelper, row, mergeCellDynamicIterator);
                }
                object2 = iterator.next();
                object = this.getCellPosition((CellElement)object2);
                cellHelper = new CellHelper((CellElement)object2, (CellPosition)object);
                if (((CellPosition)object).getRow() == n2) continue;
                mergeCellDynamicIterator.setCurrentRow(n2 + 1);
                n2 = ((CellPosition)object).getRow();
                continue block0;
            }
        }
        if (cellHelper != null) {
            for (int i3 = n3; i3 < n2; ++i3) {
                this.createRow(i3);
            }
            Row row = this.createRow(n2);
            this.dealWithCell(cellHelper, row, mergeCellDynamicIterator);
        }
    }

    private boolean hasMergeCellCondition(Iterator<CellElement> iterator, MergeCellDynamicIterator mergeCellDynamicIterator, int n2) {
        return (!iterator.hasNext() || n2 >= mergeCellDynamicIterator.getCurrentRow()) && mergeCellDynamicIterator.hasNext();
    }

    protected int[] dealWithHiddenCR(int n2, int n3, Set<Integer> set) {
        int[] nArray = new int[]{n2, n3};
        for (int n4 : set) {
            if (n4 >= n2 && n4 < n2 + n3) {
                nArray[1] = nArray[1] - 1;
                continue;
            }
            if (n4 >= n2) continue;
            nArray[0] = nArray[0] - 1;
        }
        return nArray;
    }

    private void dealWithCell(CellHelper cellHelper, Row row, MergeCellDynamicIterator mergeCellDynamicIterator) {
        int n2;
        int n3 = cellHelper.getRealPosition().getColumn();
        int n4 = cellHelper.getRealPosition().getRow();
        int n5 = cellHelper.getRealPosition().getColumnSpan();
        int n6 = cellHelper.getRealPosition().getRowSpan();
        if (n6 <= 0 || n5 <= 0) {
            return;
        }
        int n7 = n3 + n5 - 1;
        int n8 = n4 + n6 - 1;
        this.setColumnRowBreak(cellHelper.getCell(), new XssfSheetWrapper(this.xssfSheet), n3, n4, n7, n8);
        CellGUIAttr cellGUIAttr = cellHelper.getCell().getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
        if (!cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) {
            return;
        }
        int n9 = n3 + n5;
        for (int i2 = n2 = n3; i2 < n9; ++i2) {
            Cell cell = this.createCell(row, i2);
            this.createComment(cell, n4, i2, n7);
            if (i2 != n2 || !cellGUIAttr.isPrintContent() && cellGUIAttr.isPrintBackground()) {
                cell.setCellStyle(this.exporter.createXSSFCellStyle(this.wb, cellHelper.getCell().getStyle()));
                continue;
            }
            this.dealWithValue(cellHelper.getCell(), cell, cellGUIAttr, n3, n4, n5, n6);
        }
        if (n6 > 1 || n5 > 1) {
            CellRangeAddress cellRangeAddress = new CellRangeAddress(n4, n4 + n6 - 1, (int)((short)n3), (int)((short)(n3 + n5 - 1)));
            this.xssfSheet.addMergedRegion(cellRangeAddress);
        }
        if (n6 > 1) {
            mergeCellDynamicIterator.addMergeCell(new MergeCellHelper(cellHelper, n4, n8, n3, n7));
        }
    }

    private void dealWithMergeCell(MergeCellHelper mergeCellHelper, Row row) {
        int n2;
        CellElement cellElement = mergeCellHelper.getCell();
        int n3 = mergeCellHelper.getFirstCol();
        int n4 = mergeCellHelper.getLastCol();
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
        if (!cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) {
            return;
        }
        int n5 = n4 + 1;
        for (int i2 = n2 = n3; i2 < n5; ++i2) {
            Cell cell = this.createCell(row, i2);
            cell.setCellStyle(this.exporter.createXSSFCellStyle(this.wb, cellElement.getStyle()));
        }
    }

    private void dealWithValue(CellElement cellElement, Cell cell, CellGUIAttr cellGUIAttr, int n2, int n3, int n4, int n5) {
        Style style = cellElement.getStyle();
        Object object = this.exporter.evalCellValue(cellElement, this.eea.isExportHidedRow(), this.eea.isExportHidedColumn(), this.xssfCellList, new XssfCellWrapper(cell), this.cal, style, this.xssfCellFormulaList, cellGUIAttr, this.rowHeightList, this.columnWidthList, n2, n3, n4, n5, new XssfWorkbookWrapper((Workbook)this.wb));
        CellStyle cellStyle = this.setPOICellValue(style, object, cell, n3, n2, n5, n4);
        this.setPOICellStyle(cell, style, cellGUIAttr, object, cellStyle);
    }

    protected void setPOICellStyle(Cell cell, Style style, CellGUIAttr cellGUIAttr, Object object, CellStyle cellStyle) {
        Object object2;
        if (cell.getCellType() == 1 && cell.getStringCellValue().startsWith("--")) {
            style.deriveFormat(TextFormat.getInstance());
        }
        if (cell.getCellType() == 8 && (object2 = cell.getNumericStringCellValue()) != null && ((String)object2).startsWith("--")) {
            style.deriveFormat(TextFormat.getInstance());
            cell.setCellValue((String)null);
            cell.setCellType(1);
            cell.setCellValue((String)object2);
        }
        if (!cellGUIAttr.isPrintBackground()) {
            object2 = style.deriveBackground(null);
            cell.setCellStyle(this.exporter.createXSSFCellStyle(this.wb, (Style)object2));
        } else if (!(object instanceof Date) && !(object instanceof Formula)) {
            cell.setCellStyle(cellStyle);
        }
    }

    private void dealDateFormula(Cell cell, Object object, SXSSFWorkbook sXSSFWorkbook, CellStyle cellStyle, Style style) {
        cell.setCellType(2);
        String string = ((Formula)object).getContent();
        this.dealStringFormulaContent(cell, string, sXSSFWorkbook, cellStyle, style);
    }

    private void dealStringFormulaContent(Cell cell, String string, SXSSFWorkbook sXSSFWorkbook, CellStyle cellStyle, Style style) {
        if (string.equalsIgnoreCase("=now()")) {
            cell.setCellFormula("now()");
            CellStyle cellStyle2 = this.exporter.createXSSFCellStyle(sXSSFWorkbook, style.deriveFormat(DateUtils.DATETIMEFORMAT2));
            cell.setCellStyle(cellStyle2);
        } else if (string.equalsIgnoreCase("=today()")) {
            cell.setCellFormula("today()");
            CellStyle cellStyle3 = this.exporter.createXSSFCellStyle(sXSSFWorkbook, style.deriveFormat(DateUtils.DATEFORMAT2));
            cell.setCellStyle(cellStyle3);
        } else {
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            this.exporter.dealWithFormula(cell, string);
            cell.setCellStyle(cellStyle);
        }
    }

    private CellStyle setPOICellValue(Style style, Object object, Cell cell, int n2, int n3, int n4, int n5) {
        Format format = style.getFormat();
        CellStyle cellStyle = this.exporter.createXSSFCellStyle(this.wb, style);
        if ((object = ExportUtils.checkExcel2007NumberFormat((Format)format, (Object)object)) instanceof Formula) {
            this.dealDateFormula(cell, object, this.wb, cellStyle, style);
        } else if (object instanceof StringNumberType) {
            cell.setCellType(8);
            cell.setNumberCellStringValue(((StringNumberType)object).getValue());
        } else if (object instanceof BigDecimal) {
            cell.setCellType(6);
            cell.setCellValue((BigDecimal)object);
        } else if (object instanceof BigInteger) {
            cell.setCellType(7);
            cell.setCellValue((BigInteger)object);
        } else if (object instanceof Number) {
            cell.setCellType(0);
            double d2 = Double.parseDouble(String.valueOf(object));
            cell.setCellValue(d2);
        } else if (object instanceof Boolean) {
            cell.setCellType(4);
            cell.setCellValue(((Boolean)object).booleanValue());
        } else if (object instanceof Painter || object instanceof Image) {
            this.scalePic(n3, n2, n5, n4, object, style);
        } else if (object instanceof XSSFRichTextString) {
            cell.setCellType(1);
            cell.setCellValue((RichTextString)((XSSFRichTextString)object));
        } else if (object instanceof Date) {
            if (style.getFormat() == null) {
                style = this.getDefaultDateStyle((Date)object, style);
            }
            CellStyle cellStyle2 = this.exporter.createXSSFCellStyle(this.wb, style);
            cell.setCellStyle(cellStyle2);
            Format format2 = style.getFormat();
            Date date = (Date)object;
            if (!(format2 instanceof SimpleDateFormat) || !StringUtils.contains(((SimpleDateFormat)format2).toPattern(), "SSS")) {
                date.setTime(date.getTime() / 1000L * 1000L);
            }
            cell.setCellValue(date);
        } else {
            this.evalStringCellValue(object, format, cell, this.wb, cellStyle, style);
        }
        return cellStyle;
    }

    private Style getDefaultDateStyle(Date date, Style style) {
        style = date instanceof Time ? style.deriveFormat(DateUtils.TIMEFORMAT) : style.deriveFormat(DateUtils.DATETIMEFORMAT2);
        return style;
    }

    private void evalStringCellValue(Object object, Format format, Cell cell, SXSSFWorkbook sXSSFWorkbook, CellStyle cellStyle, Style style) {
        String string = null;
        string = format == null && (object instanceof String || object instanceof Primitive) ? object.toString() : Style.valueToText(object, format);
        if (string != null) {
            if (string.startsWith("=")) {
                this.dealStringFormulaContent(cell, string, sXSSFWorkbook, cellStyle, style);
            } else if (string.length() > 0) {
                string = ExportUtils.replaceNewLineChar((String)string);
                if (format instanceof NumberFormat) {
                    try {
                        cell.setCellValue(Double.parseDouble(string));
                        cell.setCellType(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        cell.setCellType(1);
                        cell.setCellValue(string);
                    }
                } else {
                    cell.setCellType(1);
                    if (string.contains("\n")) {
                        cell.setCellValue((RichTextString)new XSSFRichTextString(string));
                    } else {
                        cell.setCellValue(string);
                    }
                }
            }
        }
    }

    private void scalePic(int n2, int n3, int n4, int n5, Object object, Style style) {
        XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)n2), n3, (int)((short)(n2 + n4)), n3 + n5);
        if (object != null) {
            xSSFClientAnchor.setAnchorType(XSSFClientAnchor.MOVE_AND_RESIZE);
            double d2 = this.columnWidthList.getRangeValue(n2, n2 + n4).toPixI(96);
            double d3 = this.rowHeightList.getRangeValue(n3, n3 + n5).toPixI(96);
            double d4 = 1.0;
            if (object instanceof Image && style.getImageLayout() == 2) {
                double d5 = ((Image)object).getWidth(null);
                double d6 = ((Image)object).getHeight(null);
                d4 = Math.min(d5 / d2, d6 / d3);
            }
            int n6 = (int)(d2 * d4);
            int n7 = (int)(d3 * d4);
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n6 + 1, n7 + 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(style.getBorderLeftWidth(), style.getBorderTopWidth());
            Style.paintContent(graphics2D, object, style, n6 - style.getBorderLeftWidth(), n7 - style.getBorderTopWidth(), 96);
            bufferedImage.flush();
            graphics2D.dispose();
            try {
                int n8 = ExportUtils.loadPicture((BufferedImage)bufferedImage, (POIWorkbookAction)new XssfWorkbookWrapper((Workbook)this.wb));
                XSSFPicture xSSFPicture = this.patriarch.createPicture(xSSFClientAnchor, n8);
                if (d4 != 1.0) {
                    double d7 = (double)((int)(1.0 / d4 * 100.0)) / 100.0;
                }
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
    }

    private void setColumnRowBreak(CellElement cellElement, POISheetAction pOISheetAction, int n2, int n3, int n4, int n5) {
        this.exporter.setColumnRowBreak(cellElement, pOISheetAction, n2, n3, n4, n5);
    }

    private Cell createCell(Row row, int n2) {
        return row.createCell((int)((short)n2));
    }

    private void createComment(Cell cell, int n2, int n3, int n4) {
        String string;
        if (n3 == n4 && this.columnRowPostileMaps != null && this.columnRowPostileMaps[this.reportIndex] != null && (string = (String)this.columnRowPostileMaps[this.reportIndex].get(ColumnRow.valueOf(n4, n2))) != null) {
            int n5;
            int n6 = n2;
            long l2 = 0L;
            long l3 = 0L;
            for (n5 = n4; n5 < this.report.getColumnCount(); ++n5) {
                if ((l3 += this.report.getColumnWidth(n5).getLen()) <= 3048000L) continue;
                ++n5;
                break;
            }
            while (n6 < this.report.getRowCount()) {
                if ((l2 += this.report.getRowHeight(n6).getLen()) > 4572000L) {
                    ++n6;
                    break;
                }
                ++n6;
            }
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)n4), n2, (int)((short)n5), n6);
            try {
                Comment comment = this.patr.createCellComment((ClientAnchor)xSSFClientAnchor);
                comment.setString((RichTextString)new XSSFRichTextString(string));
                comment.setAuthor("FineReport");
                cell.setCellComment(comment);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Row createRow(int n2) {
        int n3 = Math.max(0, n2);
        Row row = this.xssfSheet.getRow(n3);
        if (row != null) {
            return row;
        }
        row = this.xssfSheet.createRow(n3);
        if (this.rowHeightList.get(n3).toFU() <= 0L) {
            row.setZeroHeight(this.eea.isExportHidedRow());
        } else {
            float f2 = this.rowHeightList.get(n3).toPTValue4Scale2() * CustomConfigManager.getInstance().getExcelAdjustHeight();
            f2 = Math.min(f2, 32767.0f);
            row.setHeight((short)f2);
        }
        return row;
    }

    private void exportFloatElement() {
        Iterator iterator = this.report.floatIterator();
        while (iterator.hasNext()) {
            BufferedImage bufferedImage;
            FloatElement floatElement = (FloatElement)iterator.next();
            Object object = floatElement.getValue();
            POIPictureLocation pOIPictureLocation = this.exporter.getFloatElementLocation(floatElement, this.rowHeightList, this.columnWidthList, this.report, object);
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(pOIPictureLocation.getFirst_cell_x(), pOIPictureLocation.getFirst_cell_y(), pOIPictureLocation.getSecond_cell_x(), pOIPictureLocation.getSecond_cell_y(), (int)pOIPictureLocation.getFirst_cell_col(), pOIPictureLocation.getFirst_cell_row(), (int)pOIPictureLocation.getSecond_cell_col(), pOIPictureLocation.getSecond_cell_row());
            Style style = floatElement.getStyle();
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            int n2 = floatElement.getWidth().toPixI(96);
            int n3 = floatElement.getHeight().toPixI(96);
            if (object instanceof Formula) {
                object = ((Formula)object).getResult();
            }
            if (object instanceof Image) {
                bufferedImage = GraphHelper.createBufferedImageFromImageWithLayout((Image)object, n2, n3, style);
                this.dealWithBufferImage(object, (ClientAnchor)xSSFClientAnchor, bufferedImage);
                continue;
            }
            if (object instanceof BaseChartPainter) {
                bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 6);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                Style.paintBackground(graphics2D, style, n2, n3);
                ((BaseChartPainter)object).paint(graphics2D, n2, n3, 96, style);
                Style.paintBorder(graphics2D, style, n2, n3);
                graphics2D.dispose();
                this.dealWithBufferImage(object, (ClientAnchor)xSSFClientAnchor, bufferedImage);
                continue;
            }
            this.dealWithTextBox(object, xSSFClientAnchor, style);
        }
    }

    private STTextAnchoringType.Enum changeVertAlignment(Style style) {
        int n2 = style.getVerticalAlignment();
        if (n2 == 3) {
            return STTextAnchoringType.B;
        }
        if (n2 == 1) {
            return STTextAnchoringType.T;
        }
        return STTextAnchoringType.CTR;
    }

    private void dealWithTextBox(Object object, XSSFClientAnchor xSSFClientAnchor, Style style) {
        String string = Utils.objectToString(object);
        XSSFTextBox xSSFTextBox = this.patriarch.createTextbox(xSSFClientAnchor);
        Color color = Color.white;
        Background background = style.getBackground();
        if (background != null && background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        xSSFTextBox.getCTShape().getTxBody().getBodyPr().setAnchor(this.changeVertAlignment(style));
        if (color != null) {
            xSSFTextBox.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        Color color2 = style.getBorderLeftColor();
        xSSFTextBox.setLineStyleColor(color2.getRed(), color2.getGreen(), color2.getBlue());
        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(string);
        XSSFFont xSSFFont = this.createFont(style.getFRFont());
        if (style.getFRFont().getForeground() == Color.BLACK) {
            xSSFFont.setColor(new XSSFColor(new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue() + 1)));
        }
        xSSFRichTextString.applyFont((Font)xSSFFont);
        xSSFTextBox.setText(xSSFRichTextString);
    }

    private XSSFFont createFont(java.awt.Font font) {
        return this.exporter.createFont(this.wb, font);
    }

    private void dealWithBufferImage(Object object, ClientAnchor clientAnchor, BufferedImage bufferedImage) {
        ExportUtils.dealWithBufferImage((Object)object, (POIClientAnchorAction)new XssfClientAnchorWrapper(clientAnchor), (POIPatriarchAction)new XssfPatriarchWrapper((Drawing)this.patriarch), (BufferedImage)bufferedImage, (POIWorkbookAction)new XssfWorkbookWrapper((Workbook)this.wb));
    }

    private void setAttr4ECReportSIL() {
        this.cal.setAttribute(ExTool.TAG, (Object)this.ex_tool);
        this.ex_tool.setRowHiddenList(this.hiddenRowList);
        this.ex_tool.setColHiddenList(this.hiddenColList);
        this.ex_tool.setReport((Report)((Object)this.report));
        this.ex_tool.setHhMap(null);
    }

    private void setColumnWidth() {
        int n2 = this.report.getColumnCount();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (this.columnWidthList.get(i2).toFU() <= 0L) {
                this.xssfSheet.setColumnHidden((int)((short)i2), this.eea.isExportHidedColumn());
                continue;
            }
            int n3 = (int)(this.columnWidthList.get(i2).toPixD(96) * CustomConfigManager.getInstance().getExcelAdjustWidth());
            n3 = Math.min(n3, 65280);
            this.xssfSheet.setColumnWidth((int)((short)i2), n3);
        }
    }

    private void setFreeze() {
        if (this.report.getReportPageAttr() != null && this.report.getReportPageAttr().getFreezeColumnRow() != null) {
            int n2;
            ColumnRow columnRow = this.report.getReportPageAttr().getFreezeColumnRow();
            int n3 = columnRow.getColumn();
            int n4 = columnRow.getRow();
            for (n2 = 0; n2 < columnRow.getColumn(); ++n2) {
                if (!this.hiddenColList.contains(n2)) continue;
                --n3;
            }
            for (n2 = 0; n2 < columnRow.getRow(); ++n2) {
                if (!this.hiddenRowList.contains(n2)) continue;
                --n4;
            }
            this.xssfSheet.createFreezePane(n3, n4);
        }
    }

    private void initHiddenSet() {
        int n2;
        if (!this.eea.isExportHidedRow()) {
            for (n2 = this.rowHeightList.size() - 1; n2 >= 0; --n2) {
                if (!this.rowHeightList.get(n2).equal_zero()) continue;
                this.hiddenRowList.add(n2);
                this.rowHeightList.remove(n2);
            }
        }
        if (!this.eea.isExportHidedColumn()) {
            for (n2 = this.columnWidthList.size() - 1; n2 >= 0; --n2) {
                if (!this.columnWidthList.get(n2).equal_zero()) continue;
                this.hiddenColList.add(n2);
                this.columnWidthList.remove(n2);
            }
        }
    }
}

