/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRCoreContext;
import com.fr.base.Margin;
import com.fr.base.background.ColorBackground;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageProvider;
import com.fr.report.core.ReportUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.UNIT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaPrintableArea;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class SWFExporter
extends AbstractAppExporter {
    private static final int PPAPI_DEFAULT_MARGIN = 1440000;
    private static final int DEFAULT_IMAGE_EXPORT_RESOLUTION = 144;
    private boolean isPrintAsImage;
    private boolean isPPAPIPrint;

    public SWFExporter() {
        this(false, false);
    }

    public SWFExporter(boolean bl, boolean bl2) {
        this.isPrintAsImage = bl;
        this.isPPAPIPrint = bl2;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        this.export(outputStream, pageSetProvider);
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        ReportPageProvider reportPageProvider;
        if (outputStream == null || pageSetProvider == null) {
            return;
        }
        int n2 = 0;
        float f2 = 0.0f;
        int n3 = this.isPrintAsImage ? 144 : 96;
        ArrayList<ReportPageProvider> arrayList = new ArrayList<ReportPageProvider>();
        FRCoreContext.TMAP.set(Boolean.TRUE);
        boolean bl = false;
        for (int i2 = 0; i2 < pageSetProvider.size() && (reportPageProvider = pageSetProvider.getPage(i2)) != null; ++i2) {
            n2 = Math.max(n2, reportPageProvider.getPaperWidth().toPixI(n3));
            f2 += reportPageProvider.getPaperHeight().toPixF(n3);
            PaperSettingProvider paperSettingProvider = this.getPaperSetting(reportPageProvider);
            bl = paperSettingProvider != null && paperSettingProvider.getOrientation() == 1;
            arrayList.add(reportPageProvider);
        }
        this.exportSwf(n3, outputStream, n2, f2, bl, arrayList);
    }

    private PaperSettingProvider getPaperSetting(ReportPageProvider reportPageProvider) {
        PaperSettingProvider paperSettingProvider = reportPageProvider.getPaperSetting();
        if (!this.isPPAPIPrint) {
            return paperSettingProvider;
        }
        Margin margin = paperSettingProvider.getMargin();
        FU fU = FU.getInstance(1440000L);
        UNIT uNIT = margin.getLeft();
        if (uNIT.subtract(fU).more_than_zero()) {
            margin.setLeft(uNIT.subtract(fU));
        } else {
            margin.setLeft(UNIT.ZERO);
        }
        UNIT uNIT2 = margin.getTop();
        if (uNIT2.subtract(fU).more_than_zero()) {
            margin.setTop(uNIT2.subtract(fU));
        } else {
            margin.setTop(UNIT.ZERO);
        }
        return paperSettingProvider;
    }

    private void exportSwf(int n2, OutputStream outputStream, int n3, float f2, boolean bl, List list) {
        double d2 = 72.0 / (double)n2;
        SWFGraphics2D sWFGraphics2D = new SWFGraphics2D(outputStream, new Dimension(n3, (int)f2));
        sWFGraphics2D.startExport();
        ColorBackground.getInstance(Color.white).paint(sWFGraphics2D, new Rectangle2D.Double(0.0, 0.0, n3, f2));
        sWFGraphics2D.scale(d2, d2);
        if (!this.isPPAPIPrint) {
            this.fixPrintArea(sWFGraphics2D);
        }
        if (bl) {
            sWFGraphics2D.rotate(Math.toRadians(90.0));
            sWFGraphics2D.translate(0.0, -f2);
        }
        if (this.isPrintAsImage) {
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n3, (int)f2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.drawPage(graphics2D, d2, n2, list);
            sWFGraphics2D.drawImage(bufferedImage, 0, 0, n3, (int)f2, null);
        } else {
            this.drawPage(sWFGraphics2D, d2, n2, list);
        }
        FRCoreContext.TMAP.set(null);
        sWFGraphics2D.endExport();
    }

    private void fixPrintArea(SWFGraphics2D sWFGraphics2D) {
        try {
            PrintService printService = PrinterJob.getPrinterJob().getPrintService();
            if (printService != null) {
                MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printService.getDefaultAttributeValue(MediaPrintableArea.class);
                int n2 = new INCH(mediaPrintableArea.getX(25400)).toPixI(96);
                int n3 = new INCH(mediaPrintableArea.getY(25400)).toPixI(96);
                sWFGraphics2D.translate(-n2, -n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawPage(Graphics2D graphics2D, double d2, int n2, List list) {
        float f2 = 0.0f;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ReportPageProvider reportPageProvider = (ReportPageProvider)list.get(i2);
            graphics2D.translate(0, (int)f2);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = StableFactory.getMarkedInstanceObjectFromClass("PagePainter", new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(n2)), false}, hashMap, PagePainterProvider.class);
            pagePainterProvider.convert();
            graphics2D.translate(0, (int)(-f2));
            f2 += reportPageProvider.getPaperHeight().toPixF(n2);
        }
    }
}

