/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.sql;

import com.fr.general.FRLogger;
import com.fr.general.jsqlparser.JSQLParserException;
import com.fr.general.jsqlparser.parser.CCJSqlParserManager;
import com.fr.general.sql.converter.NoRecordConverter;
import com.fr.stable.StringUtils;
import java.io.StringReader;

public class SqlUtils {
    private static CCJSqlParserManager parserManager = new CCJSqlParserManager();
    private static final int MAX_LENGTH = 10000;

    private static String convertToNoRecord(String string) throws JSQLParserException {
        return NoRecordConverter.convert(string);
    }

    public static String tryConvertToNoRecord(String string) {
        if (SqlUtils.isTooLong(string) || SqlUtils.containsBrackets(string)) {
            return string;
        }
        String string2 = string;
        try {
            String string3 = SqlUtils.convertToNoRecord(string);
            if (SqlUtils.isValid(string3)) {
                string2 = string3;
            } else {
                string2 = string;
                FRLogger.getLogger().error("Convert To No Record Sql Error:\n        originalSql:" + string + "\n        convertedSql:" + string3);
            }
        }
        catch (JSQLParserException jSQLParserException) {
            // empty catch block
        }
        return string2;
    }

    private static boolean isTooLong(String string) {
        return string.length() > 10000;
    }

    private static boolean containsBrackets(String string) {
        return StringUtils.contains(string, "()");
    }

    private static boolean isValid(String string) {
        try {
            parserManager.parse(new StringReader(string));
        }
        catch (JSQLParserException jSQLParserException) {
            return false;
        }
        return true;
    }
}

