/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Expression;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.antlr.ANTLRException;

public class PageCalObj
implements XMLable {
    public static final String XML_TAG = "PCOBJ";
    public static final PageCalObj MARK = new PageCalObj(null);
    private String content;
    private Expression exp = null;

    public PageCalObj(String string) {
        this.content = string;
    }

    public String getContent() {
        return this.content;
    }

    public Object resolve(CalculatorProvider calculatorProvider) throws UtilEvalError {
        if (this.content == null) {
            return null;
        }
        if (this.exp == null) {
            try {
                this.exp = calculatorProvider.parse(this.content);
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(Inter.getLocText("Error_Statement_Is") + "\"" + this.content + "\"", aNTLRException);
            }
        }
        return calculatorProvider.evalValue(this.exp);
    }

    public String toString() {
        return "";
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.content = xMLableReader.getAttrAsString("ct", null);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotBlank(this.content)) {
            xMLPrintWriter.attr("ct", this.content);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof PageCalObj && ComparatorUtils.equals(this.content, ((PageCalObj)object).content);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

