/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.EnvProvider;
import com.fr.general.GeneralContext;
import com.fr.general.LocalePackage;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.LocaleProvider;
import com.fr.stable.fun.LocaleFinder;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inter
implements LocaleProvider {
    private static Map<Locale, LocalePackage> predefinedPackageMap = new HashMap<Locale, LocalePackage>();
    private static Map<Locale, ResourceBundle> customMap = new HashMap<Locale, ResourceBundle>();
    private static Map<Locale, String> supportLocaleMap = new LinkedHashMap<Locale, String>();

    public static Map<Locale, String> getSupportLocaleMap() {
        return Collections.unmodifiableMap(supportLocaleMap);
    }

    public static Map<Locale, LocalePackage> getPredefinedPackageMap() {
        return Collections.unmodifiableMap(predefinedPackageMap);
    }

    public static ResourceBundle getCustomResourceBundle(Locale locale) {
        ResourceBundle resourceBundle;
        if (!customMap.containsKey(locale)) {
            Inter.loadLanguageFromEnv(locale);
        }
        return (resourceBundle = customMap.get(locale)) == null ? customMap.get(Locale.US) : resourceBundle;
    }

    public static void loadLocaleFile(Locale locale, String string) {
        LocalePackage localePackage = predefinedPackageMap.get(locale);
        if (localePackage == null) {
            localePackage = new LocalePackage();
            predefinedPackageMap.put(locale, localePackage);
        }
        localePackage.addResourceBundle(locale, string);
    }

    private static void loadLocaleFileInProject() {
        Inter.loadLocaleFile(GeneralContext.getLocale(), "com/fr/general/locale/fr");
    }

    public static void loadLocaleFileInProject(Locale locale) {
        String[] stringArray;
        for (String string : stringArray = StableFactory.getLocaleFiles()) {
            Inter.loadLocaleFile(locale, string);
        }
    }

    private static void loadLanguageFromEnv() {
        Inter.loadLanguageFromEnv(GeneralContext.getLocale());
    }

    private static void loadLanguageFromEnv(Locale locale) {
        if (customMap.containsKey(locale)) {
            return;
        }
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider == null) {
            return;
        }
        try {
            InputStream inputStream = envProvider.readBean("fr_" + locale.toString() + ".properties", "locale");
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
            customMap.put(locale, propertyResourceBundle);
        }
        catch (Exception exception) {
            customMap.put(locale, null);
        }
    }

    public static void loadLanguageFromPlugin(LocaleFinder localeFinder) {
        Inter.loadLanguageFromPlugin(GeneralContext.getLocale(), localeFinder);
    }

    public static void loadLanguageFromPlugin(Locale locale, LocaleFinder localeFinder) {
        LocalePackage localePackage = predefinedPackageMap.get(locale);
        if (localePackage == null) {
            localePackage = new LocalePackage();
            predefinedPackageMap.put(locale, localePackage);
        }
        String string = localeFinder.find();
        localePackage.addResourceBundle(locale, string);
    }

    public static String getLocText(String string) {
        Locale locale = GeneralContext.getLocale();
        return Inter.getLocText(string, locale);
    }

    public static String getLocText(String string, String ... stringArray) {
        String string2 = Inter.getLocText(string);
        int n2 = stringArray.length;
        for (int i2 = 1; i2 < n2 + 1; ++i2) {
            String string3 = stringArray[i2 - 1];
            string2 = string2.replaceFirst("\\{R" + i2 + "\\}", string3);
        }
        return string2;
    }

    public static String getLocText(String[] stringArray) {
        return Inter.getLocText(stringArray, null);
    }

    public static String getLocText(String[] stringArray, String[] stringArray2) {
        String string = "";
        String string2 = ComparatorUtils.equals(Locale.US, GeneralContext.getLocale()) ? " " : "";
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + (i2 == 0 ? "" : string2) + Inter.getLocText(stringArray[i2]);
            if (stringArray2 == null || stringArray2.length <= i2) continue;
            string = string + string2 + stringArray2[i2];
        }
        return string;
    }

    public static String getLocText(String string, Locale locale) {
        return Inter.getLocText(string, locale, GeneralContext.getLocale());
    }

    public static String getLocText(String string, Locale locale, Locale locale2) {
        Object object;
        if (locale == null) {
            locale = locale2;
        }
        if (StringUtils.isEmpty(locale.getCountry())) {
            object = locale.getLanguage();
            locale = "zh".equals(object) ? Locale.SIMPLIFIED_CHINESE : ("ja".equals(object) ? Locale.JAPAN : Locale.US);
        }
        if (!customMap.containsKey(locale)) {
            Inter.loadLanguageFromEnv(locale);
        }
        if (!predefinedPackageMap.containsKey(locale)) {
            Inter.loadLocaleFileInProject(locale);
        }
        if ((object = customMap.get(locale)) != null && ((ResourceBundle)object).containsKey(string)) {
            return ((ResourceBundle)object).getString(string);
        }
        LocalePackage localePackage = predefinedPackageMap.get(locale);
        return localePackage.getLocText(string);
    }

    static {
        supportLocaleMap.put(Locale.SIMPLIFIED_CHINESE, "Simplified_Chinese_Language");
        supportLocaleMap.put(Locale.ENGLISH, "English_Language");
        supportLocaleMap.put(Locale.JAPAN, "Japanese_Language");
        supportLocaleMap.put(Locale.TRADITIONAL_CHINESE, "Traditional_Chinese_Language");
        supportLocaleMap.put(Locale.KOREA, "Korea_Language");
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                customMap.clear();
            }
        });
        Inter.loadLocaleFileInProject();
        Inter.loadLanguageFromEnv();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                Inter.loadLanguageFromEnv();
            }
        });
    }
}

