/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.VT4FR;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.LicUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FUNC {
    public static final int BASIC = 0;
    public static final int DEV = 1;
    public static final int STAND = 2;
    public static final int PROFESS = 3;
    public static final int ENTER = 4;
    public static final int GROUP = 5;
    public static final int MAX_FUN_NUMBER = 81;
    public static final String[] VERSION = new String[]{"706561", "706605", "17484909", "34864023661", "265735294061", "4355081031277"};
    private static List<FUNC> FUNC_LIST = new ArrayList<FUNC>();
    private static BigInteger functions = BigInteger.ONE.shiftLeft(81).subtract(BigInteger.ONE);

    public FUNC() {
        if (this.marker() < 81) {
            FUNC_LIST.add(this);
        }
    }

    public String getLocaleKey() {
        return "";
    }

    public String toString() {
        return Inter.getLocText(this.getLocaleKey());
    }

    public static Iterator<FUNC> getAllFunctionIterator() {
        return FUNC_LIST.iterator();
    }

    public static String getEditionByFunc() {
        int n2 = -1;
        int n3 = VERSION.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            BigInteger bigInteger = new BigInteger(VERSION[i2]);
            if (bigInteger.subtract(functions) != BigInteger.ZERO) continue;
            n2 = i2;
            break;
        }
        switch (n2) {
            case 0: {
                return "Registration-Basic_Edition";
            }
            case 1: {
                return "Registration-Develop_Edition";
            }
            case 2: {
                return "Registration-Standard_Edition";
            }
            case 3: {
                return "Registration-Professional_Edition";
            }
            case 4: {
                return "Registration-Enterprise_Edition";
            }
        }
        return "Registration-Customize_Edition";
    }

    public static void refreshFuntions() {
        FUNC.initFunction();
        byte[] byArray = StableUtils.getBytes();
        try {
            if (byArray == null) {
                return;
            }
            String string = LicUtils.getLicAsStr();
            if (FUNC.invalidLic(string)) {
                FUNC.resetFunctions();
                return;
            }
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("FUNCTION") && StableUtils.isMatchOnline()) {
                functions = new BigInteger(String.valueOf(jSONObject.get("FUNCTION")));
                if (!jSONObject.has("ISAFTER701")) {
                    functions = functions.add(BigInteger.ONE.shiftLeft(15));
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            FUNC.resetFunctions();
        }
        finally {
            VT4FR.fireLicChangeListener();
        }
    }

    private static boolean invalidLic(String string) {
        return StringUtils.contains(LicUtils.getSoftLockContent(), CodeUtils.passwordEncode(string)) || ComparatorUtils.equals(functions, BigInteger.ONE.shiftLeft(1));
    }

    private static void initFunction() {
        functions = BigInteger.ONE.shiftLeft(81).subtract(BigInteger.ONE);
    }

    public static void resetFunctions() {
        functions = BigInteger.ONE.shiftLeft(1);
        VT4FR.fireLicChangeListener();
    }

    public boolean support() {
        return functions.and(this.getNum()).compareTo(BigInteger.ZERO) == 1;
    }

    private BigInteger getNum() {
        return BigInteger.ONE.shiftLeft(this.marker());
    }

    public abstract int marker();

    public boolean groupSupported() {
        return true;
    }

    public boolean enterpriseSupported() {
        return true;
    }

    public boolean professionalSupported() {
        return true;
    }

    public boolean standardSupported() {
        return true;
    }

    public boolean developmentSupported() {
        return true;
    }

    public boolean basicSupported() {
        return true;
    }

    static {
        FUNC.refreshFuntions();
    }
}

