/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.form.ui.TextEditor;
import com.fr.json.JSONException;
import com.fr.json.JSONFunction;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class Password
extends TextEditor {
    public static final String MD5 = "md5";
    public static final String ENCRYPT_ARG = "passwd";
    private String encryption = null;

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("passwordText", true);
        if (StringUtils.isNotBlank(this.getEncryption())) {
            jSONObject.put("encryption", new JSONFunction(new String[]{ENCRYPT_ARG}, this.createEncryptionFunction(repository), repository.getDevice()));
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof Password && super.equals(object);
    }

    private String createEncryptionFunction(Repository repository) {
        if (this.getEncryption() == null) {
            return "return passwd;";
        }
        String string = this.getEncryption();
        if (MD5.equalsIgnoreCase(this.getEncryption())) {
            string = "FR.$defaultImport('/com/fr/web/core/js/jquery.md5.js', 'js');";
            string = string + "return $.md5(passwd);";
        }
        string = TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), string, ParameterMapNameSpace.create(repository.getReportParameterMap()));
        return string;
    }

    public void setEncryption(String string) {
        this.encryption = string;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "encryption".equals(string = xMLableReader.getTagName())) {
            this.encryption = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.encryption)) {
            xMLPrintWriter.startTAG("encryption").textNode(this.encryption).end();
        }
    }

    public String getXType() {
        return "password";
    }
}

