/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.file.XMLFileManager;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Map;

public class LoginboardManager
extends XMLFileManager {
    private static LoginboardManager loginboardManager = null;
    private static final String DEFAULT_TOP_LOGO_PATH = "${remoteServletURL}?op=resource&resource=/com/fr/base/images/oem/toplogo.png";
    private static final String DEFAULT_BOTTOM_LOGO_PATH = "${remoteServletURL}?op=resource&resource=/com/fr/base/images/oem/bottomlogo.png";
    private static final String DEFAULT_COPY_RIGHT = "2012  FineReport";
    private String topLogoPath;
    private String bottomLogoPath;
    private String copyRight;
    private Map loginboardMap;

    public static synchronized LoginboardManager getInstance() {
        if (loginboardManager == null) {
            loginboardManager = new LoginboardManager();
            loginboardManager.readXMLFile();
        }
        return loginboardManager;
    }

    private static synchronized void envChanged() {
        loginboardManager = null;
    }

    private LoginboardManager() {
    }

    public Map getLoginboardMap() {
        this.loginboardMap = new HashMap();
        this.loginboardMap.put("topLogoPath", LoginboardManager.getInstance().getTopLogoPath());
        this.loginboardMap.put("bottomLogoPath", LoginboardManager.getInstance().getBottomLogoPath());
        this.loginboardMap.put("copyRight", LoginboardManager.getInstance().getCopyRight());
        return this.loginboardMap;
    }

    public String fileName() {
        return "loginboard.xml";
    }

    public String getDefaultTopLogoPath() {
        return DEFAULT_TOP_LOGO_PATH;
    }

    public String getDefaultBottomLogoPath() {
        return DEFAULT_BOTTOM_LOGO_PATH;
    }

    public String getDefaultCopyRight() {
        return DEFAULT_COPY_RIGHT;
    }

    public String getTopLogoPath() {
        return this.topLogoPath;
    }

    public void setTopLogoPath(String string) {
        this.topLogoPath = string;
    }

    public String getBottomLogoPath() {
        return this.bottomLogoPath;
    }

    public void setBottomLogoPath(String string) {
        this.bottomLogoPath = string;
    }

    public String getCopyRight() {
        return this.copyRight;
    }

    public void setCopyRight(String string) {
        this.copyRight = string;
    }

    public void resetLoginboard() {
        this.topLogoPath = DEFAULT_TOP_LOGO_PATH;
        this.bottomLogoPath = DEFAULT_BOTTOM_LOGO_PATH;
        this.copyRight = DEFAULT_COPY_RIGHT;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Attributes".equals(string = xMLableReader.getTagName())) {
            this.setTopLogoPath(xMLableReader.getAttrAsString("topLogoPath", DEFAULT_TOP_LOGO_PATH));
            this.setBottomLogoPath(xMLableReader.getAttrAsString("bottomLogoPath", DEFAULT_BOTTOM_LOGO_PATH));
            this.setCopyRight(xMLableReader.getAttrAsString("copyRight", DEFAULT_COPY_RIGHT));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("LoginboardManager");
        xMLPrintWriter.startTAG("Attributes");
        if (this.getTopLogoPath() != null) {
            xMLPrintWriter.attr("topLogoPath", this.getTopLogoPath());
        }
        if (this.getBottomLogoPath() != null) {
            xMLPrintWriter.attr("bottomLogoPath", this.getBottomLogoPath());
        }
        if (this.getCopyRight() != null) {
            xMLPrintWriter.attr("copyRight", this.getCopyRight());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                LoginboardManager.envChanged();
            }
        });
    }
}

