/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.Parameter;
import com.fr.cluster.rpc.ParameterFactory;
import com.fr.cluster.rpc.SocketClient;
import com.fr.cluster.rpc.SocketServer;
import com.fr.cluster.rpc.exception.ParamSerializableException;
import com.fr.general.FRLogger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class RPCClient
implements Serializable {
    private String masterIP = null;
    private int port = -1;
    private String className;

    public RPCClient(String string, String string2, int n2) {
        this.setMasterIP(string2);
        this.setPort(n2);
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMasterIP() {
        if (this.masterIP == null) {
            this.masterIP = "127.0.0.1";
        }
        return this.masterIP;
    }

    public void setMasterIP(String string) {
        this.masterIP = string;
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = SocketServer.DEFAULT_PORT;
        }
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public SocketClient perceive(Method method, Object[] objectArray) throws ParamSerializableException {
        SocketClient socketClient = new SocketClient(this.className, method.getName(), this.getMasterIP(), this.getPort());
        Parameter[] parameterArray = null;
        Type[] typeArray = method.getParameterTypes();
        if (objectArray != null) {
            parameterArray = this.preprocess(typeArray, objectArray);
        }
        this.invoke(socketClient, parameterArray);
        return socketClient;
    }

    private Parameter[] preprocess(Type[] typeArray, Object[] objectArray) throws ParamSerializableException {
        Parameter[] parameterArray = new Parameter[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            parameterArray[i2] = ParameterFactory.generateParameter(typeArray[i2], objectArray[i2]);
        }
        return parameterArray;
    }

    public SocketClient perceive(Method method) throws ParamSerializableException {
        return this.perceive(method, null);
    }

    private void invoke(SocketClient socketClient, Serializable[] serializableArray) {
        if (serializableArray != null) {
            for (int i2 = 0; i2 < serializableArray.length; ++i2) {
                socketClient.addParam(serializableArray[i2]);
            }
        }
        this.send(socketClient);
    }

    private void send(SocketClient socketClient) {
        try {
            socketClient.writeObject();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public Object readResult(SocketClient socketClient) {
        return socketClient.getReturnObject();
    }
}

