/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RadarAxisGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.core.IteratorChain;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class RadarPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 2762582684044348340L;
    private static final double MARKER_SIZE = 5.0;
    private static final double PREHEI = 20.0;
    private RadarAxisGlyph radarAxisGlyph;
    private boolean isFilled = false;
    private Color intervalColor = null;

    public Iterator selectableChildren() {
        ArrayList<RadarAxisGlyph> arrayList = new ArrayList<RadarAxisGlyph>();
        if (this.radarAxisGlyph != null) {
            arrayList.add(this.radarAxisGlyph);
        }
        return new IteratorChain(new Iterator[]{arrayList.iterator(), super.selectableChildren()});
    }

    public void draw(Graphics graphics, int n2) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.radarAxisGlyph != null) {
            this.radarAxisGlyph.draw(graphics2D, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n2);
    }

    public void drawInfo(Graphics graphics) {
        this.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.radarAxisGlyph != null) {
            this.radarAxisGlyph.drawAxisGrid(graphics2D);
            if (this.intervalColor != null) {
                this.radarAxisGlyph.paintRadarBackground(graphics2D, this.intervalColor);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void setRadarAxisGlyph(RadarAxisGlyph radarAxisGlyph) {
        this.radarAxisGlyph = radarAxisGlyph;
    }

    public RadarAxisGlyph getRadarAxisGlyph() {
        return this.radarAxisGlyph;
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setIntervalColor(Color color) {
        this.intervalColor = color;
    }

    public String getPlotGlyphType() {
        return "RadarPlotGlyph";
    }

    public void layoutAxisGlyph(int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = 20.0;
        this.radarAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D, n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
        this.radarAxisGlyph.init(double_);
        this.radarAxisGlyph.calculateAxisLengthUnit();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d2 / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
        this.setBounds(double_2);
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            GeneralPath generalPath = new GeneralPath();
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                double d2 = dataPoint.getValue();
                Point2D point2D = this.getRadarAxisGlyph().getPointInBounds(i3, d2);
                if (dataPoint.isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    point2D = this.getRadarAxisGlyph().getOrigin();
                }
                this.recalLabelPath(generalPath, point2D, dataPoint, i3, n2);
            }
            generalPath.closePath();
            this.dealFolderLine(generalPath, dataSeries);
        }
        this.dealLabelBoundsInOrder();
    }

    private void recalLabelPath(GeneralPath generalPath, Point2D point2D, DataPoint dataPoint, int n2, int n3) {
        if (n2 == 0) {
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        } else {
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        MarkerGlyph markerGlyph = new MarkerGlyph();
        dataPoint.setDrawImpl(markerGlyph);
        markerGlyph.setShape(new Rectangle2D.Double(point2D.getX() - 5.0, point2D.getY() - 5.0, 10.0, 10.0));
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.getMarker().setPlotBackground(this.getBackground() != null ? this.getBackground() : this.getWholeChartBackground());
        this.dealDataPointLabel(dataPoint, n3);
    }

    private void dealFolderLine(GeneralPath generalPath, DataSeries dataSeries) {
        FoldLine foldLine = new FoldLine(generalPath);
        dataSeries.setDrawImpl(foldLine);
        LineStyleInfo lineStyleInfo = foldLine.getLineStyleInfo();
        this.getConditionCollection().changeStyleConditionWithInfo(lineStyleInfo, dataSeries, this.createColors4Series());
        if (this.isFilled()) {
            ShapeGlyph shapeGlyph = new ShapeGlyph(generalPath);
            ColorBackground colorBackground = ColorBackground.getInstance(lineStyleInfo.getAttrLineColor().getSeriesColor());
            shapeGlyph.setBackground(colorBackground);
            shapeGlyph.setAlpha(lineStyleInfo.getSeriesAttrAlpha().getAlpha());
            dataSeries.setDrawImpl(shapeGlyph);
        }
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n2);
    }

    public Object clone() throws CloneNotSupportedException {
        RadarPlotGlyph radarPlotGlyph = (RadarPlotGlyph)super.clone();
        if (this.radarAxisGlyph != null) {
            radarPlotGlyph.radarAxisGlyph = (RadarAxisGlyph)this.radarAxisGlyph.clone();
        }
        return radarPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.radarAxisGlyph != null) {
            jSONObject.put("radarAxisGlyph", this.radarAxisGlyph.toJSONObject(repository));
        }
        jSONObject.put("isFilled", this.isFilled);
        if (this.intervalColor != null) {
            jSONObject.put("intervalColor", StableUtils.javaColorToCSSColor(this.intervalColor));
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof RadarPlotGlyph && super.equals(object) && ComparatorUtils.equals(((RadarPlotGlyph)object).radarAxisGlyph, this.radarAxisGlyph) && ComparatorUtils.equals(((RadarPlotGlyph)object).intervalColor, this.intervalColor) && ((RadarPlotGlyph)object).isFilled == this.isFilled;
    }

    public String getChartType() {
        return "Radar";
    }
}

