/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CoreConstants;
import com.fr.stable.web.Repository;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;

public class LegendGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = 8315404889874481890L;
    protected static final int PADDING_GAP = 4;
    protected static final int ROW_COL_GAP = 5;
    public static final double MAX_LEFT_WIDTH = 0.28;
    private static final String TWO_FONT_AND_MORE = Inter.getLocText("Chart-Chart_Name") + "...";
    protected static final double START_WIDTH = 3.0;
    protected static final double START_HEIGHT = 3.0;
    private LegendItem[] items;
    protected FRFont font;
    private int position = 4;
    private transient double maxLabelWidth = 0.0;
    private transient boolean drawInCutOrNot = false;

    public LegendGlyph() {
    }

    public LegendGlyph(LegendItem[] legendItemArray) {
        this.setItems(legendItemArray);
    }

    public void setItems(LegendItem[] legendItemArray) {
        this.items = legendItemArray;
    }

    public LegendItem[] getItems() {
        return this.items;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public FRFont getFont() {
        return this.font;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void draw(Graphics graphics, int n2) {
        if (this.visible) {
            super.draw(graphics, n2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(this.getBounds());
            graphics2D.translate(this.bounds.getX(), this.bounds.getY());
            if (this.getItems() != null) {
                for (int i2 = 0; i2 < this.getItems().length; ++i2) {
                    this.getItems()[i2].draw(graphics2D, this.font, n2);
                }
            }
            graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
            graphics2D.setClip(shape == null ? null : shape.getBounds2D().createIntersection(this.getBounds()));
        }
    }

    public void layoutLegendAndRefreshChartBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2, double d3, int n2) {
        Rectangle2D rectangle2D3 = this.layoutLegendBounds(rectangle2D, rectangle2D2, n2);
        this.refreshItemBoundsWithLegendBounds(rectangle2D3, n2);
        this.refreshChartBoundsWithLegendBounds(rectangle2D2, rectangle2D3, d2, d3);
        this.setLegendBounds(rectangle2D3);
    }

    protected void setLegendBounds(Rectangle2D rectangle2D) {
        this.setBounds(ChartBaseUtils.rectangle2RoundRectangle(rectangle2D, this.isRoundBorder()));
    }

    private Rectangle2D layoutLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n2) {
        double d2 = this.getLegendX(rectangle2D, rectangle2D2, n2);
        double d3 = this.getLegendY(rectangle2D, rectangle2D2, n2);
        double d4 = this.getLegendWidth(rectangle2D2, n2);
        double d5 = this.getLegendHeight(rectangle2D2, n2);
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    public void changeLegendBounds(Rectangle2D rectangle2D, int n2) {
        this.refreshItemBoundsWithLegendBounds(rectangle2D, n2);
        this.bounds = ChartBaseUtils.rectangle2RoundRectangle(rectangle2D, this.isRoundBorder());
    }

    protected void refreshChartBoundsWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2, double d3) {
        double d4 = this.refreshChartBoundsXWithLegendBounds(rectangle2D, rectangle2D2, d2);
        double d5 = this.refreshChartBoundsYWithLegendBounds(rectangle2D, rectangle2D2, d3);
        double d6 = this.refreshChartBoundsWidthWithLegendBounds(rectangle2D, rectangle2D2, d2);
        double d7 = this.refreshChartBoundsHeightWithLegendBounds(rectangle2D, rectangle2D2, d3);
        rectangle2D.setFrame(d4, d5, d6, d7);
    }

    private double refreshChartBoundsXWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2) {
        if (this.getPosition() == 2) {
            return rectangle2D.getX() + rectangle2D2.getWidth() + d2;
        }
        return rectangle2D.getX();
    }

    private double refreshChartBoundsYWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2) {
        if (this.getPosition() == 1) {
            return rectangle2D.getY() + d2 + rectangle2D2.getHeight();
        }
        return rectangle2D.getY();
    }

    private double refreshChartBoundsWidthWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2) {
        if (this.getPosition() == 3 || this.getPosition() == 1) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getWidth() - d2 - rectangle2D2.getWidth();
    }

    private double refreshChartBoundsHeightWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2) {
        if (this.getPosition() == 1 || this.getPosition() == 3) {
            return rectangle2D.getHeight() - d2 - rectangle2D2.getHeight();
        }
        return rectangle2D.getHeight();
    }

    protected double getLegendX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n2) {
        if (this.getPosition() == 2) {
            return rectangle2D2.getX();
        }
        if (this.getPosition() == 4 || this.getPosition() == 8) {
            return rectangle2D2.getX() + rectangle2D2.getWidth() - this.getLegendWidth(rectangle2D2, n2);
        }
        return rectangle2D2.getX() + (rectangle2D2.getWidth() - this.getLegendWidth(rectangle2D2, n2)) / 2.0;
    }

    protected double getLegendY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n2) {
        if (this.getPosition() == 1) {
            return rectangle2D2.getY();
        }
        if (this.getPosition() == 3) {
            return rectangle2D2.getY() + rectangle2D2.getHeight() - this.getLegendHeight(rectangle2D2, n2);
        }
        if (this.getPosition() == 8) {
            return rectangle2D2.getY();
        }
        return rectangle2D2.getY() + (rectangle2D2.getHeight() - this.getLegendHeight(rectangle2D2, n2)) / 2.0;
    }

    protected double getLegendWidth(Rectangle2D rectangle2D, int n2) {
        return this.prefferedLegendSizeWithChartBounds(rectangle2D, n2).getWidth();
    }

    protected double getLegendHeight(Rectangle2D rectangle2D, int n2) {
        return this.prefferedLegendSizeWithChartBounds(rectangle2D, n2).getHeight();
    }

    public Dimension2D prefferedLegendSizeWithChartBounds(Rectangle2D rectangle2D, int n2) {
        if (ArrayUtils.isEmpty(this.getItems())) {
            return new Dimension();
        }
        if (this.isInTopAndBottom()) {
            return this.preLegendDim4TopAndBottom(rectangle2D, n2);
        }
        return this.preLegendDim4LeftAndRight(rectangle2D, n2);
    }

    protected boolean isNotEnough4ItemInTopAndBottom(double d2, Dimension2D dimension2D, Rectangle2D rectangle2D) {
        return d2 + dimension2D.getWidth() + 5.0 > rectangle2D.getWidth();
    }

    private boolean isNoEnough4ItemInLeftAndRight(double d2, Dimension2D dimension2D, Rectangle2D rectangle2D) {
        return d2 + dimension2D.getHeight() + 5.0 > rectangle2D.getHeight();
    }

    private void refreshItemBoundsWithLegendBounds(Rectangle2D rectangle2D, int n2) {
        if (ArrayUtils.isEmpty(this.getItems())) {
            return;
        }
        if (this.isInTopAndBottom()) {
            this.refreshItem4TopAndBottom(rectangle2D, n2);
        } else {
            this.refreshItem4LeftAndRight(rectangle2D, n2);
        }
    }

    protected void refreshItem4TopAndBottom(Rectangle2D rectangle2D, int n2) {
        double d2 = 3.0;
        double d3 = 3.0;
        double d4 = d2;
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.getItems().length; ++i2) {
            Dimension2D dimension2D = this.getItems()[i2].prefferedSize(this.font, n2);
            if (this.isNotEnough4ItemInTopAndBottom(d2, dimension2D, rectangle2D) || bl2) {
                DoubleDimension2D doubleDimension2D;
                if (d2 == d4) {
                    doubleDimension2D = new DoubleDimension2D(rectangle2D.getWidth() - 8.0, dimension2D.getHeight());
                    if (bl) {
                        this.refresItemBounds(i2, d2 - 4.0 + 5.0, 9.0 + ((Dimension2D)doubleDimension2D).getHeight(), doubleDimension2D);
                        break;
                    }
                    this.refresItemBounds(i2, d2 - 4.0 + 5.0, 4.0, doubleDimension2D);
                    d3 = 8.0 + dimension2D.getHeight();
                    bl = true;
                    continue;
                }
                if (bl) {
                    this.setItemBoundsNull(i2);
                    break;
                }
                bl = true;
                d2 = 3.0;
                d3 = 4.0 + dimension2D.getHeight() + 5.0;
                if (this.isNotEnough4ItemInTopAndBottom(d2, dimension2D, rectangle2D)) {
                    doubleDimension2D = new DoubleDimension2D(rectangle2D.getWidth() - 8.0, dimension2D.getHeight());
                    this.refresItemBounds(i2, d2 - 4.0 + 5.0, d3, doubleDimension2D);
                    break;
                }
                this.refresItemBounds(i2, d2 - 4.0 + 5.0, d3, dimension2D);
                d2 += dimension2D.getWidth() + 5.0;
                continue;
            }
            this.refresItemBounds(i2, d2 - 4.0 + 5.0, d3 - 4.0 + 5.0, dimension2D);
            d2 += dimension2D.getWidth() + 5.0;
        }
    }

    protected Dimension2D preLegendDim4TopAndBottom(Rectangle2D rectangle2D, int n2) {
        this.initMaxLegendWidth4DrawisCut(rectangle2D, n2);
        double d2 = 3.0;
        double d3 = 3.0;
        double d4 = d2;
        double d5 = 0.0;
        boolean bl = false;
        double d6 = 0.0;
        for (int i2 = 0; i2 < this.getItems().length; ++i2) {
            Dimension2D dimension2D = this.getItems()[i2].prefferedSize(this.font, n2);
            if (this.isNotEnough4ItemInTopAndBottom(d2, dimension2D, rectangle2D)) {
                if (bl) break;
                if (d2 == d4) {
                    d2 = rectangle2D.getWidth();
                    d3 = 13.0 + dimension2D.getHeight() * 2.0;
                    break;
                }
                bl = true;
                d6 = d2;
                d2 = d4;
                if (this.isNotEnough4ItemInTopAndBottom(d2, dimension2D, rectangle2D)) {
                    d2 = rectangle2D.getWidth();
                    d3 = 13.0 + dimension2D.getHeight() * 2.0;
                    break;
                }
                d2 += dimension2D.getWidth() + 5.0;
                d3 = 13.0 + dimension2D.getHeight() * 2.0;
                continue;
            }
            d5 = Math.max(d5, dimension2D.getHeight());
            d3 = bl ? 13.0 + d5 * 2.0 : 8.0 + d5;
            d2 += dimension2D.getWidth() + 5.0;
        }
        return new DoubleDimension2D(Math.max(d6, d2), d3);
    }

    private Dimension2D preLegendDim4LeftAndRight(Rectangle2D rectangle2D, int n2) {
        Dimension2D dimension2D;
        this.initMaxLegendWidth4DrawisCut(rectangle2D, n2);
        double d2 = 3.0;
        double d3 = 3.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < this.getItems().length && !this.isNoEnough4ItemInLeftAndRight(d3, dimension2D = this.getItems()[i2].prefferedSize(this.font, n2), rectangle2D); ++i2) {
            d4 = Math.max(d4, dimension2D.getWidth());
            d2 = 8.0 + d4;
            d3 += dimension2D.getHeight() + 5.0;
        }
        return new DoubleDimension2D(Math.min(this.maxLabelWidth, d2), d3);
    }

    protected void initMaxLegendWidth4DrawisCut(Rectangle2D rectangle2D, int n2) {
        if (rectangle2D == null) {
            return;
        }
        this.maxLabelWidth = this.isInTopAndBottom() ? rectangle2D.getWidth() : rectangle2D.getWidth() * this.getLegendWithProportion();
        Font font = this.font == null ? FRFont.getInstance().applyResolutionNP(n2) : this.font.applyResolutionNP(n2);
        double d2 = GraphHelper.stringWidth(TWO_FONT_AND_MORE, font, CoreConstants.DEFAULT_FRC);
        this.drawInCutOrNot = d2 > this.maxLabelWidth - 8.0 - (double)(font.getSize() / 2) - 5.0;
    }

    protected double getLegendWithProportion() {
        return 0.28;
    }

    private void refreshItem4LeftAndRight(Rectangle2D rectangle2D, int n2) {
        Dimension2D dimension2D;
        double d2 = 3.0;
        double d3 = 3.0;
        double d4 = rectangle2D.getWidth() - 8.0;
        for (int i2 = 0; i2 < this.getItems().length && !this.isNoEnough4ItemInLeftAndRight(d3, dimension2D = this.getItems()[i2].prefferedSize(this.font, n2), rectangle2D); ++i2) {
            if (dimension2D.getWidth() <= d4) {
                this.refresItemBounds(i2, d2 - 4.0 + 5.0, d3 - 4.0 + 5.0, dimension2D);
            } else {
                DoubleDimension2D doubleDimension2D = new DoubleDimension2D(d4, dimension2D.getHeight());
                this.refresItemBounds(i2, d2 - 4.0 + 5.0, d3 - 4.0 + 5.0, doubleDimension2D);
            }
            d3 += dimension2D.getHeight() + 5.0;
        }
    }

    protected void refresItemBounds(int n2, double d2, double d3, Dimension2D dimension2D) {
        if (this.getItems()[n2] == null) {
            return;
        }
        this.getItems()[n2].setBounds(new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight()));
        this.getItems()[n2].setDrawInCut(this.drawInCutOrNot);
    }

    protected void setItemBoundsNull(int n2) {
        if (this.getItems()[n2] == null) {
            return;
        }
        this.getItems()[n2].setBounds(null);
    }

    private boolean isInTopAndBottom() {
        return this.getPosition() == 1 || this.getPosition() == 3;
    }

    public boolean equals(Object object) {
        return object instanceof LegendGlyph && super.equals(object) && ((LegendGlyph)object).position == this.position && ComparatorUtils.equals(((LegendGlyph)object).font, this.font) && ComparatorUtils.equals(((LegendGlyph)object).items, this.items);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        boolean bl;
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("position", this.position);
        if (this.font != null) {
            jSONObject.put("font", this.font.toJSONObject());
        }
        boolean bl2 = bl = repository != null && repository.getDevice().isMobile();
        if (this.items != null && this.items.length > 0) {
            JSONArray jSONArray = JSONArray.create();
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                LegendItem legendItem = this.items[i2];
                if (bl && (!bl || legendItem.isCompositeItem())) continue;
                jSONArray.put(legendItem.toJSONObject(repository));
            }
            jSONObject.put("items", jSONArray);
        }
        return jSONObject;
    }
}

