/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEnumDefinitions;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.HeatMapControlBar;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.stable.StringUtils;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ChartGlyphLayout {
    private static final double DEFAULT_WIDTH = 507.0;
    private static final double DEFAULT_HEIGHT = 340.0;
    private static final double DEFAULT_GAP = 8.0;
    private static final double MIN_GAP = 4.0;
    private static final double MAX_GAP = 16.0;
    private static final double INCRE_ONE_PIX = 100.0;
    private static double WIDTH_GAP = 8.0;
    private static double HEIGHT_GAP = 8.0;
    private static double CHART_CHANGE_HEIGHT = 20.0;
    public static double ARROW_WIDTH = 10.0;
    public static double ARROW_HEIGHT = 5.0;
    private static int TEST_GAP = 30;
    private static int COMBINE_GAP = 22;
    private static int FONT_HEIGHT = 12;
    private static int SHORT_WIDTH_GAP = 5;
    private static int SHORT_HEIGHT_GAP = 10;

    public static void doLayout(ChartGlyph chartGlyph, int n2) {
        if (chartGlyph == null || chartGlyph.getBounds() == null) {
            return;
        }
        Rectangle2D rectangle2D = chartGlyph.getBounds();
        Rectangle2D rectangle2D2 = chartGlyph.getBounds();
        ChartGlyphLayout.preMoreChangeChart(chartGlyph, rectangle2D2);
        ChartGlyphLayout.preGap4ChartBorder(chartGlyph, rectangle2D2);
        ChartGlyphLayout.preGap4ChartInPadding(rectangle2D2);
        ChartGlyphLayout.titleGlyphDoLayout(rectangle2D2, chartGlyph.getTitleGlyph(), n2);
        ChartGlyphLayout.calculatorDataSheetCateUnitLength(rectangle2D, rectangle2D2, chartGlyph, n2);
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, chartGlyph, n2);
        ChartGlyphLayout.makeSureDataSheetBounds(rectangle2D2, chartGlyph, n2);
        ChartGlyphLayout.plotDoLayout(rectangle2D2, chartGlyph, n2);
        ChartGlyphLayout.dataSheetDoLayoutWithPlotGlyph(chartGlyph);
    }

    public static void makeSureDataSheetBounds(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        Object v2 = chartGlyph.getDataSheetGlyph();
        if (v2 == null) {
            return;
        }
        Dimension2D dimension2D = ((DataSheetGlyph)v2).getPrefferedSize(chartGlyph, n2);
        double d2 = dimension2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() - d2, rectangle2D.getWidth(), d2);
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
        ((RectangleGlyph)v2).setBounds(double_);
    }

    private static void preMoreChangeChart(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        if (chartGlyph.isUseChangeChart()) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + CHART_CHANGE_HEIGHT, rectangle2D.getWidth(), rectangle2D.getHeight() - CHART_CHANGE_HEIGHT);
        }
    }

    public static void preGap4ChartBorder(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        double d2 = GraphHelper.getLineStyleSize(chartGlyph.getBorderStyle());
        rectangle2D.setFrame(rectangle2D.getX() + d2, rectangle2D.getY() + d2, rectangle2D.getWidth() - d2 * 2.0, rectangle2D.getHeight() - d2 * 2.0);
    }

    public static void preGap4ChartInPadding(Rectangle2D rectangle2D) {
        WIDTH_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getWidth() - 507.0) / 100.0));
        HEIGHT_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getHeight() - 340.0) / 100.0));
        rectangle2D.setFrame(rectangle2D.getX() + WIDTH_GAP, rectangle2D.getY() + HEIGHT_GAP, rectangle2D.getWidth() - WIDTH_GAP * 2.0, rectangle2D.getHeight() - HEIGHT_GAP * 2.0);
    }

    public static void titleGlyphDoLayout(Rectangle2D rectangle2D, TitleGlyph titleGlyph, int n2) {
        if (titleGlyph == null || StringUtils.isEmpty(titleGlyph.getText()) || !titleGlyph.isVisible()) {
            return;
        }
        titleGlyph.layoutTitleAndRefreshChartBounds(rectangle2D, WIDTH_GAP, HEIGHT_GAP, n2);
    }

    public static void legendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n2) {
        Object u2 = chartGlyph.getLegendGlyph();
        if (u2 == null || !((RectangleGlyph)u2).isVisible()) {
            return;
        }
        if (chartGlyph.getPlotGlyph() != null && ComparatorUtils.equals(((PlotGlyph)chartGlyph.getPlotGlyph()).getPlotGlyphType(), "MapPlotGlyph")) {
            ChartGlyphLayout.mapLegendDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, chartGlyph, n2, u2);
        } else {
            ((LegendGlyph)u2).layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n2);
        }
    }

    private static void mapLegendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n2, LegendGlyph legendGlyph) {
        Rectangle2D.Double double_;
        double d2;
        MapPlotGlyph mapPlotGlyph = (MapPlotGlyph)chartGlyph.getPlotGlyph();
        boolean bl = mapPlotGlyph.getMapType() != ChartEnumDefinitions.MapType.Map_Normal;
        boolean bl2 = mapPlotGlyph.isHeatMap();
        boolean bl3 = mapPlotGlyph.isSvgMap();
        if (!bl3 || bl && !bl2) {
            legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n2);
            return;
        }
        int n3 = legendGlyph.getPosition();
        MapHotAreaColor mapHotAreaColor = mapPlotGlyph.getAreaColors();
        TextAttr textAttr = new TextAttr();
        if (legendGlyph.getFont() != null) {
            textAttr.setFRFont(legendGlyph.getFont());
        } else {
            textAttr.setFRFont(FRFont.getInstance("Microsoft YaHei", 0, 9.0f, Color.black));
        }
        Dimension2D dimension2D = ChartGlyphLayout.getControlBarDimension(n3, mapHotAreaColor, rectangle2D2, textAttr, n2);
        boolean bl4 = false;
        if (n3 == 1 || n3 == 3) {
            d2 = dimension2D.getWidth() + WIDTH_GAP * 2.0 + (double)TEST_GAP;
            bl4 = d2 < rectangle2D2.getWidth();
            double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() - d2, rectangle2D2.getHeight());
        } else {
            d2 = dimension2D.getHeight() + HEIGHT_GAP * 2.0 + (double)TEST_GAP;
            bl4 = d2 < rectangle2D2.getHeight();
            double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - d2);
        }
        if (bl4) {
            Dimension2D dimension2D2 = legendGlyph.prefferedLegendSizeWithChartBounds(double_, n2);
            double d3 = ChartGlyphLayout.getLegendStartX(n3, dimension2D, dimension2D2, rectangle2D2);
            double d4 = ChartGlyphLayout.getLegendStartY(n3, dimension2D, dimension2D2, rectangle2D2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d3, d4, dimension2D.getWidth(), dimension2D.getHeight());
            Rectangle2D.Double double_3 = n3 == 1 || n3 == 3 ? new Rectangle2D.Double(((RectangularShape)double_2).getX() + dimension2D.getWidth() + (double)COMBINE_GAP, ((RectangularShape)double_2).getY(), dimension2D2.getWidth(), dimension2D2.getHeight()) : new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY() + dimension2D.getHeight() + (double)COMBINE_GAP, dimension2D2.getWidth(), dimension2D2.getHeight());
            legendGlyph.changeLegendBounds(double_3, n2);
            ChartGlyphLayout.makeBoundsInCenter(double_2, double_3, n3);
            n3 = n3 == 8 ? 4 : n3;
            chartGlyph.setMapControlBar(new HeatMapControlBar(double_2, n3, mapHotAreaColor, n2, textAttr));
            ChartGlyphLayout.refreshChartBoundsWithControlBar(n3, rectangle2D2, double_2, double_3);
        } else {
            legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n2);
        }
    }

    private static void makeBoundsInCenter(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n2) {
        if (n2 == 1 || n2 == 3) {
            double d2;
            double d3 = rectangle2D.getHeight();
            if (d3 > (d2 = rectangle2D2.getHeight())) {
                rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D.getY() + (d3 - d2) / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            } else {
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY() + (d2 - d3) / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        } else {
            double d4;
            double d5 = rectangle2D.getWidth();
            if (d5 > (d4 = rectangle2D2.getWidth())) {
                rectangle2D2.setRect(rectangle2D.getX() + (d5 - d4) / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
            } else {
                rectangle2D.setRect(rectangle2D2.getX() + (d4 - d5) / 2.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
    }

    private static Dimension2D getControlBarDimension(int n2, MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n3) {
        if (n2 == 1 || n2 == 3) {
            return ChartGlyphLayout.getControlBarDimensionTopAndBottom(mapHotAreaColor, rectangle2D, textAttr, n3);
        }
        return ChartGlyphLayout.getControlBarDimensionLeftAndRight(mapHotAreaColor, rectangle2D, textAttr, n3);
    }

    private static Dimension2D getControlBarDimensionTopAndBottom(MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n2) {
        int n3 = 26;
        int n4 = 13;
        int n5 = 1;
        int n6 = mapHotAreaColor.getAreaNumber();
        String string = mapHotAreaColor.getMaxLabelWithIndex(0);
        String string2 = mapHotAreaColor.getMinLabelWithIndex(n6 - 1);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string), textAttr, n2);
        double d2 = dimension2D.getWidth();
        double d3 = GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string2), textAttr, n2).getWidth();
        double d4 = dimension2D.getHeight();
        double d5 = (d2 + d3) / 2.0 + (double)(n3 * n6) + (double)(n5 * (n6 - 1));
        double d6 = d4 * 2.0 + (double)SHORT_HEIGHT_GAP + (double)n4;
        return new DoubleDimension2D(d5, d6);
    }

    private static Dimension2D getControlBarDimensionLeftAndRight(MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n2) {
        int n3 = 13;
        int n4 = 26;
        int n5 = 1;
        int n6 = mapHotAreaColor.getAreaNumber();
        double d2 = n4 * n6 + n5 * (n6 - 1) + FONT_HEIGHT;
        double d3 = 0.0;
        String[] stringArray = mapHotAreaColor.getNumberLabels();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            d3 = Math.max(GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string), textAttr, n2).getWidth(), d3);
        }
        double d4 = d3 + (double)SHORT_WIDTH_GAP + (double)n3;
        d4 = Math.min(0.28 * rectangle2D.getWidth(), d4);
        return new DoubleDimension2D(d4, d2);
    }

    private static double getLegendStartX(int n2, Dimension2D dimension2D, Dimension2D dimension2D2, Rectangle2D rectangle2D) {
        if (n2 == 1 || n2 == 3) {
            return rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth() - dimension2D2.getWidth() - (double)COMBINE_GAP) / 2.0;
        }
        if (n2 == 2) {
            return rectangle2D.getX();
        }
        return rectangle2D.getX() + rectangle2D.getWidth() - Math.max(dimension2D.getWidth(), dimension2D2.getWidth());
    }

    private static double getLegendStartY(int n2, Dimension2D dimension2D, Dimension2D dimension2D2, Rectangle2D rectangle2D) {
        if (n2 == 2 || n2 == 4) {
            return rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight() - dimension2D2.getHeight() - (double)COMBINE_GAP) / 2.0;
        }
        if (n2 == 8 || n2 == 1) {
            return rectangle2D.getY();
        }
        return rectangle2D.getY() + rectangle2D.getHeight() - Math.max(dimension2D.getHeight(), dimension2D2.getHeight());
    }

    private static void refreshChartBoundsWithControlBar(int n2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        if (n2 == 1 || n2 == 3) {
            ChartGlyphLayout.refreshChartBoundsWithControlBarTopAndBottom(n2, rectangle2D, rectangle2D2, rectangle2D3);
        } else {
            ChartGlyphLayout.refreshChartBoundsWithControlBarLeftAndRight(n2, rectangle2D, rectangle2D2, rectangle2D3);
        }
    }

    private static void refreshChartBoundsWithControlBarTopAndBottom(int n2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d2 = Math.max(rectangle2D2.getHeight(), rectangle2D3.getHeight());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + (n2 == 1 ? d2 : 0.0), rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
    }

    private static void refreshChartBoundsWithControlBarLeftAndRight(int n2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d2 = Math.max(rectangle2D2.getWidth(), rectangle2D3.getWidth());
        rectangle2D.setRect(rectangle2D.getX() + (n2 == 2 ? d2 : 0.0), rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight());
    }

    private static void calculatorDataSheetCateUnitLength(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n2) {
        Object v2 = chartGlyph.getDataSheetGlyph();
        if (v2 == null) {
            return;
        }
        Object t2 = chartGlyph.getPlotGlyph();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, double_, chartGlyph, n2);
        ChartGlyphLayout.justAxisDoLayout(double_, chartGlyph, n2);
        Object v3 = chartGlyph.getDataSheetGlyph();
        Rectangle2D rectangle2D3 = ((RectangleGlyph)v3).getBounds();
        if (t2 != null && v3 != null) {
            int n3 = 0;
            if (t2 instanceof CategoryPlotGlyph) {
                int n4 = ((CategoryPlotGlyph)t2).getxAxisGlyph().getPosition();
                if (n4 == 1 || n4 == 3) {
                    n3 = (int)((CategoryPlotGlyph)t2).getxAxisGlyph().getBounds().getWidth() / ((PlotGlyph)t2).getCategoryCount();
                } else {
                    int n5 = (int)((CategoryPlotGlyph)t2).getyAxisGlyph().getBounds().getX() + (int)((RectangleGlyph)t2).getBounds().getX();
                    n3 = (int)(rectangle2D3.getX() + rectangle2D3.getWidth() - (double)n5) / ((PlotGlyph)t2).getCategoryCount();
                }
            } else if (t2 instanceof StockPlotGlyph) {
                n3 = (int)((StockPlotGlyph)t2).getxAxisGlyph().getUnitLen();
            }
            ((DataSheetGlyph)v3).setUnitLength(n3);
        }
    }

    public static void plotDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        Object t2 = chartGlyph.getPlotGlyph();
        if (t2 == null) {
            return;
        }
        ChartGlyphLayout.justAxisDoLayout(rectangle2D, chartGlyph, n2);
        ((PlotGlyph)t2).layoutDataSeriesGlyph(n2);
        if (((GeneralGlyph)t2).getRoundRadius() > 0) {
            ((RectangleGlyph)t2).setBounds(ChartBaseUtils.rectangle2RoundRectangle(((RectangleGlyph)t2).getBounds(), ((GeneralGlyph)t2).getRoundRadius()));
        } else {
            ((RectangleGlyph)t2).setBounds(ChartBaseUtils.rectangle2RoundRectangle(((RectangleGlyph)t2).getBounds(), ((GeneralGlyph)t2).isRoundBorder()));
        }
    }

    private static void justAxisDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n2) {
        Cloneable cloneable;
        double d2;
        Object t2 = chartGlyph.getPlotGlyph();
        if (t2 == null) {
            return;
        }
        double d3 = ((PlotGlyph)t2).getPreGap4AxisRightUnit();
        double d4 = ((PlotGlyph)t2).getPreGap4AxisTopUnit();
        double d5 = ((PlotGlyph)t2).getPreLeft4DataSheet(n2);
        Object v2 = chartGlyph.getDataSheetGlyph();
        double d6 = 0.0;
        if (v2 != null) {
            d2 = ((DataSheetGlyph)v2).getPrefferedSize(chartGlyph, n2).getWidth();
            d6 = d5 > d2 ? 0.0 : d2 - d5;
        }
        d2 = 0.0;
        double d7 = 0.0;
        if (t2 instanceof RectanglePlotGlyph) {
            cloneable = (RectanglePlotGlyph)t2;
            if (cloneable.getxAxisGlyph() != null && cloneable.getxAxisGlyph().isArrowShow()) {
                d2 = ARROW_WIDTH;
            }
            if (cloneable.getyAxisGlyph() != null && cloneable.getyAxisGlyph().isArrowShow()) {
                d7 = ARROW_HEIGHT;
            }
        }
        cloneable = new Rectangle2D.Double(rectangle2D.getX() + d6, rectangle2D.getY() + d4 + d7, rectangle2D.getWidth() - d6 - d3 - d2, rectangle2D.getHeight() - d4 - d7);
        ((RectangleGlyph)t2).setBounds((RectangularShape)cloneable);
        ((PlotGlyph)t2).layoutAxisGlyph(n2);
    }

    public static void dataSheetDoLayoutWithPlotGlyph(ChartGlyph chartGlyph) {
        Object v2 = chartGlyph.getDataSheetGlyph();
        if (v2 != null) {
            ((DataSheetGlyph)v2).doLayout((PlotGlyph)chartGlyph.getPlotGlyph());
        }
    }
}

