/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.chart.chartdata.BaseTableDefinition;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.JSONDataModel;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.NameTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.SessionCachedDataModelProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class TableDataDefinition
extends TopDefinition
implements BaseTableDefinition {
    private static final long serialVersionUID = 6650119421972084763L;
    private TableData tableData;

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public abstract ChartData createChartData(DataModel var1, DataProcessor var2);

    public String[] dependence(CalculatorProvider calculatorProvider) {
        if (this.getTableData() == null) {
            return new String[0];
        }
        ParameterProvider[] parameterProviderArray = this.getTableData().getParameters((Calculator)calculatorProvider);
        if (parameterProviderArray == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            arrayList.add(parameterProviderArray[i2].getName().startsWith("$") ? parameterProviderArray[i2].getName() : "$" + parameterProviderArray[i2].getName());
            if (!(parameterProviderArray[i2].getValue() instanceof Formula)) continue;
            arrayList.addAll(Arrays.asList(((Formula)parameterProviderArray[i2].getValue()).dependence(calculatorProvider)));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("dataType", this.getDataDefinitionType());
        Calculator calculator = Calculator.createCalculator();
        try {
            TableDataDefinition tableDataDefinition = (TableDataDefinition)this.clone();
            if (tableDataDefinition != null && tableDataDefinition.getTableData() != null) {
                DataModel dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                if (dataModel != null && !(dataModel instanceof JSONDataModel)) {
                    JSONObject jSONObject2 = new JSONObject();
                    for (int i2 = 0; i2 < dataModel.getColumnCount(); ++i2) {
                        String string = dataModel.getColumnName(i2);
                        JSONArray jSONArray = new JSONArray();
                        int n2 = dataModel.getRowCount();
                        for (int i3 = 0; i3 < n2; ++i3) {
                            Object object = dataModel.getValueAt(i3, i2);
                            jSONArray.put(Utils.objectToString(object));
                        }
                        jSONObject2.put(string, jSONArray);
                    }
                    jSONObject.put("tableData", jSONObject2);
                } else if (dataModel != null) {
                    JSONDataModel jSONDataModel = (JSONDataModel)dataModel;
                    jSONObject.put("tableData", jSONDataModel.getFilePath());
                    jSONObject.put("dataSource", "remote");
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
        }
        return jSONObject;
    }

    public ChartData calcu4ChartData(Calculator calculator, DataProcessor dataProcessor) {
        ChartData chartData = null;
        try {
            TableDataDefinition tableDataDefinition = (TableDataDefinition)this.clone();
            if (tableDataDefinition != null) {
                if (tableDataDefinition.getTableData() != null) {
                    SessionCachedDataModelProcessor sessionCachedDataModelProcessor;
                    NameTableData nameTableData = (NameTableData)tableDataDefinition.getTableData();
                    String string = nameTableData.getName();
                    DataModel dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                    ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
                    if (extraClassManagerProvider != null && (sessionCachedDataModelProcessor = (SessionCachedDataModelProcessor)extraClassManagerProvider.getSingle("SessionCachedDataModelProcessor")) != null && sessionCachedDataModelProcessor.isSupportedType(new ObjectHolder(calculator))) {
                        NameSpace nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace();
                        String string2 = (String)nameSpace.getVariable("sessionID", null);
                        dataModel = (DataModel)sessionCachedDataModelProcessor.getOrCreate(string2, string, new ObjectHolder(dataModel)).get(dataModel.getClass());
                    }
                    if (dataModel == null) {
                        dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                    }
                    if (dataModel == DataModel.EMPTY_DATAMODEL) {
                        throw new TableDataException(Inter.getLocText("Chart-Table_Data_Not_Found") + "!");
                    }
                    chartData = tableDataDefinition.createChartData(dataModel, dataProcessor);
                }
                if (chartData != null) {
                    chartData = tableDataDefinition.createTopChartData(chartData, calculator);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
        }
        return chartData;
    }

    protected void addValueInColumnWithName(ArrayList arrayList, DataModel dataModel, ArrayList arrayList2, int n2, int n3) throws TableDataException {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object e2 = arrayList.get(i2);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (int i3 = 0; i3 < dataModel.getRowCount(); ++i3) {
                if (n2 == -1) {
                    arrayList3.add(dataModel.getValueAt(i3, n3));
                    continue;
                }
                if (!ComparatorUtils.equals(e2, dataModel.getValueAt(i3, n2))) continue;
                arrayList3.add(dataModel.getValueAt(i3, n3));
            }
            arrayList2.add(arrayList3);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.tableData != null) {
            DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.tableData);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        TableData tableData;
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "TableData".equals(string = xMLableReader.getTagName()) && (tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader)) != null) {
            this.setTableData(tableData);
        }
    }

    public void modDefinitionFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
    }

    public boolean equals(Object object) {
        return object instanceof TableDataDefinition && ComparatorUtils.equals(((TableDataDefinition)object).tableData, this.tableData) && super.equals(object);
    }

    public boolean isSupportAutoRefresh() {
        Calculator calculator = Calculator.createCalculator();
        if (this.getTableData() != null) {
            DataModel dataModel = this.getTableData().createDataModel(calculator);
            return dataModel instanceof JSONDataModel;
        }
        return false;
    }
}

