/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.BasePlot;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.TopDefinitionProvider;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.base.chart.chartdata.model.NormalDataModel;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.CustomPlot;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.MapPlot;
import com.fr.chart.chartattr.MeterPlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartdata.ChartSummaryColumn;
import com.fr.chart.chartdata.MoreNameCDDefinition;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalReportDataDefinition;
import com.fr.chart.chartdata.NormalTableDataDefinition;
import com.fr.chart.chartdata.OneValueCDDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.chart.charttypes.ChartTypeManager;
import com.fr.data.util.function.DataFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.NameJavaScriptGroup;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.text.Format;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends GeneralInfo
implements BaseChart {
    private static final long serialVersionUID = -2818043793300636874L;
    public static final String XML_TAG = "Chart";
    private static final String PRIORITY = "-1";
    private TopDefinitionProvider filterDefinition;
    private boolean isStyleGlobal = false;
    @Deprecated
    protected String wrapperName = "FineChart";
    private Title title;
    private Plot plot;
    private boolean isJSDraw = true;

    public void setChartImagePath(String string) {
    }

    public String getPriority() {
        return PRIORITY;
    }

    public boolean supportChange() {
        return false;
    }

    public void createSlotImage() {
    }

    public void setWrapperName(String string) {
    }

    @Deprecated
    public void setDataProcessor(DataProcessor dataProcessor) {
        if (this.plot != null) {
            this.plot.setDataProcessor(dataProcessor);
        }
    }

    @Override
    public DataProcessor getDataProcessor() {
        return this.plot == null ? new NormalDataModel() : this.plot.getDataProcessor4Definition();
    }

    public Chart() {
        this.title = null;
    }

    public Chart(Plot plot) {
        this.plot = plot;
        this.title = new Title();
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    @Override
    public void initChart(BasePlot basePlot) {
        this.plot = (Plot)basePlot;
        this.title = new Title();
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public Plot getPlot() {
        return this.plot;
    }

    @Override
    public BasePlot getBasePlot() {
        return this.plot;
    }

    @Override
    public void setFilterDefinition(TopDefinitionProvider topDefinitionProvider) {
        this.filterDefinition = topDefinitionProvider;
    }

    @Override
    public TopDefinitionProvider getFilterDefinition() {
        return this.filterDefinition;
    }

    @Override
    public String getChartName() {
        return this.plot == null ? "" : this.plot.getPlotName();
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    @Override
    public void changePlotFormat4ADHOC(Format format) {
        this.getPlot().getHotTooltipStyle().setFormat(format);
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public String[] getRequiredJS() {
        return this.plot == null ? new String[]{} : ChartTypeManager.getInstance().getRequiredJS(this.plot.getPlotID());
    }

    public String getImagePath() {
        return this.plot == null ? "" : ChartTypeManager.getInstance().getChartImagePath(this.plot.getPlotID());
    }

    public String getWrapperName() {
        return this.plot == null ? "FineChart" : ChartTypeManager.getInstance().getWrapperName(this.plot.getPlotID());
    }

    @Override
    public BaseChartGlyph createGlyph(ChartData chartData) {
        ChartGlyph chartGlyph = new ChartGlyph();
        chartGlyph.setDataDefinition(this.filterDefinition);
        chartGlyph.setGeneralInfo(this);
        chartGlyph.setJSDraw(this.isJSDraw());
        chartGlyph.setWrapperName(this.getWrapperName());
        chartGlyph.setRequiredJS(this.getRequiredJS());
        chartGlyph.setChartImagePath(this.getImagePath());
        this.createTitleGlyph4ChartGlyph(chartGlyph);
        PlotGlyph plotGlyph = this.createPlotGlyph4ChartGlyph(chartData, chartGlyph);
        this.createLegendGlyph(chartGlyph, plotGlyph);
        if (!this.isMoreCateData(chartData)) {
            this.createDataSheetGlyph4ChartGlyph(chartGlyph, plotGlyph);
        }
        return chartGlyph;
    }

    public void setRequiredJs(String[] stringArray) {
    }

    private boolean isMoreCateData(ChartData chartData) {
        if (chartData instanceof NormalChartData) {
            NormalChartData normalChartData = (NormalChartData)chartData;
            return normalChartData.getSecondCates() != null && normalChartData.getSecondCates().length > 0;
        }
        return false;
    }

    @Override
    public ChartData createNullChartData() {
        return this.getPlot() != null ? this.getPlot().createNullChartData() : new NormalChartData(new Object[]{""}, new Object[]{""}, new Object[][]{{""}});
    }

    protected void createTitleGlyph4ChartGlyph(ChartGlyph chartGlyph) {
        if (this.title != null) {
            try {
                TitleGlyph titleGlyph = this.title.createGlyph();
                chartGlyph.setTitleGlyph(titleGlyph);
            }
            catch (Exception exception) {
                chartGlyph.setTitleGlyph(new TitleGlyph());
                String string = "Error happens at Chart Title.\nerror message is " + exception.getMessage();
                FRContext.getLogger().error(string, exception);
            }
        }
    }

    protected void createLegendGlyph(ChartGlyph chartGlyph, PlotGlyph plotGlyph) {
        if (this.plot != null) {
            LegendGlyph legendGlyph = this.plot.createLegendGlyph(plotGlyph);
            chartGlyph.setLegendGlyph(legendGlyph);
        }
    }

    protected PlotGlyph createPlotGlyph4ChartGlyph(ChartData chartData, ChartGlyph chartGlyph) {
        PlotGlyph plotGlyph = null;
        try {
            if (this.plot != null) {
                plotGlyph = this.plot.createPlotGlyph(chartData);
                if (plotGlyph != null) {
                    plotGlyph.setDataProcessor(this.getDataProcessor());
                }
                chartGlyph.setPlotGlyph(plotGlyph);
            }
        }
        catch (Exception exception) {
            chartGlyph.setPlotGlyph(null);
            String string = "Error happens at Chart Plot.\nerror message is " + exception.getMessage();
            FRContext.getLogger().error(string, exception);
        }
        return plotGlyph;
    }

    @Override
    public void changeSimDemo4ADHOC() {
        this.setTitle(null);
        this.getPlot().setLegend(null);
        if (this.getPlot().getDataSheet() != null) {
            this.getPlot().getDataSheet().setFont(FRFont.getInstance("SimSun", 0, 1.0f));
        }
        if (this.getPlot() instanceof MeterPlot) {
            ((MeterPlot)this.getPlot()).getMeterStyle().setTickLabelsVisible(false);
        }
    }

    @Override
    public ChartData defaultChartData() {
        if (this.plot != null) {
            if (this.isUseMoreDate() && this.plot.isSupportMoreCate()) {
                int n2 = this.filterDefinition.getMoreCateSize();
                if (n2 == 1) {
                    return this.plot.defaultSecondMoreCate();
                }
                return this.plot.defaultThirdMoreCate();
            }
            return this.plot.defaultChartData();
        }
        return null;
    }

    public boolean isUseMoreDate() {
        return this.filterDefinition != null && this.filterDefinition.getMoreCateSize() > 0;
    }

    protected void createDataSheetGlyph4ChartGlyph(ChartGlyph chartGlyph, PlotGlyph plotGlyph) {
        try {
            if (this.plot != null && this.plot.isSupportDataSheet()) {
                DataSheetGlyph dataSheetGlyph = this.plot.createDataSheetGlyph(plotGlyph);
                chartGlyph.setDataSheetGlyph(dataSheetGlyph);
            }
        }
        catch (Exception exception) {
            String string = "Error happens at Chart Legend or DataSheet.\nerror message is " + exception.getMessage();
            FRContext.getLogger().error(string, exception);
        }
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        String[] stringArray;
        TopDefinitionProvider topDefinitionProvider = this.getFilterDefinition();
        if (topDefinitionProvider != null) {
            stringArray = topDefinitionProvider.dependence(calculatorProvider);
            list.addAll(Arrays.asList(stringArray));
        }
        if ((stringArray = this.getTitle()) != null) {
            stringArray.dependence(calculatorProvider, list);
        }
        if (this.plot != null) {
            this.plot.dependence(calculatorProvider, list);
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.title != null) {
            this.title.dealFormula(calculator);
        }
        if (this.plot != null) {
            this.plot.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.title != null) {
            this.title.buidExecuteSequenceList(list, calculator);
        }
        if (this.plot != null) {
            this.plot.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.title != null) {
            this.title.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.plot != null) {
            this.plot.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.getFilterDefinition() != null) {
            this.getFilterDefinition().modDefinitionFormulaString(mOD_COLUMN_ROW);
        }
    }

    public void changePlotInNewType(Plot plot) {
        if (plot == null) {
            return;
        }
        if (!plot.matchPlotType(this.plot)) {
            this.setPlot(plot);
        }
    }

    public void switchPlot(Plot plot) {
        if (plot == null) {
            return;
        }
        if (!plot.match4GUI(this.getPlot())) {
            plot.clearConditionAttrAndRenewLegend(this.getPlot());
            Plot plot2 = this.getPlot();
            if (plot2 != null && plot2.getHotHyperLink() != null && ComparatorUtils.equals(plot.getClass(), plot2.getClass())) {
                NameJavaScriptGroup nameJavaScriptGroup = plot2.getHotHyperLink();
                try {
                    plot.setHotHyperLink((NameJavaScriptGroup)nameJavaScriptGroup.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error("Error in Hyperlink, Please Check it.", cloneNotSupportedException);
                }
            }
            this.setPlot(plot);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        this.readChartXML(xMLableReader);
    }

    protected void readChartXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Title")) {
                this.title = new Title();
                xMLableReader.readXMLObject(this.title);
                this.changeTitleStyle4XML();
            } else if (string.equals("Plot")) {
                String string2 = xMLableReader.getAttrAsString("class", null);
                if (string2 != null && string2.endsWith("Line3DPlot")) {
                    this.plot = (Plot)xMLableReader.readXMLObject(new LinePlot());
                } else if (string2 != null && string2.endsWith("MeterCustomPlot")) {
                    this.plot = (Plot)xMLableReader.readXMLObject(new MeterPlot());
                } else {
                    this.plot = (Plot)GeneralXMLTools.readXMLable(xMLableReader);
                    if (!(!(this.plot instanceof MapPlot) || VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.CHART_MAP.support())) {
                        throw new RegistEditionException(VT4FR.CHART_MAP);
                    }
                    this.check4Custom();
                }
            } else if (string.equals("ChartAttr")) {
                this.setJSDraw(xMLableReader.getAttrAsBoolean("isJSDraw", true));
                this.setStyleGlobal(xMLableReader.getAttrAsBoolean("isStyleGlobal", false));
            } else if (ComparatorUtils.equals(string, "ChartDefinition")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        Chart.this.filterDefinition = ChartXMLUtils.deal65XMLDefinition(Chart.this, ChartXMLCompatibleUtils.readDefinition(xMLableReader));
                    }
                });
                Chart.comChange4PiePlot(this, xMLableReader);
            }
        }
    }

    private void check4Custom() {
        ConditionCollection conditionCollection;
        if (this.plot instanceof CustomPlot && (conditionCollection = this.plot.getConditionCollection()) != null && !(conditionCollection.getDefaultAttr() instanceof CustomAttr)) {
            conditionCollection.setDefaultAttr(new CustomAttr());
        }
    }

    public static void comChange4PiePlot(Chart chart, XMLableReader xMLableReader) {
        if (chart == null) {
            return;
        }
        Plot plot = chart.getPlot();
        if (plot instanceof PiePlot) {
            TopDefinitionProvider topDefinitionProvider;
            if (xMLableReader.getXMLVersion().isBefore702_FOR_CHART_PIE()) {
                Chart.readPieDefinition(chart);
            }
            if ((topDefinitionProvider = chart.getFilterDefinition()) == null) {
                return;
            }
            if (topDefinitionProvider.getCategoryPresent() != null && topDefinitionProvider.getSeriesPresent() == null) {
                topDefinitionProvider.setSeriesPresent(topDefinitionProvider.getCategoryPresent());
                topDefinitionProvider.setCategoryPresent(null);
            }
            if (topDefinitionProvider instanceof NormalTableDataDefinition) {
                ((NormalTableDataDefinition)topDefinitionProvider).setCategoryName("");
            } else if (topDefinitionProvider instanceof NormalReportDataDefinition) {
                ((NormalReportDataDefinition)topDefinitionProvider).setCategoryName("");
            }
        }
    }

    private static void readPieDefinition(Chart chart) {
        Object object;
        SeriesDefinition seriesDefinition;
        NormalReportDataDefinition normalReportDataDefinition;
        TopDefinitionProvider topDefinitionProvider = chart.getFilterDefinition();
        if (topDefinitionProvider instanceof MoreNameCDDefinition) {
            ChartSummaryColumn[] chartSummaryColumnArray;
            MoreNameCDDefinition moreNameCDDefinition = (MoreNameCDDefinition)topDefinitionProvider;
            String string = moreNameCDDefinition.getCategoryName();
            if (StringUtils.isNotEmpty(string) && (chartSummaryColumnArray = moreNameCDDefinition.getChartSummaryColumn()) != null && chartSummaryColumnArray.length > 0) {
                ChartSummaryColumn chartSummaryColumn = chartSummaryColumnArray[0];
                String string2 = chartSummaryColumn.getName();
                DataFunction dataFunction = chartSummaryColumn.getFunction();
                OneValueCDDefinition oneValueCDDefinition = new OneValueCDDefinition(moreNameCDDefinition.getTableData(), "", string, string2, dataFunction);
                if (moreNameCDDefinition.getCategoryPresent() != null && moreNameCDDefinition.getSeriesPresent() == null) {
                    oneValueCDDefinition.setSeriesPresent(moreNameCDDefinition.getCategoryPresent());
                }
                chart.setFilterDefinition(oneValueCDDefinition);
            }
        } else if (topDefinitionProvider instanceof OneValueCDDefinition) {
            OneValueCDDefinition oneValueCDDefinition = (OneValueCDDefinition)topDefinitionProvider;
            if (StringUtils.isNotEmpty(oneValueCDDefinition.getCategoryName()) && StringUtils.isEmpty(oneValueCDDefinition.getSeriesColumnName())) {
                oneValueCDDefinition.setSeriesColumnName(oneValueCDDefinition.getCategoryName());
            }
        } else if (topDefinitionProvider instanceof NormalReportDataDefinition && (normalReportDataDefinition = (NormalReportDataDefinition)topDefinitionProvider).size() == 1 && (seriesDefinition = (SeriesDefinition)normalReportDataDefinition.get(0)) != null && (object = seriesDefinition.getSeriesName()) != null) {
            String string = object.toString();
            if (string.startsWith("=")) {
                if (StringUtils.isEmpty(string)) {
                    seriesDefinition.setSeriesName(normalReportDataDefinition.getCategoryName());
                }
            } else if (StringUtils.isEmpty(object.toString())) {
                seriesDefinition.setSeriesName(normalReportDataDefinition.getCategoryName());
            }
        }
    }

    private void changeTitleStyle4XML() {
        if (this.title != null && this.title.getTextAttr() != null) {
            this.title.getTextAttr().setAlignText(0);
            this.title.getTextAttr().setRotation(0);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ChartAttr").attr("isJSDraw", this.isJSDraw).attr("isStyleGlobal", this.isStyleGlobal).end();
        if (this.title != null) {
            this.title.writeXML(xMLPrintWriter);
        }
        if (this.plot != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.plot, "Plot");
        }
        this.writeDefinition(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    protected void writeDefinition(XMLPrintWriter xMLPrintWriter) {
        if (this.filterDefinition != null) {
            xMLPrintWriter.startTAG("ChartDefinition");
            this.filterDefinition.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Chart chart = (Chart)super.clone();
        if (this.title != null) {
            chart.title = (Title)this.title.clone();
        }
        if (this.plot != null) {
            chart.plot = (Plot)this.plot.clone();
        }
        chart.setStyleGlobal(this.isStyleGlobal);
        chart.setJSDraw(this.isJSDraw);
        if (this.getFilterDefinition() != null) {
            chart.setFilterDefinition((TopDefinition)this.getFilterDefinition().clone());
        }
        return chart;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Chart && super.equals(object) && ComparatorUtils.equals(((Chart)object).getPlot(), this.plot) && ComparatorUtils.equals(((Chart)object).getTitle(), this.title) && ComparatorUtils.equals(((Chart)object).getFilterDefinition(), this.getFilterDefinition()) && ((Chart)object).isJSDraw() == this.isJSDraw && ((Chart)object).isStyleGlobal() == this.isStyleGlobal;
    }

    public boolean accept(Class<? extends Chart> clazz) {
        return ComparatorUtils.equals(Chart.class, clazz);
    }

    public void setStyleGlobal(boolean bl) {
        this.isStyleGlobal = bl;
    }

    public boolean isStyleGlobal() {
        return this.isStyleGlobal;
    }

    public String getXmlTag() {
        return XML_TAG;
    }

    public String getPlotType() {
        return this.plot == null ? "" : this.plot.getPlotDetailType();
    }

    public void demoImgEvent(boolean bl) {
    }
}

