/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseUtils;
import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.TextAttr;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.CoreConstants;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class GlyphUtils {
    private static final double PIE_ANGLE = 180.0;
    private static final int CH_NUM = 127;

    public static void drawStrings(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n2) {
        if (rectangle2D == null || StringUtils.isEmpty(string)) {
            return;
        }
        Style style = GlyphUtils.createStyleFromTextAttr(textAttr);
        GlyphUtils.drawStringWithStyle(graphics, rectangle2D, string, style, n2);
    }

    private static void drawStringWithStyle(Graphics graphics, Rectangle2D rectangle2D, String string, Style style, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = GlyphUtils.changeAllReline2Normal(string);
        String[] stringArray = string2.split(AttrContents.RelineSeparation);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (style.getVerticalText() == 1) {
                GlyphUtils.drawStringWhenVertical(graphics2D, stringArray[i2], style, rectangle2D.getHeight(), n2);
                continue;
            }
            BaseUtils.drawStringStyleInRotation(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), string, style, n2);
            if (style.getRotation() == 0) continue;
            BaseUtils.drawStringStyleInRotation(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), string, style, n2);
        }
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    private static void drawStringWhenVertical(Graphics2D graphics2D, String string, Style style, double d2, int n2) {
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        FRFont fRFont = style.getFRFont();
        graphics2D.setPaint(fRFont.getForeground());
        Font font2 = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n2), string);
        graphics2D.setFont(font2);
        double d3 = (double)font2.getSize() * 0.8;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            String string2 = String.valueOf(string.charAt(i2));
            Rectangle2D rectangle2D = font2.getStringBounds(string2, CoreConstants.DEFAULT_FRC);
            if (c2 > '\u007f' && c2 != '\u2026') {
                graphics2D.drawString(string2, (float)((double)(fRFont.getSize() / 2) - rectangle2D.getWidth() / 2.0), (float)d3);
                d3 += rectangle2D.getHeight();
                continue;
            }
            if (i2 == 0) {
                d3 = font2.getSize();
            }
            double d4 = (double)font2.getSize() * (c2 == '\u2026' ? 0.7 : 0.5);
            GraphHelper.drawRotatedString(graphics2D, String.valueOf(c2), d4, d3 - (double)font2.getSize() * 0.5, 90);
            d3 += rectangle2D.getWidth();
        }
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    private static Style createStyleNoRotationFormTextAttr(TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Style style = textAttr.getFRFont() != null ? Style.getInstance(textAttr.getFRFont()) : Style.getInstance();
        style = style.deriveVerticalText(textAttr.getAlignText());
        style = style.derivePadding(0, 0);
        return style;
    }

    private static Style createStyleFromTextAttr(TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Style style = GlyphUtils.createStyleNoRotationFormTextAttr(textAttr);
        return style.deriveRotation(textAttr.getRotation());
    }

    public static Dimension2D calculateTextDimensionWithRotation(String string, TextAttr textAttr, int n2) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
        return GlyphUtils.calDimWithRotation(dimension2D, textAttr);
    }

    private static Dimension2D calDimWithRotation(Dimension2D dimension2D, TextAttr textAttr) {
        if (textAttr != null && textAttr.getRotation() != 0) {
            int n2 = textAttr.getRotation();
            double d2 = (double)n2 * Math.PI / 180.0;
            double d3 = Math.abs(Math.cos(d2) * dimension2D.getWidth()) + Math.abs(Math.sin(d2) * dimension2D.getHeight());
            double d4 = Math.abs(Math.cos(d2) * dimension2D.getHeight()) + Math.abs(Math.sin(d2) * dimension2D.getWidth());
            return new DoubleDimension2D(d3, d4);
        }
        return dimension2D;
    }

    public static void drawAxisVerticalTitle(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n2) {
        if (rectangle2D == null || StringUtils.isEmpty(string)) {
            return;
        }
        Style style = GlyphUtils.createStyleFromTextAttr(textAttr);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = GlyphUtils.changeAllReline2Normal(string);
        String[] stringArray = string2.split(AttrContents.RelineSeparation);
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        FRFont fRFont = style.getFRFont();
        TextAttr textAttr2 = new TextAttr();
        textAttr2.setRotation(textAttr.getRotation());
        textAttr2.setFRFont(fRFont);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            GlyphUtils.drawStrings(graphics2D, string, textAttr2, rectangle2D, n2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    public static Dimension2D calculateTextDimensionWithNoRotation(String string, TextAttr textAttr, int n2) {
        FRFont fRFont;
        if (StringUtils.isEmpty(string)) {
            return new Dimension(0, 0);
        }
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        if ((fRFont = textAttr.getFRFont()) == null) {
            fRFont = FRFont.getInstance();
        }
        Font font = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n2), string);
        double d2 = 0.0;
        double d3 = 0.0;
        if (textAttr.getAlignText() == 1) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                String string2 = String.valueOf(c2);
                Rectangle2D rectangle2D = font.getStringBounds(string2, CoreConstants.DEFAULT_FRC);
                if (c2 > '\u007f' && c2 != '\u2026') {
                    d2 = Math.max(d2, rectangle2D.getWidth());
                    d3 += rectangle2D.getHeight();
                    continue;
                }
                d2 = Math.max(d2, rectangle2D.getHeight());
                d3 += rectangle2D.getWidth();
            }
        } else {
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(10, 10, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string3 = GlyphUtils.changeAllReline2Normal(string);
            String[] stringArray = string3.split(AttrContents.RelineSeparation);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                Dimension2D dimension2D = GraphHelper.stringDimensionWithRotation(stringArray[i3], font, 0, CoreConstants.DEFAULT_FRC);
                d2 = Math.max(d2, GraphHelper.stringWidth(stringArray[i3], font, fontRenderContext));
                d3 += dimension2D.getHeight();
            }
        }
        return new DoubleDimension2D(d2, d3);
    }

    public static Font getFont4StringInSystem(Font font, String string) {
        if (StringUtils.isEmpty(string)) {
            return font;
        }
        FRFont fRFont = FRFont.getInstance(Inter.getLocText("Chart-Song_TypeFace"), font.getStyle(), font.getSize());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (font.canDisplay(string.charAt(i2))) continue;
            return fRFont;
        }
        return font;
    }

    public static String changeAllReline2Normal(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '\\' && i2 + 1 < string.length() && string.charAt(i2 + 1) == 'n') {
                ++i2;
                stringBuffer.append(AttrContents.RelineSeparation);
                continue;
            }
            stringBuffer.append(string.charAt(i2));
        }
        return Utils.objectToString(stringBuffer);
    }
}

