/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.ComparatorUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public abstract class DynamicValueList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long[] elementInts;
    private int size;
    protected long defaultValue = 1L;

    protected DynamicValueList(long l2) {
        this(l2, 10);
    }

    protected DynamicValueList(long l2, int n2) {
        this.elementInts = new long[n2];
        Arrays.fill(this.elementInts, l2);
        this.size = this.elementInts.length;
        this.defaultValue = l2;
    }

    protected long getDefaultLongValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(long l2) {
        this.defaultValue = l2;
    }

    public int size() {
        return this.size;
    }

    protected long getValue(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return this.defaultValue;
        }
        return this.elementInts[n2];
    }

    protected void set(int n2, long l2) {
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.size) {
            if (l2 == this.defaultValue) {
                return;
            }
            this.ensureCapacity(n2 + 1);
        }
        this.elementInts[n2] = l2;
        if (n2 >= this.size) {
            this.size = n2 + 1;
        }
    }

    public void insert(int n2) {
        this.insert(n2, 1);
    }

    public void insert(int n2, int n3) {
        if (n2 < 0 || n3 <= 0 || n2 >= this.size) {
            return;
        }
        this.ensureCapacity(this.size + n3);
        System.arraycopy(this.elementInts, n2, this.elementInts, n2 + n3, this.size - n2);
        Arrays.fill(this.elementInts, n2, n2 + n3, this.defaultValue);
        this.size += n3;
    }

    protected long removeValue(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return this.defaultValue;
        }
        long l2 = this.elementInts[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementInts, n2 + 1, this.elementInts, n2, n3);
        }
        this.elementInts[--this.size] = this.defaultValue;
        return l2;
    }

    public void reset() {
        Arrays.fill(this.elementInts, this.defaultValue);
        this.size = 0;
    }

    protected long getRangeLongValueFromZero(int n2) {
        return this.getRangeLongValue(0, n2);
    }

    protected long getRangeLongValueExcludeHidden(int n2, HashSet hashSet) {
        return this.getRangeLongValueExcludeHidden(0, n2, hashSet);
    }

    protected long getRangeLongValue(int n2, int n3) {
        int n4;
        long l2 = 0L;
        boolean bl = n2 <= n3;
        int n5 = bl ? n2 : n3;
        int n6 = bl ? n3 : n2;
        boolean bl2 = this.defaultValue != 1L;
        n5 = n5 > 0 ? n5 : 0;
        boolean bl3 = n6 > this.elementInts.length;
        int n7 = n4 = bl3 ? this.elementInts.length : n6;
        for (int i2 = n5; i2 < n4; ++i2) {
            l2 += this.elementInts[i2];
        }
        if (bl3) {
            long l3 = n6 - Math.max(this.elementInts.length, n5);
            l3 = bl2 ? l3 * this.defaultValue : l3;
            l2 += l3;
        }
        return n2 <= n3 ? l2 : -l2;
    }

    protected long getRangeLongValueExcludeHidden(int n2, int n3, HashSet hashSet) {
        long l2 = 0L;
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        long l3 = 0L;
        if (hashSet != null && hashSet.size() > 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                l3 += n6 < this.elementInts.length ? this.elementInts[n6] : this.defaultValue;
            }
        }
        int n7 = Math.min(n5, this.elementInts.length);
        for (int i2 = n4 = Math.max(0, n4); i2 < n7; ++i2) {
            l2 += this.elementInts[i2];
        }
        if (n5 > this.elementInts.length) {
            l2 += (long)(n5 - Math.max(this.elementInts.length, n4)) * this.defaultValue;
        }
        return n2 <= n3 ? l2 : -(l2 -= l3);
    }

    protected int getValueIndex(long l2) {
        return this.getValueIndex(l2, 0);
    }

    protected int getValueIndex(long l2, int n2) {
        int n3 = 0;
        int n4 = n2;
        while ((long)(n3 = (int)((long)n3 + this.getValue(n4))) <= l2) {
            ++n4;
        }
        return n4;
    }

    private void ensureCapacity(int n2) {
        int n3 = this.elementInts.length;
        if (n2 > n3) {
            long[] lArray = this.elementInts;
            int n4 = n3 * 3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementInts = new long[n4];
            System.arraycopy(lArray, 0, this.elementInts, 0, lArray.length);
            Arrays.fill(this.elementInts, lArray.length, this.elementInts.length, this.defaultValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicValueList dynamicValueList = (DynamicValueList)super.clone();
        dynamicValueList.elementInts = (long[])this.elementInts.clone();
        return dynamicValueList;
    }

    public boolean equals(Object object) {
        return object instanceof DynamicValueList && ComparatorUtils.equals(this.elementInts, ((DynamicValueList)object).elementInts) && this.size == ((DynamicValueList)object).size && this.defaultValue == ((DynamicValueList)object).defaultValue;
    }
}

