/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reportcase;

import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.report.ReportHelper;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.worksheet.AnalysisRWorkSheet;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.AbstractWebReportCase;

public class WebElementReportCase
extends AbstractWebReportCase {
    private DynamicPixList colPixList;
    private DynamicPixList rowPixList;
    private int resolution;
    private int columnWidth;
    private int rowHeight;

    public WebElementReportCase(ElementCase elementCase, Repository repository) {
        super(elementCase);
        DynamicUnitList dynamicUnitList;
        DynamicUnitList dynamicUnitList2;
        if (elementCase instanceof AnalysisRWorkSheet) {
            dynamicUnitList2 = ReportHelper.createColumnWidthList(elementCase);
            dynamicUnitList = ReportHelper.createRowHeightList(elementCase);
            this.colPixList = dynamicUnitList2.toDynamicPixList();
            this.rowPixList = dynamicUnitList.toDynamicPixList();
        } else {
            dynamicUnitList2 = ReportHelper.getColumnWidthList(elementCase);
            dynamicUnitList = ReportHelper.getRowHeightList(elementCase);
            this.colPixList = dynamicUnitList2.toDynamicPixList();
            this.rowPixList = dynamicUnitList.toDynamicPixList();
        }
        this.resolution = repository.getResolution();
        this.columnWidth = dynamicUnitList2.getRangeValue(0, elementCase.getColumnCount()).toPixI(this.resolution);
        this.rowHeight = dynamicUnitList.getRangeValue(0, elementCase.getRowCount()).toPixI(this.resolution);
    }

    public int getColumnPixWidth(int n2) {
        return this.colPixList.get(n2, this.resolution);
    }

    public int getColumnWidth(int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            n4 += this.colPixList.get(n2, this.resolution);
            --n3;
        }
        return n4;
    }

    public int getRowPixHeight(int n2) {
        return this.rowPixList.get(n2, this.resolution);
    }

    public int getRowPixHeight(int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            n4 += this.rowPixList.get(n2, this.resolution);
            --n3;
        }
        return n4;
    }

    public DynamicNumberList getColumnWidthDynamicPixList() {
        int n2 = this.colPixList.getElementSize();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(n2);
        if (this.colPixList != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                dynamicNumberList.set(i2, this.colPixList.get(i2, this.resolution));
            }
        }
        return dynamicNumberList;
    }

    public DynamicNumberList getRowHeightDynamicPixList() {
        int n2 = this.rowPixList.getElementSize();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(n2);
        if (this.rowPixList != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                dynamicNumberList.set(i2, this.rowPixList.get(i2, this.resolution));
            }
        }
        return dynamicNumberList;
    }

    public void setFirstSelectedFlag(Tag tag) {
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getColWidth() {
        return this.columnWidth;
    }
}

