/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.base.platform.PlatformProvider;
import com.fr.file.filetree.FileNode;
import com.fr.file.filetree.FileNodeFilter;
import com.fr.file.filetree.IOFileNodeFilter;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.TemplateWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.Report;
import com.fr.report.stable.fun.Actor;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.button.page.First;
import com.fr.report.web.button.page.Last;
import com.fr.report.web.button.page.Next;
import com.fr.report.web.button.page.PageNavi;
import com.fr.report.web.button.page.Previous;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.ParameterProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import com.fr.web.ImportJsCssProvider;
import com.fr.web.RTypeService;
import com.fr.web.RepositoryHelper;
import com.fr.web.ResourceHelper;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSession;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import com.fr.write.ProcessProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportWebUtils {
    private static final FileNodeFilter CPT_FILTER = new IOFileNodeFilter(new String[]{".cpt"});
    private static final FileNodeFilter FRM_FILTER = new IOFileNodeFilter(new String[]{".frm", ".form"});

    private ReportWebUtils() {
    }

    public static Map<String, Object> context4PageTpl(HttpServletRequest httpServletRequest, ReportSession reportSession) {
        return ReportWebUtils.context4PolicyPaneTpl(httpServletRequest, reportSession, null);
    }

    public static Map<String, Object> context4EditTpl(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        Map<String, Object> map = ReportWebUtils.context4CommonPaneTpl(httpServletRequest, reportSessionIDInfor);
        ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, (SessionIDInfor)reportSessionIDInfor, 96);
        try {
            int n2 = reportSessionIDInfor.getReportCount();
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put((Object)new JSONObject().put("title", (Object)reportSessionIDInfor.getReportName(i2)));
            }
            map.put("sheets", jSONArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        try {
            map.put("param", RTypeService.config4ParameterPanel((Repository)reportRepositoryDeal, ReportWebUtils.isShowParameterPanel((Repository)reportRepositoryDeal)));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
        map.put("browserbg", BaseHTMLWriterUtils.jsonBackground((Background)ReportUtils.getBrowserBackgroundFromWorkBook(reportSessionIDInfor.getContextBook()), (Repository)reportRepositoryDeal));
        return map;
    }

    public static Map<String, Object> context4CommonPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (reportSession == null) {
            return hashMap;
        }
        hashMap.put("charset", ConfigManager.getProviderInstance().getServerCharset());
        hashMap.put("sessionID", reportSession.getSessionID());
        hashMap.put("reportlet_title", reportSession.getWebTitle());
        hashMap.put("reportlet_paperwidth", ReportWebUtils.getReportWidthPixI(reportSession) + "");
        hashMap.put("reportlet_paperheight", ReportWebUtils.getReportHeightPixI(reportSession) + "");
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace((NameSpace)ParameterMapNameSpace.create(hashMap));
        hashMap.put("csslink", WebUtils.getCSSLinks((Calculator)calculator, (ImportJsCssProvider)reportSession.getContextBook()));
        hashMap.put("jslink", WebUtils.getJSLinks((Calculator)calculator, (ImportJsCssProvider)reportSession.getContextBook()));
        hashMap.put("jsVersion", ResourceHelper.getJsVersion());
        hashMap.put("cssVersion", ResourceHelper.getCssVersion());
        hashMap.put("Baidu", ChartPreStyleServerManager.getProviderInstance().findBaiduSource());
        hashMap.put("Google", ChartPreStyleServerManager.getProviderInstance().findGoogleSource());
        return hashMap;
    }

    private static double getReportHeightPixI(ReportSession reportSession) {
        if (reportSession.getContextBook().getReportCount() == 0) {
            return 0.0;
        }
        PaperSettingProvider paperSettingProvider = reportSession.getContextBook().getReport(0).getReportSettings().getPaperSetting();
        return paperSettingProvider.getPaperSize().getHeight().toPixI(96);
    }

    private static double getReportWidthPixI(ReportSession reportSession) {
        if (reportSession.getContextBook().getReportCount() == 0) {
            return 0.0;
        }
        PaperSettingProvider paperSettingProvider = reportSession.getContextBook().getReport(0).getReportSettings().getPaperSetting();
        return paperSettingProvider.getPaperSize().getWidth().toPixI(96);
    }

    public static Map<String, Object> context4PolicyPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession, Actor actor) {
        return ReportWebUtils.context4PolicyPaneTpl(httpServletRequest, reportSession, actor, null);
    }

    public static Map<String, Object> context4PolicyPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession, Actor actor, Map<String, Object> map) {
        Map<String, Object> map2 = ReportWebUtils.context4CommonPaneTpl(httpServletRequest, reportSession);
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(Report.KEY, (Object)reportSession.getContextBook());
        actor = actor == null ? reportSession.getActor() : actor;
        try {
            ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, (SessionIDInfor)reportSession, 96);
            map2.putAll(ReportWebUtils.policyMap4Tpl((Repository)reportRepositoryDeal, actor, calculator, httpServletRequest));
            if (map != null) {
                map2.putAll(map);
            }
            if (ReportWebUtils.isNeedToolbar((Repository)reportRepositoryDeal)) {
                map2.put("script", TemplateUtils.renderTemplate((String)"/com/fr/web/core/tpl/tpl_script.js", map2));
            } else {
                map2.put("script", TemplateUtils.renderTemplate((String)"/com/fr/web/core/tpl/tpl_script_without_toolbar.js", map2));
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), (Throwable)iOException);
        }
        return map2;
    }

    private static boolean isNeedToolbar(Repository repository) {
        return !"false".equalsIgnoreCase(repository.getHTTPRequestParameter("__showtoolbar__")) || ReportWebUtils.isReportProcess(repository.getHttpServletRequest());
    }

    public static Map<String, Object> policyMap4Tpl(Repository repository, Actor actor, Calculator calculator, HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor((Repository)repository);
        boolean bl = sessionIDInfor.getParameterValue("__isdebug__") != null;
        String string = Utils.objectToString((Object)sessionIDInfor.getParameterValue("__cutpage__"));
        hashMap.put("__cutpage__", string);
        if (actor == null) {
            return hashMap;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = actor.panelConfig(repository);
            jSONObject.put("type", (Object)actor.panelType());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage());
        }
        String string2 = null;
        try {
            string2 = bl ? (jSONObject != null ? jSONObject.toString(4) : "") : (jSONObject != null ? jSONObject.toString() : "");
        }
        catch (JSONException jSONException) {
            string2 = jSONObject.toString();
        }
        hashMap.put("panel_config", string2);
        hashMap.put("__pi__", String.valueOf(ReportWebUtils.isShowParameterPanel(repository)));
        ReportWebUtils.dealWithLoading(repository, actor, calculator, httpServletRequest, hashMap, bl);
        return hashMap;
    }

    private static void dealWithLoading(Repository repository, Actor actor, Calculator calculator, HttpServletRequest httpServletRequest, Map<String, Object> map, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        try {
            RTypeService.dealWithLoading(repository, new PrintWriter(stringWriter), actor, ReportWebUtils.isShowParameterPanel(repository));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        map.put("loading", stringWriter.getBuffer().toString());
        actor.dealWithSessionInfo(repository, httpServletRequest, calculator, map, bl);
        ReportWebUtils.dealWithToolbar(repository, actor, httpServletRequest, calculator, map, bl);
    }

    private static void dealWithToolbar(Repository repository, Actor actor, HttpServletRequest httpServletRequest, Calculator calculator, Map<String, Object> map, boolean bl) {
        if (ReportWebUtils.isNeedToolbar(repository)) {
            ToolBarManager[] toolBarManagerArray = ReportWebUtils.makeToolbarManager(repository, actor, httpServletRequest);
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; toolBarManagerArray != null && i2 < toolBarManagerArray.length; ++i2) {
                jSONArray.put((Object)toolBarManagerArray[i2].toJSONConfig(repository, calculator));
            }
            String string = null;
            try {
                string = bl ? jSONArray.toString(4) : jSONArray.toString();
            }
            catch (JSONException jSONException) {
                string = jSONArray.toString();
            }
            map.put("toolbar_conf", string);
        }
    }

    private static ToolBarManager[] makeToolbarManager(Repository repository, Actor actor, HttpServletRequest httpServletRequest) {
        ToolBarManager[] toolBarManagerArray = actor.toolbarManagers(repository);
        try {
            ArrayList<ToolBarManager> arrayList = new ArrayList<ToolBarManager>();
            boolean bl = ReportWebUtils.isWriteByPage(httpServletRequest);
            boolean bl2 = ReportWebUtils.isReportProcess(httpServletRequest);
            ProcessProvider processProvider = (ProcessProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"processBridge", ProcessProvider.class);
            if (toolBarManagerArray != null) {
                Collections.addAll(arrayList, toolBarManagerArray);
            }
            if (bl2 && processProvider != null) {
                long l2 = Long.parseLong(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__processtaskid__"));
                long l3 = Long.parseLong(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__allprocesstaskid__"));
                String string = processProvider.getTaskAuthority(l2);
                if (toolBarManagerArray == null) {
                    return new ToolBarManager[]{processProvider.createDefaultReportProcessToolbar(string, l2)};
                }
                ReportWebUtils.dealReportProcessToolbar(repository, toolBarManagerArray, arrayList, processProvider, string, l2);
                ReportWebUtils.dealProcessStashData(repository, l2, processProvider);
            }
            if (bl && !arrayList.isEmpty()) {
                ToolBarManager toolBarManager = (ToolBarManager)((ToolBarManager)arrayList.get(0)).clone();
                ReportWebUtils.modifyWriteByPageToolbar(toolBarManager);
                arrayList.set(0, toolBarManager);
            }
            return arrayList.toArray(new ToolBarManager[arrayList.size()]);
        }
        catch (Exception exception) {
            return toolBarManagerArray;
        }
    }

    private static boolean isReportProcess(HttpServletRequest httpServletRequest) {
        ProcessProvider processProvider = (ProcessProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"processBridge", ProcessProvider.class);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__processtaskid__");
        return string != null && processProvider != null && processProvider.isValidTaskUser(httpServletRequest, Long.parseLong(string));
    }

    private static boolean isWriteByPage(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__cutpage__");
        if (string == null) {
            return false;
        }
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"op");
        PlatformProvider platformProvider = (PlatformProvider)StableFactory.getMarkedObject((String)"PlatformProvider", PlatformProvider.class);
        return (ComparatorUtils.equals((String)string2, (String)"write") || platformProvider != null && platformProvider.isReportEntryRequest(httpServletRequest)) && ComparatorUtils.equals((String)Utils.objectToString((Object)string), (String)"v");
    }

    private static void dealReportProcessToolbar(Repository repository, ToolBarManager[] toolBarManagerArray, List<ToolBarManager> list, ProcessProvider processProvider, String string, long l2) {
        if (!processProvider.modifyToolbar(toolBarManagerArray, list, string, l2)) {
            list.add(processProvider.createDefaultReportProcessToolbar(string, l2));
        }
    }

    private static void dealProcessStashData(Repository repository, long l2, ProcessProvider processProvider) throws Exception {
        String string = processProvider.getStashData(repository, l2);
        if (string == null) {
            return;
        }
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor((Repository)repository);
        reportSessionIDInfor.setAttribute("stash_data", string);
    }

    public static void dealReportProcessToolbar(Repository repository, ToolBarManager[] toolBarManagerArray, List<ToolBarManager> list, long l2, long l3) {
        ProcessProvider processProvider = (ProcessProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"processBridge", ProcessProvider.class);
        ReportWebUtils.dealReportProcessToolbar(repository, toolBarManagerArray, list, processProvider, processProvider.getTaskAuthority(l2), l2);
    }

    private static void modifyWriteByPageToolbar(ToolBarManager toolBarManager) {
        ToolBar toolBar = toolBarManager.getToolBar();
        toolBar.addWidgetAhead((Widget)new Last());
        toolBar.addWidgetAhead((Widget)new Next());
        toolBar.addWidgetAhead((Widget)new PageNavi());
        toolBar.addWidgetAhead((Widget)new Previous());
        toolBar.addWidgetAhead((Widget)new First());
    }

    public static Map dealWithReportParameters(TemplateWorkBook templateWorkBook, Map map) {
        CalculatorMap calculatorMap;
        Parameter[] parameterArray;
        Parameter[] parameterArray2 = parameterArray = templateWorkBook == null ? null : templateWorkBook.getParameters();
        if (map == null) {
            if (parameterArray == null || parameterArray.length == 0) {
                return Collections.EMPTY_MAP;
            }
            calculatorMap = CalculatorMap.create((ParameterProvider[])parameterArray);
        } else {
            calculatorMap = parameterArray == null || parameterArray.length == 0 ? new CalculatorMap() : CalculatorMap.create((ParameterProvider[])parameterArray);
            calculatorMap.putAll(map);
        }
        return calculatorMap;
    }

    public static boolean isShowParameterPanel(Repository repository) {
        return !ComparatorUtils.equals((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)repository.getHttpServletRequest(), (String)"__pi__"), (String)"false");
    }

    public static FileNode[] filterAndSortFile(FileNode[] fileNodeArray, String string) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        boolean bl = string.indexOf("cpt") > -1;
        boolean bl2 = string.indexOf("frm") > -1;
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            if (!ReportWebUtils.needToAddNode(bl, bl2, fileNodeArray, i2)) continue;
            arrayList.add(fileNodeArray[i2]);
        }
        FileNode[] fileNodeArray2 = new FileNode[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            fileNodeArray2[n2] = (FileNode)iterator.next();
            ++n2;
        }
        Arrays.sort(fileNodeArray2, new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof FileNode) || !(object instanceof FileNode)) {
                    return -1;
                }
                FileNode fileNode = (FileNode)object;
                FileNode fileNode2 = (FileNode)object2;
                int n2 = fileNode.isDirectory() ? (fileNode2.isDirectory() ? fileNode.getName().toLowerCase().compareTo(fileNode2.getName().toLowerCase()) : -1) : (fileNode2.isDirectory() ? 1 : fileNode.getName().toLowerCase().compareTo(fileNode2.getName().toLowerCase()));
                return n2;
            }
        });
        return fileNodeArray2;
    }

    private static boolean needToAddNode(boolean bl, boolean bl2, FileNode[] fileNodeArray, int n2) {
        return fileNodeArray[n2].isDirectory() || bl && CPT_FILTER.accept(fileNodeArray[n2]) || bl2 && FRM_FILTER.accept(fileNodeArray[n2]);
    }

    public static JSONArray getAllReportletsOfCurrentEnv(String string, IdGenerator idGenerator, String string2) {
        return ReportWebUtils.getReportletsOfCurrentEnv(string, idGenerator, string2);
    }

    public static JSONArray getReportletsOfCurrentEnv(String string, IdGenerator idGenerator, String string2) {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return jSONArray;
        }
        return ReportWebUtils.getReportletsOfCurrentEnv(fileNodeArray, idGenerator, string2);
    }

    public static JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, IdGenerator idGenerator, String string) {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile(fileNodeArray, string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put((Object)jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", (Object)fileNode.getName());
                jSONObject.put("value", (Object)fileNode.getName());
                jSONObject.put("path", (Object)string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", 1);
                jSONObject.put("write", 1);
                jSONObject.put("design", 1);
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                jSONObject.put("ChildNodes", (Object)ReportWebUtils.getReportletsOfCurrentEnv(fileNode.getEnvPath(), idGenerator, string));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            }
        }
        return jSONArray;
    }
}

