/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONException;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.cell.AbstractAnalyCellElement;
import com.fr.report.cell.AbstractWriteCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultPageCellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.fun.BackgroundPreDealProcessor;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import com.fr.web.output.common.CellUtils;
import com.fr.web.output.html.chwriter.CellHtmlWriter;
import com.fr.web.output.html.chwriter.HtmlWriteCellBox;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HTMLWriter {
    private static int ID = 0;
    private static HTMLWriter SC = new HTMLWriter();
    private static int ID_MAX = 2147482647;
    private static final int FIREHEIGHT = 33;
    private int contentHeight;

    protected HTMLWriter() {
    }

    public static HTMLWriter getInstance() {
        return SC;
    }

    protected static int _GENERATE_ID() {
        if (ID >= ID_MAX) {
            ID = 0;
        }
        return ++ID;
    }

    public Tag writeReportToHtml(WebReportCase webReportCase, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, String string) {
        int n3 = HTMLWriter._GENERATE_ID();
        cellHtmlWriter.setTableID(n3);
        return this.clipReport2Html(webReportCase, new Rectangle(0, 0, webReportCase.getColumnCount(), webReportCase.getRowCount()), n2, cellHtmlWriter, repository, false, string);
    }

    public Tag[] writeFrozenContentWithCenterCornerNW(Tag tag, WebReportCase webReportCase, ColumnRow columnRow, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, String string) {
        if (repository.getBrowser().shouldConsiderHeavyTD()) {
            cellHtmlWriter.setHeavy(true);
        }
        Tag tag2 = new Tag("div");
        Tag tag3 = new Tag("div");
        Tag tag4 = new Tag("div");
        Tag tag5 = new Tag("div");
        int n3 = HTMLWriter._GENERATE_ID();
        cellHtmlWriter.setTableID(n3);
        Tag tag6 = new Tag("table").cls("frozen-table");
        Tag tag7 = new Tag("tbody");
        Tag tag8 = new Tag("tr");
        Tag tag9 = new Tag("tr");
        Tag tag10 = new Tag("td");
        Tag tag11 = new Tag("td");
        Tag tag12 = new Tag("td");
        Tag tag13 = new Tag("td");
        this.dealWithFrozenTags(tag3, tag4, tag5, tag2, tag10, tag11, tag12, tag13, webReportCase, n2, cellHtmlWriter, repository, columnRow, tag8, tag9, string);
        tag7.sub((Html)tag8);
        tag7.sub((Html)tag9);
        tag6.attr("cellspacing", "0");
        tag6.attr("cellpadding", "0");
        tag6.sub((Html)tag7);
        tag.sub((Html)tag6);
        return new Tag[]{tag5, tag2};
    }

    private Tag createNorthTag(Tag tag, Tag tag2, WebReportCase webReportCase, ColumnRow columnRow, int n2, int n3, CellHtmlWriter cellHtmlWriter, boolean bl, String string, Repository repository, Tag tag3) {
        Tag tag4 = tag.ids("frozen-north").cls("frozen-north offset-c").css("position", "relative").css("overflow-y", "scroll").css("overflow-x", "hidden");
        tag2.sub((Html)tag4.sub((Html)this.clipReport2Html(webReportCase, new Rectangle(columnRow.getColumn(), 0, n2, columnRow.getRow()), n3, cellHtmlWriter, repository, false, false, bl, string).css("position", "relative")));
        if (repository.getBrowser().isFireFox() && this.contentHeight < 33) {
            tag4.css("height", this.contentHeight + "px");
        }
        tag3.sub((Html)tag2);
        return tag4;
    }

    private Tag createWestTag(Tag tag, Tag tag2, WebReportCase webReportCase, ColumnRow columnRow, boolean bl, String string, Tag tag3, int n2, int n3, CellHtmlWriter cellHtmlWriter, Repository repository) {
        Tag tag4 = tag.ids("frozen-west").cls("frozen-west offset-c").css("position", "relative").css("overflow-y", "hidden").css("overflow-x", "scroll");
        tag2.sub((Html)tag4.sub((Html)this.clipReport2Html(webReportCase, new Rectangle(0, columnRow.getRow(), columnRow.getColumn(), n2), n3, cellHtmlWriter, repository, false, false, bl, string).css("position", "relative")));
        tag2.attr("valign", "top");
        tag3.sub((Html)tag2);
        return tag4;
    }

    private Tag createCenterTag(Tag tag, Tag tag2, Tag tag3, WebReportCase webReportCase, ColumnRow columnRow, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, String string, int n2, int n3, int n4) {
        Tag tag4 = tag.ids("frozen-center").cls("frozen-center offset-c").css("position", "relative").css("overflow-x", "scroll").css("overflow-y", "scroll");
        tag2.sub((Html)tag4.sub((Html)this.clipReport2Html(webReportCase, new Rectangle(columnRow.getColumn(), columnRow.getRow(), n2, n3), n4, cellHtmlWriter, repository, true, true, bl, string).css("position", "relative")));
        tag2.attr("valign", "top");
        tag3.sub((Html)tag2);
        return tag4;
    }

    private Tag createCornerTag(Tag tag, Tag tag2, Tag tag3, WebReportCase webReportCase, ColumnRow columnRow, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, String string, int n2, int n3, int n4) {
        Tag tag4 = tag.ids("frozen-corner").cls("frozen-corner offset-c").css("position", "relative").css("overflow", "hidden");
        tag2.sub((Html)tag4.sub((Html)this.clipReport2Html(webReportCase, new Rectangle(0, 0, columnRow.getColumn(), columnRow.getRow()), n4, cellHtmlWriter, repository, false, false, bl, string).css("position", "relative")));
        tag3.sub((Html)tag2);
        return tag4;
    }

    private void dealWithFrozenTags(Tag tag, Tag tag2, Tag tag3, Tag tag4, Tag tag5, Tag tag6, Tag tag7, Tag tag8, WebReportCase webReportCase, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, ColumnRow columnRow, Tag tag9, Tag tag10, String string) {
        Tag tag11;
        boolean bl;
        boolean bl2 = repository.getBrowser().skipEmptyPart();
        int n3 = webReportCase.getColumnCount() - columnRow.getColumn();
        int n4 = webReportCase.getRowCount() - columnRow.getRow();
        boolean bl3 = columnRow.getColumn() > 0 && columnRow.getRow() > 0;
        boolean bl4 = n3 > 0 && columnRow.getRow() > 0;
        boolean bl5 = columnRow.getColumn() > 0 && n4 > 0;
        boolean bl6 = n3 > 0 && webReportCase.getRowCount() - columnRow.getRow() > 0;
        boolean bl7 = bl = repository.getBrowser().addHiddenTRAhead() && (bl3 && bl5 || bl4 && bl6);
        if (!bl2 || bl3) {
            tag11 = this.createCornerTag(tag, tag5, tag9, webReportCase, columnRow, cellHtmlWriter, repository, bl, string, n3, n4, n2);
        }
        if (!bl2 || bl4) {
            this.contentHeight = 0;
            tag11 = this.createNorthTag(tag2, tag6, webReportCase, columnRow, n3, n2, cellHtmlWriter, bl, string, repository, tag9);
        }
        if (!bl2 || bl5) {
            tag11 = this.createWestTag(tag3, tag7, webReportCase, columnRow, bl, string, tag10, n4, n2, cellHtmlWriter, repository);
        }
        if (!bl2 || bl6) {
            tag11 = this.createCenterTag(tag4, tag8, tag10, webReportCase, columnRow, cellHtmlWriter, repository, bl, string, n3, n4, n2);
        }
        this.dealFrozenOffset(tag, tag2, tag3, tag4, columnRow, webReportCase, repository);
    }

    private void dealFrozenOffset(Tag tag, Tag tag2, Tag tag3, Tag tag4, ColumnRow columnRow, WebReportCase webReportCase, Repository repository) {
        if (repository.getBrowser().fixFrozenOffsetByBorder()) {
            int n2;
            Object e2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Iterator iterator = webReportCase.getRow(0);
            while (iterator.hasNext()) {
                e2 = iterator.next();
                n7 = ((CellElement)e2).getColumn();
                if (n7 == 0 || n7 == columnRow.column) {
                    if (e2 == null) continue;
                    n2 = ((CellElement)e2).getStyle().getBorderLeftWidth();
                    if (n7 == 0) {
                        n3 = n2;
                        continue;
                    }
                    n5 = n2;
                    continue;
                }
                if (n7 <= columnRow.column) continue;
                break;
            }
            iterator = webReportCase.getRow(columnRow.row);
            while (iterator.hasNext()) {
                e2 = iterator.next();
                n7 = ((CellElement)e2).getColumn();
                if (n7 == 0 || n7 == columnRow.column) {
                    if (e2 == null) continue;
                    n2 = ((CellElement)e2).getStyle().getBorderLeftWidth();
                    if (n7 == 0) {
                        n4 = n2;
                        continue;
                    }
                    n6 = n2;
                    continue;
                }
                if (n7 <= columnRow.column) continue;
                break;
            }
            if (n3 == 0 && n4 == 0) {
                return;
            }
            if (n3 == 0 && n4 > 0) {
                tag.css("left", "1px");
            }
            if (n5 == 0 && n6 > 0) {
                tag2.css("left", "1px");
            }
        }
    }

    public void writeFrozenContent(Tag tag, WebReportCase webReportCase, ColumnRow columnRow, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, String string) {
        this.writeFrozenContentWithCenterCornerNW(tag, webReportCase, columnRow, n2, cellHtmlWriter, repository, string);
    }

    public void writeFrozenContent(Tag tag, WebReportCase webReportCase, ColumnRow columnRow, int n2, CellHtmlWriter cellHtmlWriter, Repository repository) {
        this.writeFrozenContentWithCenterCornerNW(tag, webReportCase, columnRow, n2, cellHtmlWriter, repository, "");
    }

    public Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository) {
        return this.clipReport2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, true);
    }

    private void addBlankTR(Tag tag, Rectangle rectangle) {
        int n2;
        Tag tag2 = new Tag("tr");
        int n3 = rectangle.width + n2;
        for (n2 = rectangle.x; n2 < n3; ++n2) {
            tag2.sub((Html)new Tag("td").attr("colSpan", "1").sub("&nbsp"));
        }
        tag.sub((Html)tag2);
    }

    private void addHiddenTR(Tag tag, Rectangle rectangle, boolean bl) {
        int n2;
        Tag tag2 = new Tag("tr");
        int n3 = rectangle.width + n2;
        for (n2 = rectangle.x; n2 < n3; ++n2) {
            Tag tag3 = new Tag("td");
            tag2.sub((Html)tag3.attr("colSpan", "1"));
        }
        tag2.css("height", "0");
        if (bl) {
            tag2.css("display", "none");
        }
        tag.sub((Html)tag2);
    }

    protected Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl) {
        return this.clipReport2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, false);
    }

    protected Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, String string) {
        return this.clipReport2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, false, false, string);
    }

    protected Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, boolean bl2) {
        return this.clipReport2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, bl2, false);
    }

    protected Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, boolean bl2, boolean bl3) {
        return this.clipReport2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, bl2, bl3, "");
    }

    protected Tag clipReport2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, boolean bl2, boolean bl3, String string) {
        BackgroundPreDealProcessor backgroundPreDealProcessor;
        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
        Tag tag = this.createTableTag(cellHtmlWriter, webReportCase, rectangle, repository, string);
        if (repository.getBrowser().shouldDoSomeStuff4MissingRightBorderOfTable()) {
            // empty if block
        }
        Tag tag2 = new Tag("tbody");
        tag.sub((Html)tag2);
        boolean[][] blArray = this.createArrayToMarkPainted(rectangle);
        Tag[] tagArray = !bl2 ? new Tag[1] : new Tag[2];
        CellElement[] cellElementArray = new CellElement[1];
        if (bl3) {
            this.addHiddenTR(tag2, rectangle, true);
        }
        if ((backgroundPreDealProcessor = (BackgroundPreDealProcessor)ExtraReportClassManager.getInstance().getSingle("BackgroundPreDealProcessor")) != null) {
            backgroundPreDealProcessor.backgroundPretreatment(repository, webReportCase, rectangle, cellHtmlWriter, bl);
        }
        this.writeClip2Html(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, tag2, tagArray, cellElementArray, blArray);
        this.dealWithLastCell(cellElementArray[0], rectangle, blArray, tag2, tagArray[0], webReportCase, repository, n2, cellHtmlWriter);
        if (repository.getBrowser().shouldAddHiddenTr()) {
            this.addHiddenTR(tag2, rectangle, false);
        }
        if (bl2) {
            boolean bl4;
            boolean bl5 = bl4 = tagArray[1] == null || ComparatorUtils.equals((String)tagArray[1].getCss("height"), (String)"0px");
            if (!bl4) {
                return tag;
            }
            this.addBlankTR(tag2, rectangle);
        }
        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
        return tag;
    }

    private void writeClip2Html(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, Tag tag, Tag[] tagArray, CellElement[] cellElementArray, boolean[][] blArray) {
        int n3;
        ArrayList[] arrayListArray = new ArrayList[webReportCase.getRowCount()];
        int[] nArray = new int[3];
        boolean bl2 = repository.getBrowser().fixRowByBorder();
        int n4 = n3 + rectangle.height;
        for (n3 = rectangle.y; n3 < n4; ++n3) {
            if ((n3 & 7) == 0) {
                MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
            }
            this.writeTr(webReportCase, rectangle, n2, cellHtmlWriter, repository, bl, tag, tagArray, cellElementArray, blArray, arrayListArray, nArray, n3, bl2);
        }
        tag.cls("rows-height-counter");
        this.appendBlankTD(repository, tag);
    }

    private void appendBlankTD(Repository repository, Tag tag) {
        if (repository.getBrowser().isNeedAppendBlankTD()) {
            List list = tag.getSubHtmlList();
            if (list == null) {
                return;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Tag tag2 = (Tag)list.get(i2);
                if (tag2 == null || tag2.getSubHtmlList() != null) continue;
                tag2.sub((Html)new Tag("td"));
            }
        }
    }

    private Widget getWidget(ResultCellElement resultCellElement) {
        if (resultCellElement.isWriter()) {
            return ((AbstractWriteCellElement)resultCellElement).getWidget();
        }
        return ((AbstractAnalyCellElement)resultCellElement).getWidget();
    }

    private void writeTr(WebReportCase webReportCase, Rectangle rectangle, int n2, CellHtmlWriter cellHtmlWriter, Repository repository, boolean bl, Tag tag, Tag[] tagArray, CellElement[] cellElementArray, boolean[][] blArray, ArrayList[] arrayListArray, int[] nArray, int n3, boolean bl2) {
        tagArray[0] = this.paintFirstRow(webReportCase, cellHtmlWriter, tag, tagArray[0], rectangle, n2, n3);
        if (n3 == rectangle.y) {
            nArray[1] = webReportCase.getRowPixHeight(n3);
        }
        HtmlWriteCellBox[] htmlWriteCellBoxArray = this.initCellsForCurrentRow(webReportCase, rectangle, n3, bl);
        boolean bl3 = false;
        this.dealMergeCell(arrayListArray, n3, htmlWriteCellBoxArray);
        for (int i2 = 0; i2 < htmlWriteCellBoxArray.length; ++i2) {
            Object object;
            if (htmlWriteCellBoxArray[i2] == null) continue;
            HtmlWriteCellBox htmlWriteCellBox = htmlWriteCellBoxArray[i2];
            ResultCellElement resultCellElement = htmlWriteCellBox.getCell();
            if ((resultCellElement.isWriter() || resultCellElement.isView()) && (object = this.getWidget(resultCellElement)) != null && ComparatorUtils.equals((String)object.getXType(), (String)"button")) {
                bl3 = true;
            }
            object = rectangle.intersection(CellUtils.getTmpCellRect(resultCellElement, webReportCase));
            if (object.width <= 0 || object.height <= 0) continue;
            cellElementArray[0] = resultCellElement;
            int n4 = object.y - rectangle.y;
            int n5 = object.x - rectangle.x;
            if (nArray[0] < n4) {
                tagArray[0] = this.writeNewLine(webReportCase, rectangle, repository, tag, tagArray[0], blArray, nArray, n4, n2, cellHtmlWriter);
            }
            this.fixRowHeight(nArray, resultCellElement, webReportCase, repository, n3, bl2);
            this.fillBlankTD(tagArray[0], blArray, n4, n5, n2, cellHtmlWriter.getTableID(), rectangle, webReportCase, repository);
            this.fillFrozenContentTD(blArray, n4, n5, object.height, object.width);
            Rectangle rectangle2 = new Rectangle(object.x, object.y, object.width, object.height);
            if (rectangle2.height > 1 || rectangle2.width > 1) {
                this.writeMergeCells(webReportCase, rectangle2, resultCellElement, htmlWriteCellBox, (Rectangle)object, n3, htmlWriteCellBoxArray, arrayListArray, repository, cellHtmlWriter);
            }
            this.writeCellElement(tagArray[0], rectangle2, (Rectangle)object, rectangle, resultCellElement, htmlWriteCellBox, webReportCase, cellHtmlWriter, nArray);
        }
        this.setRowHeight(tagArray, nArray, bl3);
    }

    private void fixRowHeight(int[] nArray, ResultCellElement resultCellElement, WebReportCase webReportCase, Repository repository, int n2, boolean bl) {
        int n3 = resultCellElement.getStyle().getBorderTop();
        int n4 = resultCellElement.getStyle().getBorderBottom();
        int n5 = webReportCase.getRowPixHeight(n2);
        if (bl && resultCellElement.getRowSpan() == 1) {
            nArray[1] = Math.min(n5 -= Math.min(Math.max(n3, n4), 3), nArray[1]);
        }
    }

    private void setRowHeight(Tag[] tagArray, int[] nArray, boolean bl) {
        if (bl) {
            nArray[1] = nArray[1] + 2;
        }
        tagArray[0].css("height", nArray[1] + "px");
        if (tagArray.length > 1) {
            tagArray[1] = tagArray[1] == null ? new Tag("tr").css("height", "0px") : tagArray[1];
            String string = tagArray[1].getCss("height");
            if (ComparatorUtils.equals((String)string, (String)"0px")) {
                tagArray[1].css("height", tagArray[0].getCss("height"));
            }
        }
    }

    private void writeCellElement(Tag tag, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, ResultCellElement resultCellElement, HtmlWriteCellBox htmlWriteCellBox, WebReportCase webReportCase, CellHtmlWriter cellHtmlWriter, int[] nArray) {
        try {
            Tag tag2 = cellHtmlWriter.cell2Tag(htmlWriteCellBox, webReportCase, rectangle, rectangle2, Calculator.createCalculator());
            tag.sub((Html)tag2);
            this.dealWithTdTag(tag2, rectangle3, resultCellElement.getColumn() - rectangle3.x, resultCellElement.getRow() - rectangle3.y);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    private void writeMergeCells(WebReportCase webReportCase, Rectangle rectangle, ResultCellElement resultCellElement, HtmlWriteCellBox htmlWriteCellBox, Rectangle rectangle2, int n2, HtmlWriteCellBox[] htmlWriteCellBoxArray, ArrayList[] arrayListArray, Repository repository, CellHtmlWriter cellHtmlWriter) {
        if (webReportCase.getRowPixHeight(n2) == 0 || webReportCase.getColumnPixWidth(resultCellElement.getColumn()) == 0) {
            int n3;
            int n4 = n2;
            int n5 = resultCellElement.getColumn();
            int n6 = rectangle.height;
            int n7 = rectangle.width;
            if (rectangle.height > 1) {
                for (n3 = 0; n3 < rectangle.height && webReportCase.getRowPixHeight(n4 = n2 + n3) <= 0; ++n3) {
                    --n6;
                }
            }
            if (n6 > 0 && rectangle.width > 1) {
                for (n3 = 0; n3 < rectangle.width && webReportCase.getColumnPixWidth(n5 = resultCellElement.getColumn() + n3) <= 0; ++n3) {
                    --n7;
                }
            }
            if (n6 > 0 && n7 > 0) {
                this.splitNewCellFromMergeCell(rectangle, resultCellElement, htmlWriteCellBox, n5, n4, n7, n6, rectangle2, n2, htmlWriteCellBoxArray, arrayListArray, webReportCase);
            }
        } else {
            this.dealNotTotalHiddenMergeCells(webReportCase, cellHtmlWriter, repository, resultCellElement, rectangle, n2);
        }
    }

    private void splitNewCellFromMergeCell(Rectangle rectangle, ResultCellElement resultCellElement, HtmlWriteCellBox htmlWriteCellBox, int n2, int n3, int n4, int n5, Rectangle rectangle2, int n6, HtmlWriteCellBox[] htmlWriteCellBoxArray, ArrayList[] arrayListArray, WebReportCase webReportCase) {
        ResultCellElement resultCellElement2 = null;
        try {
            int n7 = webReportCase.getRowByIdx(n3);
            resultCellElement2 = (ResultCellElement)resultCellElement.clone(n2, n7, n4, n5);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            resultCellElement2 = new DefaultPageCellElement(n2, n3, n4, n5, resultCellElement.getValue());
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
        HtmlWriteCellBox htmlWriteCellBox2 = new HtmlWriteCellBox(resultCellElement2);
        htmlWriteCellBox2.setHtmlID(CellHtmlWriter.retriveCellElementPositions(resultCellElement));
        htmlWriteCellBox.setBoxUSELESS();
        rectangle.height = 1;
        rectangle.width = 1;
        rectangle2.height = 1;
        rectangle2.width = 1;
        if (n3 == n6) {
            htmlWriteCellBoxArray[n2] = htmlWriteCellBox2;
        } else {
            if (arrayListArray[n3] == null) {
                arrayListArray[n3] = new ArrayList();
            }
            arrayListArray[n3].add(htmlWriteCellBox2);
        }
    }

    private void dealNotTotalHiddenMergeCells(WebReportCase webReportCase, CellHtmlWriter cellHtmlWriter, Repository repository, ResultCellElement resultCellElement, Rectangle rectangle, int n2) {
        int n3;
        int n4 = rectangle.height;
        int n5 = rectangle.width;
        if (repository.getBrowser().justDealWithTheHiddenRowsOfTail(cellHtmlWriter.mayHideTailRows())) {
            for (n3 = n4 - 1; n3 > 0 && webReportCase.getRowPixHeight(n2 + n3) <= 0; --n3) {
                --rectangle.height;
            }
        } else {
            for (n3 = 1; n3 < n4; ++n3) {
                if (webReportCase.getRowPixHeight(n2 + n3) > 0) continue;
                --rectangle.height;
            }
        }
        for (n3 = 1; n3 < n5; ++n3) {
            if (webReportCase.getColumnPixWidth(resultCellElement.getColumn() + n3) > 0) continue;
            --rectangle.width;
        }
    }

    protected Tag writeNewLine(WebReportCase webReportCase, Rectangle rectangle, Repository repository, Tag tag, Tag tag2, boolean[][] blArray, int[] nArray, int n2, int n3, CellHtmlWriter cellHtmlWriter) {
        for (int i2 = nArray[0]; i2 < n2; ++i2) {
            int n4 = webReportCase.getRowByIdx(i2 + 1);
            this.fillBlankTD(tag2, blArray, i2, rectangle.width, n3, cellHtmlWriter.getTableID(), rectangle, webReportCase, repository);
            nArray[1] = webReportCase.getRowPixHeight(i2 + 1 + rectangle.y);
            tag2 = new Tag("tr").attr("id", "r-" + (n4 + rectangle.y) + "-" + n3).attr("tridx", "" + (n4 + rectangle.y));
            tag.sub((Html)tag2.css("height", nArray[1] + "px"));
            this.contentHeight += nArray[1];
            this.dealWithTrTag(tag2, i2 + 1);
            if (nArray[1] != 0) continue;
            cellHtmlWriter.dealWithEmptyHeight(tag2);
        }
        nArray[0] = n2;
        return tag2;
    }

    private void dealWithLastCell(CellElement cellElement, Rectangle rectangle, boolean[][] blArray, Tag tag, Tag tag2, WebReportCase webReportCase, Repository repository, int n2, CellHtmlWriter cellHtmlWriter) {
        if (cellElement != null) {
            Tag tag3;
            int n3;
            int n4 = webReportCase.getIdxByRow(cellElement.getRow());
            this.fillBlankTD(tag2, blArray, n4 - rectangle.y, rectangle.width, n2, cellHtmlWriter.getTableID(), rectangle, webReportCase, repository);
            int n5 = cellElement.getRowSpan();
            boolean bl = repository.getBrowser().isNeedAppendBlankTD();
            for (n3 = 1; n3 < n5; ++n3) {
                tag3 = this.fillBlankTR(webReportCase.getRowPixHeight(n3 + cellElement.getRow()));
                tag3.attr("id", "r-" + (cellElement.getRow() + n3) + "-" + n2).attr("tridx", "" + (n3 + cellElement.getRow()));
                this.fillBlankTD(tag3, blArray, cellElement.getRow() + n3 - rectangle.y, rectangle.width, n2, cellHtmlWriter.getTableID(), rectangle, webReportCase, repository);
                tag.sub((Html)tag3);
                this.contentHeight += webReportCase.getRowPixHeight(n3 + cellElement.getRow());
                this.dealWithTrTag(tag3, n3 + cellElement.getRow() - rectangle.y);
                if (!bl || tag3.getSubHtmlList() != null) continue;
                tag3.sub((Html)new Tag("td"));
            }
            for (int i2 = n3 = rectangle.height + rectangle.y - cellElement.getRow() - cellElement.getRowSpan(); i2 > 0; --i2) {
                tag3 = this.fillBlankTR(webReportCase.getRowPixHeight(rectangle.height + rectangle.y - i2));
                tag3.attr("tridx", "" + (rectangle.height + rectangle.y - i2));
                tag.sub((Html)tag3);
                this.contentHeight += webReportCase.getRowPixHeight(rectangle.height + rectangle.y - i2);
                this.dealWithTrTag(tag3, rectangle.height - i2);
            }
        }
    }

    protected Tag createTableTag(CellHtmlWriter cellHtmlWriter, WebReportCase webReportCase, Rectangle rectangle, Repository repository, String string) {
        int n2;
        Tag tag = new Tag("table").cls("x-table").attr("id", Utils.doubleToString((double)cellHtmlWriter.getTableID())).attr("cellSpacing", "0").attr("cellPadding", "0");
        if (StringUtils.isNotEmpty((String)string)) {
            tag.cls(string + "table");
        }
        cellHtmlWriter.setTablePosition(tag);
        tag.css("table-layout", "fixed");
        Tag tag2 = new Tag("colgroup");
        tag.sub((Html)tag2);
        int n3 = 0;
        int[] nArray = webReportCase.getMinColWidths();
        int n4 = rectangle.width + n2;
        for (n2 = rectangle.x; n2 < n4; ++n2) {
            int n5 = webReportCase.getColumnPixWidth(n2);
            if (n5 == 0) continue;
            Tag tag3 = new Tag("col").attr("col", n2 + "").css("width", n5 + "px");
            if (StringUtils.isNotEmpty((String)string)) {
                tag3.cls(string + "col");
                tag3.css("min-width", nArray[n2] + "px");
                tag3.attr("c-w", GeneralUtils.objectToString((Object)n5));
            }
            tag2.sub((Html)tag3);
            n3 += n5;
        }
        if (rectangle.height == 0) {
            ++n3;
        }
        this.setTableWidth(tag, n3);
        return tag;
    }

    private void setTableWidth(Tag tag, int n2) {
        tag.css("width", n2 + "px");
    }

    private boolean[][] createArrayToMarkPainted(Rectangle rectangle) {
        boolean[][] blArrayArray = new boolean[rectangle.height][];
        for (int i2 = 0; i2 < blArrayArray.length && rectangle.width >= 0; ++i2) {
            blArrayArray[i2] = new boolean[rectangle.width];
            for (int i3 = 0; i3 < blArrayArray[i2].length; ++i3) {
                blArrayArray[i2][i3] = false;
            }
        }
        return blArrayArray;
    }

    private Tag paintFirstRow(WebReportCase webReportCase, CellHtmlWriter cellHtmlWriter, Tag tag, Tag tag2, Rectangle rectangle, int n2, int n3) {
        if (n3 == rectangle.y) {
            int n4 = webReportCase.getRowPixHeight(n3);
            int n5 = webReportCase.getRowByIdx(n3);
            tag2 = new Tag("tr").attr("id", "r-" + n5 + "-" + n2).attr("tridx", "" + n5);
            tag.sub((Html)tag2.css("height", n4 + "px"));
            this.dealWithTrTag(tag2, n3 - rectangle.y);
            if (n4 == 0) {
                cellHtmlWriter.dealWithEmptyHeight(tag2);
            }
            this.contentHeight += n4;
        }
        return tag2;
    }

    private HtmlWriteCellBox[] initCellsForCurrentRow(WebReportCase webReportCase, Rectangle rectangle, int n2, boolean bl) {
        HtmlWriteCellBox[] htmlWriteCellBoxArray = new HtmlWriteCellBox[webReportCase.getColumnCount()];
        Iterator iterator = webReportCase.getRow(n2);
        while (iterator.hasNext()) {
            ResultCellElement resultCellElement = (ResultCellElement)iterator.next();
            if (this.shouldIgnoreCellContent(webReportCase, resultCellElement, rectangle, bl)) {
                try {
                    resultCellElement = (ResultCellElement)resultCellElement.clone();
                    resultCellElement.setValue(null);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                }
            }
            htmlWriteCellBoxArray[resultCellElement.getColumn()] = new HtmlWriteCellBox(resultCellElement);
        }
        return htmlWriteCellBoxArray;
    }

    private boolean shouldIgnoreCellContent(WebReportCase webReportCase, CellElement cellElement, Rectangle rectangle, boolean bl) {
        int n2 = cellElement.getColumn();
        int n3 = webReportCase.getIdxByRow(cellElement.getRow());
        return !bl && n3 >= rectangle.y && n2 >= rectangle.x && (n3 + cellElement.getRowSpan() > rectangle.y + rectangle.height || n2 + cellElement.getColumnSpan() > rectangle.x + rectangle.width);
    }

    private void dealMergeCell(ArrayList[] arrayListArray, int n2, HtmlWriteCellBox[] htmlWriteCellBoxArray) {
        if (arrayListArray.length > n2 && arrayListArray[n2] != null) {
            ArrayList arrayList = arrayListArray[n2];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                HtmlWriteCellBox htmlWriteCellBox;
                htmlWriteCellBoxArray[htmlWriteCellBox.getCell().getColumn()] = htmlWriteCellBox = (HtmlWriteCellBox)arrayList.get(i2);
            }
        }
    }

    protected void dealWithTrTag(Tag tag, int n2) {
    }

    protected void dealWithTdTag(Tag tag, Rectangle rectangle, int n2, int n3) {
    }

    protected void fillBlankTD(Tag tag, boolean[][] blArray, int n2, int n3, int n4, int n5, Rectangle rectangle, WebReportCase webReportCase, Repository repository) {
        if (n3 < 0 || n2 < 0) {
            return;
        }
        for (int i2 = 0; i2 < n3 && n2 < blArray.length && i2 < blArray[0].length; ++i2) {
            if (blArray[n2][i2]) continue;
            blArray[n2][i2] = true;
            Tag tag2 = new Tag("td");
            tag.sub((Html)tag2);
            int n6 = webReportCase.getRowByIdx(n2);
            tag2.attr("id", ColumnRow.valueOf((int)(rectangle.x + i2), (int)(n6 + rectangle.y)) + "-" + n4 + "-" + n5).attr("row", "" + (n2 + rectangle.y)).attr("col", "" + (rectangle.x + i2));
            this.dealWithTdTag(tag2, rectangle, i2, n2);
            ReportHTMLWriterUtils.contentStyle2CssExceptBorderAndBackground(Style.DEFAULT_STYLE, tag2);
            ReportHTMLWriterUtils.style2CssOnlyWithBorder(Style.DEFAULT_STYLE, tag2);
            if (webReportCase.getColumnPixWidth(rectangle.x + i2) != 0) continue;
            tag2.css("display", "none");
        }
    }

    protected void fillFrozenContentTD(boolean[][] blArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n5; ++i3) {
                blArray[i2 + n2][i3 + n3] = true;
            }
        }
    }

    protected Tag fillBlankTR(int n2) {
        Tag tag = new Tag("tr");
        if (n2 == 0) {
            tag.css("display", "none");
        } else {
            tag.css("height", n2 + "px");
        }
        return tag;
    }
}

