/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.report.cell.CellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.stable.ColumnRow;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SheetUtils {
    private SheetUtils() {
    }

    private static TemplateCellElement getUpParent(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
        if (cellExpandAttr != null && cellExpandAttr.getUpParentColumnRow() != null) {
            return templateElementCase.getTemplateCellElement(templateCellElement.getCellExpandAttr().getUpParentColumnRow().column, templateCellElement.getCellExpandAttr().getUpParentColumnRow().row);
        }
        return null;
    }

    private static boolean isUpCycle(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        boolean bl = false;
        HashSet<TemplateCellElement> hashSet = new HashSet<TemplateCellElement>();
        int n2 = 1;
        hashSet.add(templateCellElement);
        TemplateCellElement templateCellElement2 = SheetUtils.getUpParent(templateElementCase, templateCellElement);
        while (templateCellElement2 != null) {
            hashSet.add(templateCellElement2);
            if (hashSet.size() != ++n2) {
                bl = true;
                break;
            }
            templateCellElement2 = SheetUtils.getUpParent(templateElementCase, templateCellElement2);
        }
        return bl;
    }

    private static TemplateCellElement getLeftParent(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        if (templateCellElement.getCellExpandAttr().getLeftParentColumnRow() != null) {
            return templateElementCase.getTemplateCellElement(templateCellElement.getCellExpandAttr().getLeftParentColumnRow().column, templateCellElement.getCellExpandAttr().getLeftParentColumnRow().row);
        }
        return null;
    }

    private static boolean isLeftCycle(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        boolean bl = false;
        HashSet<TemplateCellElement> hashSet = new HashSet<TemplateCellElement>();
        int n2 = 1;
        hashSet.add(templateCellElement);
        TemplateCellElement templateCellElement2 = SheetUtils.getLeftParent(templateElementCase, templateCellElement);
        while (templateCellElement2 != null) {
            hashSet.add(templateCellElement2);
            if (hashSet.size() != ++n2) {
                bl = true;
                break;
            }
            templateCellElement2 = SheetUtils.getLeftParent(templateElementCase, templateCellElement2);
        }
        return bl;
    }

    public static void calculateDefaultParent(TemplateElementCase templateElementCase) {
        int n2;
        int n3;
        int n4;
        CellExpandAttr cellExpandAttr;
        Object object;
        Object object2;
        int n5;
        if (templateElementCase == null) {
            return;
        }
        int n6 = templateElementCase.getColumnCount();
        int n7 = templateElementCase.getRowCount();
        CellElement[] cellElementArray = new CellElement[n6];
        CellElement[] cellElementArray2 = new CellElement[n6];
        for (n5 = 0; n5 < n7; ++n5) {
            object2 = templateElementCase.getRow(n5);
            while (object2.hasNext()) {
                int n8;
                object = (TemplateCellElement)object2.next();
                if (object == null) continue;
                cellExpandAttr = object.getCellExpandAttr();
                if (cellExpandAttr == null) {
                    cellExpandAttr = new CellExpandAttr();
                    cellExpandAttr.setDirection((byte)2);
                    object.setCellExpandAttr(cellExpandAttr);
                }
                if (cellExpandAttr.isUpParentDefault()) {
                    CellElement cellElement = null;
                    n4 = object.getColumn();
                    n3 = object.getColumnSpan();
                    for (n8 = 0; n8 < n3 && ((cellElement = cellElementArray[n8 + n4]) == null || cellElement == object); ++n8) {
                    }
                    cellExpandAttr.setUpParentColumnRow(cellElement == null || cellElement == object ? null : ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow()));
                    if (SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)object)) {
                        cellExpandAttr.setUpParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement2 = null;
                        n2 = object.getColumnSpan();
                        for (n3 = 0; n3 < n2 && ((cellElement2 = cellElementArray2[n3 + n4]) == null || cellElement2 == object); ++n3) {
                        }
                        cellExpandAttr.setUpParentColumnRow(cellElement2 == null || cellElement2 == object ? null : ColumnRow.valueOf((int)cellElement2.getColumn(), (int)cellElement2.getRow()));
                    }
                }
                if (!SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)object)) {
                    n4 = object.getColumnSpan();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        cellElementArray2[i2 + object.getColumn()] = cellElementArray[i2 + object.getColumn()];
                    }
                }
                if (cellExpandAttr.getDirection() == 1) {
                    int n9 = object.getColumn();
                    n8 = object.getColumnSpan();
                    for (n4 = 0; n4 < n8; ++n4) {
                        if (SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)object)) continue;
                        cellElementArray[n4 + n9] = object;
                    }
                    continue;
                }
                if (cellExpandAttr.isUpParentDefault() || cellExpandAttr.getUpParentColumnRow() != null) continue;
                int n10 = object.getColumn();
                n8 = object.getColumnSpan();
                for (n4 = 0; n4 < n8; ++n4) {
                    cellElementArray[n4 + n10] = null;
                }
            }
        }
        cellElementArray = new CellElement[n7];
        cellElementArray2 = new CellElement[n7];
        for (n5 = 0; n5 < n6; ++n5) {
            object2 = templateElementCase.getColumn(n5);
            while (object2.hasNext()) {
                object = (TemplateCellElement)object2.next();
                if (object == null) continue;
                cellExpandAttr = object.getCellExpandAttr();
                if (cellExpandAttr == null) {
                    cellExpandAttr = new CellExpandAttr();
                    cellExpandAttr.setDirection((byte)2);
                    object.setCellExpandAttr(cellExpandAttr);
                }
                if (cellExpandAttr.isLeftParentDefault()) {
                    CellElement cellElement = null;
                    n4 = object.getRow();
                    n3 = object.getRowSpan();
                    for (int i3 = 0; i3 < n3 && ((cellElement = cellElementArray[i3 + n4]) == null || cellElement == object); ++i3) {
                    }
                    cellExpandAttr.setLeftParentColumnRow(cellElement == null || cellElement == object ? null : ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow()));
                    if (SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)object)) {
                        cellExpandAttr.setLeftParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement3 = null;
                        n2 = object.getRowSpan();
                        for (n3 = 0; n3 < n2 && ((cellElement3 = cellElementArray2[n3 + n4]) == null || cellElement3 == object); ++n3) {
                        }
                        cellExpandAttr.setLeftParentColumnRow(cellElement3 == null || cellElement3 == object ? null : ColumnRow.valueOf((int)cellElement3.getColumn(), (int)cellElement3.getRow()));
                    }
                }
                if (!SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)object)) {
                    n4 = object.getRowSpan();
                    for (int i4 = 0; i4 < n4; ++i4) {
                        cellElementArray2[i4 + object.getRow()] = cellElementArray[i4 + object.getRow()];
                    }
                }
                if (cellExpandAttr.getDirection() == 0) {
                    int n11 = object.getRow();
                    int n12 = object.getRowSpan();
                    for (n4 = 0; n4 < n12; ++n4) {
                        if (SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)object)) continue;
                        cellElementArray[n4 + n11] = object;
                    }
                    continue;
                }
                if (cellExpandAttr.isLeftParentDefault() || cellExpandAttr.getLeftParentColumnRow() != null) continue;
                int n13 = object.getRow();
                int n14 = object.getRowSpan();
                for (n4 = 0; n4 < n14; ++n4) {
                    cellElementArray[n4 + n13] = null;
                }
            }
        }
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement;
            Object object3;
            object2 = (TemplateCellElement)iterator.next();
            if (object2 == null) continue;
            object = object2.getCellExpandAttr();
            cellExpandAttr = ((CellExpandAttr)object).getLeftParentColumnRow();
            if (cellExpandAttr != null && (object3 = templateElementCase.getCellElement(((ColumnRow)cellExpandAttr).column, ((ColumnRow)cellExpandAttr).row)) != null) {
                SheetUtils.setAreaDefaultLeftParent(templateElementCase, (CellElement)object3, (CellElement)object2);
            }
            if ((object3 = ((CellExpandAttr)object).getUpParentColumnRow()) == null || (cellElement = templateElementCase.getCellElement(object3.column, object3.row)) == null) continue;
            SheetUtils.setAreaDefaultUpParent(templateElementCase, cellElement, (CellElement)object2);
        }
    }

    private static void setAreaDefaultLeftParent(TemplateElementCase templateElementCase, CellElement cellElement, CellElement cellElement2) {
        int n2 = cellElement.getRow();
        int n3 = cellElement.getRow() + cellElement.getRowSpan() - 1;
        int n4 = cellElement.getColumn();
        int n5 = cellElement2.getRow();
        int n6 = cellElement2.getRow() + cellElement2.getRowSpan() - 1;
        if (n3 == n6) {
            if (n2 <= n5) {
                return;
            }
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf((int)n4, (int)n2), templateElementCase, n5, n2 - 1);
        } else if (n3 < n5) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf((int)n4, (int)n2), templateElementCase, n3 + 1, n5);
        } else if (n6 < n2) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf((int)n4, (int)n2), templateElementCase, n6, n2 - 1);
        }
    }

    private static void setAreaDefaultUpParent(TemplateElementCase templateElementCase, CellElement cellElement, CellElement cellElement2) {
        int n2 = cellElement.getRow();
        int n3 = cellElement.getColumn();
        int n4 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
        int n5 = cellElement2.getColumn();
        int n6 = cellElement2.getColumn() + cellElement2.getColumnSpan() - 1;
        if (n4 == n6) {
            if (n3 <= n5) {
                return;
            }
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf((int)n3, (int)n2), templateElementCase, n5, n3 - 1);
        } else if (n4 < n5) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf((int)n3, (int)n2), templateElementCase, n4 + 1, n5);
        } else if (n6 < n3) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf((int)n3, (int)n2), templateElementCase, n6, n3 - 1);
        }
    }

    private static void setDefaultLeftParent(ColumnRow columnRow, TemplateElementCase templateElementCase, int n2, int n3) {
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            int n4 = templateCellElement.getRow();
            if (n4 < n2 || n4 > n3 || (object = templateCellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = templateCellElement.getCellExpandAttr()).isLeftParentDefault() || cellExpandAttr.getLeftParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(templateElementCase, columnRow, ColumnRow.valueOf((int)templateCellElement.getColumn(), (int)templateCellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setLeftParentColumnRow(columnRow);
        }
    }

    private static void setDefaultUpParent(ColumnRow columnRow, TemplateElementCase templateElementCase, int n2, int n3) {
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            int n4 = templateCellElement.getColumn();
            if (n4 < n2 || n4 > n3 || (object = templateCellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = templateCellElement.getCellExpandAttr()).isUpParentDefault() || cellExpandAttr.getUpParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(templateElementCase, columnRow, ColumnRow.valueOf((int)templateCellElement.getColumn(), (int)templateCellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setUpParentColumnRow(columnRow);
        }
    }

    private static boolean willLeadToDeathCircle(TemplateElementCase templateElementCase, ColumnRow columnRow, ColumnRow columnRow2, Set set) {
        if (columnRow == null || columnRow2 == null) {
            return false;
        }
        TemplateCellElement templateCellElement = templateElementCase.getTemplateCellElement(columnRow.column, columnRow.row);
        if (templateCellElement == null) {
            return false;
        }
        if (templateCellElement.getCellExpandAttr() != null) {
            CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
            ColumnRow columnRow3 = cellExpandAttr.getLeftParentColumnRow();
            ColumnRow columnRow4 = cellExpandAttr.getUpParentColumnRow();
            if (set.contains(columnRow3) || set.contains(columnRow4)) {
                return true;
            }
            if (columnRow2.equals((Object)cellExpandAttr.getLeftParentColumnRow()) || columnRow2.equals((Object)cellExpandAttr.getUpParentColumnRow())) {
                return true;
            }
            if (columnRow3 != null) {
                set.add(columnRow3);
            }
            if (columnRow4 != null) {
                set.add(columnRow4);
            }
            return SheetUtils.willLeadToDeathCircle(templateElementCase, cellExpandAttr.getLeftParentColumnRow(), columnRow2, set) && SheetUtils.willLeadToDeathCircle(templateElementCase, cellExpandAttr.getUpParentColumnRow(), columnRow2, set);
        }
        return false;
    }
}

