/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.itf25;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import com.fr.third.com.lowagie.text.pdf.BarcodeInter25;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class ITF25Barcode
extends BarcodeImpl {
    public BarcodeInter25 inter25;
    private int height;
    private int width;
    private String data;
    private String label;
    private boolean drawLabel;
    private static final byte[][] BARS = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public ITF25Barcode(String string, int n2, double d2, boolean bl) throws BarcodeException {
        super(string);
        this.height = n2;
        this.width = (int)d2;
        this.data = string;
        this.label = string;
        this.drawLabel = bl;
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        int n4 = (this.data.length() * 7 + 8) * this.width;
        int n5 = n3 - this.height / 2;
        int n6 = n2 - n4 / 2;
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setColor(Color.BLACK);
        Image image = this.createAwtImage(this.data, true, 2, this.height, Color.black, Color.white);
        graphics2D.drawImage(image, n6, n5, image.getWidth(null), image.getHeight(null), null);
        if (this.drawLabel) {
            int n7;
            String string = "";
            int n8 = this.width - 1;
            for (n7 = 0; n7 < this.width + 1; ++n7) {
                string = string + " ";
            }
            for (n7 = 0; n7 < this.label.length(); ++n7) {
                string = string + this.label.substring(n7, n7 + 1);
                for (int i2 = 0; i2 < n8; ++i2) {
                    string = string + " ";
                }
            }
            graphics2D.drawString(string, n6 + n8, n5 + this.height + 15);
        }
    }

    public int getWidth() {
        return 50;
    }

    public int getHeight() {
        return 50;
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module[] encodeData() {
        return null;
    }

    protected double getBarcodeWidth(int n2) {
        return 0.0;
    }

    protected Module getPostAmble() {
        return null;
    }

    protected Module getPreAmble() {
        return null;
    }

    public Image createAwtImage(String string, boolean bl, int n2, int n3, Color color, Color color2) {
        int n4;
        int n5 = color.getRGB();
        int n6 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string2 = ITF25Barcode.keepNumbers(string);
        if (bl) {
            string2 = string2 + ITF25Barcode.getChecksum(string2);
        }
        int n7 = string2.length();
        int n8 = n2;
        int n9 = (n7 * (3 + 2 * n8) + (6 + n8)) * this.width;
        byte[] byArray = ITF25Barcode.getBarsInter25(string2);
        boolean bl2 = true;
        int n10 = 0;
        int n11 = n3;
        int[] nArray = new int[n9 * n11];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            int n12 = byArray[n4] == 0 ? 1 * this.width : n8 * this.width;
            int n13 = n6;
            if (bl2) {
                n13 = n5;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < n12; ++i2) {
                nArray[n10++] = n13;
            }
        }
        for (n4 = n9; n4 < nArray.length; n4 += n9) {
            System.arraycopy(nArray, 0, nArray, n4, n9);
        }
        Image image = canvas.createImage(new MemoryImageSource(n9, n11, nArray, 0, n9));
        return image;
    }

    public static char getChecksum(String string) {
        int n2 = 3;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n4 = string.charAt(i2) - 48;
            n3 += n2 * n4;
            n2 ^= 2;
        }
        return (char)((10 - n3 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        string = ITF25Barcode.keepNumbers(string);
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n2 = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        int n3 = string.length() / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string.charAt(i2 * 2) - 48;
            int n5 = string.charAt(i2 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n4];
            byte[] byArray3 = BARS[n5];
            for (int i3 = 0; i3 < 5; ++i3) {
                byArray[n2++] = byArray2[i3];
                byArray[n2++] = byArray3[i3];
            }
        }
        byArray[n2++] = 1;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        return byArray;
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    protected Dimension draw(GraphicsOutput graphicsOutput, int n2, int n3, double d2, double d3) {
        return null;
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        return null;
    }
}

