/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.base.Style;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.report.cell.cellattr.highlight.AbstractStyleHighlightAction;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class ForegroundHighlightAction
extends AbstractStyleHighlightAction {
    private Color foregroundColor = Color.black;

    public ForegroundHighlightAction() {
    }

    public ForegroundHighlightAction(Color color, int n2) {
        super(n2);
        this.foregroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    protected Style modStyle(Style style) {
        FRFont fRFont = style.getFRFont();
        fRFont = fRFont.applyForeground(this.foregroundColor);
        return style.deriveFRFont(fRFont);
    }

    public boolean equals(Object object) {
        return object instanceof ForegroundHighlightAction && super.equals(object) && ComparatorUtils.equals((Object)this.foregroundColor, (Object)((ForegroundHighlightAction)object).foregroundColor);
    }

    public Object clone() throws CloneNotSupportedException {
        ForegroundHighlightAction foregroundHighlightAction = (ForegroundHighlightAction)super.clone();
        foregroundHighlightAction.setForegroundColor(new Color(this.getForegroundColor().getRGB(), true));
        return foregroundHighlightAction;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "Foreground".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getAttrAsString("color", null)) != null) {
            this.setForegroundColor(new Color(Integer.parseInt(string), true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.foregroundColor != null && this.foregroundColor != Color.black) {
            xMLPrintWriter.startTAG("Foreground").attr("color", this.getForegroundColor().getRGB()).end();
        }
    }
}

