/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg.cache;

import com.fr.base.mobile.push.MobileMessagePushManager;
import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.cache.MessageCacheUtils;
import com.fr.base.platform.msg.control.TerminalType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MobileMessageCache {
    private static Map<TerminalType, Map<String, Message>> mobileListMap = new ConcurrentHashMap<TerminalType, Map<String, Message>>();
    private static Map<String, Message> appListMap = new ConcurrentHashMap<String, Message>();
    private static Map<String, Message> wxListMap = new ConcurrentHashMap<String, Message>();

    public static void injectMessageCache(TerminalType terminalType, Message message) throws Exception {
        String string = message.getType() + message.getId();
        if (terminalType.equals((Object)TerminalType.APP)) {
            appListMap.put(string, message);
        } else if (terminalType.equals((Object)TerminalType.WX)) {
            wxListMap.put(string, message);
        }
        MobileMessageCache.pushMessage(message);
    }

    public static void clearMessageCache() {
        appListMap.clear();
        wxListMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cache(String string, Message message) throws Exception {
        for (Map.Entry<TerminalType, Map<String, Message>> entry : mobileListMap.entrySet()) {
            Map<String, Message> map;
            Map<String, Message> map2 = map = entry.getValue();
            synchronized (map2) {
                if (map.containsKey(string)) {
                    return false;
                }
                map.put(string, message);
                MobileMessageCache.pushMessage(message);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCache(String string) throws Exception {
        for (Map.Entry<TerminalType, Map<String, Message>> entry : mobileListMap.entrySet()) {
            Map<String, Message> map;
            Map<String, Message> map2 = map = entry.getValue();
            synchronized (map2) {
                Message message = map.get(string);
                if (message != null) {
                    map.remove(string);
                }
            }
        }
        return true;
    }

    public static Message[] getAllMessages(String string, String string2) throws Exception {
        Map<String, Message> map = mobileListMap.get(string);
        return MessageCacheUtils.getAllMessages(map, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateToasted(String string) throws Exception {
        for (Map.Entry<TerminalType, Map<String, Message>> entry : mobileListMap.entrySet()) {
            Map<String, Message> map;
            Map<String, Message> map2 = map = entry.getValue();
            synchronized (map2) {
                Message message = map.get(string);
                if (message == null) {
                    return false;
                }
                message.setToasted(true);
            }
        }
        return true;
    }

    public static void pushMessage(Message message) throws Exception {
        MobileMessagePushManager.getInstance().push(message, null);
    }

    static {
        mobileListMap.put(TerminalType.APP, appListMap);
        mobileListMap.put(TerminalType.WX, wxListMap);
    }
}

