/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class dateUtil {
    public static final int NUMSECSINHR = 3600;
    public static final int NUMSECSINDY = 86400;
    public static final int NUMSECSINWK = 604800;
    public static final int NUMSECSINMN = 18144000;
    public static final int NUMSECSINYR = 217728000;
    private static final char ERA_ID = 'E';
    private static final char DAY_ID = 'D';
    private static final char MONTH_ID = 'M';
    private static final char YEAR_ID = 'Y';
    private static final char PERCENT = '%';
    private static final char CQUOTE = '\'';
    private static final char SPACE = ' ';
    private static final char FOUR_DIGIT_YEAR = '4';
    private static final char TWO_DIGIT_YEAR = '2';
    private static final String SLASH = "/";
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String NOSEP = "0";
    private static final String UNDERSCORE = "_";
    private static final String SQUOTE = "'";
    private static final String CDIRTAG = ";;;;";
    private static final String WDIRTAG = ";;;;;";
    private static final String NONALPHANUMTOKS = "/-. ~`!@#$%^&*()_+=\t\n\r\b{}[]|\\:;'\"<>,?";
    static int[] numDaysArr = new int[12];

    public static int calcNumDays(String string) {
        if (!dateUtil.isValidDate(string)) {
            return -1;
        }
        dateUtil.numDaysArr[0] = 0;
        dateUtil.numDaysArr[1] = 31;
        dateUtil.numDaysArr[2] = 59;
        dateUtil.numDaysArr[3] = 90;
        dateUtil.numDaysArr[4] = 120;
        dateUtil.numDaysArr[5] = 151;
        dateUtil.numDaysArr[6] = 181;
        dateUtil.numDaysArr[7] = 212;
        dateUtil.numDaysArr[8] = 243;
        dateUtil.numDaysArr[9] = 273;
        dateUtil.numDaysArr[10] = 304;
        dateUtil.numDaysArr[11] = 334;
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        int n = 0;
        if (dateUtil.isValidDate(string)) {
            int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
            int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
            int n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n = numDaysArr[n3 - 1] + n4;
            if (n3 > 2 && (n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 && true)) {
                ++n;
            }
        }
        return n;
    }

    public static boolean isValidTimeStamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidDate(stringTokenizer.nextToken())) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.indexOf(46) == -1) {
            return dateUtil.isValidTime(string2);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, PERIOD);
        if (stringTokenizer2.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidTime(stringTokenizer2.nextToken())) {
            return false;
        }
        String string3 = stringTokenizer2.nextToken();
        return stringUtil.isANum(string3) && string3.length() <= 8;
    }

    public static String IfxTimeStamp(String string) {
        if (string.length() > 25) {
            return string.substring(0, 25);
        }
        return string;
    }

    public static boolean isValidTime(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        int n = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n < 0 || n > 23) {
            return false;
        }
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        return n3 >= 0 && n3 <= 59;
    }

    public static boolean isValidDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 4) {
            return false;
        }
        int n = stringUtil.stringToInt(string2);
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (n3 >= 1 && n3 <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n3 >= 1 && n3 <= 30) break;
                return false;
            }
            case 2: {
                int n4 = 28;
                if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
                    n4 = 29;
                }
                if (n3 >= 1 && n3 <= n4) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static long gregToJulian(String string) {
        int n = stringUtil.stringToInt(string.substring(0, 4));
        int n2 = stringUtil.stringToInt(string.substring(5, 7));
        int n3 = stringUtil.stringToInt(string.substring(8, 10));
        long l = 1461 * (n + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - 12 * ((n2 - 14) / 12)) / 12 - 3 * ((n + 4900 + (n2 - 14) / 12) / 100) / 4 + n3 - 32075;
        return l;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    private static String getdbDateStr(java.sql.Date date, String string, String string2) throws SQLException {
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl = false;
        int n = 0;
        Locale locale = dateUtil.getLocaleValue(string);
        if (string2.length() < 4 || string2.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + string2 + "\"", locale);
        }
        String string6 = string2.substring(string2.length() - 1);
        if (string6.equals(SLASH) || string6.equals(HYPHEN) || string6.equals(PERIOD)) {
            string5 = string6;
            bl = true;
        } else if (string6.equals(NOSEP)) {
            string5 = "";
            bl = true;
        } else {
            if (!(string6.equals("E") || string6.equals("2") || string6.equals("4") || string6.equals("M") || string6.equals("D"))) {
                bl = true;
            }
            string5 = SLASH;
        }
        n = bl ? string2.length() - 1 : string2.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string2.charAt(n2)) {
                case 'E': {
                    if (n2 == 0) {
                        string3 = String.valueOf(string3) + "GGG ";
                        break;
                    }
                    string3 = String.valueOf(string3) + " GGG ";
                    break;
                }
                case 'D': {
                    string3 = String.valueOf(string3) + "dd" + string5;
                    break;
                }
                case 'M': {
                    string3 = String.valueOf(string3) + "MM" + string5;
                    break;
                }
                case 'Y': {
                    if (n2 + 1 == n) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + string2 + "\"", locale);
                    }
                    if (string2.charAt(n2 + 1) == '2' || string2.charAt(n2 + 1) == '4') break;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + string2 + "\"", locale);
                }
                case '2': 
                case '4': {
                    if (n2 == 0 || string2.charAt(n2 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", locale);
                    }
                    if (string2.charAt(n2) == '2') {
                        string3 = String.valueOf(string3) + "yy" + string5;
                        break;
                    }
                    string3 = String.valueOf(string3) + "yyyy" + string5;
                    break;
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + string2 + "\"", locale);
                }
            }
            ++n2;
        }
        if (string5.equals("")) {
            string4 = dateUtil.formatDate(date, locale, string3);
            return string4;
        }
        string4 = dateUtil.formatDate(date, locale, string3.substring(0, string3.length() - 1));
        return string4;
    }

    private static String getglDateStr(java.sql.Date date, String string, String string2, boolean bl) {
        String string3 = "";
        String string4 = "";
        boolean bl2 = false;
        String[] stringArray = new String[5];
        Locale locale = dateUtil.getLocaleValue(string);
        int n = 0;
        while (n < string2.length()) {
            switch (string2.charAt(n)) {
                case '%': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "%";
                        break;
                    }
                    if (!bl2) break;
                    string3 = String.valueOf(string3) + SQUOTE;
                    bl2 = false;
                    break;
                }
                case '\'': {
                    if (bl2) {
                        string3 = String.valueOf(string3) + SQUOTE + SQUOTE + SQUOTE;
                        bl2 = false;
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + SQUOTE;
                    break;
                }
                case 'a': {
                    Locale locale2;
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        locale2 = new Locale("fr", "CH", "");
                        Locale locale3 = new Locale("tr", "TR", "");
                        if (bl && (locale.toString().equals(locale3.toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale2.toString()))) {
                            if (bl2) {
                                string3 = String.valueOf(string3) + dateUtil.getInfmxglPattern(date, 'a', locale);
                                break;
                            }
                            string3 = String.valueOf(string3) + SQUOTE + dateUtil.getInfmxglPattern(date, 'a', locale);
                            bl2 = true;
                            break;
                        }
                        string3 = String.valueOf(string3) + "E";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "a";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "a";
                    bl2 = true;
                    break;
                }
                case 'A': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "EEEEE";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "A";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "A";
                    bl2 = true;
                    break;
                }
                case 'b': {
                    Locale locale2;
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        locale2 = new Locale("fr", "CH", "");
                        if (bl && (locale.toString().equals(Locale.JAPAN.toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale2.toString()))) {
                            if (bl2) {
                                string3 = String.valueOf(string3) + dateUtil.getInfmxglPattern(date, 'b', locale);
                                break;
                            }
                            string3 = String.valueOf(string3) + SQUOTE + dateUtil.getInfmxglPattern(date, 'b', locale);
                            bl2 = true;
                            break;
                        }
                        string3 = String.valueOf(string3) + "MMM";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "b";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "b";
                    bl2 = true;
                    break;
                }
                case 'B': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        if (bl && locale.toString().equals(Locale.JAPAN.toString())) {
                            if (bl2) {
                                string3 = String.valueOf(string3) + dateUtil.getInfmxglPattern(date, 'B', locale);
                                break;
                            }
                            string3 = String.valueOf(string3) + SQUOTE + dateUtil.getInfmxglPattern(date, 'B', locale);
                            bl2 = true;
                            break;
                        }
                        string3 = String.valueOf(string3) + "MMMMM";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "B";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "B";
                    bl2 = true;
                    break;
                }
                case 'C': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + CDIRTAG + "yyyy";
                        break;
                    }
                    if (n >= 2 && string2.charAt(n - 1) == 'E' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + CDIRTAG + "yyyy" + " GGGGG ";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "C";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "C";
                    bl2 = true;
                    break;
                }
                case 'd': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "dd";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "d";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "d";
                    bl2 = true;
                    break;
                }
                case 'D': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "MM/dd/yy";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "D";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "D";
                    bl2 = true;
                    break;
                }
                case 'e': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "d";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "e";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "e";
                    bl2 = true;
                    break;
                }
                case 'h': {
                    Locale locale2;
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        locale2 = new Locale("fr", "CH", "");
                        if (bl && (locale.toString().equals(Locale.JAPAN.toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale2.toString()))) {
                            if (bl2) {
                                string3 = String.valueOf(string3) + dateUtil.getInfmxglPattern(date, 'h', locale);
                                break;
                            }
                            string3 = String.valueOf(string3) + SQUOTE + dateUtil.getInfmxglPattern(date, 'h', locale);
                            bl2 = true;
                            break;
                        }
                        string3 = String.valueOf(string3) + "MMM";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "h";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "h";
                    bl2 = true;
                    break;
                }
                case 'i': {
                    if (n != 0 && string2.charAt(n - 1) == '%') break;
                    if (bl2) {
                        string3 = String.valueOf(string3) + "i";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "i";
                    bl2 = true;
                    break;
                }
                case 'E': {
                    if (n != 0 && string2.charAt(n - 1) == '%') break;
                    if (bl2) {
                        string3 = String.valueOf(string3) + "E";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "E";
                    bl2 = true;
                    break;
                }
                case 'y': {
                    if (n != 0 && string2.charAt(n - 1) == '%' || n >= 2 && string2.charAt(n - 1) == 'i' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + "yy";
                        break;
                    }
                    if (n >= 2 && string2.charAt(n - 1) == 'E' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + "yy" + " GGGGG ";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "y";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "y";
                    bl2 = true;
                    break;
                }
                case 'Y': {
                    if (n != 0 && string2.charAt(n - 1) == '%' || n >= 2 && string2.charAt(n - 1) == 'i' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + "yyyy";
                        break;
                    }
                    if (n >= 2 && string2.charAt(n - 1) == 'E' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + "yyyy" + " GGGGG ";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "Y";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "Y";
                    bl2 = true;
                    break;
                }
                case 'm': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "MM";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "m";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "m";
                    bl2 = true;
                    break;
                }
                case 'n': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "\f";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "n";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "n";
                    bl2 = true;
                    break;
                }
                case 't': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + "\t";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "t";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "t";
                    bl2 = true;
                    break;
                }
                case 'w': {
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + WDIRTAG + "E";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "w";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "w";
                    bl2 = true;
                    break;
                }
                case 'x': {
                    stringArray = dateUtil.getLocaleDateOrder(locale, true);
                    if (n != 0 && string2.charAt(n - 1) == '%') {
                        string3 = String.valueOf(string3) + dateUtil.getglDateXPattern(stringArray);
                        break;
                    }
                    if (n >= 2 && string2.charAt(n - 1) == 'E' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + dateUtil.getglDateXPattern(stringArray) + " GGGGG ";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "x";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "x";
                    bl2 = true;
                    break;
                }
                case 'g': {
                    if (n >= 2 && string2.charAt(n - 1) == 'E' && string2.charAt(n - 2) == '%') {
                        string3 = String.valueOf(string3) + CDIRTAG + "yyyy" + " G ";
                        break;
                    }
                    if (bl2) {
                        string3 = String.valueOf(string3) + "g";
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + "g";
                    bl2 = true;
                    break;
                }
                default: {
                    if (Character.isLetter(string2.charAt(n)) && !bl2) {
                        string3 = String.valueOf(string3) + SQUOTE + string2.substring(n, n + 1);
                        bl2 = true;
                        break;
                    }
                    if (Character.isLetter(string2.charAt(n)) && bl2 || !Character.isLetter(string2.charAt(n)) && !bl2) {
                        string3 = String.valueOf(string3) + string2.substring(n, n + 1);
                        break;
                    }
                    string3 = String.valueOf(string3) + SQUOTE + string2.substring(n, n + 1);
                    bl2 = false;
                }
            }
            ++n;
        }
        if (bl2) {
            string3 = String.valueOf(string3) + SQUOTE;
        }
        string4 = dateUtil.formatDate(date, locale, string3);
        return string4;
    }

    private static String getLocaleDateStr(java.sql.Date date, String string) {
        DateFormat dateFormat = null;
        String string2 = null;
        Locale locale = dateUtil.getLocaleValue(string);
        dateFormat = DateFormat.getDateInstance(3, locale);
        string2 = dateFormat.format(date);
        return string2;
    }

    private static String formatDate(java.sql.Date date, Locale locale, String string) {
        SimpleDateFormat simpleDateFormat;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string.indexOf(WDIRTAG) == -1) {
            simpleDateFormat = new SimpleDateFormat(string, locale);
            string2 = simpleDateFormat.format(date);
        } else {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            simpleDateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            string2 = simpleDateFormat.format(date);
            int n3 = 0;
            int n4 = 0;
            while (n3 < string2.length() && (n = string2.indexOf(WDIRTAG, n3)) != -1) {
                int n5 = 0;
                while (n5 < stringArray.length - 1) {
                    if (string2.indexOf(WDIRTAG + stringArray[n5 + 1], n3) != -1) {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                string2 = String.valueOf(string2.substring(0, n)) + n4 + string2.substring(n + WDIRTAG.length() + stringArray[n4 + 1].length());
                n3 = n + 1;
            }
        }
        while (n2 < string2.length() && (n = string2.indexOf(CDIRTAG, n2)) != -1) {
            string2 = String.valueOf(string2.substring(0, n)) + string2.substring(n + CDIRTAG.length(), n + CDIRTAG.length() + 2) + string2.substring(n + CDIRTAG.length() + 4);
            n2 = n + 2;
        }
        return string2;
    }

    private static String convertdbDate(String string, String string2, String string3) throws SQLException {
        String string4 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        java.sql.Date date = java.sql.Date.valueOf(string);
        string4 = dateUtil.getdbDateStr(date, string2, string3);
        return string4;
    }

    private static String convertglDate(String string, String string2, String string3) throws SQLException {
        String string4 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        java.sql.Date date = java.sql.Date.valueOf(string);
        string4 = dateUtil.getglDateStr(date, string2, string3, true);
        return string4;
    }

    private static String convertcllDate(String string, String string2) throws SQLException {
        String string3 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        java.sql.Date date = java.sql.Date.valueOf(string);
        string3 = dateUtil.getLocaleDateStr(date, string2);
        return string3;
    }

    private static java.sql.Date getdbDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = ifxConnection.getdbDate();
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -10000;
        int n5 = -85000;
        int n6 = -2500000;
        StringTokenizer stringTokenizer = null;
        java.sql.Date date = null;
        boolean bl2 = false;
        if (string2.length() < 4 || string2.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + string2 + "\"", ifxConnection);
        }
        String string5 = string2.substring(string2.length() - 1);
        if (string5.equals(SLASH) || string5.equals(HYPHEN) || string5.equals(PERIOD)) {
            string3 = string5;
            bl = true;
        } else if (string5.equals(NOSEP)) {
            string3 = "";
            bl = true;
        } else {
            if (!(string5.equals("E") || string5.equals("2") || string5.equals("4") || string5.equals("M") || string5.equals("D"))) {
                bl = true;
            }
            string3 = SLASH;
        }
        n2 = bl ? string2.length() - 1 : string2.length();
        if (!string3.equals("") && (stringTokenizer = new StringTokenizer(string, String.valueOf(string3) + " ")).countTokens() < 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + string + "\"", ifxConnection);
        }
        int n7 = 0;
        while (n7 < n2) {
            if (string3.equals("") && n >= string.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
            }
            if (!string3.equals("") && !stringTokenizer.hasMoreTokens()) {
                throw IfxErrMsg.getSQLException(-79804, "\"" + string + "\"", ifxConnection);
            }
            if (!string3.equals("") && string2.charAt(n7) != 'Y') {
                string4 = stringTokenizer.nextToken();
            }
            switch (string2.charAt(n7)) {
                case 'E': {
                    if (!string3.equals("")) break;
                    if (n <= string.length()) {
                        n3 = string.indexOf(32, n);
                        if (n3 != -1) {
                            n = n3 + 1;
                            break;
                        }
                        throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'D': {
                    if (!string3.equals("")) {
                        n6 = stringUtil.stringToInt(string4);
                        if (n6 != 0) break;
                        throw IfxErrMsg.getSQLException(-79806, "\"" + string + "\"", ifxConnection);
                    }
                    if (n + 2 <= string.length()) {
                        n6 = stringUtil.stringToInt(string.substring(n, n + 2));
                        if (n6 == 0) {
                            throw IfxErrMsg.getSQLException(-79806, "\"" + string + "\"", ifxConnection);
                        }
                        n += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'M': {
                    if (!string3.equals("")) {
                        n5 = stringUtil.stringToInt(string4) - 1;
                        if (n5 != -1) break;
                        throw IfxErrMsg.getSQLException(-79807, "\"" + string + "\"", ifxConnection);
                    }
                    if (n + 2 <= string.length()) {
                        n5 = stringUtil.stringToInt(string.substring(n, n + 2)) - 1;
                        if (n5 == -1) {
                            throw IfxErrMsg.getSQLException(-79807, "\"" + string + "\"", ifxConnection);
                        }
                        n += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'Y': {
                    if (n7 + 1 == n2) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (string2.charAt(n7 + 1) == '2' || string2.charAt(n7 + 1) == '4') break;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + string2 + "\"", ifxConnection);
                }
                case '2': {
                    if (n7 == 0 || string2.charAt(n7 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (!string3.equals("")) {
                        n4 = stringUtil.stringToInt(string4);
                        if (string4.length() >= 3) break;
                        bl2 = true;
                        break;
                    }
                    if (n + 2 <= string.length()) {
                        n4 = stringUtil.stringToInt(string.substring(n, n + 2));
                        bl2 = true;
                        n += 2;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string2 + "\"", ifxConnection);
                }
                case '4': {
                    if (n7 == 0 || string2.charAt(n7 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (!string3.equals("")) {
                        n4 = stringUtil.stringToInt(string4);
                        if (string4.length() >= 3) break;
                        bl2 = true;
                        break;
                    }
                    if (n + 4 <= string.length()) {
                        n4 = stringUtil.stringToInt(string.substring(n, n + 4));
                        n += 4;
                        break;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + string2 + "\"", ifxConnection);
                }
            }
            ++n7;
        }
        try {
            if (bl2) {
                n4 += dateUtil.getCentury(ifxConnection, n4, n5 + 1, n6);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n4, n5, n6);
            date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return date;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static java.sql.Date getglDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = ifxConnection.getglDate();
        String string3 = ifxConnection.getclLocale();
        int n = 0;
        int n2 = 0;
        int n3 = -10000;
        int n4 = -85000;
        int n5 = -2500000;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        DateFormatSymbols dateFormatSymbols = null;
        String[] stringArray = new String[8];
        String[] stringArray2 = new String[13];
        String[] stringArray3 = new String[13];
        java.sql.Date date = null;
        String[] stringArray4 = new String[3];
        String string7 = null;
        int n6 = 0;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        boolean bl = false;
        Locale locale = dateUtil.getLocaleValue(string3);
        dateFormatSymbols = new DateFormatSymbols(locale);
        int n7 = 0;
        while (n7 < string2.length()) {
            if (n >= string.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
            }
            block1 : switch (string2.charAt(n7)) {
                case '%': {
                    if (n7 == 0 || string2.charAt(n7 - 1) != '%') break;
                    ++n;
                    break;
                }
                case 'a': {
                    String[] stringArray5;
                    int n8;
                    int n9;
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        stringArray = dateFormatSymbols.getShortWeekdays();
                        n9 = 0;
                        n8 = 0;
                        while (n8 < stringArray.length - 1) {
                            string9 = stringArray[n8 + 1].toLowerCase(locale);
                            n9 = stringArray[n8 + 1].length();
                            if (n + n9 <= string.length()) {
                                Locale locale2 = new Locale("tr", "TR", "");
                                string8 = string.substring(n, n + n9).toLowerCase(locale);
                                if (string8.indexOf(string9) != -1) {
                                    stringArray5 = new Locale("fr", "CH", "");
                                    if (locale.toString().equals(stringArray5.toString())) {
                                        n += 3;
                                        break block1;
                                    }
                                    n += n9;
                                    break block1;
                                }
                                if ((locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale2.toString())) && string8.indexOf(string9.substring(0, 3)) != -1) {
                                    n += 3;
                                    break block1;
                                }
                            } else if (n + 3 <= string.length()) {
                                string8 = string.substring(n, n + 3).toLowerCase(locale);
                                if (n9 >= 3 && string8.equals(string9.substring(0, 3))) {
                                    n += 3;
                                    break block1;
                                }
                            }
                            ++n8;
                        }
                        break;
                    }
                    ++n;
                    break;
                }
                case 'A': {
                    int n8;
                    int n9;
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        stringArray = dateFormatSymbols.getWeekdays();
                        n9 = 0;
                        n8 = 0;
                        while (n8 < stringArray.length - 1) {
                            n9 = stringArray[n8 + 1].length();
                            if (n + n9 <= string.length() && (string8 = string.substring(n, n + n9).toLowerCase(locale)).indexOf(string9 = stringArray[n8 + 1].toLowerCase(locale)) != -1) {
                                n += n9;
                                break block1;
                            }
                            ++n8;
                        }
                        break;
                    }
                    ++n;
                    break;
                }
                case 'b': 
                case 'h': {
                    int n10;
                    String[] stringArray5;
                    int n8;
                    int n9;
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        n9 = 0;
                        n8 = 0;
                        stringArray2 = dateFormatSymbols.getShortMonths();
                        int n11 = 0;
                        while (n11 < stringArray2.length - 1) {
                            string10 = stringArray2[n11].toLowerCase(locale);
                            n8 = stringArray2[n11].length();
                            if (n + n8 <= string.length()) {
                                stringArray5 = new Locale("fr", "CH", "");
                                string8 = string.substring(n, n + n8).toLowerCase(locale);
                                if (string8.indexOf(string10) != -1) {
                                    n4 = n11;
                                    n9 = 1;
                                    n += n8;
                                    break;
                                }
                                if ((locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(stringArray5.toString())) && (string8.indexOf(string10.substring(0, 3)) != -1 || string10.equals("juin") && string8.substring(0, 3).equals("jun") || string10.equals("juil.") && string8.substring(0, 3).equals("jul"))) {
                                    n4 = n11;
                                    n9 = 1;
                                    n += 3;
                                    break;
                                }
                            } else if (n + 3 <= string.length()) {
                                stringArray5 = new Locale("fr", "CH", "");
                                string8 = string.substring(n, n + 3).toLowerCase(locale);
                                if (n8 >= 3 && string8.equals(string10.substring(0, 3))) {
                                    n4 = n11;
                                    n9 = 1;
                                    n += 3;
                                    break;
                                }
                                if ((locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(stringArray5.toString())) && (string10.equals("juin") && string8.equals("jun") || string10.equals("juil.") && string8.equals("jul"))) {
                                    n4 = n11;
                                    n9 = 1;
                                    n += 3;
                                    break;
                                }
                            }
                            ++n11;
                        }
                        if (n9 != 0) break;
                        stringArray5 = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", ""};
                        dateFormatSymbols.setShortMonths(stringArray5);
                        stringArray3 = dateFormatSymbols.getShortMonths();
                        n10 = 0;
                        while (n10 < stringArray3.length - 1) {
                            n8 = stringArray3[n10].length();
                            if (n + n8 <= string.length() && (string8 = string.substring(n, n + n8).toLowerCase(locale)).indexOf(stringArray3[n10]) != -1) {
                                n4 = n10;
                                n += n8;
                                break block1;
                            }
                            ++n10;
                        }
                        break;
                    }
                    ++n;
                    break;
                }
                case 'B': {
                    int n10;
                    String[] stringArray5;
                    int n8;
                    int n9;
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        n9 = 0;
                        n8 = 0;
                        stringArray2 = dateFormatSymbols.getMonths();
                        int n12 = 0;
                        while (n12 < stringArray2.length - 1) {
                            n8 = stringArray2[n12].length();
                            if (n + n8 <= string.length() && (string8 = string.substring(n, n + n8).toLowerCase(locale)).indexOf(string10 = stringArray2[n12].toLowerCase(locale)) != -1) {
                                n4 = n12;
                                n9 = 1;
                                n += n8;
                                break;
                            }
                            ++n12;
                        }
                        if (n9 != 0) break;
                        stringArray5 = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", ""};
                        dateFormatSymbols.setMonths(stringArray5);
                        stringArray3 = dateFormatSymbols.getMonths();
                        n10 = 0;
                        while (n10 < stringArray3.length - 1) {
                            n8 = stringArray3[n10].length();
                            if (n + n8 <= string.length() && (string8 = string.substring(n, n + n8).toLowerCase(locale)).indexOf(stringArray3[n10]) != -1) {
                                n4 = n10;
                                n += n8;
                                break block1;
                            }
                            ++n10;
                        }
                        break;
                    }
                    ++n;
                    break;
                }
                case 'C': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        n += 2;
                        break;
                    }
                    if (n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'd': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string6 = string.substring(n, n + 2);
                        n5 = stringUtil.stringToInt(string6);
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'D': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else {
                            if (n + 6 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 6;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n6 = 0;
                        string7 = stringTokenizer2.nextToken();
                        n4 = stringUtil.stringToInt(string7) - 1;
                        n6 += string7.length();
                        string7 = stringTokenizer2.nextToken();
                        n5 = stringUtil.stringToInt(string7);
                        n6 += string7.length();
                        string7 = stringTokenizer2.nextToken();
                        n3 = stringUtil.stringToInt(string7);
                        if (string7.length() < 3) {
                            bl = true;
                        }
                        n = n + (n6 += string7.length()) + 2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'e': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        if (n != 0 && string.charAt(n - 1) == ' ') {
                            if (n + 1 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            string6 = string.substring(n, n + 1);
                            ++n;
                        } else {
                            if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            string6 = string.substring(n, n + 2);
                            n += 2;
                        }
                        n5 = stringUtil.stringToInt(string6);
                        break;
                    }
                    ++n;
                    break;
                }
                case 'i': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') break;
                    ++n;
                    break;
                }
                case 'E': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') break;
                    ++n;
                    break;
                }
                case 'y': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%' || n7 >= 2 && string2.charAt(n7 - 1) == 'i' && string2.charAt(n7 - 2) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 2);
                        n3 = stringUtil.stringToInt(string4);
                        bl = true;
                        n += 2;
                        break;
                    }
                    if (n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 2);
                        n3 = stringUtil.stringToInt(string4);
                        bl = true;
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'Y': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%' || n7 >= 2 && string2.charAt(n7 - 1) == 'i' && string2.charAt(n7 - 2) == '%') {
                        if (n + 4 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 4);
                        n3 = stringUtil.stringToInt(string4);
                        n += 4;
                        break;
                    }
                    if (n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                        if (n + 5 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 4);
                        n3 = stringUtil.stringToInt(string4);
                        n2 = string.indexOf(32, n + 5);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'm': {
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string5 = string.substring(n, n + 2);
                        n4 = stringUtil.stringToInt(string5) - 1;
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'x': {
                    int n9;
                    if (n7 != 0 && string2.charAt(n7 - 1) == '%' || n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                        stringArray4 = dateUtil.getLocaleDateOrder(locale, false);
                        if (n + 10 <= string.length()) {
                            n2 = n + 10;
                        } else if (n + 9 <= string.length()) {
                            n2 = n + 9;
                        } else if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else {
                            if (n + 6 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 6;
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79809, "\"" + string + "\"", ifxConnection);
                        }
                        n6 = 0;
                        n9 = 0;
                        while (n9 < stringArray4.length) {
                            string7 = stringTokenizer.nextToken();
                            n6 += string7.length();
                            if (stringArray4[n9].indexOf("YEAR") != -1) {
                                n3 = stringUtil.stringToInt(string7);
                                if (string7.length() < 3) {
                                    bl = true;
                                }
                            } else if (stringArray4[n9].indexOf("MONTH") != -1) {
                                n4 = stringUtil.stringToInt(string7) - 1;
                            } else {
                                n5 = stringUtil.stringToInt(string7);
                            }
                            ++n9;
                        }
                        n6 += 2;
                        if (n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                            if (n + n6 + 1 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = string.indexOf(32, n + n6 + 1);
                            if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                            n = n2 + 1;
                            break;
                        }
                        n += n6;
                        break;
                    }
                    ++n;
                    break;
                }
                case 'g': {
                    if (n7 >= 2 && string2.charAt(n7 - 1) == 'E' && string2.charAt(n7 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        break;
                    }
                    ++n;
                    break;
                }
                default: {
                    ++n;
                }
            }
            ++n7;
        }
        try {
            if (bl) {
                n3 += dateUtil.getCentury(ifxConnection, n3, n4 + 1, n5);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n4, n5);
            return new java.sql.Date(gregorianCalendar.getTime().getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
    }

    private static java.sql.Date getLocaleDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = ifxConnection.getclLocale();
        int n = -10000;
        int n2 = -85000;
        int n3 = -2500000;
        java.sql.Date date = null;
        String string3 = null;
        boolean bl = false;
        Locale locale = dateUtil.getLocaleValue(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/-.");
        if (stringTokenizer.countTokens() != 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + string + "\"", ifxConnection);
        }
        String[] stringArray = dateUtil.getLocaleDateOrder(locale, false);
        int n4 = 0;
        while (n4 < stringArray.length) {
            string3 = stringTokenizer.nextToken();
            if (stringArray[n4].indexOf("YEAR") != -1) {
                n = stringUtil.stringToInt(string3);
                if (string3.length() < 3) {
                    bl = true;
                }
            } else if (stringArray[n4].indexOf("MONTH") != -1) {
                n2 = stringUtil.stringToInt(string3) - 1;
            } else {
                n3 = stringUtil.stringToInt(string3);
            }
            ++n4;
        }
        try {
            if (bl) {
                n += dateUtil.getCentury(ifxConnection, n, n2 + 1, n3);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
            date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return date;
    }

    private static String[] getLocaleDateOrder(Locale locale, boolean bl) {
        String string = null;
        String[] stringArray = !bl ? new String[3] : new String[5];
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1964, 1, 7);
        java.sql.Date date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        String string2 = dateFormat.format(date);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/-.", bl);
        int n = 0;
        while (n < stringArray.length) {
            string = stringTokenizer.nextToken();
            stringArray[n] = string.indexOf("64") != -1 ? (string.length() > 2 ? "YEAR4" : "YEAR2") : (string.equals("02") ? "MONTH2" : (string.equals("2") ? "MONTH1" : (string.equals("07") ? "DAY2" : (string.equals("7") ? "DAY1" : (string.equals(SLASH) ? SLASH : (string.equals(HYPHEN) ? HYPHEN : PERIOD))))));
            ++n;
        }
        return stringArray;
    }

    public static Locale getLocaleValue(String string) {
        Locale locale = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, UNDERSCORE);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            locale = new Locale(string2, string3);
        } else {
            locale = new Locale(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
        }
        return locale;
    }

    public static String convertNativeSQLDate(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = null;
        String string3 = "";
        if (ifxConnection.getdbDate() != null) {
            string3 = ifxConnection.getdbDate();
            string2 = dateUtil.convertdbDate(string, ifxConnection.getclLocale(), string3);
        } else if (ifxConnection.getglDate() != null) {
            string3 = ifxConnection.getglDate();
            string2 = dateUtil.convertglDate(string, ifxConnection.getclLocale(), string3);
        } else {
            string2 = dateUtil.convertcllDate(string, ifxConnection.getclLocale());
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + string3 + "\"", ifxConnection);
        }
        return string2;
    }

    public static String convertDateStr(java.sql.Date date, IfxConnection ifxConnection) throws SQLException {
        String string = null;
        string = ifxConnection.getdbDate() != null ? dateUtil.getdbDateStr(date, ifxConnection.getclLocale(), ifxConnection.getdbDate()) : (ifxConnection.getglDate() != null ? dateUtil.getglDateStr(date, ifxConnection.getclLocale(), ifxConnection.getglDate(), false) : dateUtil.getLocaleDateStr(date, ifxConnection.getclLocale()));
        return string;
    }

    public static java.sql.Date convertDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        java.sql.Date date = null;
        date = ifxConnection.getdbDate() != null ? dateUtil.getdbDateObj(string, ifxConnection) : (ifxConnection.getglDate() != null ? dateUtil.getglDateObj(string, ifxConnection) : dateUtil.getLocaleDateObj(string, ifxConnection));
        return date;
    }

    private static String getglDateXPattern(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n].equals("YEAR4") ? String.valueOf(string) + "yyyy" : (stringArray[n].equals("YEAR2") ? String.valueOf(string) + "yy" : (stringArray[n].equals("MONTH1") ? String.valueOf(string) + "M" : (stringArray[n].equals("MONTH2") ? String.valueOf(string) + "MM" : (stringArray[n].equals("DAY1") ? String.valueOf(string) + "d" : (stringArray[n].equals("DAY2") ? String.valueOf(string) + "dd" : (stringArray[n].equals(SLASH) ? String.valueOf(string) + SLASH : (stringArray[n].equals(HYPHEN) ? String.valueOf(string) + HYPHEN : String.valueOf(string) + PERIOD)))))));
            ++n;
        }
        return string;
    }

    private static String getInfmxglPattern(java.sql.Date date, char c, Locale locale) {
        String string = "";
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = new String[8];
        String[] stringArray2 = new String[8];
        String[] stringArray3 = new String[13];
        String[] stringArray4 = new String[13];
        String string2 = null;
        block0 : switch (c) {
            case 'b': 
            case 'h': {
                String[] stringArray5;
                string2 = dateUtil.formatDate(date, locale, "MMM");
                stringArray3 = dateFormatSymbols.getShortMonths();
                if (locale.toString().equals(Locale.JAPAN.toString())) {
                    stringArray5 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
                    System.arraycopy(stringArray5, 0, stringArray4, 0, 13);
                } else {
                    stringArray5 = new String[]{"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c", ""};
                    System.arraycopy(stringArray5, 0, stringArray4, 0, 13);
                }
                int n = 0;
                while (n < stringArray3.length - 1) {
                    if (string2.equals(stringArray3[n])) {
                        string = stringArray4[n];
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            case 'B': {
                string2 = dateUtil.formatDate(date, locale, "MMMMM");
                stringArray3 = dateFormatSymbols.getMonths();
                String[] stringArray6 = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
                System.arraycopy(stringArray6, 0, stringArray4, 0, 13);
                int n = 0;
                while (n < stringArray3.length - 1) {
                    if (string2.equals(stringArray3[n])) {
                        string = stringArray4[n];
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            case 'a': {
                String[] stringArray7;
                string2 = dateUtil.formatDate(date, locale, "E");
                stringArray = dateFormatSymbols.getShortWeekdays();
                Locale locale2 = new Locale("tr", "TR", "");
                if (locale.toString().equals(locale2.toString())) {
                    stringArray7 = new String[]{"", "Pzr", "Pzt", "Sal", "\u00e7ar", "Per", "Cum", "Cts"};
                    System.arraycopy(stringArray7, 0, stringArray2, 0, 8);
                } else {
                    stringArray7 = new String[]{"", "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"};
                    System.arraycopy(stringArray7, 0, stringArray2, 0, 8);
                }
                int n = 0;
                while (n < stringArray.length - 1) {
                    if (string2.equals(stringArray[n + 1])) {
                        string = stringArray2[n + 1];
                        break block0;
                    }
                    ++n;
                }
                break;
            }
        }
        return string;
    }

    private static int getCentury(IfxConnection ifxConnection, int n, int n2, int n3) throws SQLException {
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCentury: conn is null.", null);
        }
        Trace trace = ifxConnection.getTrace();
        if (n > 99) {
            return 0;
        }
        GregorianCalendar gregorianCalendar = null;
        int n4 = 0;
        int n5 = 0;
        gregorianCalendar = dateUtil.getCurrentDateGC(ifxConnection);
        n4 = gregorianCalendar.get(1) / 100;
        if (ifxConnection.getdbCentury() == null || ifxConnection.getdbCentury().equalsIgnoreCase("R")) {
            n5 = n4;
        } else {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            GregorianCalendar gregorianCalendar2 = null;
            l = gregorianCalendar.getTime().getTime();
            int n6 = gregorianCalendar.get(2);
            int n7 = gregorianCalendar.get(5);
            int n8 = n2;
            int n9 = n3;
            int n10 = n4 * 100 + n;
            if (n8 == 29 && n9 == 2 && (n10 % 4 == 0 && n10 % 100 != 0 || n10 % 400 == 0 && true)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l2 = gregorianCalendar2.getTime().getTime();
            n8 = n2;
            n9 = n3;
            n10 = (n4 - 1) * 100 + n;
            if (n8 == 29 && n9 == 2 && (n10 % 4 == 0 && n10 % 100 != 0 || n10 % 400 == 0 && true)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l4 = gregorianCalendar2.getTime().getTime();
            n8 = n2;
            n9 = n3;
            n10 = (n4 + 1) * 100 + n;
            if (n8 == 29 && n9 == 2 && (n10 % 4 == 0 && n10 % 100 != 0 || n10 % 400 == 0 && true)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l3 = gregorianCalendar2.getTime().getTime();
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            char c = ifxConnection.getdbCentury().toUpperCase().charAt(0);
            switch (c) {
                case 'C': {
                    l5 = Math.abs(l2 - l);
                    l6 = Math.abs(l4 - l);
                    l7 = Math.abs(l3 - l);
                    if (l5 < l6) {
                        if (l5 < l7) {
                            n5 = n4;
                            break;
                        }
                        n5 = n4 + 1;
                        break;
                    }
                    if (l6 < l7) {
                        n5 = n4 - 1;
                        break;
                    }
                    n5 = n4 + 1;
                    break;
                }
                case 'P': {
                    l5 = l2 - l;
                    l6 = l4 - l;
                    if (l5 < 0L) {
                        n5 = n4;
                        break;
                    }
                    n5 = n4 - 1;
                    break;
                }
                case 'F': {
                    l5 = l2 - l;
                    l7 = l3 - l;
                    if (l5 > 0L) {
                        n5 = n4;
                        break;
                    }
                    n5 = n4 + 1;
                    break;
                }
                default: {
                    n5 = n4;
                }
            }
        }
        return n5 * 100;
    }

    public static GregorianCalendar getCurrentDateGC(IfxConnection ifxConnection) throws SQLException {
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCurrentDateGC: conn is null.", null);
        }
        Trace trace = ifxConnection.getTrace();
        Locale locale = dateUtil.getLocaleValue(ifxConnection.getclLocale());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        long l = ifxConnection.getdbTodayStart();
        long l2 = ifxConnection.getdbTodayDate();
        if (l2 != -1L && l != -1L) {
            long l3 = gregorianCalendar.getTime().getTime();
            long l4 = l3 - l;
            long l5 = l2 + l4;
            Date date = new Date(l5);
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
        }
        return gregorianCalendar;
    }
}

