/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrPosition;
import com.fr.chart.base.AttrStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.Result;
import com.fr.data.core.Compare;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionAttr
implements XMLable {
    private static final long serialVersionUID = -3118030222189423100L;
    public static final String XML_TAG = "ConditionAttr";
    private List attributeList2Change = new ArrayList();
    private AbstractCondition condition = null;
    private String name = "";

    public DataSeriesCondition getDataSeriesCondition(int n) {
        return (DataSeriesCondition)this.attributeList2Change.get(n);
    }

    public void addDataSeriesCondition(DataSeriesCondition dataSeriesCondition) {
        this.attributeList2Change.add(dataSeriesCondition);
    }

    public int getDataSeriesConditionCount() {
        return this.attributeList2Change == null ? 0 : this.attributeList2Change.size();
    }

    public void removeAll() {
        this.attributeList2Change.clear();
    }

    public void remove(DataSeriesCondition dataSeriesCondition) {
        this.attributeList2Change.remove(dataSeriesCondition);
    }

    public void remove(Class clazz) {
        Iterator iterator = this.attributeList2Change.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next().getClass();
            if (!ComparatorUtils.equals((String)clazz2.getName(), (String)clazz.getName())) continue;
            iterator.remove();
        }
    }

    public <T extends DataSeriesCondition> T getExisted(Class<T> clazz) {
        for (DataSeriesCondition dataSeriesCondition : this.attributeList2Change) {
            if (dataSeriesCondition == null || !ComparatorUtils.equals((String)dataSeriesCondition.getClass().getName(), (String)clazz.getName())) continue;
            return (T)dataSeriesCondition;
        }
        return null;
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.condition != null) {
            list.addAll(Arrays.asList(this.condition.dependence(calculatorProvider)));
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.condition != null) {
            this.condition.formula2Value(calculator);
        }
    }

    public boolean conditionEqualsTo(ConditionAttr conditionAttr) {
        if (conditionAttr == null || conditionAttr.getCondition() == null || this.condition == null) {
            return false;
        }
        return ComparatorUtils.equals((String)this.getPureConditionString(conditionAttr.getCondition()), (String)this.getPureConditionString(this.condition));
    }

    private String getPureConditionString(AbstractCondition abstractCondition) {
        if (abstractCondition == null) {
            return "";
        }
        return abstractCondition.toString().replaceAll("([*/^()'\"\\s])", "");
    }

    public void combineConditionAttrs(ConditionAttr conditionAttr) {
        if (conditionAttr == null) {
            return;
        }
        int n = conditionAttr.getDataSeriesConditionCount();
        for (int i = 0; i < n; ++i) {
            this.addDataSeriesCondition(conditionAttr.getDataSeriesCondition(i));
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.condition != null) {
            this.condition.buildExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.condition != null) {
            this.condition.modColumnRow(mOD_COLUMN_ROW);
        }
    }

    public String getConditionAttrType() {
        return XML_TAG;
    }

    public void setCondition(AbstractCondition abstractCondition) {
        this.condition = abstractCondition;
    }

    public Iterator getConditionIterator() {
        return this.attributeList2Change.iterator();
    }

    public List getAttributeList2Change() {
        return this.attributeList2Change;
    }

    public AbstractCondition getCondition() {
        return this.condition;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean eval(Result result, Calculator calculator) {
        return result.evalWithCondition((Condition)this.condition, calculator);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.name);
        if (this.attributeList2Change != null && this.getDataSeriesConditionCount() > 0) {
            xMLPrintWriter.startTAG("AttrList");
            for (int i = 0; i < this.getDataSeriesConditionCount(); ++i) {
                GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.getDataSeriesCondition(i), (String)"Attr");
            }
            xMLPrintWriter.end();
        }
        if (this.condition != null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.condition, (String)"Condition");
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("ConditionList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (!xMLableReader.isChildNode() || xMLableReader.getTagName().equals("Condition")) {
                            // empty if block
                        }
                    }
                });
            }
            if (string.equals(XML_TAG)) {
                String string2 = xMLableReader.getAttrAsString("name", null);
                if (string2 != null) {
                    this.name = string2;
                }
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            String string = xMLableReader.getTagName();
                            if (string.equals("AttrList")) {
                                xMLableReader.readXMLObject(new XMLReadable(){

                                    public void readXML(XMLableReader xMLableReader) {
                                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Attr")) {
                                            DataSeriesCondition dataSeriesCondition = (DataSeriesCondition)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                                            ConditionAttr.this.addDataSeriesCondition(ConditionAttr.this.checkCondition(dataSeriesCondition));
                                        }
                                    }
                                });
                            }
                            if (string.equals("Condition")) {
                                if (xMLableReader.getAttrAsString("class", null).endsWith("ChartCondition")) {
                                    ConditionAttr.this.condition = (AbstractCondition)xMLableReader.readXMLObject((XMLReadable)new ListCondition());
                                } else {
                                    ConditionAttr.this.condition = (AbstractCondition)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private DataSeriesCondition checkCondition(DataSeriesCondition dataSeriesCondition) {
        if (dataSeriesCondition instanceof AttrPosition) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents == null) {
                attrContents = new AttrContents("${VALUE}");
            } else {
                this.remove(attrContents);
            }
            attrContents.setPosition(((AttrPosition)dataSeriesCondition).getPosition());
            return attrContents;
        }
        if (dataSeriesCondition instanceof AttrStyle) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents == null) {
                attrContents = new AttrContents("${VALUE}");
            } else {
                this.remove(attrContents);
            }
            AttrStyle attrStyle = (AttrStyle)dataSeriesCondition;
            attrContents.setTextAttr(attrStyle.getTextAttr());
            attrContents.setFormat(attrStyle.getFormat());
            attrContents.setPercentFormat(attrStyle.getPercentFormat());
            return attrContents;
        }
        if (dataSeriesCondition instanceof AttrContents) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents != null) {
                AttrContents attrContents2 = (AttrContents)dataSeriesCondition;
                this.remove(attrContents);
                attrContents.setSeriesLabel(attrContents2.getSeriesLabel());
                attrContents.setFormat(attrContents2.getFormat());
                attrContents.setPercentFormat(attrContents2.getFormat());
                attrContents.setPosition(attrContents2.getPosition());
                attrContents.setShowGuidLine(attrContents2.isShowGuidLine());
                attrContents.setTextAttr(attrContents2.getTextAttr());
                return attrContents;
            }
            return dataSeriesCondition;
        }
        if (dataSeriesCondition instanceof AttrLine) {
            return this.comAttrLineToColor((AttrLine)dataSeriesCondition);
        }
        return dataSeriesCondition;
    }

    private AttrColor comAttrLineToColor(AttrLine attrLine) {
        this.remove(attrLine);
        AttrLineStyle attrLineStyle = new AttrLineStyle(attrLine.getSeriesLineStyle());
        this.addDataSeriesCondition(attrLineStyle);
        AttrColor attrColor = new AttrColor();
        attrColor.setSeriesColor(attrLine.getSeriesLineColor());
        this.remove(AttrColor.class);
        return attrColor;
    }

    public DataSeriesCondition getConditionInType(String string) {
        if (this.attributeList2Change != null && this.getDataSeriesConditionCount() > 0) {
            for (int i = 0; i < this.getDataSeriesConditionCount(); ++i) {
                DataSeriesCondition dataSeriesCondition = this.getDataSeriesCondition(i);
                if (!ComparatorUtils.equals((String)dataSeriesCondition.getConditionType(), (String)string)) continue;
                return dataSeriesCondition;
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        ConditionAttr conditionAttr = (ConditionAttr)super.clone();
        if (this.attributeList2Change != null) {
            conditionAttr.attributeList2Change = new ArrayList();
            for (int i = 0; i < this.getDataSeriesConditionCount(); ++i) {
                if (this.getDataSeriesCondition(i) == null) continue;
                conditionAttr.addDataSeriesCondition((DataSeriesCondition)this.getDataSeriesCondition(i).clone());
            }
        }
        if (this.condition != null) {
            conditionAttr.condition = (AbstractCondition)this.condition.clone();
        }
        return conditionAttr;
    }

    public boolean equals(Object object) {
        return object instanceof ConditionAttr && ComparatorUtils.equals((Object)((ConditionAttr)object).attributeList2Change, (Object)this.attributeList2Change) && ComparatorUtils.equals((Object)((ConditionAttr)object).condition, (Object)this.condition) && ComparatorUtils.equals((String)((ConditionAttr)object).name, (String)this.name);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("conditionAttrType", (Object)this.getConditionAttrType());
        if (this.getDataSeriesConditionCount() > 0) {
            jSONObject.put("attrList", (Object)this.attrs2JSON(repository));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            jSONObject.put("name", (Object)this.name);
        }
        return jSONObject;
    }

    public JSONObject toJSONObject(Repository repository, DataSeries[] dataSeriesArray) throws JSONException {
        JSONObject jSONObject = this.toJSONObject(repository);
        if (this.condition != null && !ArrayUtils.isEmpty((Object[])dataSeriesArray)) {
            JSONArray jSONArray = new JSONArray();
            JSONArray jSONArray2 = new JSONArray();
            Calculator calculator = Calculator.createCalculator();
            for (int i = 0; i < dataSeriesArray.length; ++i) {
                DataSeries dataSeries = dataSeriesArray[i];
                if (dataSeries.evalWithCondition((Condition)this.condition, calculator)) {
                    jSONArray.put(dataSeries.getSeriesIndex());
                }
                int n = dataSeries.getDataPointCount();
                for (int j = 0; j < n; ++j) {
                    if (!dataSeries.getDataPoint(j).evalWithCondition((Condition)this.condition, calculator)) continue;
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("series", dataSeries.getSeriesIndex());
                    jSONObject2.put("category", dataSeries.getDataPoint(j).getCategoryIndex());
                    jSONArray2.put((Object)jSONObject2);
                }
            }
            jSONObject.put("ConditionDataSeries", (Object)jSONArray);
            jSONObject.put("ConditionDataPoint", (Object)jSONArray2);
        }
        return jSONObject;
    }

    public JSONObject exportConditionConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("conditionAttrType", (Object)this.getConditionAttrType());
        if (this.getDataSeriesConditionCount() > 0) {
            jSONObject.put("attrList", (Object)this.attrs2JSON(null));
        }
        if (this.condition != null) {
            jSONObject.put("attrConditions", (Object)this.exportConditions());
        }
        return jSONObject;
    }

    private JSONObject exportConditions() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        if (this.condition instanceof ListCondition) {
            JSONArray jSONArray2 = new JSONArray();
            ListCondition listCondition = (ListCondition)this.condition;
            for (int i = 0; i < listCondition.getJoinConditionCount(); ++i) {
                JoinCondition joinCondition = listCondition.getJoinCondition(i);
                CommonCondition commonCondition = (CommonCondition)joinCondition.getCondition();
                jSONArray.put((Object)this.exportCommonCondition(commonCondition));
                jSONArray2.put(joinCondition.getJoin());
            }
            if (listCondition.getJoinConditionCount() > 1) {
                jSONObject.put("joins", (Object)jSONArray2);
            }
        } else if (this.condition instanceof CommonCondition) {
            CommonCondition commonCondition = (CommonCondition)this.condition;
            jSONArray.put((Object)this.exportCommonCondition(commonCondition));
        }
        jSONObject.put("conditions", (Object)jSONArray);
        return jSONObject;
    }

    private JSONObject exportCommonCondition(CommonCondition commonCondition) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = commonCondition.getColumnName();
        Compare compare = commonCondition.getCompare();
        if (string != null && compare != null) {
            jSONObject.put("leftValue", (Object)ChartUtils.getConditionName(string));
            jSONObject.put("compare", compare.getOp());
            jSONObject.put("rightValue", compare.getValue());
        }
        return jSONObject;
    }

    private JSONArray attrs2JSON(Repository repository) throws JSONException {
        DataSeriesCondition[] dataSeriesConditionArray = this.attributeList2Change.toArray(new DataSeriesCondition[this.attributeList2Change.size()]);
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < dataSeriesConditionArray.length; ++i) {
            JSONObject jSONObject = new JSONObject();
            DataSeriesCondition dataSeriesCondition = dataSeriesConditionArray[i];
            jSONObject.put("attrType", (Object)dataSeriesCondition.getConditionType());
            jSONObject.put("attr", (Object)dataSeriesCondition.toJSONObject(repository));
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }
}

