/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.StockChartData;
import com.fr.chart.chartdata.StockLabel;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public class StockTableDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = 6697538020224053485L;
    public static final String XML_TAG = "StockTableDefinition";
    private StockLabel stockLabel;
    private String cateTime;
    private String volumnString;
    private String openString;
    private String highString;
    private String lowString;
    private String closeString;

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        StockChartData stockChartData;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        try {
            int n = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.cateTime);
            if (n != -1) {
                arrayList.addAll(Arrays.asList(dataProcessor.getDistinctValues(dataModel, n)));
            } else {
                arrayList.add(this.cateTime);
            }
            int n2 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.openString);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList2, n, n2);
            int n3 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.highString);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList3, n, n3);
            int n4 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.lowString);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList4, n, n4);
            int n5 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.closeString);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList5, n, n5);
            int n6 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.volumnString);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList6, n, n6);
            stockChartData = new StockChartData(arrayList.toArray(), arrayList2.toArray(), arrayList3.toArray(), arrayList4.toArray(), arrayList5.toArray(), arrayList6.toArray());
        }
        catch (TableDataException tableDataException) {
            stockChartData = new StockChartData();
        }
        if (this.stockLabel == null) {
            this.stockLabel = new StockLabel();
        }
        stockChartData.initLabels(this.stockLabel);
        return stockChartData;
    }

    private void addValueInColunmWithName(ArrayList arrayList, DataModel dataModel, ArrayList arrayList2, int n, int n2) throws TableDataException {
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e == null) continue;
            for (int j = 0; j < dataModel.getRowCount(); ++j) {
                if (!ComparatorUtils.equals(e, (Object)dataModel.getValueAt(j, n))) continue;
                arrayList2.add(dataModel.getValueAt(j, n2));
                continue block0;
            }
        }
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        jSONObject.put("timeLine", (Object)this.cateTime);
        jSONObject.put("volume", (Object)this.volumnString);
        jSONObject.put("open", (Object)this.openString);
        jSONObject.put("high", (Object)this.highString);
        jSONObject.put("low", (Object)this.lowString);
        jSONObject.put("close", (Object)this.closeString);
        return jSONObject;
    }

    public void setStockLabels(StockLabel stockLabel) {
        this.stockLabel = stockLabel;
    }

    public StockLabel getStockLabel() {
        if (this.stockLabel == null) {
            this.stockLabel = new StockLabel();
        }
        return this.stockLabel;
    }

    public String getDataDefinitionType() {
        return "StockDefinition";
    }

    public void setCateTime(String string) {
        this.cateTime = string;
    }

    public String getCateTime() {
        return this.cateTime;
    }

    public void setVolumnString(String string) {
        this.volumnString = string;
    }

    public String getVolumnString() {
        return this.volumnString;
    }

    public void setOpenString(String string) {
        this.openString = string;
    }

    public String getOpenString() {
        return this.openString;
    }

    public void setHighString(String string) {
        this.highString = string;
    }

    public String getHighString() {
        return this.highString;
    }

    public void setLowString(String string) {
        this.lowString = string;
    }

    public String getLowString() {
        return this.lowString;
    }

    public void setCloseString(String string) {
        this.closeString = string;
    }

    public String getCloseString() {
        return this.closeString;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "StockTable201109".equals(xMLableReader.getTagName())) {
            this.stockLabel = new StockLabel(xMLableReader.getAttrAsString("volumeLabel", StockLabel.VOLUMEN), xMLableReader.getAttrAsString("openLabel", StockLabel.OPEN), xMLableReader.getAttrAsString("highLabel", StockLabel.HIGHT), xMLableReader.getAttrAsString("lowLabel", StockLabel.LOW), xMLableReader.getAttrAsString("closeLabel", StockLabel.CLOSE));
            this.setCateTime(xMLableReader.getAttrAsString("cateTime", null));
            this.setVolumnString(xMLableReader.getAttrAsString("volumnString", null));
            this.setOpenString(xMLableReader.getAttrAsString("openString", null));
            this.setHighString(xMLableReader.getAttrAsString("highString", null));
            this.setLowString(xMLableReader.getAttrAsString("lowString", null));
            this.setCloseString(xMLableReader.getAttrAsString("closeString", null));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("StockTable201109").attr("volumeLabel", this.stockLabel.getVolumeLabel()).attr("openLabel", this.stockLabel.getOpenLabel()).attr("highLabel", this.stockLabel.getHighLabel()).attr("lowLabel", this.stockLabel.getLowLabel()).attr("closeLabel", this.stockLabel.getCloseLabel()).attr("cateTime", this.getCateTime()).attr("volumnString", this.getVolumnString()).attr("openString", this.getOpenString()).attr("highString", this.getHighString()).attr("lowString", this.getLowString()).attr("closeString", this.getCloseString()).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof StockTableDefinition && ComparatorUtils.equals((String)((StockTableDefinition)object).getCateTime(), (String)this.getCateTime()) && ComparatorUtils.equals((String)((StockTableDefinition)object).getVolumnString(), (String)this.getVolumnString()) && ComparatorUtils.equals((String)((StockTableDefinition)object).getOpenString(), (String)this.getOpenString()) && ComparatorUtils.equals((String)((StockTableDefinition)object).getHighString(), (String)this.getHighString()) && ComparatorUtils.equals((String)((StockTableDefinition)object).getLowString(), (String)this.getLowString()) && ComparatorUtils.equals((String)((StockTableDefinition)object).getCloseString(), (String)this.getCloseString()) && ComparatorUtils.equals((Object)((StockTableDefinition)object).getStockLabel(), (Object)this.getStockLabel()) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        StockTableDefinition stockTableDefinition = (StockTableDefinition)super.clone();
        stockTableDefinition.setStockLabels((StockLabel)this.getStockLabel().clone());
        return stockTableDefinition;
    }
}

