/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RadarAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RadarAxisGlyph;
import com.fr.chart.chartglyph.RadarPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadarPlot
extends Plot {
    private static final long serialVersionUID = 224372350182474023L;
    private static final String[] CATENAME = new String[]{"1", "2", "3", "4", "5", "6", "7"};
    private static final Object[] SERIESNAME = new Object[]{"NA"};
    private static final Object[][] VALUE = new Object[][]{{"35", "35", "35", "35", "40", "50", "40"}};
    private static final NormalChartData RADARDATA = new NormalChartData(CATENAME, SERIESNAME, VALUE);
    private RadarAxis radarAxis = new RadarAxis();
    private boolean isFilled = false;
    private Color intervalColor = null;

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        RadarPlotGlyph radarPlotGlyph = new RadarPlotGlyph();
        this.install4PlotGlyph(radarPlotGlyph, chartData);
        this.createAxisGlyph(radarPlotGlyph, chartData);
        return radarPlotGlyph;
    }

    @Override
    public boolean isOnlyIntervalBackground() {
        return true;
    }

    @Override
    public boolean isSupportCate() {
        return true;
    }

    public void install4PlotGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(radarPlotGlyph, chartData);
        radarPlotGlyph.setFilled(this.isFilled);
        radarPlotGlyph.setIntervalColor(this.intervalColor);
    }

    private void createAxisGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        int n;
        RadarPlotGlyph radarPlotGlyph2 = radarPlotGlyph;
        RadarAxisGlyph radarAxisGlyph = (RadarAxisGlyph)this.radarAxis.createAxisGlyph(chartData);
        radarAxisGlyph.setAxisType("xAxis");
        radarAxisGlyph.setCategoryCount(chartData.getCategoryLabelCount());
        radarAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData, radarAxisGlyph.isLog(), ChartAxisPosition.AXIS_LEFT), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT));
        double[] dArray = new double[chartData.getCategoryLabelCount()];
        double[] dArray2 = new double[chartData.getCategoryLabelCount()];
        if (this.radarAxis.isAllMaxMin()) {
            for (n = 0; n < chartData.getCategoryLabelCount(); ++n) {
                dArray[n] = radarAxisGlyph.getMaxValue();
                dArray2[n] = radarAxisGlyph.getMinValue();
            }
        } else {
            for (n = 0; n < chartData.getCategoryLabelCount(); ++n) {
                dArray2[n] = this.getMinValueFromaCateData(chartData, n);
                double d = this.getMaxValueFromCateData(chartData, n, ChartAxisPosition.AXIS_LEFT);
                if (d <= dArray2[n]) {
                    d += 10.0;
                }
                dArray[n] = d;
            }
        }
        radarAxisGlyph.setRadarMax(dArray);
        radarAxisGlyph.setRadarMin(dArray2);
        int n2 = chartData.getCategoryLabelCount();
        for (n = 0; n < n2; ++n) {
            radarAxisGlyph.addCategoryLabel(chartData.getCategoryPresentLabel(n) == null ? "" : chartData.getCategoryPresentLabel(n));
        }
        radarPlotGlyph2.setRadarAxisGlyph(radarAxisGlyph);
    }

    public double getMaxValueFromCateData(ChartData chartData, int n, ChartAxisPosition chartAxisPosition) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        for (int i = 0; i < normalChartData.getSeriesCount(); ++i) {
            Number number = normalChartData.getValueAt(i, n);
            if (number == null) continue;
            d = i == 0 ? number.doubleValue() : (number.doubleValue() > d ? number.doubleValue() : d);
        }
        if (d == this.getMinValueFromData(normalChartData, false, chartAxisPosition)) {
            return d + 10.0;
        }
        return d;
    }

    private double getMinValueFromaCateData(ChartData chartData, int n) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        for (int i = 0; i < normalChartData.getSeriesCount(); ++i) {
            Number number = normalChartData.getValueAt(i, n);
            if (number == null) continue;
            d = number.doubleValue() < d ? number.doubleValue() : d;
        }
        return d;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setIsFilled(boolean bl) {
        this.isFilled = bl;
    }

    public void setIntervalColor(Color color) {
        this.intervalColor = color;
    }

    public Color getIntervalColor() {
        return this.intervalColor;
    }

    @Override
    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof RadarPlot && super.match4GUI(plot);
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof RadarPlot;
    }

    @Override
    public boolean isSupportIntervalBackground() {
        return true;
    }

    @Override
    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.getConditionCollection().getDefaultAttr().remove(AttrLineStyle.class);
        this.getConditionCollection().getDefaultAttr().addDataSeriesCondition(new AttrLineStyle(5));
    }

    @Override
    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    @Override
    public ChartData defaultChartData() {
        return RADARDATA;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("RadarAttr".equals(string2)) {
                this.setIsFilled(xMLableReader.getAttrAsBoolean("isFilled", false));
                this.setIntervalColor(xMLableReader.getAttrAsColor("intervalColor", null));
                if (!xMLableReader.getAttrAsBoolean("showLine", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
                }
                if (!xMLableReader.getAttrAsBoolean("showMarker", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
                }
            } else if ("RadarAxis".equals(string2) && (string = xMLableReader.getAttrAsString("class", null)) != null && string.endsWith(".RadarAxis")) {
                this.radarAxis = (RadarAxis)xMLableReader.readXMLObject((XMLReadable)new RadarAxis());
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RadarAttr").attr("isFilled", this.isFilled);
        if (this.intervalColor != null) {
            xMLPrintWriter.attr("intervalColor", this.intervalColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.radarAxis != null) {
            this.radarAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof RadarPlot && super.equals(object) && ComparatorUtils.equals((Object)((RadarPlot)object).radarAxis, (Object)this.radarAxis) && ((RadarPlot)object).isFilled() == this.isFilled && ComparatorUtils.equals((Object)((RadarPlot)object).getIntervalColor(), (Object)this.intervalColor);
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        if (this.radarAxis != null) {
            this.radarAxis.dependence(calculatorProvider, list);
        }
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.radarAxis != null) {
            this.radarAxis.dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.radarAxis != null) {
            this.radarAxis.buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.radarAxis != null) {
            this.radarAxis.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RadarPlot radarPlot = (RadarPlot)super.clone();
        if (this.radarAxis != null) {
            radarPlot.radarAxis = (RadarAxis)this.radarAxis.clone();
        }
        return radarPlot;
    }

    @Override
    public Axis getxAxis() {
        return this.radarAxis;
    }

    public String getPlotName() {
        boolean bl = true;
        AttrMarkerType attrMarkerType = this.getConditionCollection().getDefaultAttr().getExisted(AttrMarkerType.class);
        if (attrMarkerType != null) {
            bl = !ComparatorUtils.equals((String)attrMarkerType.getMarkerType(), (String)"NullMarker");
        }
        String string = Inter.getLocText((String)"FR-Chart-Type_Radar");
        if (this.isFilled()) {
            string = Inter.getLocText((String)"FR-Chart-Shape_Fill") + string;
        }
        if (bl) {
            string = Inter.getLocText((String[])new String[]{"Data", "Marker"}) + string;
        }
        return string;
    }

    @Override
    public void setxAxis(Axis axis) {
        if (axis instanceof RadarAxis) {
            this.radarAxis = (RadarAxis)axis;
        }
    }

    @Override
    public void setyAxis(Axis axis) {
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/radar/0";
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.RADAR;
    }

    @Override
    public int getDetailType() {
        return 0;
    }

    @Override
    public String getPlotID() {
        return "FineReportRadarChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.RADAR_CHART;
    }
}

