/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.CompositePiePlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.text.DecimalFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiePlot
extends Plot {
    private static final long serialVersionUID = -4335570991687277300L;
    private static final int PIE_CHART = 0;
    private int subType = 3;
    private double smallPercent = 0.05;
    private static final String[] PIECATE = new String[]{"Pie1"};
    private static final String[] PIESERIES = new String[]{"PS1", "PS2", "PS3", "PS4", "PS5", "PS6", "PS7"};
    private static final String[][] PIEVALUE = new String[][]{{"10"}, {"20"}, {"30"}, {"190"}, {"110"}, {"120"}, {"125"}};
    private static final NormalChartData PIEDATA = new NormalChartData(PIECATE, PIESERIES, PIEVALUE);

    public PiePlot() {
        this.subType = 1;
    }

    public PiePlot(int n) {
        this.subType = n;
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        PiePlotGlyph piePlotGlyph = this.subType == 1 ? new PiePlotGlyph() : new CompositePiePlotGlyph();
        chartData = this.create65Data4New(chartData);
        this.install4PlotGlyph(piePlotGlyph, chartData);
        return piePlotGlyph;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new DataPoint4Pie();
    }

    protected ChartData create65Data4New(ChartData chartData) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        int n = normalChartData.getSeriesCount();
        int n2 = normalChartData.getCategoryLabelCount();
        if (n == 1 && n2 > 1) {
            int n3;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = normalChartData.getCategoryPresentLabel(i);
            }
            Object[] objectArray2 = new Object[n];
            int n4 = n3 = n == 1 ? 0 : 1;
            while (n3 < n) {
                objectArray2[n3] = normalChartData.getSeriesPresentLabel(n3);
                ++n3;
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            ArrayList<Number> arrayList2 = new ArrayList<Number>();
            for (int i = 0; i < n2; ++i) {
                arrayList2 = new ArrayList();
                arrayList2.add(normalChartData.getValueAt(0, i));
                arrayList.add(arrayList2.toArray());
            }
            Object[][] objectArray3 = (Object[][])arrayList.toArray((T[])new Object[1][]);
            normalChartData = new NormalChartData(objectArray2, objectArray, objectArray3);
        } else if (n2 > 1) {
            Object[] objectArray = new Object[1];
            for (int i = 0; i < 1; ++i) {
                objectArray[i] = normalChartData.getCategoryPresentLabel(i);
            }
            Object[] objectArray4 = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray4[i] = normalChartData.getSeriesPresentLabel(i);
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            ArrayList<Number> arrayList3 = new ArrayList<Number>();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 1; ++j) {
                    arrayList3 = new ArrayList();
                    arrayList3.add(normalChartData.getValueAt(0, j));
                    arrayList.add(arrayList3.toArray());
                }
            }
            Object[][] objectArray5 = (Object[][])arrayList.toArray((T[])new Object[1][]);
            normalChartData = new NormalChartData(objectArray, objectArray4, objectArray5);
        }
        return normalChartData;
    }

    public void install4PlotGlyph(PiePlotGlyph piePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(piePlotGlyph, chartData);
        if (piePlotGlyph instanceof CompositePiePlotGlyph) {
            ((CompositePiePlotGlyph)piePlotGlyph).setSubType(this.subType);
            ((CompositePiePlotGlyph)piePlotGlyph).setSmallPercent(this.smallPercent);
        }
    }

    @Override
    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, ChartData chartData) {
        super.addSeriesByIndex(n, n2, plotGlyph, chartData);
        this.addNewSeries(plotGlyph);
    }

    private void addNewSeries(PlotGlyph plotGlyph) {
        if (this.getSubType() == 2 || this.getSubType() == 3) {
            DataSeries<DataPoint4Pie> dataSeries = new DataSeries<DataPoint4Pie>(plotGlyph.getSeriesSize());
            CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(), "0%");
            dataSeries.setSeriesName("\u2264" + coreDecimalFormat.format(new Double(this.getSmallPercent())));
            for (int i = 0; i < plotGlyph.getCategoryCount(); ++i) {
                DataPoint4Pie dataPoint4Pie = new DataPoint4Pie();
                dataPoint4Pie.setSeriesIndex(plotGlyph.getSeriesSize());
                dataPoint4Pie.setCategoryIndex(i);
                double d = 0.0;
                double d2 = 0.0;
                for (int j = 0; j < plotGlyph.getSeriesSize(); ++j) {
                    DataSeries dataSeries2 = plotGlyph.getSeries(j);
                    DataPoint4Pie dataPoint4Pie2 = (DataPoint4Pie)dataSeries2.getDataPoint(i);
                    if (!(dataPoint4Pie2.getPercentValue() < this.getSmallPercent())) continue;
                    d += dataPoint4Pie2.getValue();
                    d2 += dataPoint4Pie2.getPercentValue();
                }
                dataPoint4Pie.setValue(d);
                dataPoint4Pie.setPercentValue(d2);
                dataPoint4Pie.setSeriesName(dataSeries.getSeriesName());
                dataPoint4Pie.setSeriesIndex(dataSeries.getSeriesIndex());
                this.createDataLabel4DataPointWithCondition(dataPoint4Pie, this.getConditionCollection());
                dataSeries.addDataPoint(dataPoint4Pie);
            }
            plotGlyph.addSeries(dataSeries);
            dataSeries.setCompositeSeries(true);
        }
    }

    @Override
    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof PiePlot && super.match4GUI(plot);
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof PiePlot;
    }

    @Override
    public boolean isSupportSeriesDrag() {
        return true;
    }

    @Override
    public boolean isSupportCategoryFilter() {
        return false;
    }

    @Override
    public boolean isSupportLeadLine() {
        return true;
    }

    @Override
    public boolean isHaveAxis() {
        return false;
    }

    @Override
    public ChartData defaultChartData() {
        return PIEDATA;
    }

    @Override
    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PieAttr").attr("subType", this.subType).attr("smallPercent", this.smallPercent);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "PieAttr".equals(string = xMLableReader.getTagName())) {
            this.setSubType(xMLableReader.getAttrAsInt("subType", 1));
            this.setSmallPercent(xMLableReader.getAttrAsDouble("smallPercent", 0.15));
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PiePlot && super.equals(object) && ((PiePlot)object).getSmallPercent() == this.smallPercent && ((PiePlot)object).getSubType() == this.subType && ((PiePlot)object).getPlotStyle() == this.getPlotStyle();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PiePlot piePlot = (PiePlot)super.clone();
        return piePlot;
    }

    public void setSubType(int n) {
        this.subType = n;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSmallPercent(double d) {
        this.smallPercent = d;
    }

    public double getSmallPercent() {
        return this.smallPercent;
    }

    public String getPlotName() {
        int n = this.getSubType();
        if (n == 3) {
            return Inter.getLocText((String)"FR-Chart-Pie_ReCombinePie_Bar");
        }
        if (n == 2) {
            return Inter.getLocText((String)"FR-Chart-Pie_ReCombinePie");
        }
        return Inter.getLocText((String)"FR-Chart-Type_Pie");
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/pie/0";
    }

    @Override
    public int getDetailType() {
        return 0;
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.PIE;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(PiePlot.class, clazz);
    }

    @Override
    public String getPlotID() {
        return "FineReportPieChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.PIE_CHART;
    }
}

