/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.MeterChartData;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MeterPlotGlyph;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterPlot
extends Plot {
    private static final long serialVersionUID = 1L;
    public static String XML_TAG = "MeterPlot";
    protected MeterStyle meterStyle = new MeterStyle();
    private static final MeterChartData METERDATA = new MeterChartData(new String[]{Inter.getLocText((String)"FR-Chart-Type_Meter")}, new String[]{"120"});

    public MeterPlot() {
        this.resetNullLegendAttr();
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public String getPlotName() {
        return Inter.getLocText((String)"FR-Chart-Type_Meter");
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        MeterPlotGlyph meterPlotGlyph = new MeterPlotGlyph();
        this.install4PlotGlyph(meterPlotGlyph, chartData);
        return meterPlotGlyph;
    }

    public void install4PlotGlyph(MeterPlotGlyph meterPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(meterPlotGlyph, chartData);
        meterPlotGlyph.setMeterStyle(this.meterStyle);
    }

    @Override
    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        MeterChartData meterChartData = ChartXMLUtils.chartData4Meter(chartData);
        this.addSeriesByIndex(plotGlyph, meterChartData);
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, MeterChartData meterChartData) {
        int n = meterChartData.getCategoryLabelCount();
        DataSeries dataSeries = this.createDataSeries(0);
        plotGlyph.addSeries(dataSeries);
        for (int i = 0; i < n; ++i) {
            DataPoint dataPoint = this.createDataPoint();
            dataPoint.setCategoryIndex(i);
            dataPoint.setSeriesIndex(0);
            double d = 0.0;
            Number number = meterChartData.getValue(i);
            if (number != null) {
                d = number.doubleValue();
            } else {
                dataPoint.setValueIsNull(true);
                d = 0.0;
            }
            dataPoint.setValue(d);
            if (i < meterChartData.getCategoryLabelCount()) {
                dataPoint.setCategoryName(Utils.objectToString((Object)meterChartData.getCategoryPresentLabel(i)));
                dataPoint.setCategoryOriginalName(Utils.objectToString((Object)meterChartData.getCategoryOriginalLabel(i)));
            }
            dataSeries.addDataPoint(dataPoint);
        }
        this.createDataPointLabel(plotGlyph);
    }

    @Override
    public boolean isSupportSeriesFilter() {
        return false;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof MeterPlot;
    }

    @Override
    public ChartData defaultChartData() {
        return METERDATA;
    }

    @Override
    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.resetNullLegendAttr();
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        if (this.meterStyle != null) {
            this.meterStyle.dependence(calculatorProvider, list);
        }
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.meterStyle != null) {
            this.meterStyle.dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.meterStyle != null) {
            this.meterStyle.buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.meterStyle != null) {
            this.meterStyle.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    @Override
    public boolean isSupportDataSeriesCondition() {
        return false;
    }

    @Override
    public boolean isSupportDataLabelAttr() {
        return false;
    }

    @Override
    public boolean isSupportTooltipInInteractivePane() {
        return false;
    }

    @Override
    public boolean isHaveAxis() {
        return false;
    }

    @Override
    public ChartData createNullChartData() {
        return new MeterChartData(new String[]{""}, new String[]{"0"});
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.meterStyle != null) {
            this.meterStyle.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "MeterStyle".equals(string = xMLableReader.getTagName())) {
            this.meterStyle = (MeterStyle)xMLableReader.readXMLObject((XMLReadable)new MeterStyle());
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof MeterPlot && super.equals(object) && ComparatorUtils.equals((Object)((MeterPlot)object).getMeterStyle(), (Object)this.meterStyle);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MeterPlot meterPlot = (MeterPlot)super.clone();
        if (this.meterStyle != null) {
            meterPlot.setMeterStyle((MeterStyle)this.meterStyle.clone());
        }
        return meterPlot;
    }

    @Override
    public boolean isMeterPlot() {
        return true;
    }

    @Override
    public TextAttr getValueTextAttr() {
        return this.meterStyle.getValueTextAttr();
    }

    @Override
    public TextAttr getUnitTextAttr() {
        return this.meterStyle.getUnitTextAttr();
    }

    @Override
    public TextAttr getCategoryNameTextAttr() {
        return this.meterStyle.getTitleTextAttr();
    }

    @Override
    public void setValueTextAttr(TextAttr textAttr) {
        this.meterStyle.setValueTextAttr(textAttr);
    }

    @Override
    public void setUnitTextAttr(TextAttr textAttr) {
        this.meterStyle.setUnitTextAttr(textAttr);
    }

    @Override
    public void setCategoryNameTextAttr(TextAttr textAttr) {
        this.meterStyle.setTitleTextAttr(textAttr);
    }

    @Override
    public void setShowCateName(boolean bl) {
        this.meterStyle.setShowCateName(bl);
    }

    @Override
    public boolean isShowCateName() {
        return this.meterStyle.isShowCateName();
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/meter/" + this.getDetailType();
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.METER;
    }

    @Override
    public int getDetailType() {
        return 0;
    }

    @Override
    public boolean isSupportLegend() {
        return false;
    }

    @Override
    public String getPlotID() {
        return "FineReportMeterChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.METER_CHART;
    }
}

