/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BarPlot
extends CategoryPlot {
    private static final long serialVersionUID = 6388999613764540798L;
    private static final double STA_SERIES_GAP = -0.25;
    private static final int CHART = 0;
    private static final int STACK_CHART = 1;
    private static final int PERCENT_STACK_CHART = 2;
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = -0.25;
    protected double categoryIntervalPercent = 1.0;

    public void install4PlotGlyph(BarPlotGlyph barPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(barPlotGlyph, chartData);
        barPlotGlyph.setHorizontal(this.isHorizontal);
        barPlotGlyph.setSeriesOverlapPercent(this.seriesOverlapPercent);
        barPlotGlyph.setCategoryIntervalPercent(this.categoryIntervalPercent);
    }

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
        if (!this.getxAxis().hasAxisReversed() && !this.getyAxis().hasAxisReversed()) {
            if (bl) {
                this.getxAxis().setPosition(2);
                this.getyAxis().setPosition(3);
            } else {
                this.getxAxis().setPosition(3);
                this.getyAxis().setPosition(2);
            }
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    @Override
    public boolean isSupportDataSheet() {
        return !this.isHorizontal;
    }

    @Override
    public boolean isSupportMoreCate() {
        return !this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public String getPlotName() {
        String string = "";
        string = this.isHorizontal() ? Inter.getLocText((String)"FR-Chart-Type_Bar") : Inter.getLocText((String)"FR-Chart-Type_Column");
        if (this.isStacked()) {
            string = Inter.getLocText((String)"FR-Chart-Type_Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText((String)"Chart-Use_Percent") + string;
        }
        return string;
    }

    @Override
    public String getPlotSmallIconPath() {
        String string = this.getBaseIconPath();
        string = this.isHorizontal() ? string + "bar/" : string + "column/";
        return string + this.getDetailType();
    }

    @Override
    public int getDetailType() {
        boolean bl = this.getyAxis().isPercentage();
        if (!this.isStacked() && !bl) {
            return 0;
        }
        if (this.isStacked() && !bl) {
            return 1;
        }
        if (this.isStacked() && bl) {
            return 2;
        }
        return 1;
    }

    protected String getBaseIconPath() {
        return "com/fr/design/images/toolbar/";
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    @Override
    public boolean match4GUI(Plot plot) {
        return super.match4GUI(plot) && this.isHorizontal == ((BarPlot)plot).isHorizontal;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof BarPlot && ((BarPlot)plot).isHorizontal == this.isHorizontal;
    }

    @Override
    public boolean isSupportSeriesDrag() {
        return true;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "BarAttr".equals(string = xMLableReader.getTagName())) {
            this.setHorizontal(xMLableReader.getAttrAsBoolean("isHorizontal", false));
            this.setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("overlap", -0.25));
            this.setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("interval", 1.0));
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("BarAttr").attr("isHorizontal", this.isHorizontal).attr("overlap", this.seriesOverlapPercent).attr("interval", this.categoryIntervalPercent).end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BarPlot && super.equals(object) && ((BarPlot)object).getCategoryIntervalPercent() == this.categoryIntervalPercent && ((BarPlot)object).getSeriesOverlapPercent() == this.seriesOverlapPercent && ((BarPlot)object).isHorizontal() == this.isHorizontal;
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        if (this.isHorizontal()) {
            return ChartTypeValueCollection.BAR;
        }
        return ChartTypeValueCollection.COLUMN;
    }

    @Override
    protected boolean isSupportAxisLabelWrapShow() {
        return true;
    }

    @Override
    public boolean isSupportTooltipSeriesType() {
        return this.isStacked;
    }

    @Override
    public String getPlotID() {
        return this.isHorizontal ? "FineReportBarChart" : "FineReportColumnChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.BAR_CHART;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(BarPlot.class, clazz);
    }
}

