/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;

public class SignalThrowingEventListener
extends BaseDelegateEventListener {
    protected String signalName;
    protected boolean processInstanceScope = true;

    @Override
    public void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            if (event.getProcessInstanceId() == null && this.processInstanceScope) {
                throw new ActivitiIllegalArgumentException("Cannot throw process-instance scoped signal, since the dispatched event is not part of an ongoing process instance");
            }
            CommandContext commandContext = Context.getCommandContext();
            List<SignalEventSubscriptionEntity> subscriptionEntities = null;
            if (this.processInstanceScope) {
                subscriptionEntities = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByProcessInstanceAndEventName(event.getProcessInstanceId(), this.signalName);
            } else {
                String tenantId = null;
                if (event.getProcessDefinitionId() != null) {
                    ProcessDefinitionEntity processDefinitionEntity = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(event.getProcessDefinitionId());
                    tenantId = processDefinitionEntity.getTenantId();
                }
                subscriptionEntities = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByEventName(this.signalName, tenantId);
            }
            for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
                signalEventSubscriptionEntity.eventReceived(null, false);
            }
        }
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setProcessInstanceScope(boolean processInstanceScope) {
        this.processInstanceScope = processInstanceScope;
    }

    @Override
    public boolean isFailOnException() {
        return true;
    }
}

