/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.utils;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.impl.AbstractRequestParameterCollector;
import com.fr.web.utils.WebUtils;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestParameterCollector
extends AbstractRequestParameterCollector {
    private static DefaultRequestParameterCollector instance;

    public static synchronized DefaultRequestParameterCollector getInstance() {
        if (instance == null) {
            instance = new DefaultRequestParameterCollector();
        }
        return instance;
    }

    @Override
    public Map<String, Object> getParametersFromSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (httpSession == null) {
            return hashMap;
        }
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e);
            hashMap.put(string.toUpperCase(), httpSession.getAttribute("" + e));
        }
        return hashMap;
    }

    @Override
    public Map<String, Object> getParametersFromAttribute(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e);
            try {
                if (hashMap.containsKey(string.toUpperCase())) {
                    hashMap.remove(string.toUpperCase());
                }
                hashMap.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    @Override
    public Map<String, Object> getParametersFromParameter(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e);
            try {
                if (hashMap.containsKey(string.toUpperCase())) {
                    hashMap.remove(string.toUpperCase());
                }
                hashMap.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                if ("reportlet".equalsIgnoreCase(string)) {
                    hashMap.put("reportName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                }
                if ("formlet".equalsIgnoreCase(string)) {
                    hashMap.put("formletName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                }
                if ("chartlet".equalsIgnoreCase(string)) {
                    hashMap.put("chartName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                }
                hashMap.put(URLDecoder.decode(string, "UTF-8"), WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    @Override
    public Map<String, Object> getParametersFromJSON(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        Map<String, Object> map2 = new HashMap<String, Object>();
        Object object = map.get("__parameters__");
        if (object instanceof String) {
            try {
                map2 = GeneralUtils.jsonString2Map((String)object);
                for (Map.Entry<String, Object> entry : map2.entrySet()) {
                    String string = entry.getKey();
                    if (!map.containsKey(string.toUpperCase())) continue;
                    map.remove(string.toUpperCase());
                }
                map.remove("__parameters__");
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return map2;
    }

    @Override
    public Map<String, Object> getParametersFromReqInputStream(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string = (String)httpServletRequest.getAttribute("__STREAMCLOSED__");
            if (string == null) {
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                if (servletInputStream == null) {
                    return hashMap;
                }
                string = IOUtils.inputStream2String((InputStream)servletInputStream);
                httpServletRequest.setAttribute("__STREAMCLOSED__", (Object)string);
            }
            if (StringUtils.isEmpty(string)) {
                return hashMap;
            }
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject.get(string2));
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return hashMap;
    }
}

